<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';

// Get website settings
$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);


$perPage = 6; 
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page > 1) ? ($page * $perPage) - $perPage : 0;

// Get paginated members
$query = "SELECT * FROM campaigns 
          WHERE status = 'active'
          ORDER BY id DESC 
          LIMIT $start, $perPage";
$result = mysqli_query($connection, $query);

// Get total count for pagination
$totalQuery = "SELECT COUNT(*) as total FROM campaigns 
               WHERE status = 'active'";
$totalResult = mysqli_query($connection, $totalQuery);
$totalRow = mysqli_fetch_assoc($totalResult);
$total = $totalRow['total'];

// Calculate total pages
$pages = ceil($total / $perPage);

// Get paginated members
$query = "SELECT * FROM campaigns WHERE status = 'active' ORDER BY id DESC LIMIT $start, $perPage";
$result = mysqli_query($connection, $query);
$campaign = [];
while ($row = mysqli_fetch_assoc($result)) {
    $campaign[] = $row;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $heading ?> - Campaigns</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
 <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
     :root {
            --primary-color: #0a7e6b;
            --hover-color: #c6c8cb;
            --secondary-color: #3f37c9;
            --accent-color: #4cc9f0;
            --light-bg: #f8f9fa;
            --dark-text: #212529;
        }
        .campaign-card {
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            border: none;
        }
        .campaign-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .campaign-img {
            height: 200px;
            width: 100%;
        }
        .progress {
            height: 10px;
        }
        
.category-badge {
    position: absolute;
    top: 10px;
    background: white !important;
    right: 10px;
    color: rgb(13 110 253) !important;
}

        .gallery-thumbnail {
            height: 60px;
            width: 60px;
            object-fit: cover;
            margin-right: 5px;
            margin-bottom: 5px;
            cursor: pointer;
        }
        .search-container {
            /*background: #f8f9fa;*/
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        .no-campaigns {
            min-height: 300px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .donation-badge {
            position: absolute;
            top: 10px;
            left: 10px;
            background-color: rgba(0,0,0,0.7);
        }
        .donation-progress {
            height: 6px;
        }
        .donor-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
        }
        
         /* Pagination Styles */
    .pagination-container {
        display: flex;
        justify-content: center;
        margin-top: 30px;
        margin-bottom: 50px;
    }
    
    .pagination {
        display: flex;
        list-style: none;
        padding: 0;
    }
    
    .page-item {
        margin: 0 5px;
    }
    
    .page-link {
        color: #0a7e6b;
        background-color: white;
        border: 1px solid #dee2e6;
        padding: 8px 16px;
        border-radius: 4px;
        transition: all 0.3s;
    }
    
    .page-link:hover {
        background-color: #f1f1f1;
        border-color: #dee2e6;
    }
    
    .page-item.active .page-link {
        background-color: #0a7e6b;
        border-color: #0a7e6b;
        color: white;
    }
    
    .page-item.disabled .page-link {
        color: #6c757d;
        pointer-events: none;
        background-color: white;
        border-color: #dee2e6;
    }
  
.btn-details {
    border: 2px solid #4361ee;
    color: #4361ee;
    font-weight: 600;
    padding: 8px 20px;
    border-radius: 8px;
    transition: all 0.3s ease;
}  

.donate_btn:hover{
     background:#c6c8cb !important;
     color:black;
}

.btn-details:hover{
     background: #4361ee !important;
     color:white !important;
}
    
.donate_btn{
    color: white;
    background:#0a7e6b;
    font-weight: 600;
    padding: 8px 25px;
    border-radius: 8px;
    border: none;
    transition: all 0.3s ease;
}    

.card-title{
    font-weight: 700;
    margin-bottom: 0.75rem;
    font-size: 1.25rem;
}

.text_muted{
    color: #6c757d;
    margin-bottom: 1rem;
    font-size: 0.9rem;
    line-height: 1.5;
}

.section-title {
    font-weight: 600;
    color: var(--dark-color);
    margin-bottom: 2rem;
    position: relative;
    display: inline-block;
}

.section-title:after {
    content: '';
    position: absolute;
    bottom: -4px;
    left: 0;
    width: 70px;
    height: 3px;
    background: linear-gradient(90deg, var(--primary-color), var(--accent-color));
    border-radius: 3px;
}

.main_header{
    background: linear-gradient(100deg, var(--primary-color), var(--secondary-color));
    margin-top: 20px;
    border-radius: 0 0 20px 20px;
}
    </style>
</head>
<body style="background-color:#f5f7ff;">
    <div class="main_header">
        <div class="container">
            <h1 class="text-center" style="text-align: center !important;
    margin: 0 !important;
    color: white;
    padding-top: 25px;
    font-weight: 700;">Support Meaningful Causes</h1>
        
        <!-- Search and Filter Section -->
        <div class="search-container">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="input-group">
                        <input type="text" class="form-control" id="searchInput" placeholder="Search campaigns...">
                        <button class="btn btn-primary" id="searchButton">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <select class="form-select" id="categoryFilter">
                        <option value="">All Categories</option>
                        <option value="Education Support">Education Support</option>
                        <option value="Healthcare & Medical Aid">Healthcare & Medical Aid</option>
                        <option value="Women Empowerment">Women Empowerment</option>
                        <option value="Child Welfare">Child Welfare</option>
                        <option value="Environment & Sustainability">Environment & Sustainability</option>
                        <option value="Rural Development">Rural Development</option>
                        <option value="Animal Welfare">Animal Welfare</option>
                        <option value="Disaster Relief">Disaster Relief</option>
                        <option value="Senior Citizen Care">Senior Citizen Care</option>
                        <option value="Livelihood Support">Livelihood Support</option>
                        <option value="Food & Nutrition">Food & Nutrition</option>
                        <option value="Disabled Persons Support">Disabled Persons Support</option>
                        <option value="Community Development">Community Development</option>
                        <option value="Menstrual Hygiene Awareness">Menstrual Hygiene Awareness</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <select class="form-select" id="statusFilter">
                        <option value="">All Statuses</option>
                        <option value="active">Active</option>
                        <option value="upcoming">Upcoming</option>
                        <option value="completed">Completed</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <label for="amountRange" class="form-label" style="color:white; font-weight:600;">Goal Amount: <span id="amountValue">Any</span></label>
                    <input type="range" class="form-range" min="0" max="10000000" step="1000" id="amountRange" value="0">
                </div>
                <div class="col-md-6">
                    <div style="display:flex; justify-content: end !important;">
                        <div class="text-muted" style="color: white !important;font-weight: 600 !important;">
                            Showing <span id="campaignCount"><?= count($campaign) ?></span> campaigns
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>
    
    <div class="container py-5">
        
        
        <!-- Campaigns Grid -->
        
        <h1 class="section-title">Featured Campaigns</h1>
        
        <div class="row" id="campaignsContainer">
            <?php if (!empty($campaign)): ?>
                <?php foreach ($campaign as $item): 
                    $gallery_images = json_decode($item['gallery_images'], true) ?? [];
                    
                    // Calculate total donations for this campaign
                    $total_donations = 0;
                    $campaign_donations = array_filter($donation, function($donation) use ($item) {
                        return $donation['campaign_id'] == $item['id'];
                    });
                    
                    foreach ($campaign_donations as $donation_item) {
                        $total_donations += $donation_item['amount'];
                    }
                    
                    $progress = min(100, ($total_donations / $item['goal_amount'] * 100));
                    $days_left = max(0, (strtotime($item['end_date']) - time()) / (60 * 60 * 24));
                    
                    // Get recent donors (last 3)
                    $recent_donors = array_slice($campaign_donations, 0, 3);
                ?>
                
                    <div class="col-lg-4 col-md-6 mb-4 campaign-item" 
                         data-title="<?= strtolower($item['title']) ?>"
                         data-category="<?= $item['category'] ?>"
                         data-status="<?= $item['status'] ?>"
                         data-amount="<?= $item['goal_amount'] ?>">
                        <div class="card campaign-card h-100">
                            <div class="position-relative">
                                <img src="<?= base_url('CampaignsImage/' . $item['featured_image']) ?>" class="card-img-top campaign-img" alt="<?= $item['title'] ?>">
                                <span class="badge bg-primary category-badge"><?= $item['category'] ?></span>
                                <?php if (!empty($campaign_donations)): ?>
                                    <span class="badge donation-badge">
                                        <i class="fa-solid fa-heart"></i> <?= count($campaign_donations) ?> donations
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title"><?= $item['title'] ?></h5>
                                <p class="card-text text-muted text_muted"><?= substr($item['description'], 0, 100) ?>...</p>
                                
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between mb-1">
                                       <div>
                                            <small style="font-weight:600;">Raised: ₹<?= number_format($total_donations, 2) ?></small><br>
                                            <small style="font-weight:600;">Goal: ₹<?= number_format($item['goal_amount'], 2) ?></small>
                                       </div>
                                       <div>
                                           <small><?= ceil($days_left) ?> days left</small><br>
                                           <small class="text-muted"><?= count($campaign_donations) ?> Supporters</small>
                                       </div>
                                    </div>
                                    <div class="progress">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: <?= $progress ?>%" 
                                             aria-valuenow="<?= $progress ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                
                                <?php if (!empty($recent_donors)): ?>
                                    <div class="mb-3">
                                        <small class="text-muted">Recent donors:</small>
                                        <div class="d-flex align-items-center">
                                            <?php foreach ($recent_donors as $donor): ?>
                                                <?php
$name = trim($donor['name']);
$words = explode(' ', $name);

$firstInitial = isset($words[0][0]) ? strtoupper($words[0][0]) : '';
$lastInitial = isset($words[count($words) - 1][0]) ? strtoupper($words[count($words) - 1][0]) : '';
$initials = $firstInitial . $lastInitial;
?>

<div class="position-relative me-2" data-bs-toggle="tooltip" title="<?= esc($donor['name']) ?> donated ₹<?= esc($donor['amount']) ?>">
    <p style="font-size: 17px;
        height: 41px;
        width: 41px;
        color: white !important;
        border-radius: 23px;
        display: flex;
        justify-content: center;
        align-items: center;
        background: linear-gradient(135deg, #4361ee, #4cc9f0);">
        <?= $initials ?>
    </p>
</div>

                                            <?php endforeach; ?>
                                            <?php if (count($campaign_donations) > 3): ?>
                                                <small class="text-muted ms-2">+<?= count($campaign_donations) - 3 ?> more</small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                               
                                <div class="d-flex justify-content-between align-items-center">
                                    
                                    <span class="badge bg-<?= $item['status'] === 'active' ? 'success' : ($item['status'] === 'upcoming' ? 'warning' : 'secondary') ?>">
                                        <?= ucfirst($item['status'] ?? 'unknown') ?>
                                    </span>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="d-flex justify-content-between">
                                    
                                    <div>
                                        <a href="<?= base_url('Campaign-Donate-Form/' . $item['id']) ?>" class="btn me-1 donate_btn" target="_blank()">
                                            <i class="fa-solid fa-heart"></i> Donate
                                        </a>
                                    </div>
                                    <div>
                                        <a href="<?= base_url('campaign_details/' . $item['id']) ?>" class="btn btn-sm btn-details" target="_blank()">
                                            <i class="fas fa-info-circle me-1"></i>Details
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12 no-campaigns">
                    <div class="text-center">
                        <i class="fas fa-exclamation-circle fa-3x text-muted mb-3"></i>
                        <h4>No campaigns found</h4>
                        <p class="text-muted">There are currently no campaigns available.</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <!-- Pagination -->
        <?php if($pages > 1): ?>
    <nav aria-label="Event pagination" class="mt-5">
        <ul class="pagination justify-content-center">
            <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $page-1 ?>" tabindex="-1" aria-disabled="<?= ($page <= 1) ? 'true' : 'false' ?>">Previous</a>
            </li>
            
            <?php for($i = 1; $i <= $pages; $i++): ?>
                <li class="page-item <?= ($page == $i) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
            
            <li class="page-item <?= ($page >= $pages) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $page+1 ?>" aria-disabled="<?= ($page >= $pages) ? 'true' : 'false' ?>">Next</a>
            </li>
        </ul>
    </nav>
    <?php endif; ?>
    </div>

    <!-- Image Modal -->
    <div class="modal fade" id="imageModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="" id="modalImage" class="img-fluid" style="max-height: 80vh;">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });
            
            // Image modal
            $('.gallery-thumbnail').click(function() {
                $('#modalImage').attr('src', $(this).data('img'));
            });
            
            // Filter functions
            function filterCampaigns() {
                const searchText = $('#searchInput').val().toLowerCase();
                const category = $('#categoryFilter').val();
                const status = $('#statusFilter').val();
                const amount = $('#amountRange').val();
                
                let visibleCount = 0;
                
                $('.campaign-item').each(function() {
                    const title = $(this).data('title');
                    const itemCategory = $(this).data('category');
                    const itemStatus = $(this).data('status');
                    const itemAmount = $(this).data('amount');
                    
                    const matchesSearch = title.includes(searchText) || searchText === '';
                    const matchesCategory = category === '' || itemCategory === category;
                    const matchesStatus = status === '' || itemStatus === status;
                    const matchesAmount = amount === '0' || itemAmount <= amount;
                    
                    if (matchesSearch && matchesCategory && matchesStatus && matchesAmount) {
                        $(this).show();
                        visibleCount++;
                    } else {
                        $(this).hide();
                    }
                });
                
                $('#campaignCount').text(visibleCount);
                
                // Remove any existing "no results" message
                $('.no-campaigns').remove();
                
                if (visibleCount === 0) {
                    $('#campaignsContainer').append(`
                        <div class="col-12 no-campaigns">
                            <div class="text-center">
                                <i class="fas fa-exclamation-circle fa-3x text-muted mb-3"></i>
                                <h4>No campaigns match your filters</h4>
                                <p class="text-muted">Try adjusting your search criteria.</p>
                            </div>
                        </div>
                    `);
                }
            }
            
            // Event listeners
            $('#searchInput, #categoryFilter, #statusFilter, #amountRange').on('input change', filterCampaigns);
            
            $('#amountRange').on('input', function() {
                const val = $(this).val();
                $('#amountValue').text(val === '0' ? 'Any' : 'Up to ₹' + parseInt(val).toLocaleString());
            });
            
            $('#resetFilters').click(function() {
                $('#searchInput').val('');
                $('#categoryFilter').val('');
                $('#statusFilter').val('');
                $('#amountRange').val('0');
                $('#amountValue').text('Any');
                filterCampaigns();
            });
            
            // Initialize
            filterCampaigns();
        });
    </script>
</body>
</html>