<?php if (!empty($transactions)) : ?>

<table>
    <thead>
        <tr>
            <th>#</th>
            <th>Transaction ID</th>
            <th>Amount (₹)</th>
            <th>Status</th>
            <th>Date</th>
        </tr>
    </thead>

    <tbody>
        <?php $i = 1; ?>
        <?php foreach ($transactions as $t): ?>
        <tr>
            <td><?= $i++; ?></td>
            <td><?= $t['transactionId']; ?></td>
            <td><?= number_format($t['amount'], 2); ?></td>
            <td><?= ucfirst($t['payment_status']); ?></td>
            <td><?= date("d-m-Y h:i A", strtotime($t['created_at'])); ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<br>
<h4 style="text-align:right; color:#333;">
    <strong>Total Paid: ₹<?= number_format($total, 2); ?></strong>
</h4>

<?php else: ?>

<p>No transaction history found.</p>

<?php endif; ?>
