<!DOCTYPE html>
<html>
<head> 
    <title>Health Card Receipt</title>
    
    <style>
        body {
            font-family: Arial, sans-serif;
            background:#f1f1f1;
            margin:0;
            padding:0;
        }
        .receipt-box {
            width: 800px;
            margin: 30px auto;
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }
        h2 {
            text-align:center;
            text-transform:uppercase;
            letter-spacing:1px;
        }
        table {
            width:100%;
            margin-top:20px;
            border-collapse: collapse;
        }
        table tr td {
            padding:8px;
            border-bottom:1px solid #ddd;
        }
        .photo-box {
            text-align:center;
            margin-top:20px;
        }
        .photo-box img{
            width:120px;
            border-radius:8px;
            border:3px solid #ddd;
        }
        .members-table th, .members-table td {
            padding:6px;
            border:1px solid #ddd;
            text-align:center;
        }
        .download-btn {
            text-align:center;
            margin-top:25px;
        }
        .download-btn a{
            padding: 10px 20px;
            background:#ff4b2b;
            color:white;
            text-decoration:none;
            border-radius:5px;
            font-size:16px;
        }
    </style>
</head>
<body>

<div class="receipt-box">
    
    <h2>Health Card Payment Receipt</h2>

    <div style="text-align:center;">
        <img src="<?= $logo ?>" width="100">
        <p style="font-size:20px; font-weight:bold; margin:10px 0;">
            Your Organization Name
        </p>
    </div>

    <table>
        <tr>
            <td><strong>Receipt No:</strong></td>
            <td><?= $transaction['transactionId'] ?></td>
        </tr>
        <tr>
            <td><strong>Health Card No:</strong></td>
            <td><?= $card['card_number'] ?></td>
        </tr>
        <tr>
            <td><strong>Name:</strong></td>
            <td><?= $card['name'] ?></td>
        </tr>
        <tr>
            <td><strong>Mobile:</strong></td>
            <td><?= $card['mobile'] ?></td>
        </tr>
        <tr>
            <td><strong>Email:</strong></td>
            <td><?= $card['email'] ?></td>
        </tr>
        <tr>
            <td><strong>Payment Date:</strong></td>
            <td><?= $paymentDate ?></td>
        </tr>
        <tr>
            <td><strong>Amount Paid:</strong></td>
            <td>₹ <?= $transaction['amount'] ?></td>
        </tr>
        <tr>
            <td><strong>Payment Status:</strong></td>
            <td style="color:green; font-weight:bold;"><?= ucfirst($transaction['payment_status']) ?></td>
        </tr>
    </table>

    <div class="photo-box">
        <h3>Card Holder Photo</h3>
        <img src="<?= $photo ?>" alt="Photo">
    </div>

    <h3 style="margin-top:30px;">Family Member Details</h3>

    <?php if(!empty($members)): ?>
    <table class="members-table" width="100%">
        <tr>
            <th>Name</th>
            <th>Relation</th>
            <th>Aadhar</th>
            <th>Age</th>
        </tr>

        <?php foreach($members as $m): ?>
        <tr>
            <td><?= $m['name'] ?></td>
            <td><?= $m['relation'] ?></td>
            <td><?= $m['aadhar_no'] ?></td>
            <td><?= $m['age'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
    <?php else: ?>
    <p>No family members added.</p>
    <?php endif; ?>

    <div class="download-btn">
        <a href="#">
            Download Receipt (PDF)
        </a>
    </div>

</div>

</body>
</html>
