<!DOCTYPE html>
<html>
<head>
    <title>Health Protection Card</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f7fa;
            margin: 0;
            padding: 0;
        }

        .card-wrapper {
            width: 700px;                   /* Perfect A4 fit */
            margin: 20px auto;
            background: #ffffff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0px 3px 10px rgba(0,0,0,0.15);
        }

        .header {
            text-align: center;
            padding-bottom: 10px;
            border-bottom: 2px solid #ccc;
        }

        .header h2 {
            margin: 0;
            font-size: 28px;
            color: #0056b3;
            font-weight: bold;
        }

        .header .sub {
            margin-top: 5px;
            font-size: 16px;
            color: #444;
        }

        .card-info {
            margin-top: 20px;
            display: flex;
            gap: 20px;
        }

        .left-side {
            width: 65%;
        }

        .right-side {
            width: 35%;
            text-align: center;
        }

        .photo-box img {
            width: 130px;
            height: 150px;
            border-radius: 8px;
            border: 2px solid #ccc;
            object-fit: cover;
        }

        .section-title {
            background: #0056b3;
            color: white;
            padding: 8px 10px;
            margin-top: 25px;
            border-radius: 6px;
            font-size: 18px;
        }

        table {
            width: 100%;
            margin-top: 12px;
            border-collapse: collapse;
            font-size: 15px;
        }

        table td {
            padding: 10px;
            border-bottom: 1px solid #ddd;
        }

        .member-table th {
            background: #ececec;
            padding: 10px;
            border: 1px solid #ccc;
        }

        .member-table td {
            padding: 8px;
            border: 1px solid #ccc;
        }

        /* Print Button Hidden in PDF */
        @media print {
            .print-btn {
                display: none;
            }

            .card-wrapper {
                box-shadow: none;
                border: none;
                margin: 0;
                width: 100%;
            }
        }

        .print-btn {
            text-align: center;
            margin-top: 25px;
        }

        .print-btn button {
            padding: 12px 25px;
            font-size: 16px;
            background: #28a745;
            border: none;
            color: white;
            border-radius: 8px;
            cursor: pointer;
        }
    </style>

    <script>
        function printCard() {
            window.print();
        }
    </script>
</head>

<body>

<div class="card-wrapper">

    <div class="header">
        <h2>HEALTH PROTECTION CARD</h2>
        <div class="sub"><b>Card No:</b> <?= $card['card_number'] ?></div>
        <div class="sub"><b>Validity:</b> 1 Year</div>
    </div>

    <div class="card-info">
        <div class="left-side">
            <table>
                <tr>
                    <td><strong>Full Name:</strong></td>
                    <td><?= $card['name'] ?></td>
                </tr>
                <tr>
                    <td><strong>Father Name:</strong></td>
                    <td><?= $card['father_name'] ?></td>
                </tr>
                <tr>
                    <td><strong>Mobile:</strong></td>
                    <td><?= $card['mobile'] ?></td>
                </tr>
                <tr>
                    <td><strong>DOB:</strong></td>
                    <td><?= $card['dob'] ?> (Age: <?= $card['age'] ?>)</td>
                </tr>
                <tr>
                    <td><strong>Aadhar No:</strong></td>
                    <td><?= $card['aadhar_no'] ?></td>
                </tr>
                <tr>
                    <td><strong>Address:</strong></td>
                    <td><?= $card['full_address'] ?></td>
                </tr>
                <tr>
                    <td><strong>State / District:</strong></td>
                    <td><?= $card['state'] ?> / <?= $card['district'] ?></td>
                </tr>
            </table>
        </div>

        <div class="right-side">
            <div class="photo-box">
                <img src="<?= base_url('member_images/'.$card['photo']) ?>" alt="Photo">
            </div>
        </div>
    </div>

    <h3 class="section-title">Family Members Covered</h3>

    <table class="member-table">
        <tr>
            <th>#</th>
            <th>Name</th>
            <th>Relation</th>
            <th>Age</th>
        </tr>

        <?php $i=1; foreach($members as $m): ?>
        <tr>
            <td><?= $i++ ?></td>
            <td><?= $m['name'] ?></td>
            <td><?= $m['relation'] ?></td>
            <td><?= $m['age'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <div class="print-btn">
        <button onclick="printCard()">Print / Download PDF</button>
    </div>

</div>

</body>
</html>
