<?php
// Ensure variables exist
$isEdit = isset($isEdit) && $isEdit === true;
$card = $card ?? [];
$memberData = $members ?? [];

// Determine initial member count (at least 1)
$initialMemberCount = max(1, count($memberData));
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title><?= $heading ?? ($isEdit ? 'Update Health Card' : 'Health Card Registration') ?></title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
<style>
/* (Use your existing CSS — truncated here for brevity in this response) */
:root{--primary-color:#2a9d8f;--primary-dark:#21867a;--border-color:#e0e0e0;--danger-color:#e74c3c;--radius:10px}
*{box-sizing:border-box}body{font-family:Roboto,Arial;background:linear-gradient(135deg,#f5f7fa 0%,#c3cfe2 100%);padding:20px;color:#2c3e50}
.container{max-width:1000px;margin:30px auto;background:#fff;border-radius:var(--radius);box-shadow:0 4px 12px rgba(0,0,0,.08);overflow:hidden}
.header{background:linear-gradient(to right,var(--primary-color),var(--primary-dark));color:#fff;padding:25px 30px;text-align:center}
.header h1{font-family:Poppins,sans-serif;font-weight:600;font-size:28px}
.form-container{padding:30px}
.section-title{font-family:Poppins,sans-serif;font-size:20px;color:var(--primary-dark);margin-bottom:20px;display:flex;gap:10px;align-items:center}
.form-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(280px,1fr));gap:20px}
label{display:block;margin-bottom:8px;font-weight:500}
.required::after{content:" *";color:var(--danger-color)}
input,select,textarea{width:100%;padding:12px;border:1px solid var(--border-color);border-radius:6px;font-size:15px}
.input-with-icon{position:relative}
.input-with-icon i{position:absolute;left:15px;top:50%;transform:translateY(-50%);color:#7f8c8d}
.input-with-icon input{padding-left:45px}
.readonly-input{background:#f8f9fa}
.file-upload{border:2px dashed var(--border-color);padding:20px;border-radius:var(--radius);text-align:center;cursor:pointer}
.file-upload:hover{border-color:var(--primary-color);background:rgba(42,157,143,.05)}
#photo{display:none}
.btn{padding:12px 20px;border:none;border-radius:6px;cursor:pointer}
.btn-primary{background:var(--primary-color);color:#fff}
.member-box{background:#f8f9fa;padding:18px;border-left:4px solid var(--primary-color);border-radius:8px;margin-top:15px}
.button-group{display:flex;gap:10px;margin-top:15px;flex-wrap:wrap}
.form-footer{display:flex;justify-content:space-between;align-items:center;margin-top:30px;padding-top:20px;border-top:1px solid var(--border-color)}
@media(max-width:768px){.form-grid{grid-template-columns:1fr}.form-footer{flex-direction:column;gap:15px}}
</style>
</head>
<body>
<div class="container">
    <div class="header">
        <div style="font-size:40px;color:rgba(255,255,255,.9)"><i class="fas fa-heartbeat"></i></div>
        <h1><?= $heading ?? ($isEdit ? 'Update Health Card' : 'Health Card Registration') ?></h1>
        <p>Register for your health card to access healthcare services</p>
    </div>

    <div class="form-container">
        <!-- Dynamic form action -->
        <form id="healthCardForm"
              action="<?= $card ? base_url('updateCard/'.$card['id']) : base_url('healthCardSave') ?>"
              method="post"
              enctype="multipart/form-data">

            <!-- Personal Details -->
            <div class="form-section">
                <div class="section-title"><i class="fas fa-user"></i><span>Personal Details</span></div>

                <div class="form-grid">

                    <div class="form-group input-with-icon">
                        <label class="required">Full Name</label>
                        <i class="fas fa-user"></i>
                        <input id="name" type="text" name="name" value="<?= esc($card['name'] ?? '') ?>" placeholder="Full Name" required>
                    </div>

                    <div class="form-group input-with-icon">
                        <label class="required">Father Name</label>
                        <i class="fas fa-user"></i>
                        <input type="text" name="father_name" value="<?= esc($card['father_name'] ?? '') ?>" placeholder="Father Name" required>
                    </div>

                    <div class="form-group input-with-icon">
                        <label>Email</label>
                        <i class="fas fa-envelope"></i>
                        <input type="email" name="email" value="<?= esc($card['email'] ?? '') ?>" placeholder="Email Address">
                    </div>

                    <div class="form-group input-with-icon">
                        <label class="required">Mobile Number</label>
                        <i class="fas fa-mobile-alt"></i>
                        <input id="mobile" type="text" name="mobile" value="<?= esc($card['mobile'] ?? '') ?>" placeholder="10-digit mobile" required>
                    </div>

                    <div class="form-group input-with-icon">
                        <label class="required">Aadhar Number</label>
                        <i class="fas fa-address-card"></i>
                        <input id="aadhar_no" type="text" name="aadhar_no" value="<?= esc($card['aadhar_no'] ?? '') ?>" placeholder="12-digit Aadhar" required>
                    </div>

                    <div class="form-group input-with-icon">
                        <label class="required">Date of Birth</label>
                        <i class="fas fa-calendar-alt"></i>
                        <input id="dob" type="date" name="dob" value="<?= esc($card['dob'] ?? '') ?>" onchange="calculateAge()" required>
                    </div>

                    <div class="form-group input-with-icon">
                        <label>Age</label>
                        <i class="fas fa-birthday-cake"></i>
                        <input id="age" type="number" name="age" value="<?= esc($card['age'] ?? '') ?>" readonly class="readonly-input">
                    </div>

                    <div class="form-group input-with-icon">
                        <label class="required">State</label>
                        <i class="fas fa-map-marker-alt"></i>
                        <input type="text" name="state" value="<?= esc($card['state'] ?? '') ?>" placeholder="State" required>
                    </div>

                    <div class="form-group input-with-icon">
                        <label class="required">District</label>
                        <i class="fas fa-map-pin"></i>
                        <input type="text" name="district" value="<?= esc($card['district'] ?? '') ?>" placeholder="District" required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="required">Full Address</label>
                    <textarea name="full_address" rows="3" required><?= esc($card['full_address'] ?? '') ?></textarea>
                </div>

                <div class="form-group">
                    <label>Passport Size Photo</label>

                    <?php if (!empty($card['photo'])): ?>
                        <div style="margin-bottom:10px;">
                            <img src="<?= base_url('member_images/'.esc($card['photo'])) ?>" width="120" style="border-radius:6px">
                        </div>
                    <?php endif; ?>
  <?php if (!empty($card['photo'])){ ?>
                    <div class="file-upload" id="fileUploadDiv" onclick="document.getElementById('photo').click();">
                        <i class="fas fa-cloud-upload-alt"></i>
                        <p id="fileUploadText"><?= $isEdit ? 'Click to change photo (optional)' : 'Click to upload photo' ?></p>
                        <span><?= $isEdit ? 'JPEG, PNG, JPG (optional, max 2MB)' : 'JPEG, PNG, JPG (required, max 2MB)' ?></span>
                    </div>
                    <input id="photo" type="file" name="photo" accept="image/*" >
                    <?php } else { ?>
                    <div class="file-upload" id="fileUploadDiv" onclick="document.getElementById('photo').click();">
                        <i class="fas fa-cloud-upload-alt"></i>
                        <p id="fileUploadText"><?= $isEdit ? 'Click to change photo (optional)' : 'Click to upload photo' ?></p>
                        <span><?= $isEdit ? 'JPEG, PNG, JPG (optional, max 2MB)' : 'JPEG, PNG, JPG (required, max 2MB)' ?></span>
                    </div>
                    <input id="photo" type="file" name="photo" accept="image/*" <?= $isEdit ? '' : 'required' ?>>
                    <?php } ?>
                </div>
            </div>

            <!-- Family Members -->
            <div class="form-section">
                <div class="section-title"><i class="fas fa-users"></i><span>Family Member Details</span></div>

                <div class="member-header" style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
                    <div class="member-title"><span>Family Members</span></div>
                    <div>
                        <span class="member-count" id="memberCount"><?= $initialMemberCount ?></span>
                    </div>
                </div>

                <p style="color:#7f8c8d;margin-bottom:15px">You can add up to 4 family members including yourself.</p>

            
                <div class="member-box" id="firstMember">
                    <div style="margin-bottom:12px;font-weight:600;color:#2c3e50">Primary Applicant (Yourself)</div>

                    <div class="form-grid">
                        <div class="form-group input-with-icon">
                            <label>Full Name</label>
                            <i class="fas fa-user"></i>
                            <input type="text" name="member_name[]" placeholder="Full name" required value="<?= esc($memberData[0]['name'] ?? $card['name'] ?? '') ?>">
                        </div>

                        <div class="form-group input-with-icon">
                            <label>Relation</label>
                            <i class="fas fa-heart"></i>
                            <select name="member_relation[]" required>
                                <option value="Self" <?= (isset($memberData[0]['relation']) && $memberData[0]['relation']=='Self') ? 'selected' : '' ?>>Self</option>
                            </select>
                        </div>

                        <div class="form-group input-with-icon">
                            <label>Aadhar Card No.</label>
                            <i class="fas fa-address-card"></i>
                            <input type="text" name="member_aadhar[]" placeholder="Aadhar" value="<?= esc($memberData[0]['aadhar_no'] ?? $card['aadhar_no'] ?? '') ?>">
                        </div>

                        <div class="form-group input-with-icon">
                            <label>Age</label>
                            <i class="fas fa-birthday-cake"></i>
                            <input type="number" name="member_age[]" placeholder="Age" min="0" max="120" required value="<?= esc($memberData[0]['age'] ?? $card['age'] ?? '') ?>">
                        </div>
                    </div>
                </div>

                <!-- Existing members (edit mode beyond primary) -->
                <?php if ($card && count($memberData) > 1): ?>
                    <?php for ($i = 1; $i < count($memberData); $i++): $m = $memberData[$i]; ?>
                        <div class="member-box">
                            <div style="margin-bottom:12px;font-weight:600;color:#2c3e50">Family Member <?= $i+1 ?></div>
                            <div class="form-grid">
                                <div class="form-group">
                                    <label>Full Name</label>
                                    <input type="text" name="member_name[]" value="<?= esc($m['name']) ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>Relation</label>
                                    <select name="member_relation[]" required>
                                        <option value="Spouse" <?= $m['relation']=='Spouse' ? 'selected':'' ?>>Spouse</option>
                                        <option value="Child" <?= $m['relation']=='Child' ? 'selected':'' ?>>Child</option>
                                        <option value="Parent" <?= $m['relation']=='Parent' ? 'selected':'' ?>>Parent</option>
                                        <option value="Sibling" <?= $m['relation']=='Sibling' ? 'selected':'' ?>>Sibling</option>
                                        <option value="Other" <?= $m['relation']=='Other' ? 'selected':'' ?>>Other</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Aadhar</label>
                                    <input type="text" name="member_aadhar[]" value="<?= esc($m['aadhar_no']) ?>">
                                </div>
                                <div class="form-group">
                                    <label>Age</label>
                                    <input type="number" name="member_age[]" value="<?= esc($m['age']) ?>" required>
                                </div>
                            </div>
                            <div class="button-group">
                                <button type="button" class="btn btn-danger" onclick="removeMember(this)"> <i class="fas fa-trash"></i> Remove Member</button>
                            </div>
                        </div>
                    <?php endfor; ?>
                <?php endif; ?>

                <!-- Container for new members -->
                <div id="members"></div>

                <div class="button-group" style="margin-top:12px;">
                    <button type="button" class="btn btn-success" onclick="addMember()"> <i class="fas fa-plus"></i> Add Family Member</button>
                </div>

            </div>

            <!-- Form footer -->
            <div class="form-footer">
                <div class="form-info"><i class="fas fa-info-circle"></i> All fields marked * are required</div>
                <div>
                    <button type="reset" class="btn btn-secondary">Reset</button>
                    <?php if($card && $card['id']) { ?>
                     <button type="submit" class="btn btn-primary" >Update Health Card</button>
                    
                    <?php } else { ?>
                    <button type="button" class="btn btn-primary" onclick="openPaymentModal()"><?= $isEdit ? 'Update Health Card' : 'Submit Registration' ?></button>
                    <?php } ?>
                </div>
            </div>

        </form>
    </div>

    <div class="footer" style="text-align:center;padding:20px;background:#f8f9fa">
        <p><i class="fas fa-shield-alt"></i> Your information is secure.</p>
        <p>© <?= date('Y') ?> Health Card Registration System.</p>
    </div>
</div>

<!-- Payment Modal (keeps same behavior) -->
<div id="paymentModal" style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,.5);display:none;justify-content:center;align-items:center;z-index:9999">
    <div style="background:#fff;padding:25px;width:90%;max-width:420px;border-radius:10px;box-shadow:0 5px 20px rgba(0,0,0,.3)">
        <h2 style="text-align:center;margin-bottom:15px">Select Payment Type</h2>
        <label style="display:block;margin-bottom:10px"><input type="radio" name="payment_type" value="full"> Pay Complete – <b>₹551</b></label>
        <label style="display:block;margin-bottom:20px"><input type="radio" name="payment_type" value="emi"> Pay EMI First Payment – <b>₹51</b></label>
        <button onclick="finalSubmit()" style="background:#2a9d8f;color:#fff;border:none;padding:12px;width:100%;border-radius:6px">Final Submit</button>
        <button onclick="closePaymentModal()" style="margin-top:10px;background:#e74c3c;color:#fff;border:none;padding:10px;width:100%;border-radius:6px">Cancel</button>
    </div>
</div>

<script>
/* JS logic — fixed & consolidated */

// member count initialization
let memberCount = <?= $initialMemberCount ?>;
document.getElementById('memberCount').textContent = memberCount;

// Add member (max 4)
function addMember() {
    if (memberCount >= 4) {
        alert('Maximum 4 members allowed.');
        return;
    }
    memberCount++;
    document.getElementById('memberCount').textContent = memberCount;

    const membersDiv = document.getElementById('members');
    const idx = memberCount; // just for display
    const html = document.createElement('div');
    html.className = 'member-box';
    html.innerHTML = `
        <div style="margin-bottom:12px;font-weight:600;color:#2c3e50">Family Member ${idx}</div>
        <div class="form-grid">
            <div class="form-group"><label>Full Name</label><input type="text" name="member_name[]" required></div>
            <div class="form-group"><label>Relation</label><select name="member_relation[]" required>
                <option value="">Select Relation</option>
                <option value="Spouse">Spouse</option>
                <option value="Child">Child</option>
                <option value="Parent">Parent</option>
                <option value="Sibling">Sibling</option>
                <option value="Other">Other</option>
            </select></div>
            <div class="form-group"><label>Aadhar</label><input type="text" name="member_aadhar[]"></div>
            <div class="form-group"><label>Age</label><input type="number" name="member_age[]" min="0" max="120" required></div>
        </div>
        <div class="button-group"><button type="button" class="btn btn-danger" onclick="removeMember(this)"><i class="fas fa-trash"></i> Remove Member</button></div>
    `;
    membersDiv.appendChild(html);
}

function removeMember(btn) {
    if (!confirm('Are you sure to remove this member?')) return;
    btn.closest('.member-box').remove();
    memberCount--;
    document.getElementById('memberCount').textContent = memberCount;
}

// copy main name/aadhar/age into first member inputs (if present)
document.addEventListener('DOMContentLoaded', function() {
    const mainName = document.getElementById('name');
    const mainAadhar = document.getElementById('aadhar_no');
    const mainDob = document.getElementById('dob');
    const mainAge = document.getElementById('age');

    // set initial firstMember values if empty
    try {
        const firstName = document.querySelector('#firstMember input[name="member_name[]"]');
        const firstAadhar = document.querySelector('#firstMember input[name="member_aadhar[]"]');
        const firstAge = document.querySelector('#firstMember input[name="member_age[]"]');

        if (firstName && mainName && !firstName.value) firstName.value = mainName.value;
        if (firstAadhar && mainAadhar && !firstAadhar.value) firstAadhar.value = mainAadhar.value;
        if (firstAge && mainAge && !firstAge.value) firstAge.value = mainAge.value;
    } catch(e){}

    // wire live copy
    if (mainName) mainName.addEventListener('input', function(){ const f = document.querySelector('#firstMember input[name="member_name[]"]'); if(f) f.value = this.value; });
    if (mainAadhar) mainAadhar.addEventListener('input', function(){ const f = document.querySelector('#firstMember input[name="member_aadhar[]"]'); if(f) f.value = this.value; });
    if (mainDob) mainDob.addEventListener('change', function(){ calculateAge(); const f = document.querySelector('#firstMember input[name="member_age[]"]'); if(f) f.value = document.getElementById('age').value; });
});

// age calc
function calculateAge() {
    const dobEl = document.getElementById('dob');
    if (!dobEl || !dobEl.value) return;
    const birth = new Date(dobEl.value);
    const today = new Date();
    let age = today.getFullYear() - birth.getFullYear();
    const m = today.getMonth() - birth.getMonth();
    if (m < 0 || (m === 0 && today.getDate() < birth.getDate())) age--;
    document.getElementById('age').value = age;
    const fAge = document.querySelector('#firstMember input[name="member_age[]"]');
    if (fAge) fAge.value = age;
}

// file upload preview + size check
const photoInput = document.getElementById('photo');
const fileUploadText = document.getElementById('fileUploadText');
if (photoInput) {
    photoInput.addEventListener('change', function(){
        if (!this.files || !this.files[0]) return;
        const file = this.files[0];
        const maxSize = 2 * 1024 * 1024; // 2MB
        if (file.size > maxSize) {
            alert('File size exceeds 2MB. Please upload a smaller image.');
            this.value = '';
            return;
        }
        fileUploadText.innerText = 'Photo selected: ' + file.name;
    });
}

// Payment modal handling: adds selected_payment hidden field and submits form
function openPaymentModal(){ document.getElementById('paymentModal').style.display='flex'; }
function closePaymentModal(){ document.getElementById('paymentModal').style.display='none'; }
function finalSubmit(){
    const typeEl = document.querySelector("input[name='payment_type']:checked");
    if (!typeEl) { alert('Please select a payment type.'); return; }
    // append hidden input
    let hidden = document.querySelector("input[name='selected_payment']");
    if (!hidden) {
        hidden = document.createElement('input'); hidden.type='hidden'; hidden.name='selected_payment';
        document.getElementById('healthCardForm').appendChild(hidden);
    }
    hidden.value = typeEl.value;
    document.getElementById('healthCardForm').submit();
}

// final validation before submit: attach to form submit if someone submits directly
document.getElementById('healthCardForm').addEventListener('submit', function(e){
    // mobile validation
    const mobile = document.getElementById('mobile').value.trim();
    if (mobile && !/^\d{10}$/.test(mobile)) { alert('Enter valid 10-digit mobile'); e.preventDefault(); return false; }
    // aadhar validation
    const aadhar = document.getElementById('aadhar_no').value.trim();
    if (aadhar && !/^\d{12}$/.test(aadhar)) { alert('Enter valid 12-digit Aadhar'); e.preventDefault(); return false; }
    // photo size if provided (already checked on change), redundant check
    if (photoInput && photoInput.files.length && photoInput.files[0].size > 2*1024*1024) { alert('Photo too large'); e.preventDefault(); return false; }
});
</script>
</body>
</html>
