<!DOCTYPE html>
<html>
<head>
    <title>Health Card Details</title>

    <link rel="stylesheet" 
          href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

    <style>
        body {
            background: #f5f5f5;
            font-family: Arial;
        }
        .card-box {
            background: #fff;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 0 10px #ddd;
            margin-top: 25px;
        }
        .title {
            background: #007bff;
            color: white;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .profile-img {
            width: 120px;
            height: 120px;
            border-radius: 8px;
            border: 2px solid #007bff;
        }
    </style>

</head>

<body>

<div class="container">

    <div class="card-box">

        <h3 class="title text-center">Health Card Details</h3>

        <div class="row mb-4">
            <div class="col-md-3 text-center">
                <?php if (!empty($card['photo'])): ?>
                    <img src="<?= base_url('member_images/' . $card['photo']); ?>" 
                         class="profile-img">
                <?php else: ?>
                    <img src="https://via.placeholder.com/120" class="profile-img">
                <?php endif; ?>
            </div>

            <div class="col-md-9">
                
                <h4><?= $card['name']; ?></h4>
                <p><strong>Card Number:</strong> <?= $card['card_number']; ?></p>
                <p><strong>Aadhar:</strong> <?= $card['aadhar_no']; ?></p>
                <p><strong>Email:</strong> <?= $card['email']; ?></p>
                <p><strong>Mobile:</strong> <?= $card['mobile']; ?></p>
                <p><strong>Address:</strong> <?= $card['full_address']; ?></p>
                <p><strong>DOB:</strong> <?= $card['dob']; ?></p>
                <p><strong>Age:</strong> <?= $card['age']; ?></p>
            </div>
        </div>

        <hr>

        <h4 class="mb-3">Family Members</h4>

        <?php if (!empty($members)): ?>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Sr No</th>
                    <th>Name</th>
                    <th>Relation</th>
                    <th>Aadhar</th>
                    <th>Age</th>
                </tr>
            </thead>

            <tbody>
                <?php $i=1; foreach ($members as $m): ?>
                <tr>
                    <td><?= $i++; ?></td>
                    <td><?= $m['name']; ?></td>
                    <td><?= $m['relation']; ?></td>
                    <td><?= $m['aadhar_no']; ?></td>
                    <td><?= $m['age']; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <?php else: ?>

            <p class="text-danger">No family members added.</p>

        <?php endif; ?>

        <div class="text-center mt-4">
            <a href="#" onclick="history.back();" class="btn btn-secondary">Back</a>
            
        </div>

    </div>

</div>

</body>
</html>
