<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';

$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Posts - <?= $dataweb['web_name']??''?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        :root {
            --primary: #1877f2;
            --secondary: #42b72a;
            --bg-color: #f0f2f5;
            --card-bg: #ffffff;
            --text-primary: #1c1e21;
            --text-secondary: #65676b;
            --border: #dddfe2;
            --shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
            --hover-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }
        
 header {
      box-shadow: 0 2px 15px rgba(0,0,0,0.1);
      padding: 15px 20%;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 1000;
      background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    }

    header .logo-area {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    header .logo-area img {
      height: 50px;
      width: 50px;
      object-fit: contain;
    }

    header h2 {
      margin: 0;
      font-size: 22px;
      color: white;
      font-weight: 700;
    }

header nav a {
    margin-left:10px;
    text-decoration: none;
    color: black;
    font-weight: 500;
    transition: color 0.3s;
    position: relative;
    background: #f0f7f4;
    padding: 8px 20px;
    border-radius: 9px;
    text-decoration:none;
}

    header nav a:hover {
      color: black;
    }          
        
        body {
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            background: var(--bg-color);
            color: var(--text-primary);
            line-height: 1.5;
            overflow-x: hidden;
        }
        
        /* Modern Header */
        .modern-header {
            background: linear-gradient(135deg, var(--primary), #166fe5);
            color: white;
            padding: 16px 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        
        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo-section {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .logo {
            width: 44px;
            height: 44px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            backdrop-filter: blur(10px);
        }
        
        .header-text h1 {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 2px;
        }
        
        .header-text p {
            font-size: 14px;
            opacity: 0.9;
        }
        
        /* Main Container */
        .modern-container {
            max-width: 680px;
            margin: 0 auto;
            padding: 0px 20px 60px 20px;
        }
        
        /* Post Cards - Modern Design */
        .post-card {
            background: var(--card-bg);
            border-radius: 16px;
            box-shadow: var(--shadow);
            margin-bottom: 20px;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid var(--border);
        }
        
        .post-card:hover {
            box-shadow: var(--hover-shadow);
            transform: translateY(-2px);
        }
        
        .post-header {
            padding: 16px 20px 12px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }
        
        .post-avatar {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            /*background: linear-gradient(135deg, var(--primary), var(--secondary));*/
            /*display: flex;*/
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 18px;
            flex-shrink: 0;
            overflow: hidden;
        }
        
        .post-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .post-meta {
            flex: 1;
        }
        
        .post-author {
            font-size: 16px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 2px;
        }
        
        .post-time {
            font-size: 13px;
            color: var(--text-secondary);
            display: flex;
            align-items: center;
            gap: 6px;
        }
        
        .post-time i {
            font-size: 12px;
        }
        
        .post-content {
            padding: 0 20px 16px;
        }
        
        .post-title {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 8px;
            color: var(--text-primary);
            line-height: 1.4;
        }
        
        .post-description {
            font-size: 15px;
            color: var(--text-primary);
            margin-bottom: 16px;
            line-height: 25px;
        }
        
        .post-banner {
            width: 100%;
            max-height: 500px;
            object-fit: cover;
            border-radius: 12px;
            margin-bottom: 16px;
            display: block;
        }
        
        /* Post Stats */
        .post-stats {
            padding: 0 20px 12px;
            display: flex;
            justify-content: space-between;
            font-size: 14px;
            color: var(--text-secondary);
            border-bottom: 1px solid var(--border);
        }
        
        .post-actions {
            padding: 8px 20px;
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 4px;
        }
        
        .action-btn {
            background: none;
            border: none;
            color: var(--text-secondary);
            cursor: pointer;
            padding: 8px 4px;
            border-radius: 6px;
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-size: 14px;
            font-weight: 600;
        }
        
        .action-btn:hover {
            background: var(--bg-color);
            color: var(--primary);
        }
        
        .action-btn.active {
            color: var(--primary);
        }
        
        .action-btn i {
            font-size: 18px;
        }
        
        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 80px 20px;
            color: var(--text-secondary);
        }
        
        .empty-icon {
            font-size: 80px;
            margin-bottom: 24px;
            opacity: 0.5;
        }
        
        .empty-state h3 {
            font-size: 20px;
            margin-bottom: 8px;
            color: var(--text-primary);
        }
        
        .empty-state p {
            font-size: 15px;
            max-width: 400px;
            margin: 0 auto;
        }
        
        /* Loading Animation */
        .loading-posts {
            text-align: center;
            padding: 40px 20px;
            color: var(--text-secondary);
        }
        
        .spinner {
            width: 40px;
            height: 40px;
            border: 4px solid var(--border);
            border-top: 4px solid var(--primary);
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 16px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Floating Action Button */
        .fab {
            position: fixed;
            bottom: 24px;
            right: 24px;
            width: 56px;
            height: 56px;
            background: linear-gradient(135deg, var(--primary), #166fe5);
            color: white;
            border: none;
            border-radius: 50%;
            cursor: pointer;
            box-shadow: 0 4px 20px rgba(24, 119, 242, 0.4);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            transition: all 0.3s ease;
            z-index: 1000;
        }
        
        .fab:hover {
            transform: scale(1.1);
            box-shadow: 0 6px 24px rgba(24, 119, 242, 0.5);
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .modern-container {
                padding: 16px 12px 60px;
            }
            
            .post-card {
                border-radius: 12px;
                margin-bottom: 16px;
            }
            
            .post-header {
                padding: 14px 16px 10px;
            }
            
            .post-content {
                padding: 0 16px 14px;
            }
            
            .post-stats, .post-actions {
                padding-left: 16px;
                padding-right: 16px;
            }
            
            .header-text h1 {
                font-size: 18px;
            }
            
            .header-text p {
                font-size: 13px;
            }
            
            .fab {
                bottom: 20px;
                right: 20px;
                width: 52px;
                height: 52px;
            }
            
             header {
         padding: 23px 1% !important;
         gap: 20px !important;
         flex-flow: column !important; 
    }
    
     .footer-content {
        flex-flow: column;
        gap: 10px !important;
        padding-top: 20px;
        padding-bottom: 20px;
    }
    .footer-column p {
        margin: 0 !important;
        text-align: center;
    }    
        }
        
        @media (max-width: 480px) {
            .post-avatar {
                width: 42px;
                height: 42px;
            }
            
            .post-title {
                font-size: 17px;
            }
            
            .post-description {
                font-size: 14px;
            }
            
            .action-btn span {
                display: none;
            }
            
            .action-btn {
                gap: 0;
            }
            
    .modal {
        top: 152px !important;
        height: 60% !important;
        margin-left: 10px;
        /* margin-right: 10px; */
        width: 95% !important;
        border-radius: 10px;
        border: 3px solid #178967;
    }
    
    .close {
    top: 9px !important;
    right: 9px !important;}
    
.modal-content{
    height: 90% !important;
    opacity: 1 !important;
    margin-bottom: 40px !important;
}  

.nav-btn {
        padding: 0px 14px !important;
        font-size: 20px !important;
        width: 30px !important;
        height: 30px !important;
        display: flex;
        justify-content: center;
        align-items: center;
        border-radius: 50%;
        background: white !important;
        color: black !important;
        margin-left: -20px !important;
        margin-right: -18px !important;
    
}
    
        }
        
        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }
        
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--bg-color);
        }
        
        ::-webkit-scrollbar-thumb {
            background: #c1c1c1;
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #a8a8a8;
        }
        
        /* Like animation */
        @keyframes likeAnimation {
            0% { transform: scale(1); }
            50% { transform: scale(1.3); }
            100% { transform: scale(1); }
        }
        
        .liked {
            animation: likeAnimation 0.4s ease;
            color: var(--primary) !important;
        }

/* Grid Layout */
.image-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
    gap: 10px;
}

/* Each image wrapper */
.image-item {
    width: 100%;
    height: 150px;
    overflow: hidden;
    border-radius: 8px;
    cursor: pointer;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
}

/* Image itself */
.image-item img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.image-item img:hover {
    transform: scale(1.1);
}

.image-item {
  border-radius: 8px;
  overflow: hidden;
  cursor: pointer;
  transition: transform 0.2s ease;
}

.image-item:hover {
  transform: scale(1.05);
}

.image-item img {
  width: 100%;
  height: 160px;
  object-fit: cover;
  border-radius: 8px;
}

/* Modal */
.modal {
  display: none;
  position: fixed;
  z-index: 9999;
  padding-top: 60px;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0,0,0,0.9);
  text-align: center;
}

.modal-content {
  margin: auto;
  display: block;
  max-width: 90%;
  max-height: 85vh;
  border-radius: 10px;
  box-shadow: 0 0 20px rgba(255,255,255,0.2);
}

.close {
  position: absolute;
  top: 20px;
  right: 35px;
  color: #fff;
  font-size: 35px;
  font-weight: bold;
  cursor: pointer;
}

.close:hover {
  color: #f00;
}

/* Footer */
footer {
    color: white;
    padding-bottom: 15px;
}
    
.logo_box {
    width: 100px;
    height: 100px;
    display: flex;
    margin: auto;
}

.logo_box img{
    width:100%;
    height:100%;
}

.contact_info_box{
    display:flex;
    justify-content:center;
}

.contact_info{
    text-align: center;
    position: relative;
    margin: 0;
    padding-top: 17px;
    padding-bottom: 11px;
}

.contact_info::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    height: 2px;
    background: white;
}
    
.footer-content {
    display: flex;
    justify-content: center;
    gap: 30px;
    padding-top: 20px;
}

.footer-column h3 {
    margin-bottom: 20px;
    font-size: 1.3rem;
    position: relative;
    padding-bottom: 10px;
}

.footer-column h3::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 40px;
    height: 2px;
    background: white;
}

.footer-column p, .footer-column a {
    color: white;
    margin-bottom: 10px;
    display: block;
    text-decoration: none;
    transition: color 0.3s;
}

.copyright {
    text-align: center;
    border-top: 1px solid rgba(255,255,255,0.1);
    color: #aaa;
    font-size: 0.9rem;
}   
    
.direct_top{
    position: fixed;
    bottom: 47px;
    right: 25px;
    background: #e57d07;
    width: 35px;
    color: white;
    height: 35px;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
    text-decoration: none;
    z-index: 100000;
}

.modal {
  display: none;
  position: fixed;
  z-index: 9999;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  background: rgba(0,0,0,0.9);
  justify-content: center;
  align-items: center;
  overflow: hidden;
}

.modal.open {
  display: flex;
}

.modal-content {
  max-width: 90%;
  max-height: 85vh;
  border-radius: 10px;
  box-shadow: 0 0 20px rgba(255,255,255,0.3);
  transition: opacity 0.3s ease, transform 0.3s ease;
  opacity: 1;
  transform: scale(1);
}

.close {
  position: absolute;
  top: 20px;
  right: 35px;
  color: #fff;
  font-size: 35px;
  font-weight: bold;
  cursor: pointer;
  transition: 0.3s;
  z-index: 10000;
}

.close:hover {
  color: #f00;
}

.nav-btn {
    position: absolute;
    top: 50%;
    color: black;
    font-size: 30px;
    font-weight: bold;
    background: white;
    border: none;
    width: 50px;
    height: 50px;
    cursor: pointer;
    user-select: none;
    transform: translateY(-50%);
    transition: background 0.3s;
    z-index: 10000;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
}

.nav-btn:hover {
  background: rgba(255,255,255,0.2);
}

.prev {
  left: 30px;
}

.next {
  right: 30px;
}

.cross_icon{
    width: 30px;
    height: 30px;
    background: white;
    display: flex;
    justify-content: center;
    align-items: center;
    font-size: 17px;
    border-radius: 50%;
    color: black !important;
}

/* Filter Button Styles */
.filter-container {
    display: flex;
    justify-content: center;
    margin: 20px 0;
    gap: 10px;
    flex-wrap: wrap;
}

.filter-btn {
    padding: 12px 24px;
    border: none;
    background:  #db7a0b;
    color: white;
    border-radius: 25px;
    cursor: pointer;
    transition: all 0.3s ease;
    font-weight: 500;
    font-size: 14px;
    border: 2px solid #08314f !important;
}

.filter-btn:hover {
    /*background: #d0d0d0;*/
    transform: translateY(-2px);
}

.filter-btn.active {
    background: #08314f;
    color: white;
    border-color: #db7a0b !Important;
    box-shadow: 0 4px 12px rgba(20, 123, 92, 0.3);
}

/* No posts message for filtered state */
.no-posts-message {
    text-align: center;
    padding: 60px 20px;
    color: #666;
    display: none;
}

.no-posts-message.show {
    display: block;
}

.no-posts-message i {
    font-size: 48px;
    margin-bottom: 20px;
    opacity: 0.5;
}

.no-posts-message h3 {
    font-size: 20px;
    margin-bottom: 10px;
    color: #333;
}

.no-posts-message p {
    font-size: 14px;
    max-width: 400px;
    margin: 0 auto;
}
</style>
</head>

<body>
    <!-- Header Section -->
    <header>
        <div class="logo-area">
            <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
                <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
            </a>
            <div>
                <h2><?php echo $dataweb['web_name']?></h2>
                <p style="margin:0; color:white;"><?php echo $dataweb['web_tag_line']?></p>
            </div>
        </div>

        <nav>
            <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
                <i class="fa-solid fa-house-user"></i> Home
            </a>
            <a href="tel:<?php echo $dataweb['site_mobile_1'] ?>" style="color: black; padding-left: 20px; text-decoration: none;">
                <i class="fa-solid fa-phone"></i> 
                <?php echo $dataweb['site_mobile_1'] ?>
            </a>
        </nav>
    </header>

    <!-- Filter Buttons -->
    <div class="filter-container">
        <button type="button" class="filter-btn active" data-filter="all">Show All</button>
        <button type="button" class="filter-btn" data-filter="Press/Media Post">Press / Media Post</button>
        <button type="button" class="filter-btn" data-filter="Activity Post">Activity Post</button>
    </div>

    <!-- Main Content -->
    <main class="modern-container" id="postsContainer">
        <!-- No Posts Message (Hidden by default) -->
        <div class="no-posts-message" id="noPostsMessage">
            <i class="fas fa-search"></i>
            <h3>No posts found</h3>
            <p>There are no posts matching your current filter. Try selecting a different filter.</p>
        </div>

        <?php if(empty($posts)): ?>
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="far fa-newspaper"></i>
                </div>
                <h3>No posts yet</h3>
                <p>We're working on sharing our latest activities and updates. Please check back soon!</p>
            </div>
        <?php else: ?>
            <?php foreach($posts as $post): ?>
                <div class="post-card" data-post-id="<?= $post['id'] ?>" data-category="<?= $post['category'] ?>">
                    <div class="post-header">
                        <div class="post-avatar">
                            <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
                                <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
                            </a>
                        </div>
                        <div class="post-meta">
                            <div class="post-author"><?= $dataweb['web_name']??''?></div>
                            <div class="post-time">
                                <i class="far fa-clock"></i>
                                <?= date('F j, Y \a\t g:i A', strtotime($post['created_at'])) ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="post-content">
                        <h2 class="post-title"><?= esc($post['name']) ?></h2>
                        <div class="post-description">
                            <?= esc($post['description']) ?>
                        </div>
                        
                        <?php
                        $images = json_decode($post['banner'], true);
                        ?>

                        <div class="image-grid">
                            <?php if (!empty($post['images'])): ?>
                                <?php foreach ($post['images'] as $i => $img): ?>
                                    <div class="image-item">
                                        <img 
                                            src="<?php echo base_url('BannerPost/'.$img['banner']); ?>" 
                                            class="clickable-img"
                                            onclick="openModal(this, <?php echo $i; ?>)" 
                                            data-group="post-<?php echo $post['id']; ?>"
                                        />
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <p>No images found.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <!-- Loading Indicator -->
        <div class="loading-posts" id="loadingIndicator" style="display: none;">
            <div class="spinner"></div>
            <p>Loading more posts...</p>
        </div>
    </main>

    <!-- Modal Image Viewer -->
    <div id="imageModal" class="modal">
        <span class="close cross_icon" onclick="closeModal()">X</span>
        <button class="nav-btn prev" onclick="changeImage(-1)">&#10094;</button>
        <img class="modal-content" id="fullImage">
        <button class="nav-btn next" onclick="changeImage(1)">&#10095;</button>
    </div>

    <!-- Footer -->
    <footer style="background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);">
        <div style="padding-top:25px;">
            <div class="logo_box">
                <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
                    <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
                </a>
            </div>
        </div>
        <div class="contact_info_box">
            <h3 class="contact_info">Contact Info</h3>
        </div>
        
        <div class="footer-content">
            <div class="footer-column">
                <p><i class="fas fa-phone"></i> <?php echo $dataweb['site_mobile_1']?></p>
            </div>
            <div class="footer-column">
                <p><i class="fas fa-envelope"></i>  <?php echo $dataweb['webemail_1']?></p>
            </div>
            <div class="footer-column">
                <p><i class="fas fa-map-marker-alt"></i> <?php echo $dataweb['website_address'] ?></p>
            </div>
        </div>
        <div class="copyright">
            <!-- footer --> 
            <?php require_once($_SERVER['DOCUMENT_ROOT'] . '/software/app/Views/footer.php'); ?>
            <!-- / footer -->
        </div>
    </footer>   

    <!-- Floating Action Button -->
    <button class="fab" onclick="scrollToTop()">
        <i class="fas fa-arrow-up"></i>
    </button>

    <script>
        // Filter functionality
        document.addEventListener('DOMContentLoaded', function() {
            const filterButtons = document.querySelectorAll('.filter-btn');
            const postCards = document.querySelectorAll('.post-card');
            const noPostsMessage = document.getElementById('noPostsMessage');
            
            // Initialize - show all posts
            filterPosts('all');
            
            // Add event listeners to filter buttons
            filterButtons.forEach(button => {
                button.addEventListener('click', function() {
                    // Remove active class from all buttons
                    filterButtons.forEach(btn => btn.classList.remove('active'));
                    
                    // Add active class to clicked button
                    this.classList.add('active');
                    
                    // Get filter type
                    const filterType = this.getAttribute('data-filter');
                    
                    // Filter posts
                    filterPosts(filterType);
                });
            });
            
            function filterPosts(filterType) {
                let visiblePosts = 0;
                
                postCards.forEach(card => {
                    const category = card.getAttribute('data-category');
                    
                    if (filterType === 'all' || category === filterType) {
                        card.style.display = 'block';
                        visiblePosts++;
                    } else {
                        card.style.display = 'none';
                    }
                });
                
                // Show/hide no posts message
                if (visiblePosts === 0 && postCards.length > 0) {
                    noPostsMessage.classList.add('show');
                } else {
                    noPostsMessage.classList.remove('show');
                }
                
                // If no posts at all, don't show the filter message
                if (postCards.length === 0) {
                    noPostsMessage.classList.remove('show');
                }
            }
        });

        // Image Modal functionality
        let currentIndex = 0;
        let imageList = [];

        function openModal(element, index) {
            const group = element.getAttribute("data-group");
            imageList = [...document.querySelectorAll(`.clickable-img[data-group='${group}']`)].map(img => img.src);
            currentIndex = index;

            const modal = document.getElementById('imageModal');
            const modalImg = document.getElementById('fullImage');
            modalImg.src = imageList[currentIndex];
            modal.style.display = 'block';
            document.body.style.overflow = "hidden";
        }

        function closeModal() {
            document.getElementById('imageModal').style.display = "none";
            document.body.style.overflow = "";
        }

        function changeImage(direction) {
            currentIndex += direction;
            if (currentIndex < 0) currentIndex = imageList.length - 1;
            if (currentIndex >= imageList.length) currentIndex = 0;

            const modalImg = document.getElementById('fullImage');
            modalImg.style.opacity = 0;
            setTimeout(() => {
                modalImg.src = imageList[currentIndex];
                modalImg.style.opacity = 1;
            }, 200);
        }

        // Keyboard controls for modal
        document.addEventListener("keydown", function(e){
            const modal = document.getElementById('imageModal');
            if (modal.style.display !== 'block') return;
            
            if(e.key === "Escape") closeModal();
            if(e.key === "ArrowRight") changeImage(1);
            if(e.key === "ArrowLeft") changeImage(-1);
        });

        // Close modal when clicking outside the image
        document.getElementById('imageModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeModal();
            }
        });

        // Scroll to top functionality
        function scrollToTop() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        }

        // Show/hide floating action button
        window.addEventListener('scroll', function() {
            const fab = document.querySelector('.fab');
            if (window.scrollY > 300) {
                fab.style.display = 'flex';
            } else {
                fab.style.display = 'none';
            }
        });

        // Loading functionality (if needed for infinite scroll)
        let isLoading = false;
        window.addEventListener('scroll', function() {
            if (isLoading) return;
            
            const scrollPosition = window.innerHeight + window.scrollY;
            const pageHeight = document.documentElement.scrollHeight - 500;
            
            if (scrollPosition >= pageHeight) {
                loadMorePosts();
            }
        });

        function loadMorePosts() {
            isLoading = true;
            const loadingIndicator = document.getElementById('loadingIndicator');
            loadingIndicator.style.display = 'block';
            
            // Simulate loading (replace with actual AJAX call)
            setTimeout(() => {
                loadingIndicator.innerHTML = '<p>No more posts to load</p>';
                isLoading = false;
            }, 2000);
        }

        // Add interactive hover effects to post cards
        document.querySelectorAll('.post-card').forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-4px)';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });
    </script>
</body>
</html>