<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Card Holder Login</title>
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body{font-family:Poppins,Arial;background:linear-gradient(135deg,#eef2f6,#dbe7f2);height:100vh;display:flex;align-items:center;justify-content:center;margin:0}
        .card{background:#fff;padding:28px;border-radius:12px;box-shadow:0 10px 30px rgba(20,40,80,.08);width:420px;max-width:90%}
        h2{margin:0 0 8px;font-size:20px;color:#172b4d}
        p.lead{margin:0 0 18px;color:#6b7a91}
        label{display:block;margin-bottom:6px;font-size:14px;color:#344055}
        input[type="text"], input[type="date"]{width:100%;padding:10px 12px;border:1px solid #e3e8ef;border-radius:8px;margin-bottom:14px}
        .btn{display:inline-block;background:#2a9d8f;color:#fff;padding:10px 14px;border-radius:8px;border:none;cursor:pointer}
        .msg {padding:10px;border-radius:6px;margin-bottom:12px}
        .error{background:#fdecea;color:#8a2b2b;border:1px solid #f5c2c2}
        .info{background:#eef9f2;color:#1e612f;border:1px solid #cfeedb}
        .small{font-size:13px;color:#7782a0;margin-top:10px}
    </style>
</head>
<body>
    <div class="card">
        <h2>Health Card Holder Login</h2>
        <p class="lead">Login with your Card Number and Date of Birth</p>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="msg error"><?= esc(session()->getFlashdata('error')) ?></div>
        <?php endif; ?>

        <form method="post" action="<?= base_url('card-login') ?>">
            <label for="card_number">Card Number</label>
            <input id="card_number" name="card_number" type="text" placeholder="Enter card number" required>

            <label for="dob">Date of Birth</label>
            <input id="dob" name="dob" type="date" required>

            <button class="btn" type="submit">Login</button>
        </form>

        <div class="small">If you don't remember DOB format, use the format provided at registration (YYYY-MM-DD).</div>
    </div>
</body>
</html>
