<?php
               
               $session = session();
               $admin_id = $session->admin_id;
                        require 'db_config.php';
                        
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                        
                        ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Beneficiary List</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    .beneficiary-card {
      border: 1px solid #ddd;
      border-radius: 10px;
      padding: 15px;
      background: #fff;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
      transition: all 0.3s ease-in-out;
      height: 100%;
    }
    .beneficiary-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    .beneficiary-photo {
      width: 100%;
      height: 200px;
      /*object-fit: cover;*/
      border-radius: 10px;
    }
    .filter-section {
      margin-bottom: 25px;
    }
    .hidden {
      display: none !important;
    }
    
header {
      background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
      box-shadow: 0 2px 15px rgba(0,0,0,0.1);
      padding: 15px 20%;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 1000;
    }

    header .logo-area {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    header .logo-area img {
      height: 50px;
      width: 50px;
      object-fit: contain;
    }

    header h2 {
      margin: 0;
      font-size: 22px;
      color: white;
      font-weight: 700;
    }

header nav a {
    margin-left:10px;
    text-decoration: none;
    color: black;
    font-weight: 500;
    transition: color 0.3s;
    position: relative;
    background: white;
    padding: 8px 20px;
    border-radius: 9px;
    text-decoration:none;
}

.bg-success{
    background:#08314f !important;
}

    
  /* Footer */
    footer {
          background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    color: white;
    padding-bottom: 15px;
    }
    
.logo_box {
    width: 100px;
    height: 100px;
    display: flex;
    margin: auto;
}

.logo_box img{
    width:100%;
    height:100%;
}

.contact_info_box{
    display:flex;
    justify-content:center;
}

.contact_info{
    text-align: center;
    position: relative;
    margin: 0;
    padding-top: 17px;
    padding-bottom: 11px;
}

.contact_info::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    height: 2px;
    background: white;
}
    
.footer-content {
    display: flex;
    justify-content: center;
    gap: 30px;
    padding-top: 20px;
}

    .footer-column h3 {
      margin-bottom: 20px;
      font-size: 1.3rem;
      position: relative;
      padding-bottom: 10px;
    }

    .footer-column h3::after {
      content: '';
      position: absolute;
      left: 0;
      bottom: 0;
      width: 40px;
      height: 2px;
      background: #1a936f;
    }

    .footer-column p, .footer-column a {
      color: white;
      margin-bottom: 10px;
      display: block;
      text-decoration: none;
      transition: color 0.3s;
    }


    .copyright {
      text-align: center;
      border-top: 1px solid rgba(255,255,255,0.1);
      color: #aaa;
      font-size: 0.9rem;
    }    
  
@media(max-width:500px){
    header {
         padding: 23px 1% !important;
         gap: 20px !important;
         flex-flow: column !important; 
    }
    
     .footer-content {
        flex-flow: column;
        gap: 10px !important;
        padding-top: 20px;
        padding-bottom: 20px;
    }
    .footer-column p {
        margin: 0 !important;
        text-align: center;
    }
    
    .filter-section{
        gap:10px;
    }
    
}  

.direct_top{
    position: fixed;
    bottom: 47px;
    right: 25px;
    background: #f68302;
    width: 35px;
    color: white;
    height: 35px;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
    text-decoration: none;
    z-index: 100000;
}   

/* popup image code statrt */

.thumbnail {
    width: 100%;
    height: 100%;
    /* object-fit: cover; */
    /* margin: 10px; */
    cursor: pointer;
    /* border: 2px solid #ddd; */
    transition: transform 0.2s;
    border: none;
}
    
.thumbnail:hover {
    transform: scale(1.05);
    border-color: #888;
}
    
.gallery {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    /*max-width: 1200px;*/
    margin: 0 auto;
}
    
.modal2 {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    /*background-color: rgba(0, 0, 0, 0.9);*/
    z-index: 10000000;
    overflow: auto;
}
    
.modal-content {
    position: relative;
    display: inline-block;
    /*max-width: 100%;*/
    /*max-height: 100%;*/
    width:unset !important;
}
    

    
.close-btn {
    position: absolute;
    top: 5px;
    right: 5px;
    color: white;
    font-size: 20px;
    font-weight: bold;
    cursor: pointer;
    background: rgba(0, 0, 0, 0.5);
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
}
    
.close-btn:hover {
    background: rgba(255, 0, 0, 0.7);
    transform: scale(1.1);
}
    
@media(max-width:500px){
    .full-image {
        width: 320px !important;
        height: 320px !important;
    }  
}
  .full-image {
    display: block;
    width: 400px;
    border-radius: 5px;
    height: 400px;
    /*object-fit: contain;*/
    box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
    background:white;
    }  
/* popup image code end */    
  
.btn-primary{
    background:#08314F;
}    

.btn-primary:hover{
    background:#f68302;
}   
  </style>
</head>
<body class="bg-light">
    
<a href="#" class="direct_top"><i class="fa-solid fa-arrow-up"></i></a>

<!-- Header Section -->
  <header>
    <!-- Left Side: Logo + NGO Name -->
    <div class="logo-area">
       <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
      <div>
          <h2><?php echo $dataweb['web_name']?></h2>
          <p style="margin:0; color:white;"><?php echo $dataweb['web_tag_line']?></p>
      </div>
    </div>

    <!-- Right Side: Navigation -->
    <nav>
      <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
            <i class="fa-solid fa-house-user"></i> Home
        </a>
        
      <a href="tel:<?php echo $dataweb['site_mobile_1'] ?>" style="color: black;
    padding-left: 20px;
    text-decoration: none;">
    <i class="fa-solid fa-phone"></i> 
    <?php echo $dataweb['site_mobile_1'] ?>
</a>

    </nav>
  </header>    

<div class="container py-4">
  <h3 class="text-center mb-4">Beneficiary List</h3>

  <!-- Filters -->
  <div class="row filter-section">
    <div class="col-md-4">
      <input type="text" id="searchInput" class="form-control" placeholder="Search by Name or Email">
    </div>
    <div class="col-md-3">
      <select id="categoryFilter" class="form-select">
        <option value="">Filter by Category</option>
        <option value="Education">Education</option>
        <option value="Health">Health</option>
        <option value="Women Empowerment">Women Empowerment</option>
      </select>
    </div>
    <div class="col-md-3">
      <select id="statusFilter" class="form-select">
        <option value="">Filter by Status</option>
        <option value="1">Active</option>
        <option value="0">Stopped</option>
      </select>
    </div>
    <div class="col-md-2 text-end">
      <button id="clearFilters" class="btn btn-secondary w-100">Clear</button>
    </div>
  </div>

  <!-- Beneficiary Cards -->
  <div id="beneficiaryContainer" class="row g-4">
    <?php if (!empty($beneficiary)): ?>
      <?php foreach ($beneficiary as $item): ?>
        <?php
        $benId = $item['id'];
        require 'db_config.php';
        $query = "SELECT * FROM `beneficiarieshelp` WHERE `beneficiary_id` = '$benId'";
        $query_num = mysqli_query($connection, $query);
        $rowci = mysqli_num_rows($query_num);
         
      $benId = $item['id'];
require 'db_config.php';

$query = "SELECT SUM(help_amount) AS total_amount 
          FROM beneficiarieshelp 
          WHERE beneficiary_id = '$benId'";

$result = mysqli_query($connection, $query);
$data = mysqli_fetch_assoc($result);

$totalAmount = $data['total_amount'] ?? 0;
?>
        <div class="col-md-4 beneficiary-item"
             data-name="<?= strtolower($item['full_name']) ?>"
             data-email="<?= strtolower($item['email']) ?>"
             data-category="<?= $item['category'] ?>"
             data-status="<?= $item['status'] ?>"
             data-totalhelp="<?= $rowci ?>"
            data-totalhelpAmount="<?= $totalAmount ?>">
          <div class="beneficiary-card">
            <img src="<?= base_url('beneficiary/profile/' . ($item['profile'] ?: 'no-image.png')) ?>"
                 alt="Profile" class="beneficiary-photo">
            <h5 class="mt-3"><?= esc($item['full_name']) ?></h5>
            <p style="margin:0; padding-bottom:3px;"><strong>Beneficiary Category:</strong> <?= esc($item['category']) ?></p>
            <!--<p style="margin:0; padding-bottom:3px;"><strong>Mobile:</strong> <?= esc($item['mobile']) ?></p>-->
            <!--<p style="margin:0; padding-bottom:3px;"><strong>Email:</strong> <?= esc($item['email']) ?></p>-->
            <p style="margin:0; padding-bottom:3px;"><strong>Beneficiary Details:</strong></p>

<div class="remark-container">
  <span class="remark-text"></span>
  <div class="remark-full-text" style="display:none;">
    <?= esc($item['remark']) ?>
  </div>
  <button class="toggle-btn" style="display:none;">Read More</button>
</div>

<style>
.remark-container {
  max-width: 700px;
  margin-bottom: 10px;
  font-family: Arial, sans-serif;
}

.toggle-btn {
  background: none;
  color: #007bff;
  border: none;
  cursor: pointer;
  font-size: 14px;
  padding: 0;
  margin-top: 5px;
}

.toggle-btn:hover {
  text-decoration: underline;
}

.modle_image_box{
    width: 100px;
    height: 100px;
    border: 1px solid black;
    border-radius: 10px;
    margin:auto;
    padding:4px;
}

.main_popup_image_box{
    /*width: 400px;*/
    margin: auto;
    display: flex;
    justify-content: center;
    gap: 15px;
    
}
</style>



            <p><strong>Total Help:</strong> <?= esc($rowci) ?></p>
            <p>
              <span class="badge <?= $item['status'] == 1 ? 'bg-success' : 'bg-danger' ?>">
                <?= $item['status'] == 1 ? 'Active' : 'Stopped' ?>
              </span>
            </p>
            <button class="btn btn-primary btn-sm viewDetailsBtn"
        data-bs-toggle="modal"
        data-bs-target="#detailsModal"
        data-details='<?= json_encode($item) ?>'
        data-totalhelp='<?= $rowci ?>'
        data-totalhelpamount='<?= $totalAmount ?>'> <!-- Fixed: removed extra comma and corrected attribute -->
    View Details
</button>
                    
              View Details
            </button>
          </div>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <p class="text-center text-muted">No beneficiaries found.</p>
    <?php endif; ?>
  </div>

  <!-- Pagination -->
  <div class="text-center mt-4">
    <button id="prevPage" class="btn btn-outline-primary btn-sm">Previous</button>
    <span id="pageInfo" class="mx-2">Page 1 of 1</span>
    <button id="nextPage" class="btn btn-outline-primary btn-sm">Next</button>
  </div>
</div>

<!-- MODAL -->
<div class="modal fade" id="detailsModal" tabindex="-1" aria-hidden="true" >
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Beneficiary Details</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-4 text-center">
            <img id="modalProfile" src="" class="img-fluid rounded mb-2" style="height:200px;object-fit:cover;">
          </div>
          <div class="col-md-8">
            <h5 id="modalName"></h5>
            <p class="m-0 pb-2"><strong>Father's Name:</strong> <span id="modalFather"></span> || <strong>Gender:</strong> <span id="modalGender"></span> || <strong>Age:</strong> <span id="modalAge"></span></p>
            <p class="m-0 pb-2"><strong>Category:</strong> <span id="modalCategory"></span></p>
            <p class="m-0 pb-2"><strong>State:</strong> <span id="modalState"></span> || <strong>City:</strong> <span id="modalCity"></span></p>
            <p style="margin:0; padding-bottom:3px;"><strong>Beneficiary Details:</strong> <span id="modalRemark"></span></p>
            <p class="m-0 pb-2"><strong>Status:</strong> <span id="modalStatus"></span></p>
            <p class="m-0 pb-2"><strong>Total Help:</strong> <span id="modalTotalHelp"></span></p>
            
          </div>
        </div>
        
        <hr>
<div class="text-center">
  <button id="viewHelpHistoryBtn" 
          class="btn btn-outline-primary btn-sm">
    View Help History
  </button>
</div>
<!-- Help History Section (Initially Hidden) -->
<div id="helpHistorySection" 
     class="mt-3" 
     style="display:none; max-height:250px; overflow-y:auto;">
  <table class="table table-sm table-bordered">
    <thead class="table-light">
      <tr>
        <th>Sr. No.</th>
        <th>Description</th>
        <th>Amount</th>
        <th>Date</th>
      </tr>
    </thead>
    <tbody id="helpHistoryBody">
      <tr><td colspan="4" class="text-center text-muted">Loading...</td></tr>
    </tbody>
  </table>
  <p class="m-0 pb-2"><strong>Total Help Amount:</strong> <span id="modaltotalhelpamount"></span></p>
</div>        
        
        <hr>
        <div class="main_popup_image_box" >
          <div class="text-center">
            <p><strong>ID Proof 1:</strong></p>
               <div class="modle_image_box">
                    <img id="modalId1" src="" class="img-fluid rounded thumbnail" onclick="openFullImage(this.src)">
               </div>
          </div>
          <div class="text-center">
            <p><strong>ID Proof 2:</strong></p>
              <div class="modle_image_box">
                  <img id="modalId2" src="" class="img-fluid rounded thumbnail" onclick="openFullImage(this.src)">
              </div>
          </div>
        </div>
        

      </div>
    </div>
  </div>
</div>

<!-- Footer -->
  <footer>
      <div style="padding-top:25px;">
          <div class="logo_box">
              <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
        </div>
      </div>
        <div class="contact_info_box">
            <h3 class="contact_info">Contact Info</h3>
        </div>
        
    <div class="footer-content">
        
      <div class="footer-column">
        <p><i class="fas fa-phone"></i> <?php echo $dataweb['site_mobile_1']?></p>
      </div>
      <div class="footer-column">
        <p><i class="fas fa-envelope"></i>  <?php echo $dataweb['webemail_1']?></p>
       
      </div>
      <div class="footer-column">
        <p><i class="fas fa-map-marker-alt"></i> <?php echo $dataweb['website_address'] ?></p>
        
      </div>
    </div>
    <div class="copyright">
       <!-- footer --> 
            <?php require_once($_SERVER['DOCUMENT_ROOT'] . '/software/app/Views/footer.php'); ?>
        <!-- / footer -->
    </div>
  </footer>    

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
  const MAX_CHARS = 100; // show first 100 characters

  document.querySelectorAll('.remark-container').forEach(function(container) {
    const textEl = container.querySelector('.remark-text');
    const fullEl = container.querySelector('.remark-full-text');
    const btn = container.querySelector('.toggle-btn');
    const fullText = (fullEl.textContent || '').trim();

    if (!fullText) return;

    if (fullText.length > MAX_CHARS) {
      const shortText = fullText.substring(0, MAX_CHARS) + '...';
      textEl.textContent = shortText;
      btn.style.display = 'inline';
      btn.textContent = 'Read More';

      btn.addEventListener('click', function() {
        const expanded = btn.textContent === 'Read Less';
        textEl.textContent = expanded ? shortText : fullText;
        btn.textContent = expanded ? 'Read More' : 'Read Less';
      });
    } else {
      textEl.textContent = fullText;
      btn.style.display = 'none';
    }
  });
});
</script>
<script>
$(document).ready(function(){
  const itemsPerPage = 6;
  let currentPage = 1;
  let $allItems = $(".beneficiary-item");
  let $filteredItems = $allItems;

 
  updatePagination();

 
  function filterItems() {
    const searchVal = $("#searchInput").val().toLowerCase();
    const categoryVal = $("#categoryFilter").val();
    const statusVal = $("#statusFilter").val();

    $filteredItems = $allItems.filter(function(){
      const $item = $(this);
      const name = $item.data("name");
      const email = $item.data("email");
      const category = $item.data("category");
      const status = $item.data("status").toString();
      
      const matchesSearch = !searchVal || 
                           name.includes(searchVal) || 
                           email.includes(searchVal);
      
      const matchesCategory = !categoryVal || category === categoryVal;
      const matchesStatus = !statusVal || status === statusVal;
      
      return matchesSearch && matchesCategory && matchesStatus;
    });

    currentPage = 1;
    updatePagination();
  }


  function updatePagination() {

    $allItems.addClass('hidden');
    

    const totalItems = $filteredItems.length;
    const totalPages = Math.max(1, Math.ceil(totalItems / itemsPerPage));

    if (currentPage > totalPages) {
      currentPage = totalPages;
    }
    if (currentPage < 1) {
      currentPage = 1;
    }
    
   
    const startIndex = (currentPage - 1) * itemsPerPage;
    const endIndex = startIndex + itemsPerPage;
    
  
    $filteredItems.slice(startIndex, endIndex).removeClass('hidden');
    
  
    $("#pageInfo").text(`Page ${currentPage} of ${totalPages}`);
    
   
    $("#prevPage").prop("disabled", currentPage === 1);
    $("#nextPage").prop("disabled", currentPage === totalPages || totalItems === 0);
    

    $(".text-center.mt-4").toggle(totalItems > itemsPerPage);
  }


  $("#searchInput, #categoryFilter, #statusFilter").on("input change", function(){
    filterItems();
  });

  $("#clearFilters").on("click", function(){
    $("#searchInput").val('');
    $("#categoryFilter").val('');
    $("#statusFilter").val('');
    filterItems();
  });

  $("#prevPage").on("click", function(){
    if (currentPage > 1) {
      currentPage--;
      updatePagination();
    }
  });

  $("#nextPage").on("click", function(){
    const totalItems = $filteredItems.length;
    const totalPages = Math.max(1, Math.ceil(totalItems / itemsPerPage));
    
    if (currentPage < totalPages) {
      currentPage++;
      updatePagination();
    }
  });


let currentBeneficiaryId = null; 

$(document).on("click", ".viewDetailsBtn", function(){
  const item = $(this).data("details");
  const totalHelp = $(this).data("totalhelp");
   const totalhelpAmount = $(this).data("totalhelpamount");
  currentBeneficiaryId = item.id; 

  
  $("#helpHistorySection").hide();
  $("#helpHistoryBody").html('<tr><td colspan="4" class="text-center text-muted">Loading...</td></tr>');

  
  $("#modalProfile").attr("src", "<?= base_url('beneficiary/profile/') ?>" + (item.profile || 'no-image.png'));
  $("#modalName").text(item.full_name);
  $("#modalFather").text(item.father_name);
  $("#modalGender").text(item.gender);
  $("#modalAge").text(item.age);
  $("#modalCategory").text(item.category);
  $("#modalAddress").text(item.address);
  $("#modalCity").text(item.district);
  $("#modalState").text(item.state);
  $("#modalMobile").text(item.mobile);
  $("#modalRemark").text(item.remark);
  $("#modalEmail").text(item.email);
  $("#modalTotalHelp").text(totalHelp);
   $("#modaltotalhelpamount").text(totalhelpAmount);
  
  const statusBadge = item.status == 1 ? 
      '<span class="badge bg-success">Active</span>' : 
      '<span class="badge bg-danger">Stopped</span>';
  $("#modalStatus").html(statusBadge);
  
  $("#modalId1").attr("src", "<?= base_url('beneficiary/idproof/') ?>" + (item.idimage1 || 'no-image.png'));
  $("#modalId2").attr("src", "<?= base_url('beneficiary/idproof2/') ?>" + (item.idimage2 || 'no-image.png'));
});


$("#viewHelpHistoryBtn").on("click", function(){
  if(!currentBeneficiaryId) return;

  $("#helpHistorySection").show();
  $("#helpHistoryBody").html('<tr><td colspan="4" class="text-center text-muted">Loading...</td></tr>');

  $.ajax({
    url: "<?= base_url('get-beneficiary-help-history') ?>/" + currentBeneficiaryId,
    method: "GET",
    dataType: "json",
    success: function(response){
      if(response.status === 'success' && response.data.length > 0){
        let rows = "";
      response.data.forEach((item, index) => {
  const date = new Date(item.created_at);
  const formattedDate = date.toLocaleDateString('en-GB', {
    day: '2-digit',
    month: 'short',
    year: 'numeric'
  });
  
  rows += `<tr>
            <td>${index + 1}</td>
            <td>${item.help_description}</td>
            <td>₹${item.help_amount}</td>
            <td>${formattedDate}</td>
          </tr>`;
});


        $("#helpHistoryBody").html(rows);
      } else {
        $("#helpHistoryBody").html('<tr><td colspan="4" class="text-center text-muted">No help history found.</td></tr>');
      }
    },
    error: function(){
      $("#helpHistoryBody").html('<tr><td colspan="4" class="text-center text-danger">Error loading history.</td></tr>');
    }
  });
});

});
</script>


<!-- popup Image code statrt -->
<script>
  function openFullImage(src) {
    const modal = document.getElementById("imageModal");
    const fullImage = document.getElementById("fullImage");
    
    fullImage.src = src;
    modal.style.display = "flex";
    modal.style.justifyContent = "center";
    modal.style.alignItems = "center";
    document.body.style.overflow = "hidden";
  }
  
  function closeModal() {
    document.getElementById("imageModal").style.display = "none";
    document.body.style.overflow = "auto";
  }
  
  // Close when clicking outside image
  window.addEventListener('click', function(event) {
    if (event.target === document.getElementById("imageModal")) {
      closeModal();
    }
  });
  
  // Close with ESC key
  document.addEventListener('keydown', function(event) {
    if (event.key === "Escape") {
      closeModal();
    }
  });
</script>

<div id="imageModal" class="modal2">
  <div class="modal-content">
    <span class="close-btn" onclick="closeModal()">X</span>
    
        <img id="fullImage" class="full-image">
    
  </div>
</div>

<!-- popup Image code end -->  

</body>
</html>