<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';

$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Expense Details</title>
  <meta name="viewport" content="widtd=device-widtd, initial-scale=1">

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
  <link rel="stylesheet" href="<?php echo base_url('public/css/popup.css')?>" type="text/css" />
  
  
  <style>
    body {
      background-color: #41586e;
      font-family: 'Segoe UI', sans-serif;
    }

    .container {
    width: 450px;
    margin-top: 73px;
    margin-bottom: 50px;
      background: #fff;
      padding: 25px;
      /*border-radius: 8px;*/
      box-shadow: 0 2px 12px rgba(0,0,0,0.1);
    }
    
table {
    width: 100%;
    border-collapse: collapse;
    border: 2px solid #d4efda !important;
  }

th, td {
    padding: 0 !important;
    text-align: left;
    border-bottom: 2px solid #d4efda !important;
     border-left: 2px solid #d4efda !important;
  }
  
  .icon-box {
     width: 42px;
     height: 42px;
     background-color: #e9f7ef;
     display: flex;
     align-items: center;
     justify-content: center;
     color: #0a7e6b;
}
    
.control-label{
    display: flex;
    align-items: center;
    gap:10px;
    margin:0 !important;
    color: black;
    font-weight: 600;
}
    
td p{
    padding-left: 5px;
} 

    .logo-img {
      widtd: 90px;
      height: 90px;
      object-fit: contain;
      margin-bottom: 10px;
    }

    h4.title {
     background: #0a7e6b;
    font-weight: 600;
    margin-bottom: 25px;
    color: white;
    font-size: 22px;
    margin-top: -50px;
    padding: 7px;
    border-radius: 5px;
    }

   

    .btn-success i {
      margin-right: 5px;
    }
    
.member_ship_box{
    width: 90px;
    height: 90px;
    border-radius: 50%;
    padding: 4px;
    background: white;
    margin: auto;
    transform: translate(0px, -70px);
     box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
    }
    .winggo_logo_radius{
        widtd:100%;
        height:100%;
    }
    
@media(max-width:500px){
    .container{
        width:95% !important;
    }
}    

.btn-primary{
    background:#0e6d60 !important;
}
    
  </style>
</head>
<body>

<div class="bg-dark background_color background_color2">
    <div class="container text-center">
   <div class="member_ship_box">
		    <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
		</div>
  <!-- Title -->
  <h4 class="title">Expense Details</h4>

  <!-- Table -->
  <table class="table text-left">
      
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-regular fa-id-card"></i></div>Expense ID:
                </label>
            </td>
            <td><p>EXP-<?php echo $users['id'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-solid fa-receipt"></i></div>Receipt ID::
                </label>
            </td>
            <td><p><?php echo $users['user_id'] ?? 'N/A' ?></p></td>
        </tr>

        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-solid fa-user"></i></div>Name:
                </label>
            </td>
            <td><p><?php echo $users['name'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-solid fa-indian-rupee-sign"></i></div>Amount:
                </label>
            </td>
            <td><p><?php echo $users['amount'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-regular fa-id-card"></i></div>Product Name:
                </label>
            </td>
            <td><p><?php echo $users['productName'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-solid fa-layer-group"></i></div>Expense Category:
                </label>
            </td>
            <td><p><?php echo $users['expense_category'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-brands fa-amazon-pay"></i></div>Paid To:
                </label>
            </td>
            <td><p><?php echo $users['paid_to'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-solid fa-money-check-dollar"></i></div>Payment Mode:
                </label>
            </td>
            <td><p><?php echo $users['payment_mode'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-regular fa-id-card"></i></div>Project Name:
                </label>
            </td>
            <td><p><?php echo $users['project_name'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-regular fa-id-card"></i></div> Description:
                </label>
            </td>
            <td><p><?php echo $users['description'] ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-solid fa-calendar-days"></i></div>Expense Date:
                </label>
            </td>
            <td><p><?php echo date('d-m-Y', strtotime($users['expense_date'])) ?></p></td>
        </tr>
        
        <tr>
            <td>
                <label class="control-label">
                    <div class="icon-box"><i class="fa-solid fa-calendar-days"></i></div>Created Date:
                </label>
            </td>
            <td><p><?php echo date('d-m-Y', strtotime($users['created_at'])) ?></p></td>
        </tr>

  </table>

  <!-- Back Button -->
  <button onclick="history.back()" class="btn btn-primary btn-block" style="outline:none; margin-top: 2%; border:none;">Go Back</button> 
</div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
