<!-- ====================== CSS ======================= -->
<style>
/* Active button styling - Bootstrap compatible */
.active-btn {
    background-color: #0a58ca !important;
    border-color: #0a58ca !important;
    color: #fff !important;
    font-weight: 600;
    box-shadow: 0 0 8px rgba(0, 123, 255, 0.5);
    position: relative;
}

/* Add a small indicator for active button */

.hidden { 
    display: none !important; 
}

.action-buttons {
    text-align: center; 
    margin-top: 20px; 
    display: flex; 
    justify-content: center; 
    gap: 15px; 
    flex-wrap: wrap;
    padding: 15px;
    background-color: #f8f9fa;
    border-radius: 8px;
    border: 1px solid #dee2e6;
}

.category-buttons {
    text-align: center; 
    margin-bottom: 20px; 
    display: flex; 
    justify-content: center; 
    gap: 10px; 
    flex-wrap: wrap;
}

/* Make buttons look better */
.btn_2 {
    padding: 7px 10px;
    border-radius: 6px;
    transition: all 0.3s ease;
    min-width: 100px;
    border-top: 3px solid;
    border-bottom: 3px solid;
}

.btn_2:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}
</style>

<!-- Detect Current URL Path -->
<?php 
// Get the current path properly
$uri = service('request')->getUri();
$currentPath = $uri->getPath(); // This gives you the path without query string
$path = service('request')->uri->getPath();

// Extract the first segment to determine which section is active
$segments = explode('/', trim($currentPath, '/'));
$activeSection = !empty($segments[0]) ? $segments[0] : '';
?>

<!-- ================= CATEGORY BUTTONS ================= -->
<div class="category-buttons">
    <button class="btn_2 btn-secondary <?= ($path == '/software/zones') ? 'active-btn' : '' ?> actionBtn <?= ($activeSection === 'zones') ? 'active-btn' : '' ?>" 
            data-target="zone"><i class="fa-solid fa-crown"></i> Zone</button>
    <button class="btn_2 btn-secondary <?= ($path == '/software/states') ? 'active-btn' : '' ?> actionBtn <?= ($activeSection === 'states') ? 'active-btn' : '' ?>" 
            data-target="state"><i class="fa-solid fa-flag-usa"></i> State</button>
    <button class="btn_2 btn-secondary <?= ($path == '/software/districts') ? 'active-btn' : '' ?> actionBtn <?= ($activeSection === 'districts') ? 'active-btn' : '' ?>" 
            data-target="district"><i class="fa-solid fa-city"></i> District</button>
    <button class="btn_2 btn-secondary <?= ($path == '/software/blocks') ? 'active-btn' : '' ?> actionBtn <?= ($activeSection === 'blocks') ? 'active-btn' : '' ?>" 
            data-target="block"><i class="fa-solid fa-cube"></i> Block</button>
    <button class="btn_2 btn-secondary <?= ($path == '/software/panchayats') ? 'active-btn' : '' ?> actionBtn <?= ($activeSection === 'panchayats') ? 'active-btn' : '' ?>" 
            data-target="panchayat"><i class="fa-solid fa-chess"></i> Panchayat</button>
    <button class="btn_2 btn-secondary" onclick="history.back()" style="background:#2edb2e; color:white; border-color:black;"><i class="fa-solid fa-arrow-left"></i> Go Back</button>        
    <a href="https://<?php echo $dataweb['site_url']?>">
        <button class="btn_2 btn-secondary" style="background: #FF5722; color: white; border-color: black;"><i class="fa-solid fa-house"></i> Home</button>        
    </a>
</div>

<!-- =================== ZONE BOX ====================== -->
<div id="zoneBox" class="action-buttons <?= ($activeSection !== 'zones' && $activeSection !== '') ? 'hidden' : '' ?>">
    <a href="<?= base_url('zones') ?>" 
       class="btn btn-secondary <?= ($currentPath === 'zones' || $currentPath === 'zones/') ? 'active-btn' : '' ?>">
       Show Zone
    </a>

    <a href="<?= base_url('zones/create') ?>" 
       class="btn btn-success <?= ($currentPath === 'zones/create') ? 'active-btn' : '' ?>">
       Add Zone
    </a>
</div>

<!-- =================== STATE BOX ====================== -->
<div id="stateBox" class="action-buttons <?= ($activeSection !== 'states') ? 'hidden' : '' ?>">
    <a href="<?= base_url('states') ?>" 
       class="btn btn-secondary <?= ($currentPath === 'states' || $currentPath === 'states/') ? 'active-btn' : '' ?>">
       Show State
    </a>

    <a href="<?= base_url('states/create') ?>" 
       class="btn btn-success <?= ($currentPath === 'states/create') ? 'active-btn' : '' ?>">
       Add State
    </a>
</div>

<!-- =================== DISTRICT BOX ====================== -->
<div id="districtBox" class="action-buttons <?= ($activeSection !== 'districts') ? 'hidden' : '' ?>">
    <a href="<?= base_url('districts') ?>" 
       class="btn btn-secondary <?= ($currentPath === 'districts' || $currentPath === 'districts/') ? 'active-btn' : '' ?>">
       Show District
    </a>

    <a href="<?= base_url('districts/create') ?>" 
       class="btn btn-success <?= ($currentPath === 'districts/create') ? 'active-btn' : '' ?>">
       Add District
    </a>
</div>

<!-- =================== BLOCK BOX ====================== -->
<div id="blockBox" class="action-buttons <?= ($activeSection !== 'blocks') ? 'hidden' : '' ?>">
    <a href="<?= base_url('blocks') ?>" 
       class="btn btn-secondary <?= ($currentPath === 'blocks' || $currentPath === 'blocks/') ? 'active-btn' : '' ?>">
       Show Block
    </a>

    <a href="<?= base_url('blocks/create') ?>" 
       class="btn btn-success <?= ($currentPath === 'blocks/create') ? 'active-btn' : '' ?>">
       Add Block
    </a>
</div>

<!-- =================== PANCHAYAT BOX ====================== -->
<div id="panchayatBox" class="action-buttons <?= ($activeSection !== 'panchayats') ? 'hidden' : '' ?>">
    <a href="<?= base_url('panchayats') ?>" 
       class="btn btn-secondary <?= ($currentPath === 'panchayats' || $currentPath === 'panchayats/') ? 'active-btn' : '' ?>">
       Show Panchayat
    </a>

    <a href="<?= base_url('panchayats/create') ?>" 
       class="btn btn-success <?= ($currentPath === 'panchayats/create') ? 'active-btn' : '' ?>">
       Add Panchayat
    </a>
</div>

<!-- ====================== SCRIPT ======================= -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const actionButtons = document.querySelectorAll('.actionBtn');
    const actionBoxes = document.querySelectorAll('.action-buttons');
    
    // Function to show specific box
    function showBox(targetBox) {
        // Hide all boxes
        actionBoxes.forEach(box => {
            box.classList.add('hidden');
        });
        
        // Remove active class from all category buttons
        actionButtons.forEach(btn => {
            btn.classList.remove('active-btn');
        });
        
        // Show the target box
        const boxToShow = document.getElementById(targetBox + 'Box');
        if (boxToShow) {
            boxToShow.classList.remove('hidden');
        }
        
        // Add active class to clicked button
        const clickedBtn = document.querySelector(`.actionBtn[data-target="${targetBox}"]`);
        if (clickedBtn) {
            clickedBtn.classList.add('active-btn');
        }
    }
    
    // Add click event to category buttons
    actionButtons.forEach(btn => {
        btn.addEventListener('click', function() {
            const target = this.dataset.target;
            showBox(target);
        });
    });
    
    // Show appropriate box based on current URL on page load
    const currentPath = window.location.pathname;
    const pathSegments = currentPath.split('/').filter(segment => segment);
    
    if (pathSegments.length > 0) {
        const currentSection = pathSegments[0];
        
        // Map URL segments to box targets
        const sectionMap = {
            'zones': 'zone',
            'states': 'state',
            'districts': 'district',
            'blocks': 'block',
            'panchayats': 'panchayat'
        };
        
        if (sectionMap[currentSection]) {
            // Show the box for current section
            setTimeout(() => {
                showBox(sectionMap[currentSection]);
            }, 100);
        }
    } else {
        // Default: show zone box if no specific section
        showBox('zone');
    }
});
</script>