<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>News</title>
    <style>
        * { 
            margin: 0;
            padding: 0; 
            box-sizing: 
            border-box; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
            
        }
        body {
            /*background-image: linear-gradient(39deg, #FEED18 0%, #D84B37 54%);*/
            min-height: 100vh;
            display: flex; flex-direction: column; 
            justify-content: center; 
            align-items: center;
            padding: 20px; 
            color: #fff;
        }
        
        .container { 
            /*background-image: linear-gradient(39deg, #FEED18 0%, #D84B37 54%);*/
            max-width: 800px; 
            width: 100%; 
            /*background: rgba(255, 255, 255, 0.1); */
            backdrop-filter: blur(10px);
            border-radius: 12px; 
            /*padding: 25px; */
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3); 
            border-top: 3px solid #376070;
            border-bottom: 3px solid #376070;
            overflow: hidden;
            background: linear-gradient(to right, #0a7e6b, #c5c7ca);
        }
        
h1 { 
    /*text-align: center; */
    font-size: 2.5rem;
    text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
    color: #fff;
    font-size: 23px;
    /*padding: 20px;*/
    border-radius: 12px 12px 0px 0px;
}
        
        .news-box { 
            width: 100%; 
            height: 350px; 
            border: 1px solid rgba(255, 255, 255, 0.2); 
            overflow: hidden; 
            position: relative;
            background: rgba(0, 0, 0, 0.2); 
            /*border-radius: 8px; */
            padding: 15px; 
            background: white;
        }
        
        .news-box h3 { 
            text-align: center; 
            margin: 0 0 15px; 
            font-size: 1.8rem;
            background: linear-gradient(90deg, #ff8a00, #e52e71); 
            color: white;
            padding: 12px; 
            border-radius: 6px; 
            position: relative; 
            z-index: 10; 
            box-shadow: 0 4px 6px rgba(0,0,0,0.2); 
            
        }
        
        .news-list-container { 
            height: calc(100% - 0px); 
            overflow: hidden; 
            position: relative; 
            
        }
        
        .news-list { 
            position: absolute; 
            width: 100%; 
            animation: scrollUp 140s linear infinite; 
            
        }
        
.news-item { 
    padding: 15px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    font-size: 1.1rem;
    line-height: 1.5;
    /* background: rgba(255, 255, 255, 0.1); */
    margin-bottom: 10px;
    /* background: red; */
    box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
    border-radius: 6px;
    transition: transform 0.3s, background 0.3s;
    border-left: 3px solid #4ca1af;
    display: flex
;
    align-items: center;
        }
        
        .news-item:hover { 
            background: rgba(255,255,255,0.2); 
            transform: translateX(5px); 
            
        }
        
        .news-list.paused { 
            animation-play-state: paused; 
            
        }
        
        @keyframes scrollUp {
            0%{ transform: translateY(0);
                
            } 
            100%{ transform: translateY(-100%);
                
            } 
            
        }
        
.instructions { 
    /*text-align: center;*/
    margin: 20px;
    font-size: 1rem;
    opacity: 0.8;
    color: white;
            
}
        
.date-badge {
    /* display: inline-block; */
    background: rgba(255, 255, 255, 0.2);
    /* padding: 3px 8px; */
    border-radius: 12px;
    font-size: 0.8rem;
    margin-right: 8px;
    height: 60px;
    width: 60px;
    display: flex;
    justify-content: center;
    align-items: center;
    text-align: center;
        background: linear-gradient(to right, #0a7e6b, #c5c7ca);
}
        
        .breaking-news { 
            background: linear-gradient(90deg, #ff0000, #ff8a00); 
            color:white;
            padding:3px 10px; 
            border-radius:4px; 
            font-weight:bold; 
            margin-right:8px; 
            font-size:0.8rem; 
            
        }
        
        .news-source { 
            float:right; 
            font-style:italic; 
            opacity:0.7; 
            
        }
        
.latest_news{
    padding: 20px;
    display: flex;
    justify-content: space-between;
}        
        
        @media (max-width: 600px) {
            .latest_news { 
                font-size: 20px !important; 
                /*margin-bottom: 15px !important;*/
                flex-flow:column;
            } 
            
            .news-box { 
                height: 300px; 
                
            }
            
            .news-item { 
                font-size: 1rem; 
                padding: 12px; 
                
            }
            
            .instructions{
                font-size:15px !important;
            }
        }
        
::-webkit-scrollbar {
    display: none !important;
}        
    </style>
</head>
<body>
    <div class="container">
        
        <div class="latest_news">
            <h1 >Latest News Updates</h1>
            <span>Total <?= count($news)?> items</span>
        </div>
        
        <div class="news-box">
            <h3 style="display:none;"><?= $heading ?></h3>
            <div class="news-list-container">
                <div class="news-list" id="newsList">
                    <?php if(!empty($news)){ ?>
                        <?php foreach($news as $item): ?>
                            
                                <a href="<?= base_url('News-Details/'.$item['id']) ?>" target="_blank" style="color:white;text-decoration:none;">
                            <div class="news-item">
                                <span class="date-badge date_badge_2">
                                    <?= date("d M Y", strtotime($item['created_at'] ?? date("Y-m-d"))) ?>
                                </span>
                                <?php if(!empty($item['is_breaking'])){ ?>
                                    <span class="breaking-news">BREAKING</span>
                                <?php } ?>
                                
                                    <span style="color: black;"><?= esc($item['title']) ?><br> <span style="font-size:14px;"><?= esc($item['description']) ?></span></span>
                                    <span style="color: black;"></span>
                               
                                <?php if(!empty($item['source'])){ ?>
                                    <span class="news-source"><?= esc($item['source']) ?></span>
                                <?php } ?>
                                
                            </div>
                             </a>
                        <?php endforeach; ?>
                    <?php } else { ?>
                        <p>No Active News Found</p>
                    <?php } ?>
                </div>
            </div>
        </div>
        
        <div class="instructions">Hover over the news to pause scrolling</div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const newsList = document.getElementById('newsList');
            const newsItems = newsList.querySelectorAll('.news-item');
            
            // Clone for seamless scrolling
            // newsItems.forEach(item => {
            //     const clone = item.cloneNode(true);
            //     newsList.appendChild(clone);
            // });
            
            // Pause on hover
            const newsBox = document.querySelector('.news-box');
            newsBox.addEventListener('mouseenter', () => newsList.classList.add('paused'));
            newsBox.addEventListener('mouseleave', () => newsList.classList.remove('paused'));
        });
    </script>
    
    
</body>
</html>
