<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';


$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);


$perPage = 6;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page > 1) ? ($page * $perPage) - $perPage : 0;


$totalQuery = "SELECT COUNT(*) as total FROM users WHERE status = 'active'"; 
$totalResult = mysqli_query($connection, $totalQuery);
$totalRow = mysqli_fetch_assoc($totalResult);
$total = $totalRow['total'];


$pages = ceil($total / $perPage);


$query = "SELECT * FROM users WHERE status = 'active' ORDER BY id DESC LIMIT $start, $perPage";
$result = mysqli_query($connection, $query);
$member = [];
while ($row = mysqli_fetch_assoc($result)) {
    $member[] = $row;
}


$statesQuery = "SELECT DISTINCT state FROM users WHERE state IS NOT NULL AND state != '' ORDER BY state";
$statesResult = mysqli_query($connection, $statesQuery);
$states = [];
while ($row = mysqli_fetch_assoc($statesResult)) {
    $states[] = $row['state'];
}

$districtsQuery = "SELECT DISTINCT district FROM users WHERE district IS NOT NULL AND district != '' ORDER BY district";
$districtsResult = mysqli_query($connection, $districtsQuery);
$districts = [];
while ($row = mysqli_fetch_assoc($districtsResult)) {
    $districts[] = $row['district'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Member Data</title>
     <link rel="shortcut icon" type="image/x-icon" href="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>"/>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
 <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
     :root {
            --primary-color: #0a7e6b;
            --hover-color: #c6c8cb;
            --secondary-color: #3f37c9;
            --accent-color: #4cc9f0;
            --light-bg: #f8f9fa;
            --dark-text: #212529;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--light-bg);
            color: var(--dark-text);
        }
        
 header {
      box-shadow: 0 2px 15px rgba(0,0,0,0.1);
      padding: 15px 20%;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 1000;
      background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    }

    header .logo-area {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    header .logo-area img {
      height: 50px;
      width: 50px;
      object-fit: contain;
    }

    header h2 {
      margin: 0;
      font-size: 22px;
      color: white;
      font-weight: 700;
    }

header nav a {
    margin-left:10px;
    text-decoration: none;
    color: black;
    font-weight: 500;
    transition: color 0.3s;
    position: relative;
    background: #f0f7f4;
    padding: 8px 20px;
    border-radius: 9px;
    text-decoration:none;
}

    header nav a:hover {
      color: black;
    }            
    
    .member-card {
        background: white;
        transition: all 0.2s ease;
        border-radius: 10px;
        margin-bottom: 20px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        border-top: 6px solid #e07b09;
        border-bottom: 6px solid #e07b09;
        padding-top:5px;
        border-left: none;
        border-right: none;
    }
    
    .member-card:hover {
        transform: translateY(-12px);
    }

    .member_profile_img {
        height: 100px;
        width: 100px;
        margin: auto;
        border: 2px solid #e67d07;
        border-radius:50%;
        padding: 2px;
        margin-top: -50px;
        background: white;
    }

    .member-img{
        width:100%;
        height:100%;
        border-radius:50%;
    }

    .card-body {
        padding: 1.25rem;
    }
    .member-status {
        position: absolute;
        top: 10px;
        right: 10px;
        padding: 3px 8px;
        border-radius: 20px;
        font-size: 12px;
    }
    .status-active {
        background-color: #28a745;
        color: white;
    }
    .status-inactive {
        background-color: #dc3545;
        color: white;
    }
    .search-container {
        background: white;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        padding: 20px;
        margin-top: 10px;
        border-radius: 8px;
        margin-bottom: 30px;
        padding-top:25px;
    }

    .main_search_box{
        background: #ffffff;
        margin: auto;
        position: sticky;
        top: 10px;
        z-index: 1000;
    }
    .filter-btn {
        margin-right: 5px;
        margin-bottom: 5px;
    }
    .no-results {
        text-align: center;
        padding: 50px;
        color: #6c757d;
    }
    .filter-section {
        margin-bottom: 15px;
    }
    
    .form-control:focus {
        color: var(--bs-body-color);
        background-color: var(--bs-body-bg);
        border-color: #86b7fe;
    }

    .form-label {
        font-weight: 500;
        color: #5a5c69;
        margin-bottom: 8px;
        font-size: 0.9rem;
    }

    .card-title{
        text-align: center;
        font-size: 25px;
        font-weight: 600;
    }

    .location_icon{
        width: 40px;
        height: 40px;
        background-color: rgba(67, 97, 238, 0.1);
        color: #08314f;
        display: flex;
        border-radius: 50%;
        align-items: center;
        justify-content: center;
    }

    .card-text span{
        font-size: 13px;
        font-weight: 400;
        color: #c6c8cb;
    }

    .card-footer{
        margin-top: 25px;
        border: none;
        background: #f8f9fa !important;
        text-align: center;
        border-radius: 5px !important;
    }
    
 /* Footer */
    footer {
      /*background: #1a3c32;*/
    color: white;
    padding-bottom: 15px;
    }
    
.logo_box {
    width: 100px;
    height: 100px;
    display: flex;
    margin: auto;
}

.logo_box img{
    width:100%;
    height:100%;
}

.contact_info_box{
    display:flex;
    justify-content:center;
}

.contact_info{
    text-align: center;
    position: relative;
    margin: 0;
    padding-top: 17px;
    padding-bottom: 11px;
}

.contact_info::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    height: 2px;
    background: white;
}
    
.footer-content {
    display: flex;
    justify-content: center;
    gap: 30px;
    padding-top: 20px;
}

    .footer-column h3 {
      margin-bottom: 20px;
      font-size: 1.3rem;
      position: relative;
      padding-bottom: 10px;
    }

    .footer-column h3::after {
      content: '';
      position: absolute;
      left: 0;
      bottom: 0;
      width: 40px;
      height: 2px;
      background: white;
    }

    .footer-column p, .footer-column a {
      color: white;
      margin-bottom: 10px;
      display: block;
      text-decoration: none;
      transition: color 0.3s;
    }


    /*.copyright {*/
    /*  text-align: center;*/
    /*  border-top: 1px solid rgba(255,255,255,0.1);*/
    /*  color: #aaa;*/
    /*  font-size: 0.9rem;*/
    /*}   */
    
.direct_top{
    position: fixed;
    bottom: 47px;
    right: 25px;
    background:  #db7a0b;
    width: 35px;
    color: white;
    height: 35px;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
    text-decoration: none;
    z-index: 100000;
}

    

@media(max-width:500px){
     header {
         padding: 23px 1% !important;
         gap: 20px !important;
         flex-flow: column !important; 
    }
    
     .footer-content {
        flex-flow: column;
        gap: 10px !important;
        padding-top: 20px;
        padding-bottom: 20px;
    }
    .footer-column p {
        margin: 0 !important;
        text-align: center;
    }    
        
        .main_search_box{
            width:100% !important;
        }
        
        .search-box{
            margin-bottom:10px;
        }
        
        .search_state{
            width:50%;
        }
    }

    .search-icon {
        position: absolute;
        left: 20px;
        top: 43px;
        color: #b7b9cc;
    }
    
    .search-header {
        color: #e07b09;
        margin-bottom: 25px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    ::-webkit-scrollbar {
        display:none;
    }
    
    /* Pagination Styles */
    .pagination-container {
        display: flex;
        justify-content: center;
        margin-top: 30px;
        margin-bottom: 50px;
    }
    
    .pagination {
        display: flex;
        list-style: none;
        padding: 0;
    }
    
    .page-item {
        margin: 0 5px;
    }
    
    .page-link {
        color: #e67d07;
        background-color: white;
        border: 1px solid #dee2e6;
        padding: 8px 16px;
        border-radius: 4px;
        transition: all 0.3s;
    }
    
    .page-link:hover {
        background-color: #f1f1f1;
        border-color: #dee2e6;
    }
    
    .page-item.active .page-link {
        background-color: #e67d07;
        border-color: #0a7e6b;
        color: white;
    }
    
    .page-item.disabled .page-link {
        color: #e67d07;
        pointer-events: none;
        background-color: white;
        border-color: #dee2e6;
    }
    
  /* Filter box animation */
.animated-slide-up {
    backdrop-filter: blur(10px);
    opacity:0;
    transform: translateY(40px);
    animation: slideUp 1.5s ease forwards;
    animation-delay: 0.6s;
  }
  @keyframes slideUp {
    to {opacity:1; transform: translateY(0);}
  }    
  
  
    
    </style>
</head>
<body>
    
<a href="#" class="direct_top"><i class="fa-solid fa-arrow-up"></i></a>

<!-- Header Section -->
  <header>
    <!-- Left Side: Logo + NGO Name -->
    <div class="logo-area">
       <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
          <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
       </a>
      <div>
          <h2><?php echo $dataweb['web_name']?></h2>
          <p style="margin:0; color:white;"><?php echo $dataweb['web_tag_line']?></p>
      </div>
    </div>

    <!-- Right Side: Navigation -->
    <nav>
        
         <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <i class="fa-solid fa-house-user"></i> Home
</a>

      <a href="tel:<?php echo $dataweb['site_mobile_1'] ?>" style="color: black;
    padding-left: 20px;
    text-decoration: none;">
    <i class="fa-solid fa-phone"></i> 
    <?php echo $dataweb['site_mobile_1'] ?>
</a>

    </nav>
  </header>        
    
    <div class="container">
        <div class="animated-slide-up" style="background: #ffffff; margin: auto; ">
            <div class="main_search_box">
                <div class="search-container">
                    <h4 class="search-header"><i class="fa-solid fa-users"></i> Member Search</h4>
                    <div class="row">
                        <!-- Search Input -->
                        <div class="col-md-6 search-box position-relative">
                            <label for="search" class="form-label">Search Members</label>
                            <i class="fas fa-search search-icon"></i>
                            <input type="text" id="search" class="form-control" placeholder="Name, PIN code, member ID..." style="padding-left: 30px;">
                        </div>
                         
                        <div class="col-md-3 search_state">
                            <div class="filter-section">
                                <label class="form-label"><i class="fa-solid fa-location-dot"></i> State</label>
                                <select id="stateFilter" class="form-select form-control">
                                    <option value="">All States</option>
                                    <?php foreach ($states as $state): ?>
                                        <option value="<?= htmlspecialchars($state) ?>"><?= htmlspecialchars($state) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3 search_state">
                            <div class="filter-section">
                                <label class="form-label"><i class="fa-solid fa-building"></i> District</label>
                                <select id="districtFilter" class="form-select form-control">
                                    <option value="">All Districts</option>
                                    <?php foreach ($districts as $district): ?>
                                        <option value="<?= htmlspecialchars($district) ?>"><?= htmlspecialchars($district) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>   
                    </div>
                </div>
            </div>
        </div>

        <!-- Members Cards -->
        <div style="max-width: 1050px; margin: auto;">
            <div class="row" id="membersContainer">
                <?php if (!empty($member)): ?>
                    <?php foreach ($member as $m): ?>
                    <div class="col-md-4 member-item mb-5" style="margin-top:30px;"
                         data-name="<?= strtolower(htmlspecialchars($m['name'])) ?>" 
                         data-mobile="<?= htmlspecialchars($m['mobile']) ?>" 
                         data-email="<?= strtolower(htmlspecialchars($m['email'])) ?>" 
                         data-address="<?= strtolower(htmlspecialchars($m['address'])) ?>" 
                         data-pin_code="<?= htmlspecialchars($m['pin_code']) ?>" 
                         data-status="<?= htmlspecialchars($m['status']) ?>"
                         data-state="<?= htmlspecialchars($m['state']) ?>"
                         data-district="<?= htmlspecialchars($m['district']) ?>">
                        <div class="card member-card h-100">
                            <div class="position-relative">
                                <?php if (!empty($m['profile'])): ?>
                                    <div class="member_profile_img">
                                        <img src="<?= htmlspecialchars(base_url('images/'.$m['profile'])) ?>" class="card-img-top member-img" alt="<?= htmlspecialchars($m['name']) ?>">
                                    </div>
                                <?php else: ?>
                                    <div class="member_profile_img">
                                        <i class="fas fa-user-circle text-secondary" style="font-size:75px;"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title"><?= htmlspecialchars($m['name']) ?></h5>
                                <div style="display: flex; align-items: center; margin-bottom: 15px;">
                                    <p style="margin:0;">
                                    <i class="fas fa-map-marker-alt me-2 location_icon"></i>
                                </p>
                                <p class="card-text">
                                    <span>Location</span><br>
                                    <?php if (!empty($m['state'])): ?>
                                            <?= htmlspecialchars($m['district']) ?>, <?= htmlspecialchars($m['state']) ?>
                                       <br>
                                    <?php endif; ?>
                                </p>
                                </div>
                             
                                
                                <div style="display: flex; align-items: center;">
                                    <p style="margin:0;">
                                        <i class="fa-solid fa-users location_icon"></i> 
                                    </p>
                                    <p class="card-text" style="margin-left: 10px;">
                                        <span>Designation</span><br>
                                    <?php if (!empty($m['designation'])): ?>
                                        <?php 
$designationParts = explode('-', $m['designation']);
echo isset($designationParts[1]) ? trim($designationParts[1]) : ucfirst($m['designation']);
?>
                                    <?php endif; ?>
                                </p>
                                </div>
                                <div class="card-footer bg-transparent">
                                    <small class="text-muted"><i class="fa-solid fa-calendar-days"></i>&nbsp; Joined: <?= date('d M Y', strtotime($m['created_at'])) ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12 no-results">
                        <i class="fas fa-search fa-3x mb-3"></i>
                        <h3>No Members Found</h3>
                        <p>There are currently no active members</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Pagination -->
        <?php if($pages > 1): ?>
    <nav aria-label="Event pagination" class="mt-5">
        <ul class="pagination justify-content-center">
            <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $page-1 ?>" tabindex="-1" aria-disabled="<?= ($page <= 1) ? 'true' : 'false' ?>">Previous</a>
            </li>
            
            <?php for($i = 1; $i <= $pages; $i++): ?>
                <li class="page-item <?= ($page == $i) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
            
            <li class="page-item <?= ($page >= $pages) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $page+1 ?>" aria-disabled="<?= ($page >= $pages) ? 'true' : 'false' ?>">Next</a>
            </li>
        </ul>
    </nav>
    <?php endif; ?>
    </div>
    
<!-- Footer -->
  <footer style="background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);">
      <div style="padding-top:25px;">
          <div class="logo_box">
              <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
        </div>
      </div>
        <div class="contact_info_box">
            <h3 class="contact_info">Contact Info</h3>
        </div>
        
    <div class="footer-content">
        
      <div class="footer-column">
        <p><i class="fas fa-phone"></i> <?php echo $dataweb['site_mobile_1']?></p>
      </div>
      <div class="footer-column">
        <p><i class="fas fa-envelope"></i>  <?php echo $dataweb['webemail_1']?></p>
       
      </div>
      <div class="footer-column">
        <p><i class="fas fa-map-marker-alt"></i> <?php echo $dataweb['website_address'] ?></p>
        
      </div>
    </div>
    <div class="copyright">
       <!-- footer --> 
            <?php require_once($_SERVER['DOCUMENT_ROOT'] . '/software/app/Views/footer.php'); ?>
        <!-- / footer -->
    </div>
  </footer>        
    
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Search and filter functionality
            function filterMembers() {
                const searchTerm = $('#search').val().toLowerCase();
                const stateFilter = $('#stateFilter').val();
                const districtFilter = $('#districtFilter').val();
                
                let hasResults = false;
                
                $('.member-item').each(function() {
                    const name = $(this).data('name');
                    const mobile = $(this).data('mobile');
                    const email = $(this).data('email');
                    const address = $(this).data('address');
                    const pinCode = $(this).data('pin_code');
                    
                    const matchesSearch = name.includes(searchTerm) || 
                                         mobile.includes(searchTerm) || 
                                         email.includes(searchTerm) || 
                                         address.includes(searchTerm) || 
                                         pinCode.toString().includes(searchTerm);
                    
                    const matchesState = !stateFilter || $(this).data('state') === stateFilter;
                    const matchesDistrict = !districtFilter || $(this).data('district') === districtFilter;
                    
                    if (matchesSearch && matchesState && matchesDistrict) {
                        $(this).show();
                        hasResults = true;
                    } else {
                        $(this).hide();
                    }
                });
                
                if ($('.member-item:visible').length === 0) {
                    $('#noResults').show();
                } else {
                    $('#noResults').hide();
                }
            }
            
            // Initialize filters
            $('#search, #stateFilter, #districtFilter').on('change keyup', filterMembers);
            
            // Update district options when state changes
            $('#stateFilter').change(function() {
                const selectedState = $(this).val();
                if (selectedState) {
                    // You could implement AJAX here to fetch districts for the selected state
                    // For now, we'll just filter the existing districts
                    $('#districtFilter option').show();
                    if (selectedState) {
                        $('#districtFilter option').each(function() {
                            const $option = $(this);
                            const districtState = $option.data('state'); // You would need to add data-state attributes
                            if (districtState && districtState !== selectedState) {
                                $option.hide();
                            }
                        });
                    }
                }
                $('#districtFilter').val('').trigger('change');
            });
        });
    </script>
</body>
</html>