<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\TransactionModel;
use App\Controllers\BaseController;
use App\Models\AdminNoticeModel;
use App\Models\Payments_Mode_Models;
use App\Models\Payments_Payu_Mode_Model;
use App\Models\Payments_Razor_Mode_Model;
use App\Models\Donote_TransactionModel;
use App\Models\SettingsModel;
use Razorpay\Api\Api;
use Dompdf\Dompdf;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
 use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf; 
use CodeIgniter\I18n\Time;
class User_Controller extends BaseController
{

public function Donate_My_Referal(){
    
            $session = session();
         $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
       
        if($data){
            $id =$session->id;
             if($data['user_type']=="user"){
                 $data['heading']="Donate My Referral";
                   $data['users'] = $userModel->where('id', $session->id)->first();
                   $totaAmount = 0;
                   $DonateModel = new Donote_TransactionModel();
$dataAmount = $DonateModel->where('referralId', $id)
                            ->whereIn('payment_status', ['captured', 'PAYMENT_SUCCESS'])
                            ->findAll();
                            
                            foreach($dataAmount as $totalData):
                                
                             $totaAmount +=   $totalData['amount'];
                                endforeach;
                           

              $data['TotalDonation'] =  $totaAmount;    
            $DonateModel = new Donote_TransactionModel();
$data['user'] = $DonateModel->where('referralId', $id)
                            ->whereIn('payment_status', ['captured', 'PAYMENT_SUCCESS'])
                            ->findAll();

        
        
        
        
        
        return view('user_dashboard/Donate_My_Referal', $data);
        
        }else{
          return view('signin', ['msg' => 'Unauthorized Access!']);

        }
        }else{
         return view('signin', ['msg' => 'Unauthorized Access!']);

        }  
}

 
   public function sendOtp()
    {
        $email = $this->request->getPost('email');
        $mobile = $this->request->getPost('mobile');

        $session = session();

        // Simulate user match (in real use case, fetch from DB)
        if ($email == 'atul@gmail.com' || $mobile == '9470267102') {
            $otp = rand(100000, 999999);
            $session->set([
                'verified_email' => $email,
                'verified_mobile' => $mobile,
                'otp' => $otp
            ]);

            return $this->response->setJSON(['status' => 'success', 'otp' => $otp]);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Invalid email or mobile']);
        }
    }

    public function verifyOtp()
    {
        $otp = $this->request->getPost('otp');
        $session = session();

        if ($otp == $session->get('otp')) {
            return $this->response->setJSON(['status' => 'success']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Invalid OTP']);
        }
    }

    public function resetPassword()
    {
        $password = $this->request->getPost('password');
        $confirm = $this->request->getPost('confirm');

        if ($password !== $confirm) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Passwords do not match']);
        }

        if (strlen($password) < 8) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Password must be at least 8 characters']);
        }

        // In real app: update user password in DB

        session()->destroy();
        return $this->response->setJSON(['status' => 'success']);
    } 
    
    
    
    public function checkAadhar()
{
    $aadhar = $this->request->getPost('aadhar');

    
    $aadhar = preg_replace('/\D/', '', $aadhar);
$formatted = preg_replace("/(\d{4})(\d{4})(\d{4})/", "$1 $2 $3", $aadhar);
    $userModel = new \App\Models\UserModel();
    $exists = $userModel->where('aadhar_card_no', $formatted)->first();

    if ($exists) {
        return $this->response->setJSON([
            'status' => false,
            'message' => "Aadhar number ($formatted) already exists!"
        ]);
    } else {
        
        $formatted = preg_replace("/(\d{4})(\d{4})(\d{4})/", "$1 $2 $3", $aadhar);

        return $this->response->setJSON([
            'status' => true,
            'message' => "Aadhar number ($formatted) is available."
        ]);
    }
}


    
    public function register_member()
    {
       $model=new UserModel();  
          
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }
        /*return view('index');*/
         return view('registration_member');
}
public function loginsignup(){
    return view('loginsignup');
}

public function user_registration_mode(){
$session = session();
  $expectedCaptcha = $session->getTempdata('captcha_sum');
    $userCaptcha = $this->request->getPost('captcha');

    if ($userCaptcha != $expectedCaptcha) {
       return redirect()->back()->withInput()->with('error', 'Invalid captcha answer.');

    }
   $model=new UserModel();
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }


   $email = $this->request->getVar('email');
  $name = $this->request->getVar('name');
   $mobile = $this->request->getVar('mobile');
  $password = $this->request->getVar('password');
        /* include helper form */
        helper(['form']);
        /* set rules validation form */
        $rules = [
           
            'email'         => 'required|min_length[6]|max_length[200]|valid_email|is_unique[users.email]',
            
            'mobile'         => 'required|min_length[10]|max_length[10]|is_unique[users.mobile]',
            'terms'         => 'required',
        ];
       $created_at =date('Y-m-d');
        if($this->validate($rules)){
            $model = new UserModel();
            $data = [
                'name'     => $this->request->getVar('name'),
                'referralId'     => $this->request->getVar('referralId'),
                'email'    => $this->request->getVar('email'),
                 'mobile'    => $this->request->getVar('mobile'),
                'user_type' =>'user',
                'password' => password_hash($this->request->getVar('password'), PASSWORD_DEFAULT),
                 'created_at' => $created_at,
                 'terms' =>"yes",
            ];
        
            $model->save($data);
             $this->autoLogin($data['email'], $this->request->getPost('password'));
             
             $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();
         if($adminData){ $adminEmail = $adminData['email'];}else{ $adminEmail = "test@gmail.com";} 
       
              //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 
                         
    $dataurl = base_url();                     

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
    
                        $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                       $site_url=$dataweb['site_url'];
                        $certificate_provider_name= $dataweb['certificate_provider_name'];
                              $designation= $dataweb['designation'];
                              
             $weblogo = base_url('websiteLogoImages/'.$dataweb['web_logo']);
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Welcome to '.$dataweb['web_name'].' - Your Account Has Been Created';
$weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark container -->
  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <!-- Content box -->
    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
      </div>

      <!-- Message Body -->
      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear {$name},<br><br>

         <strong>Congratulations!</strong> Your account has been successfully created on 
        <strong>{$dataweb['web_name']}</strong>. Below are your login details:<br><br>

        <strong>Email Address:</strong> {$email}<br>
        <strong>Password:</strong> {$password}<br><br>

         Please keep your credentials safe and do not share them with anyone. You can now log in and explore our features and services.<br><br>

         If you have any questions, contact us at 
        <a href='mailto:{$dataweb['webemail_1']}' style='color: #ff4b2b;'>{$dataweb['webemail_1']}</a><br><br>

        Thanks for joining us!<br><br>

        Best regards,<br>
        <a href='https://www.{$dataweb['site_url']}' target='_blank' style='color: #ff416c;'>www.{$dataweb['site_url']}</a><br>
        {$dataweb['certificate_provider_name']}<br>
        {$dataweb['designation']}<br>
        <strong>{$dataweb['web_name']}</strong>
      </div>

    </div>
  </div>
</div>
";


$mail->AltBody = $email_data['message'];
$mail->send();


  // ===================== SEND TO ADMIN =====================
        $mailAdmin = new PHPMailer(true);
        try {
            $mailAdmin->isSMTP();
            $mailAdmin->Host = $email_data['host'];
            $mailAdmin->SMTPAuth = true;
            $mailAdmin->Username = $email_data['by_email'];
            $mailAdmin->Password = $email_data['by_password'];
            $mailAdmin->SMTPSecure = 'tls';
            $mailAdmin->Port = 587;

            $mailAdmin->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mailAdmin->addAddress($adminEmail, 'Join Member ' . $name);
            $mailAdmin->isHTML(true);
           $mailAdmin->Subject = 'New User Registered: ' . $name;

$mailAdmin->Body = "
<div style='font-family: Arial, sans-serif; padding: 20px; background: #f9f9f9;'>
    <h2 style='color: #28a745;'> New User Registration</h2>
    <p><strong>Name:</strong> {$name}</p>
    <p><strong>Email:</strong> {$email}</p>
    <p><strong>Phone:</strong> {$mobile}</p>
    <p><strong>Registered On:</strong> {$created_at}</p>
    <hr>
    <p style='color: #555;'>Please login to the admin panel to view full user details.</p>
</div>";

            $mailAdmin->send();
                $session=session();
            $data['validation'] = $this->validator;
            
              $session=session();
            $session->set("msg"," Account created successfully. Welcome! ");
            $session->markAsFlashdata("msg");
            $userModel = new UserModel();
            $data = $userModel->where('id', $session->id)->first();
            
            $sess_data = [
                           'id'=> $data['id'],
                            'loginned' =>'loginned',
                            'user_type' =>$data['user_type'],
                ];

                 $session=session();
               $session->set($sess_data);
              return redirect()->to('user_dashboard');
        } catch (Exception $e) {
             return redirect()->to('user_dashboard');
        }


   $session=session();
            $data['validation'] = $this->validator;
            
              $session=session();
            $session->set("msg"," Account created successfully. Welcome! ");
            $session->markAsFlashdata("msg");
            $userModel = new UserModel();
            $data = $userModel->where('id', $session->id)->first();
            
            $sess_data = [
                           'id'=> $data['id'],
                            'loginned' =>'loginned',
                            'user_type' =>$data['user_type'],
                ];

                 $session=session();
               $session->set($sess_data);
              return redirect()->to('user_dashboard');
} 



catch (Exception $e) {
    $session=session();
    $userModel = new UserModel();
            $data = $userModel->where('id', $session->id)->first();
            
            $sess_data = [
                           'id'=> $data['id'],
                            'loginned' =>'loginned',
                            'user_type' =>$data['user_type'],
                ];

                 $session=session();
               $session->set($sess_data);
            $data['validation'] = $this->validator;
            $session->set("msg","Register Successfully But Email Not Sent  ?");
            $session->markAsFlashdata("msg");
         
            return redirect()->to('user_dashboard');
}
             
          
        }
        else{
            $session = session();
$session->setFlashdata('msg', 'Your Email ID OR Mobile No. Already Registered?');
return redirect()->back()->withInput()->with('error', 'Your Email ID OR Mobile No. Already Registered?');

        }
         
    }
    
    
        private function autoLogin($email, $password)
    {
        $userModel = new UserModel();
        $data = $userModel->where('email', $email)->first();

        if ($data && password_verify($password, $data['password'])) {
            // Set user session or perform any desired actions upon successful login
            // For example: $this->session->set('user_id', $user['id']);
            $sess_data = [
                     'id'       => $data['id'],
                     'name'     => $data['name'],
                     
                      'loginned' =>'loginned',
                       'user' =>'user',
                 ];

                  $session=session();
                $session->set($sess_data);
        }
    }
    
    
    
    
private function updateNotificationCount()
     
    {
        $session = \Config\Services::session();

        // Get the current count or initialize to 0
        $notificationCount = $session->get('notification_count') ?? 0;

        // Increment the count
        $notificationCount++;

        // Update the session
        $session->set('notification_count', $notificationCount);
        
    }

    public function login_auth()
     {
        
       $model=new UserModel();    
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }
        
$session = session();
         $model = new UserModel();
         $email = $this->request->getVar('email');
         $upassword = $this->request->getVar('password');
         $data = $model->where('email', $email)->orWhere('mobile', $email)->first();
         if($data){
             $pass = $data['password'];
             $verify_pass = password_verify($upassword, $pass);
             if($verify_pass){
                 $sess_data = [ 
                  'admin_id'       => $data['admin_id'],
                     'id'       => $data['id'],
                     'name'     => $data['name'],
                     'mobile'     => $data['mobile'],
                     'city'     => $data['city'],
                      
                      'profile_update'     => $data['profile_update'],
                     'email'    => $data['email'],
                     'father_name'   => $data['father_name'],
                      'profile'   => $data['profile'],
                      'district' => $data['district'],
                      'nationality'=>$data['nationality'],
                      'status'=>$data['status'],
                      'payment_status'=>$data['payment_status'],
                     'user_type' => $data['user_type'],
                      'loginned' =>'loginned',
                 ];

                  $session=session();
                $session->set($sess_data);
                if($data['user_type']=="user"){
                   
                     $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $data['id'])->first();
                      $url="user_dashboard";
                }
                 if($data['user_type']=="manager"){
                   
                    $url="manager_dashboard";
                }
               
              
                if($data['user_type']=="admin")
               {
                 
                    $url="admin_dashboard";
                    
                }

     
    
                return redirect()->to(base_url($url));
 
               
            }
            else{
                $session=session();
                $session->set("msg","The passwords you entered do not match. Please try again.");
                $session->markAsFlashdata('msg');
                return redirect()->back()->withInput();
            }
            }

         else
         {
             $session=session();
                $session->set("msg","Your Email or Mobile No Was Not Resgistered ?");
                $session->markAsFlashdata('msg');
            return redirect()->back()->withInput();

         }

         }
     
    public function  member_ship_pay_now($id){
$paymentsModel=new Payments_Mode_Models();
          $dataphonepe=$paymentsModel->first(); 
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first();
$userModel = new UserModel();
        $data= $userModel->where('id', $id)->first();
         require 'db_config.php';
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         
                         
                         $designationId =$data['designation'];
                         
                         $db = \Config\Database::connect();
    $builder = $db->table('occupations');

    // Optionally check that this occupation belongs to this user
    $desugnationData = $builder->where(['id' => $designationId])->Orwhere(['designation' => $designationId])->get()->getRow();
    
    $designation = $desugnationData->designation;
    
    
                         $amount = $desugnationData->fee;
                         $amountF = $amount*100;
                         
if($datapayu['status']=="payu"){
   $key  = getenv('PAYU_KEY');
        $salt =getenv('PAYU_SALT');

        // Required fields (apni data source se lo)
        $txnid      = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        $amount = round($amount, 2); 
        $firstname  = $data['name'] ?? 'Buyer';
        $email      = $data['email'] ?? 'no@domain.com';
        $productinfo= $data['productinfo'] ?? 'Fee';
        $phone      = $data['mobile'] ?? '';

        // Build params
        $params = [
            'key'        => $key,
            'txnid'      => $txnid,
            'amount'     => $amount,
            'productinfo'=> $productinfo,
            'firstname'  => $firstname,
            'email'      => $email,
            'udf1' => '', 'udf2' => '', 'udf3' => '', 'udf4' => '', 'udf5' => '',
            
            'phone' => $phone,
            'Salt'=> $salt,
             'surl' => base_url().'payu/response',
     'furl' => base_url().'payu/response'
        ];

        // Generate correct hash
        $hash = $this->generatePayuRequestHash($params, $salt);

        // Prepare data for auto-post form
        $data = $params;
        $data['hash']   = $hash;
        $data['action'] = $this->payuUrl();
       
 $trans = [
     'transaction_id' => $txnid,
     'payment_status'=>"fail",
     ];
     
 
$userModel = new UserModel();
$transid= $userModel->update($id, $trans);
 if($transid){
    

     
        return view('user_dashboard/payu_form', $data);
    }else{
        
        return redirect()->back()->with('msg', 'Server Not Response');
    }
          } 
            $id = $data['id'];
$paymentsModel=new Payments_Mode_Models();
          $dataPayment = $paymentsModel->first();
          if($dataPayment['status']=="phonepe") {
          
      $webname=$dataPayment['name']; 
$webemail=$dataPayment['email']; 
$client_id = $dataPayment['merchantId']; 
$client_secret = $dataPayment['apiKey']; 
$demo_link = $dataPayment['demo_link'];
$init_link = $dataPayment['init_link'];
//$mobile=9999999999;
// amount in INR
$description = $dataPayment['description']; 

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $demo_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 
  'client_id='.$client_id.'&client_version=1&client_secret='.$client_secret.'&grant_type=client_credentials',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$jsonResponse = curl_exec($curl);
$response = json_decode($jsonResponse, true);
$token = $response['access_token'];
 $order_id = uniqid();
 $trans = [
     'transaction_id' => $order_id,
     'payment_status'=>"fail",
     ];
     
 
$userModel = new UserModel();
$transid= $userModel->update($id, $trans);
 if($transid){
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $init_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "merchantOrderId": "'.$order_id.'",
    "amount": '.$amountF.',
    "expireAfter": 1200,
    "metaInfo": {
        "udf1": "'.$order_id.'",
        "udf2": "additional-information-2",
        "udf3": "additional-information-3",
        "udf4": "additional-information-4",
        "udf5": "additional-information-5"
    },
    "paymentFlow": {
        "type": "PG_CHECKOUT",
        "message": "Payment message used for collect requests",
        "merchantUrls": {
            "redirectUrl": "'.base_url('success_payment').'"
        }
    } 
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$token,
  ),
));

$responseURL = curl_exec($curl);
// echo $responseURL;
// die;
curl_close($curl);
$response = json_decode($responseURL, true);
$tokenurl = $response['redirectUrl'];
$session = session();
$sessdata =[
    'transactionId'=>$order_id,
'token_id'=>$token,
];
$session->set($sessdata);
return redirect()->to($tokenurl);
die;
 
//end pay
}

else{
    $session=session();
                $session->set("msg","Server Not Respond Try Now");
                $session->markAsFlashdata('msg');
                return redirect()->to('user_dashboard');
    
}
}else{
   $session = session();
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $userModel = new UserModel();
    $user = $userModel->where('id', $id)->first();
    
    if(!$user) {
        return redirect()->to('user_dashboard');
    }

    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    // Create order
    $orderData = [
        'amount'          => $amount * 100,
        'currency'        => 'INR',
        'receipt'         => 'ORD_'.time().'_'.$id,
        'payment_capture' => 1
    ];

    try {
        $razorpayOrder = $api->order->create($orderData);
        $data = [
            'users'    => $user,
            'amount'   => $amount,
            'order_id' => $razorpayOrder->id,
            'dataweb'  => $dataweb
        ];
        
        return view('user_dashboard/payment-form', $data);
        
    } catch (Exception $e) {
        log_message('error', 'Razorpay Order Creation Error: '.$e->getMessage());
        session()->setFlashdata('error', 'Payment gateway error. Please try again.');
        return redirect()->back();
    }
    
    /*end pay*/
    
}

}


  private function generatePayuRequestHash($params, $salt)
{
    $key = $params['key'];
    $txnid = $params['txnid'];
    $amount = $params['amount'];
    $productinfo = $params['productinfo'];
    $firstname = $params['firstname'];
    $email = $params['email'];
    $udf1 = $params['udf1'] ?? '';
    $udf2 = $params['udf2'] ?? '';
    $udf3 = $params['udf3'] ?? '';
    $udf4 = $params['udf4'] ?? '';
    $udf5 = $params['udf5'] ?? '';

    // PayU sequence
    $hashString = $key . '|' . $txnid . '|' . $amount . '|' . $productinfo . '|' .
                  $firstname . '|' . $email . '|' . $udf1 . '|' . $udf2 . '|' .
                  $udf3 . '|' . $udf4 . '|' . $udf5 . '||||||' . $salt;

    // Generate hash (case should be exact)
    return hash('sha512', $hashString);
}



       private function payuUrl()
    {
        return (getenv('PAYU_ENV') === 'production')
            ? 'https://secure.payu.in/_payment'
            : 'https://test.payu.in/_payment';
    }
  
    public function response()
    {
        $posted = $this->request->getPost();

        if (! isset($posted['status'], $posted['txnid'], $posted['hash'])) {
            return view('payment_error', ['msg' => 'Invalid response from PayU']);
        }

        // (Optional) verify response hash same way using reverse formula
        // TODO: implement reverse hash validation here

        if ($posted['status'] === 'success') {
            $userModel = new UserModel();
        $data = $userModel->where('transaction_id', $posted['txnid'])->first();
       
        $user_id = $data['id'];
  
               $data=[
                   'user_id'=>$user_id,
                   'providerReferenceId' =>$posted['mihpayid'],
                   'user_name'=>$data['name'],
                 
                   'trans_id'=> $posted['txnid'],
                   'trans_status'=>$posted['status'],
                   'amount'=>$posted['amount'],
                   'created_at' =>date('Y-m-d H:i:s'),
                   ];
                 
                   $trans= new TransactionModel();
                   $sucess=$trans->save($data);
                   if($sucess ==true){
                  // sms start
            
            $userModel = new UserModel();
        $data = $userModel->where('transaction_id', $posted['txnid'])->first();
            //get the inputs
                
            // end sms
        $trans= new TransactionModel();
         $data['payments'] = $trans->where('trans_id', $posted['txnid'])->first();
         
          
          
             $userModel = new UserModel();
        $data = $userModel->where('id', $user_id)->first();
           $id=$data['id'];
           $status=$data['status'];
          $email=$data['email'];
          $mobile=$data['mobile'];
          $name=$data['name'];
           $setingsModel = new SettingsModel();
           $dettingdata = $setingsModel->first();
           $payment_auto_verify = $dettingdata['payment_auto_verify'];
          if(!empty($data)){
    if($payment_auto_verify == "1"){
        $action = 'active';
    }
    else{
        $action = 'inactive';

    }
    $data = [
           "status" => $action,
            "payment_status"=>"success",
           "verifie_date" => date('Y-m-d'),
           "expire_date" => date('Y-m-d', strtotime('+1 year')),
    ];
    
    /*$updateStatus = $this->model->update("users",["user_id =>$user_id"], $data);*/
     $model=new UserModel();
    $updateStatus  = $model->update($id, $data);
    if($updateStatus){
       
   return  $this->sendEmailPaymentSuccess($id);

}
        }
        
        
                   }
        }
        else {
            return view('payment_failure', ['data' => $posted]);
        }
    

    }
     

private function sendEmailPaymentSuccess($id){
     $userModel = new UserModel();
        $data = $userModel->where('id', $id)->first();
           $id=$data['id'];
           $status=$data['status'];
          $email=$data['email'];
          $mobile=$data['mobile'];
          $name=$data['name'];
             //These must be at the top of your script, not inside a function
$dataurl= base_url();
 $MembershipCertificatel=base_url('Membership-Certificate/'.$id);
 $downloadurl=base_url('membership_receipt_download/'.$id);
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
     $weblogo = base_url('websiteLogoImages/' . $web_data['web_logo']);
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
     $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Confirmation of Membership Fee Payment and Receipt Download';

$mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark container -->
  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <!-- Content box -->
    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
      </div>

      <!-- Message Body -->
      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear {$name},<br><br>

        We hope this email finds you well. This is to confirm that we have received your application for membership at <strong>{$datawebname}</strong>. We are thrilled to welcome you to our community of passionate individuals dedicated to making a positive impact.<br><br>

        We are pleased to inform you that your <strong>membership fee payment</strong> has been successfully processed. Your commitment to our cause is greatly appreciated, and your contribution will play a vital role in supporting our initiatives and programs.<br><br>

    As a token of appreciation, we have attached your membership fee payment receipt to this email. Please review the receipt for your records.<br><br>

         <strong>Download Membership Certificate Here:</strong> <a href='{$MembershipCertificatel}' target='_blank' style='color: #ff4b2b;'>{$MembershipCertificatel}</a><br>
         <strong>Download Receipt Here:</strong> <a href='{$downloadurl}' target='_blank' style='color: #ff4b2b;'>{$downloadurl}</a><br><br>
        
         If you have any questions or require further information, please do not hesitate to contact us at 
        <a href='mailto:{$webemail_1}' style='color: #ff416c;'>{$webemail_1}</a> or {$site_mobile_1}.<br><br>

        Thank you once again for your support and dedication. We look forward to working together to create meaningful change in our community.<br><br>

        Best regards,<br>
        <a href='https://www.{$site_url}' target='_blank' style='color: #ff4b2b;'>www.{$site_url}</a><br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        <strong>{$datawebname}</strong>
      </div>

    </div>
  </div>
</div>
";
    $mail->AltBody = $email_data['message'];

    $mail->send();
   $session=session();
           

                 $trans= new TransactionModel();
         $data = $trans->where('user_id', $id)->first();
         $date_payment=$data['created_at'];
$word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['created_at'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ];
                
                 $data['users'] = $userModel->where('id', $id)->first();
                  $trans= new TransactionModel();
         $data['payments'] = $trans->where('user_id', $id)->first();
              
              $session=session();
                    $session->set("msg",'<h1>'."Congratulations".'</h1>'." Payment successfully ");
                    $session->markAsFlashdata("msg");
              
           $trans= new UserModel();
         $data = $trans->where('id', $id)->first();
        
                 $sess_data = [ 
                  'admin_id'       => $data['admin_id'],
                     'id'       => $data['id'],
                     'name'     => $data['name'],
                     'mobile'     => $data['mobile'],
                     'city'     => $data['city'],
                      
                      'profile_update'     => $data['profile_update'],
                     'email'    => $data['email'],
                     'father_name'   => $data['father_name'],
                      'profile'   => $data['profile'],
                      'district' => $data['district'],
                      'nationality'=>$data['nationality'],
                      'status'=>$data['status'],
                      'payment_status'=>$data['payment_status'],
                     'user_type' => $data['user_type'],
                      'loginned' =>'loginned',
                      'type'=>"payu",
                 ];

                  $session=session();
                $session->set($sess_data);
         return redirect()->to('membership_receipt_download/'.$id);
                   
    } 
catch (Exception $e) {
    
    
      $trans= new UserModel();
         $data = $trans->where('id', $id)->first();
        
                 $sess_data = [ 
                  'admin_id'       => $data['admin_id'],
                     'id'       => $data['id'],
                     'name'     => $data['name'],
                     'mobile'     => $data['mobile'],
                     'city'     => $data['city'],
                      
                      'profile_update'     => $data['profile_update'],
                     'email'    => $data['email'],
                     'father_name'   => $data['father_name'],
                      'profile'   => $data['profile'],
                      'district' => $data['district'],
                      'nationality'=>$data['nationality'],
                      'status'=>$data['status'],
                      'payment_status'=>$data['payment_status'],
                     'user_type' => $data['user_type'],
                      'loginned' =>'loginned',
                      'type'=>"payu",
                 ];

                  $session=session();
                $session->set($sess_data);
    
      return redirect()->to('membership_receipt_download/'.$id);
} 
    
}



 public function processPayment()
{
    // Initialize session and get input
    $session = session();
    $input = $this->request->getPost();
    
    // Validate payment ID
    if (empty($input['razorpay_payment_id'])) {
        $session->setFlashdata('error', 'Payment ID missing');
        return redirect()->back();
    }

    // Load database configuration
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    // Initialize Razorpay API
    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    try {
        // Verify payment signature
        $attributes = [
            'razorpay_order_id' => $input['razorpay_order_id'],
            'razorpay_payment_id' => $input['razorpay_payment_id'],
            'razorpay_signature' => $input['razorpay_signature']
        ];
        $api->utility->verifyPaymentSignature($attributes);

        // Process payment
        $payment = $api->payment->fetch($input['razorpay_payment_id']);
        
        // Capture payment if authorized
        if ($payment->status == 'authorized') {
            $payment->capture(['amount' => $payment->amount]);
        }

        // Process successful payment
        if (in_array(strtolower($payment->status), ['captured', 'authorized'])) {
            $trnx = new TransactionModel();
            $userModel = new UserModel();
            
            // Prepare transaction data
            $trans_data = [
                "amount" => $payment->amount / 100,
              
                "trans_id" => $payment->id,
                "providerReferenceId" => $payment->card ? $payment->card->id : null,
                "trans_status" => $payment->status,
                "user_name" => $payment->notes['trans_name'] ?? $payment->email ?? null,
                "user_id" => $input['user_id'] ?? null,
               
               
                "created_at" => date('Y-m-d H:i:s'),
               
            ];

            // Save transaction
            $trnx->save($trans_data);

            // Update user status
            $dataid = $input['user_id'];
            if ($dataid) {
                
                 $setingsModel = new SettingsModel();
                 $settingData = $setingsModel->first();
                 $payment_auto_verify = $settingData['payment_auto_verify'];
                if($payment_auto_verify =="1"){
                 $action = "active";   
                }else{
                    $action = "inactive";    
                }
                
                $userData = [
                    "transaction_id" => $input['razorpay_payment_id'],
                    "status" => $action,
                    "payment_status" => "success",
                    "verifie_date" => date('Y-m-d'),
                    "expire_date" => date('Y-m-d', strtotime('+1 year'))
                ];
                
            $result=    $userModel->update($dataid, $userData);
               if($result){
                $user = $userModel->where('id', $dataid)->first();
                $id= $user['id'];
               }
 return  $this->sendEmailPaymentSuccess($id);          
               
            }
        }

    }   catch (\Exception $e) {
      
       
         $session->setFlashdata('error', 'Payment ID missing'.$e->getMessage());
        return redirect()->back();
    }
}
     
    public function success_payment(){
         
         $response=  $this->request->getPost();
           $response=  $this->request->getVar();
        $session = session();
$transactionId = $session->get('transactionId');
$tokenId = $session->get('token_id');

$curl = curl_init();
 $paymentsModel=new Payments_Mode_Models();
          $dataPayment=$paymentsModel->first();           
   $paymentMode = $dataPayment['payment_mode'];
if($paymentMode=="test"){
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
// CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
}
else{
    
    curl_setopt_array($curl, array(
//   CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
 CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
    
}


$response = curl_exec($curl);

curl_close($curl);
$responseUrl = json_decode($response, true);
       
             $staff_id = $transactionId;
            
              $amount = $responseUrl['amount']/100;
              
               $trans_status = $responseUrl['state'];
               if($trans_status =="COMPLETED"  or $trans_status =="captured"){
               $staff_id = $this->request->getPost('staff_id');
               $cust_id = $this->request->getPost('cust_id');
               $providerReferenceId = $responseUrl['orderId'];
               $cust_mobile = $this->request->getPost('cust_mobile');
                $userModel = new UserModel();
                
                 $userModel = new UserModel();
        $data = $userModel->where('transaction_id', $transactionId)->first();
       
        $user_id = $data['id'];
  
               $data=[
                   'user_id'=>$user_id,
                   'providerReferenceId' =>$providerReferenceId,
                   'user_name'=>$data['name'],
                    'amount'=>$amount,
                   'trans_id'=> $transactionId,
                   'trans_status'=>$trans_status,
                   'amount'=>$amount,
                   'created_at' =>date('Y-m-d H:i:s'),
                   ];
                 
                   $trans= new TransactionModel();
                   $sucess=$trans->save($data);
                   if($sucess ==true){
                  // sms start
            
            $userModel = new UserModel();
        $data = $userModel->where('transaction_id', $transactionId)->first();
            //get the inputs
                
            // end sms
        $trans= new TransactionModel();
         $data['payments'] = $trans->where('trans_id', $transactionId)->first();
         
          $data = $trans->where('trans_id', $this->request->getPost('transactionId'))->first();
          
             $userModel = new UserModel();
        $data = $userModel->where('id', $user_id)->first();
           $id=$data['id'];
           $status=$data['status'];
          
          if(!empty($data)){
               $setingsModel = new SettingsModel();
               $settingData = $setingsModel->first();
               $payment_auto_verify = $settingData['payment_auto_verify'];
    if($payment_auto_verify =="1"){
        $action = 'active';
    }
    else{
        $action = 'inactive';

    }
    $data = [
           "status" => "inactive",
            "payment_status"=>"success",
           "verifie_date" => date('Y-m-d'),
           "expire_date" => date('Y-m-d', strtotime('+1 year')),
    ];
    
    /*$updateStatus = $this->model->update("users",["user_id =>$user_id"], $data);*/
     $model=new UserModel();
    $updateStatus  = $model->update($id, $data);
           return  $this->sendEmailPaymentSuccess($id);
                  
                   
                    }
         }
         
         
         else {
             
             $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data['users'] = $userModel->where('id', $data['id'])->first();
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
             ];
              
                  $session=session();
                $session->set($sess_data);
                 
         return redirect()->to('user_dashboard');
             
         }
               }else{
                 $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg"); 
                     return redirect()->to('user_dashboard');
               }
     }
 public function membership_receipt_download($id){
    
    
     $trans= new UserModel();
        $data = $trans->where('id', $id)->orWhere('transaction_id', $id)->first();
        
if($data){
             
              $trans_id = $data['transaction_id'];
            $trans= new TransactionModel();
         $data = $trans->where('trans_id', $trans_id)->first();
         if($data){
        $receipt_id=$data['id'];
          // Load the custom helper
       $word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['created_at'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ];  
             $userModel = new UserModel();
            $data['users'] = $userModel->where('id', $id)->orWhere('transaction_id', $id)->first();
               $trans= new TransactionModel();
         $data['payments'] = $trans->where('id', $receipt_id)->first();
            
          return view('user_dashboard/membership_payment_receipt',$data);
          
 }else{ $session=session();
                    $session->set("msg",'<h1>'."Opps".'</h1>'."Data Not Founds");
                    $session->markAsFlashdata("msg");
          return redirect()->back();
 }
             
         }
   else{
      
       $session=session();
                    $session->set("msgp",'<h1>'."Opps".'</h1>'."Data Not Founds");
                    $session->markAsFlashdata("msgp");
         return redirect()->back();
   } 
   
     
 }
 
 public function numberToWord($num = '')
	{
		$num    = (string) ((int) $num);

		if ((int) ($num) && ctype_digit($num)) {
			$words  = array();

			$num    = str_replace(array(',', ' '), '', trim($num));

			$list1  = array(
				'', 'one', 'two', 'three', 'four', 'five', 'six', 'seven',
				'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen',
				'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
			);

			$list2  = array(
				'', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty',
				'seventy', 'eighty', 'ninety', 'hundred'
			);

			$list3  = array(
				'', 'thousand', 'million', 'billion', 'trillion',
				'quadrillion', 'quintillion', 'sextillion', 'septillion',
				'octillion', 'nonillion', 'decillion', 'undecillion',
				'duodecillion', 'tredecillion', 'quattuordecillion',
				'quindecillion', 'sexdecillion', 'septendecillion',
				'octodecillion', 'novemdecillion', 'vigintillion'
			);

			$num_length = strlen($num);
			$levels = (int) (($num_length + 2) / 3);
			$max_length = $levels * 3;
			$num    = substr('00' . $num, -$max_length);
			$num_levels = str_split($num, 3);

			foreach ($num_levels as $num_part) {
				$levels--;
				$hundreds   = (int) ($num_part / 100);
				$hundreds   = ($hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ($hundreds == 1 ? '' : 's') . ' ' : '');
				$tens       = (int) ($num_part % 100);
				$singles    = '';

				if ($tens < 20) {
					$tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
				} else {
					$tens = (int) ($tens / 10);
					$tens = ' ' . $list2[$tens] . ' ';
					$singles = (int) ($num_part % 10);
					$singles = ' ' . $list1[$singles] . ' ';
				}
				$words[] = $hundreds . $tens . $singles . (($levels && (int) ($num_part)) ? ' ' . $list3[$levels] . ' ' : '');
			}
			$commas = count($words);
			if ($commas > 1) {
				$commas = $commas - 1;
			}

			$words  = implode(', ', $words);

			$words  = trim(str_replace(' ,', ',', ucwords($words)), ', ');
			if ($commas) {
				$words  = str_replace(',', ' and', $words);
			}

			return $words;
		} else if (!((int) $num)) {
			return 'Zero';
		}
		return '';
	}
 
  public function membership_receipt_download_print($id){
      
      
      $model=new UserModel();
         $users= $model->where('id', $id)->first();
         if($users['profile'] != null) {
                              if($users['status'] !='block') { 
                               if($users['status'] == 'active') { 
    $trans= new TransactionModel();
         $data = $trans->where('user_id', $id)->first();
         
        
                // Assuming you have a date string
$dateString = $data['created_at'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
        $data['daterecipt']=['formattedDate'=>$formattedDate];   
        $userModel = new UserModel();
      
             $data['users'] = $userModel->where('id', $id)->first();
              $trans= new TransactionModel();
         $data['payments'] = $trans->where('user_id', $id)->first();
         
//               $mpdf = new \Mpdf\Mpdf();
// 		$html = view('user_dashboard/membership_payment_receipt',$data);
// 		$mpdf->WriteHTML($html);
// 		$this->response->setHeader('Content-Type', 'application/pdf');
// 		$mpdf->Output('arjun.pdf','I');
             $userModel = new UserModel();
      
             $data['users'] = $userModel->where('id', $id)->first();
              $trans= new TransactionModel();
         $data['payments'] = $trans->where('user_id', $id)->first();
            
         return view('user_dashboard/membership_payment_receipt',$data);
              
                              } else {return redirect()->to('user_dashboard');
                             }
                              }else {return redirect()->to('user_dashboard');
                             }
         }else {return redirect()->to('user_dashboard');
                             }
}

  public function show_notice_user($id){
       $modelNotice=new AdminNoticeModel();
        $data =$modelNotice->where('id',$id)->first();
        $userModel = new UserModel();
      
    $data['users'] = $userModel->where('id', $data['user_id'])->first();
        
      $data['notice']=$modelNotice->where('id',$id)->first();
      
      return view('user_dashboard/show_notice_user',$data);
      
  }
  
  public function show_admin_notice($id){
      $session = session();
     $modelNotice=new AdminNoticeModel();
        $data =$modelNotice->where('id',$id)->first();
        $userModel = new UserModel();
      
    $data['users'] = $userModel->where('id', $session->id)->first();
        
      $data['notice']=$modelNotice->where('id',$id)->first();
      
      return view('user_dashboard/show_admin_notice',$data); 
      
  }
  
  
     public function logout()
     {
          require 'db_config.php';
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
         $website= $web_data['site_url'];
         
         $session = session();
         $session->destroy();
         return redirect()->to('https://www.'.$website);
         
     }
 

}