<?php

namespace App\Controllers\Admin;
namespace App\Controllers\Location;
use App\Controllers\BaseController;
use App\Models\ZoneModel;

class ZoneController extends BaseController
{
    public function index()
    {
       
        $zoneModel = new ZoneModel();

        $data = [
            'zones' => $zoneModel->orderBy('id', 'DESC')->findAll(),
        ];

        return view('admin_dashboard/zones/index', $data);
    }

    public function create()
    {
        $data['heading'] ="Add Zone"; 
        return view('admin_dashboard/zones/create',$data);
    }

    public function store()
    {
        $rules = [
            'name' => 'required|min_length[2]',
        ];

        if (! $this->validate($rules)) {
            return redirect()->back()
                ->with('error', 'Validation failed')
                ->withInput();
        }
$id = $this->request->getPost('id');
        $zoneModel = new ZoneModel();
        if(!empty($id)){
           
         $data = [
            'name' => $this->request->getPost('name'),
        ]; 
        $zoneModel->update($id, $data);
         return redirect()->to('zones')->with('success', 'Zone Update successfully');  
        }else{
           $zoneModel->save([
            'name' => $this->request->getPost('name'),
        ]);

        return redirect()->to('zones')->with('success', 'Zone created successfully');  
        }
       
    }

    public function edit($id)
    {
        $zoneModel = new ZoneModel();
        $zone = $zoneModel->find($id);
        
        if (! $zone) {
            return redirect()->to('zones')->with('error', 'Zone not found');
        }
         $data['heading'] ="Update Zone"; 
          $data['zone'] = $zoneModel->find($id);
       return view('admin_dashboard/zones/create',$data);
    }

    public function update($id)
    {
        $rules = [
            'name' => 'required|min_length[2]',
        ];

        if (! $this->validate($rules)) {
            return redirect()->back()
                ->with('error', 'Validation failed')
                ->withInput();
        }

        $zoneModel = new ZoneModel();

        $zoneModel->update($id, [
            'name' => $this->request->getPost('name'),
        ]);

        return redirect()->to('zones')->with('success', 'Zone updated successfully');
    }

    public function delete($id)
    {
        $zoneModel = new ZoneModel();
        $zoneModel->delete($id);

        return redirect()->to('/admin/zones')->with('success', 'Zone deleted successfully');
    }
}
