<?php

namespace App\Controllers\Admin;
namespace App\Controllers\Location;
use App\Controllers\BaseController;
use App\Models\PanchayatModel;
use App\Models\BlockModel;

class PanchayatController extends BaseController
{
    public function index()
    {
        $data['panchayats'] = (new PanchayatModel())
            ->select('panchayats.*, blocks.name as block_name')
            ->join('blocks', 'blocks.id = panchayats.block_id')
            ->orderBy('panchayats.id', 'DESC')
            ->findAll();

        return view('admin_dashboard/panchayats/index', $data);
    }

    public function create()
{
    $data['heading'] = "Add Panchayat";
    $data['panchayat'] = null; // Important for insert mode
    $data['blocks'] = (new BlockModel())->findAll();

    return view('admin_dashboard/panchayats/create', $data);
}

public function store()
{
    $rules = [
        'block_id' => 'required',
        'name'     => 'required|min_length[2]'
    ];

    if (!$this->validate($rules)) {
        return redirect()->back()->with('error', 'Validation Failed')->withInput();
    }

    (new PanchayatModel())->save([
        'block_id' => $this->request->getPost('block_id'),
        'name'     => $this->request->getPost('name'),
    ]);

    return redirect()->to('panchayats')->with('success', 'Panchayat Created Successfully');
}

public function edit($id)
{
    $data['heading'] = "Update Panchayat";
    $data['panchayat'] = (new PanchayatModel())->find($id);
    $data['blocks'] = (new BlockModel())->findAll();

    return view('admin_dashboard/panchayats/create', $data);
}

public function updatePanchayats($id)
{
    $rules = [
        'block_id' => 'required',
        'name'     => 'required|min_length[2]'
    ];

    if (!$this->validate($rules)) {
        return redirect()->back()->with('error', 'Validation Failed')->withInput();
    }

    (new PanchayatModel())->update($id, [
        'block_id' => $this->request->getPost('block_id'),
        'name'     => $this->request->getPost('name'),
    ]);

    return redirect()->to('panchayats')->with('success', 'Panchayat Updated Successfully');
}

    public function delete($id)
    {
        (new PanchayatModel())->delete($id);

        return redirect()->to('panchayats')->with('success', 'Panchayat Deleted Successfully');
    }
}
