<?php

namespace App\Controllers\Location;

use App\Controllers\BaseController;
use App\Models\ZoneModel;
use App\Models\StateModel;
use App\Models\DistrictModel;
use App\Models\BlockModel;
use App\Models\GramPanchayatModel;

class LocationController extends BaseController
{
    public function index()
    {
        $zoneModel = new ZoneModel();
        $data['zones'] = $zoneModel->findAll();

        return view('admin_dashboard/zones/index', $data);
    }

    // -------- API endpoints ----------

    public function zones()
    {
        $zones = (new ZoneModel())->select('id, name')->findAll();
        return $this->response->setJSON($zones);
    }

    public function states($zoneId)
    {
        $states = (new StateModel())
            ->where('zone_id', $zoneId)
            ->select('id, name')
            ->findAll();

        return $this->response->setJSON($states);
    }

    public function districts($stateId)
    {
        $districts = (new DistrictModel())
            ->where('state_id', $stateId)
            ->select('id, name')
            ->findAll();

        return $this->response->setJSON($districts);
    }

    public function blocks($districtId)
    {
        $blocks = (new BlockModel())
            ->where('district_id', $districtId)
            ->select('id, name')
            ->findAll();

        return $this->response->setJSON($blocks);
    }

    public function gramPanchayats($blockId)
    {
        $gps = (new GramPanchayatModel())
            ->where('block_id', $blockId)
            ->select('id, name')
            ->findAll();

        return $this->response->setJSON($gps);
    }

    // --------- Zone CRUD (example) ---------

    public function create()
    {
        return view('admin_dashboard/zones/create');
    }

    public function store()
    {
        $zoneModel = new ZoneModel();
        $zoneModel->insert([
            'name' => $this->request->getPost('name')
        ]);

        return redirect()->to('zone')->with('success', 'Zone created successfully');
    }

    public function edit($id)
    {
        $zoneModel = new ZoneModel();
        $data['zone'] = $zoneModel->find($id);

        return view('admin/zones/edit', $data);
    }

    public function update($id)
    {
        $zoneModel = new ZoneModel();
        $zoneModel->update($id, [
            'name' => $this->request->getPost('name')
        ]);

        return redirect()->to('zone')->with('success', 'Zone updated successfully');
    }

    public function delete($id)
    {
        $zoneModel = new ZoneModel();
        $zoneModel->delete($id);

        return redirect()->to('zone')->with('success', 'Zone deleted successfully');
    }
}
