<?php

namespace App\Controllers\Admin;
namespace App\Controllers\Location;
use App\Controllers\BaseController;
use App\Models\DistrictModel;
use App\Models\StateModel;

class DistrictController extends BaseController
{
    public function index()
    {
        $data['districts'] = (new DistrictModel())
            ->select('districts.*, states.name as state_name')
            ->join('states', 'states.id = districts.state_id')
            ->orderBy('districts.id', 'DESC')
            ->findAll();

        return view('admin_dashboard/districts/index', $data);
    }

   public function create()
{    
    $data['heading'] = "Add District";
    $data['district'] = null;  // important
    $data['states'] = (new StateModel())->findAll();

    return view('admin_dashboard/districts/create', $data);
}

public function store()
{
    $rules = [
        'state_id' => 'required',
        'name'     => 'required|min_length[2]'
    ];

    if (!$this->validate($rules)) {
        return redirect()->back()->with('error', 'Validation Failed')->withInput();
    }

    (new DistrictModel())->save([
        'state_id' => $this->request->getPost('state_id'),
        'name'     => $this->request->getPost('name'),
    ]);

    return redirect()->to('districts')->with('success', 'District Created Successfully');
}

public function edit($id)
{
    $model = new DistrictModel();
    
    $data['heading'] = "Update District";
    $data['district'] = $model->find($id);
    $data['states']   = (new StateModel())->findAll();

    return view('admin_dashboard/districts/create', $data);
}

public function updateDistrict($id)
{
    $rules = [
        'state_id' => 'required',
        'name'     => 'required|min_length[2]'
    ];

    if (!$this->validate($rules)) {
        return redirect()->back()->with('error', 'Validation Failed')->withInput();
    }

    (new DistrictModel())->update($id, [
        'state_id' => $this->request->getPost('state_id'),
        'name'     => $this->request->getPost('name'),
    ]);

    return redirect()->to('districts')->with('success', 'District Updated Successfully');
}


    public function update($id)
    {
        $rules = [
            'state_id' => 'required',
            'name'     => 'required|min_length[2]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->with('error', 'Validation Failed')->withInput();
        }

        (new DistrictModel())->update($id, [
            'state_id' => $this->request->getPost('state_id'),
            'name'     => $this->request->getPost('name'),
        ]);

        return redirect()->to('/admin/districts')->with('success', 'District Updated Successfully');
    }

    public function delete($id)
    {
        (new DistrictModel())->delete($id);

        return redirect()->to('/admin/districts')->with('success', 'District Deleted Successfully');
    }
}
