<?php

namespace App\Controllers\Api;

use App\Controllers\BaseController;
use App\Models\EventModel;
use CodeIgniter\API\ResponseTrait;

class EventController extends BaseController
{
    use ResponseTrait;

    public function activeEvents()
    {
        try {
            $model = new EventModel();
            $events = $model->orderBy('id', 'DESC')->findAll();
            
            return $this->respond([
                'status' => 'success',
                'message' => 'Events retrieved successfully',
                'data' => $events
            ]);
            
        } catch (\Exception $e) {
            return $this->failServerError('Server error: ' . $e->getMessage());
        }
    }
    
    public function getEventDetails($id)
    {
        $eventModel = new EventModel();
        $event = $eventModel->where('id', $id)->first();

        if (!$event) {
            return $this->response->setStatusCode(404)->setJSON([
                'status' => false,
                'message' => 'Event not found',
            ]);
        }

        return $this->response->setJSON([
            'status' => true,
            'message' => 'Event details fetched successfully',
            'data' => $event,
        ]);
    }
}