<?php
namespace App\Controllers;
use App\Models\UserModel;
use App\Models\CertificateModel;
use App\Models\CommonModel;
use App\Models\TransactionModel;
use App\Models\AdminNoticeModel;
use App\Models\AdminPostModel;
use App\Models\Comment_Model;
use App\Models\EventModel;
use App\Models\EventTicketModel;
use App\Models\InternshipModel;
use App\Models\ProjectExpenseModel;
use App\Models\DonationProjectModel;
use App\Models\BirthdayMessageModel;
use App\Models\Like_Model;
use App\Models\GenerateDonateModel;
use App\Models\ExpenseModel;
use App\Models\PostsModel;
use App\Models\ImagePostsModel;
use App\Models\NewsModel;
use App\Models\Message_controller;
use App\Controllers\QRcode;
use App\Models\DonateCampaignModel;
use App\Models\CampaignModel;
use App\Models\InternshipApplicationModel;
use App\Models\Admin_Website_Model;
use App\Models\Admin_Appointment_updataModel;
use App\Models\Student_Model;
use App\Models\Admin_email_credentials;
use App\Models\Student_certificate_Model;
use CodeIgniter\I18n\Time;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
use App\Models\Donote_TransactionModel;
use App\Models\EnquiryModel;
use App\Models\ManagementBodyModel;
use App\Models\DesignationModel;
use CodeIgniter\CLI\CLI;
use Razorpay\Api\Api;
use CodeIgniter\API\ResponseTrait;
use App\Models\Payments_Razor_Mode_Model;
use App\Models\Payments_Payu_Mode_Model;
use App\Models\Payments_Mode_Models;
use App\Models\BeneficiaryModel;
use App\Models\BeneficiaryHelpModel;
use App\Models\SettingsModel;
use App\Controllers\BaseController;
use App\Models\DistrictModel;
use App\Models\BlockModel;
use App\Models\PanchayatModel;
use App\Models\StateModel;
use App\Models\ZoneModel;
use App\Models\HealthCardModel;
use App\Models\HealthCardMemberModel;
use App\Models\HealthCardTransactionModel;
class Admin_Controller extends BaseController
{
    private $model;
    function __construct(){
        $this->model = new CommonModel();
    }
    
    
     public function managementBodyCreate()
    {
        
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        
        return view('managementbody/createUpdate');
    }
    
 public function resetLocation()
{
    $session = session();
    $userModel = new UserModel();

   
    $admin = $userModel->find($session->id);
    if (!$admin || $admin['user_type'] != "admin") {
        return redirect()->to('signin')->with('msg', 'Unauthorized Access!');
    }

   
    $zoneModel      = new ZoneModel();
    $stateModel     = new StateModel();
    $districtModel  = new DistrictModel();
    $blockModel     = new BlockModel();
    $panchModel     = new PanchayatModel();

    
    $db = \Config\Database::connect();
    $db->query("UPDATE users SET 
        zone_id = NULL,
        state_id = NULL,
        district_id = NULL,
        block_id = NULL,
        panchayat_id = NULL
    ");

    
    $zoneModel->truncate();
    $stateModel->truncate();
    $districtModel->truncate();
    $blockModel->truncate();
    $panchModel->truncate();

  
    $session->setFlashdata("msg", "All Location Data Reset Successfully!");

    return redirect()->back();
}




   public function managementBodyStore()
{
    $session = session();
    $userModel = new UserModel();
    $admin = $userModel->where('id', $session->id)->first();

 
    if (!$admin || $admin['user_type'] != "admin") {
        return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
    }

    $Managementmodel = new ManagementBodyModel();
    $id = $this->request->getPost('id');

   
    $photo = $this->request->getFile('profile');
    $photoName = null;

    if ($photo && $photo->isValid() && !$photo->hasMoved()) {
        $photoName = $photo->getRandomName();
        $photo->move('managementbodyImage', $photoName);

            $existing = $Managementmodel->find($id);
            if (!empty($existing['photo']) && file_exists("managementbodyImage/" . $existing['photo'])) {
                unlink("managementbodyImage/" . $existing['photo']);
            }
        
    }

  
    $data = [
        'name'        => $this->request->getPost('name'),
        'designation' => $this->request->getPost('designation'),
        'status'      => $this->request->getPost('status'),
    ];

   
    if ($photoName) {
        $data['photo'] = $photoName;
    }

   
    if ($id) {
        
        $Managementmodel->update($id, $data);
        return redirect()->to('managementbodyList')->with('msg', 'Member updated successfully');
    } else {
        $Managementmodel->insert($data);
        return redirect()->to('managementbodyList')->with('msg', 'Member added successfully');
    }
}

   public function ManagementBodyEdit($id)
    {
         
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        $data['heading']="Update Managementbody Memeber";
        $model = new ManagementBodyModel();
        $data['member'] = $model->find($id);

        return view('managementbody/createUpdate', $data);
    }

    public function managementBodyUpdate($id)
    {
        $model = new ManagementBodyModel();
        $member = $model->find($id);

        $photo = $this->request->getFile('photo');
        $photoName = $member['photo']; // keep old

        if ($photo && $photo->isValid() && !$photo->hasMoved()) {
            $photoName = $photo->getRandomName();
            $photo->move(FCPATH . 'uploads/managementbody', $photoName);
        }

        $model->update($id, [
            'name'        => $this->request->getPost('name'),
            'designation' => $this->request->getPost('designation'),
            'photo'       => $photoName,
            'status'      => $this->request->getPost('status')
        ]);

        return redirect()->back()->with('success', 'Member updated successfully');
    }

  public function SearchDonationHistory(){
    
     return view('Front/Search-Donation-History');
}

 public function SearchDonationHistoryDataId(){
        
     $email = $this->request->getPost('email');
      $mobile = $this->request->getPost('mobile'); 
   if (!is_numeric($mobile)) {
    return redirect()->back()
                     ->with('error', 'This Mobile No. Formate is Not Valid!')
                     ->withInput();
}
    $model = new Donote_TransactionModel();
    $data = $model->where('email', $email)->where('mobile', $mobile)->findAll();

    if($data){
         $model = new Donote_TransactionModel();
    $data['payments'] = $model->where('email', $email)->where('mobile', $mobile)->findAll();
   
        return view('Front/Search-Donation-History-data', $data);
    } else {
        return redirect()->back()->with('error', 'This Member ID Does Not Exist!!')->withInput();  
    }   
        
    }
    public function VerifyMemberData(){
        return view('Front/Verify-Member-Form');
        
    }
    
    public function VerifyMemberDataId()
{
    $session = session();
   
    $id = $this->request->getPost('memberId'); 
   if (!is_numeric($id)) {
    return redirect()->back()
                     ->with('error', 'This Member ID is Not Valid!')
                     ->withInput();
}
    $model = new UserModel();
    $data = $model->where('id', $id)->where('user_type', "user")->first();

    if($data){
        $datasess = [
            'verify'=>"verify"
            ];
        $session->set($datasess);
        return redirect()->to('indcard_verifie/'.$id); 
    } else {
        return redirect()->back()->with('error', 'This Member ID Does Not Exist!!')->withInput();  
    }
}

    public function LandingManagementBody()
{
     $data['heading']="LandingManagementBody";
    $Webmodel = new Admin_Website_Model();
    $data['web'] = $Webmodel->first();

    $model = new ManagementBodyModel();

    
    $data['member'] = $model->orderBy('id', 'DESC')->paginate(10);

   
    $data['pager'] = $model->pager;

    return view('managementbody/Landing-Management-Body', $data);
}

    public function LandingManagement4Body()
{   
    $data['heading']="LandingManagement4Body";
    $Webmodel = new Admin_Website_Model();
    $data['web'] = $Webmodel->first();

    $model = new ManagementBodyModel();
    $data['member'] = $model->orderBy('id', 'ASC')->paginate(4);

 
    $data['pager'] = $model->pager;

    return view('managementbody/Landing-Management-Body', $data);
}


  
    public function managementBodyDelete($id)
    {
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        
        $model = new ManagementBodyModel();
        $model->delete($id);

        return redirect()->to('/managementbody')->with('success', 'Member deleted successfully');
    }
    
    public function managementbodyList(){
      $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
   
   $model = new ManagementBodyModel();
        $data['member'] = $model->orderBy('id', 'DESC')->findAll(); 
        
      return view('managementbody/managementbodyList', $data);   
    
}
    
    
    public function bulkdeleteEnquiry() {
          $session = session();
    $model = new \App\Models\UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Unauthorized Access!'
        ])->setStatusCode(403);
    }

    $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (empty($ids)) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'No records selected!'
        ]);
    }

    $EventModel = new \App\Models\EnquiryModel();
    $deleted = $EventModel->whereIn('id', $ids)->delete();

    return $this->response->setJSON([
        'success' => $deleted ? true : false,
        'message' => $deleted ? 'Selected Enquiry deleted successfully!' : 'Failed to delete events.'
    ]);
}

    
   public function bulkDeleteEvent()
{
    $session = session();
    $model = new \App\Models\UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Unauthorized Access!'
        ])->setStatusCode(403);
    }

    $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (empty($ids)) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'No records selected!'
        ]);
    }

    $EventModel = new \App\Models\EventModel();
    $deleted = $EventModel->whereIn('id', $ids)->delete();

    return $this->response->setJSON([
        'success' => $deleted ? true : false,
        'message' => $deleted ? 'Selected events deleted successfully!' : 'Failed to delete events.'
    ]);
}

   public function bulkDeleteEventUser()
{
    $session = session();
    $model = new \App\Models\UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Unauthorized Access!'
        ])->setStatusCode(403);
    }

    $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (empty($ids)) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'No records selected!'
        ]);
    }

    $EventModel = new \App\Models\EventTicketModel();
    $deleted = $EventModel->whereIn('id', $ids)->delete();

    return $this->response->setJSON([
        'success' => $deleted ? true : false,
        'message' => $deleted ? 'Selected events deleted successfully!' : 'Failed to delete events.'
    ]);
}
    
    public function adminAddOccupation(){
        
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
    $data['heading'] ="Add Occupation";
  
       
        return view('admin_dashboard/admin-Add-Occupation', $data);
        
    
        
    }
    
    
    public function paymentGatewayUpdateStatus(){
        
         $session = session();
    $model = new UserModel();
 $data = $model->where('id', $session->id)->first();
    if (!$data || $data['user_type'] != "admin") {
        return view('signin');
    }
        
        
        $status =$this->request->getPost('status');
        if($status =="payu"){
             $paymentsModel=new Payments_Mode_Models();
           $dataphonepe=$paymentsModel->first();
             $id=$dataphonepe['id'];
             $data = [
                 'status'=>"inactive",
             ];
             $paymentsModel->update($id, $data);
             
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
          $id=$datapayu['id'];
             $data = [
                 'status'=>"payu",
             ];
             $payuModel->update($id, $data);
          
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first(); 
            $id=$datarazor['id'];
             $data = [
                 'status'=>"inactive",
             ];
             $razorModel->update($id, $data);
             
              $session=session();
        $session->set("msg","Payment Mode Change");
        $session->markAsFlashdata("msg");
        
        return redirect()->back();
        }
        
        if($status =="razorpay"){
             $paymentsModel=new Payments_Mode_Models();
           $dataphonepe=$paymentsModel->first();
             $id=$dataphonepe['id'];
             $data = [
                 'status'=>"inactive",
             ];
             $paymentsModel->update($id, $data);
             
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
          $id=$datapayu['id'];
             $data = [
                 'status'=>"inactive",
             ];
             $payuModel->update($id, $data);
          
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first(); 
            $id=$datarazor['id'];
             $data = [
                 'status'=>"razorpay",
             ];
             $razorModel->update($id, $data);
             
              $session=session();
        $session->set("msg","Payment Mode Change");
        $session->markAsFlashdata("msg");
        
        return redirect()->back();
        }
        
         if($status =="phonepe"){
             $paymentsModel=new Payments_Mode_Models();
           $dataphonepe=$paymentsModel->first();
             $id=$dataphonepe['id'];
             $data = [
                 'status'=>"phonepe",
             ];
             $paymentsModel->update($id, $data);
             
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
          $id=$datapayu['id'];
             $data = [
                 'status'=>"inactive",
             ];
             $payuModel->update($id, $data);
          
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first(); 
            $id=$datarazor['id'];
             $data = [
                 'status'=>"inactive",
             ];
             $razorModel->update($id, $data);
              $session=session();
        $session->set("msg","Payment Mode Change");
        $session->markAsFlashdata("msg");
        
        return redirect()->back();
        }
        
        
    }
     public function admin_payment_update_data_payu_process(){
       
        $session = session();
    $model = new UserModel();
 $data = $model->where('id', $session->id)->first();
    if (!$data || $data['user_type'] != "admin") {
        return view('signin');
    }
       
        
      $data= $this->request->getPost();
      
         $admin_id= $this->request->getPost('id');
       $payment_website_name= $this->request->getPost('payment_website_name');
       $email= $this->request->getPost('email');
       $mobile= $this->request->getPost('mobile');
        $description= $this->request->getPost('description');
       $merchantId= $this->request->getPost('merchant_key');
       $apiKey= $this->request->getPost('merchant_salt');
       $demo_link= $this->request->getPost('auth_header');
       $web_tag_line = $this->request->getPost('payment_mode');
       
      
       
       $data=[
           
           'name'=>$payment_website_name,
           'email'=>$email,
           'mobile'=>$email,
          
           'merchant_key'=>$merchantId,
           'merchant_salt'=>$apiKey,
           'auth_header'=>$demo_link,
           'payment_mode'=>$web_tag_line,
           'create_at'=> date('Y-m-d H:i:s'),
           
           ];
           
           
           
           $session = session();
               
                        require 'db_config.php';
                         $queryli = "SELECT * FROM `website_payu_transaction`";
                         $result = mysqli_query($connection, $queryli);
                         $payments = mysqli_fetch_all($result, MYSQLI_ASSOC);
                         
                        
                      if($payments){
           
         $paymentsModel=new Payments_Payu_Mode_Model();
         $payuid = $paymentsModel->first();
        $id = $payuid['id'];
        $result = $paymentsModel->update($id, $data);
         
          $session=session();
            $session->set("msg","Website Transaction Mode Update Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                      }
                      else{
                           echo "check save";
                           $paymentsModel = new Payments_Payu_Mode_Model();
         $result = $paymentsModel->save($data);
         
          $session=session();
            $session->set("msg","Website Transaction Mode Save Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                          
                      }  
        
    }
    
    
    public function createNews()
    {
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        return view('admin_dashboard/create_news_form'); 
    }

    public function storeNews()
    {
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        $newsModel = new NewsModel();

        // Validation
        $validation = \Config\Services::validation();
        $validation->setRules([
            'title' => 'required|min_length[25]',

            'description' => 'required',
            
        ]);

        if (!$validation->withRequest($this->request)->run()) {
            return redirect()->to('Active-News')->with('error', $validation->getErrors());
        }

        // Insert into DB
        $newsModel->save([
            'title' => $this->request->getPost('title'),
            'description' => $this->request->getPost('description'),
            'status' => "active",
            
        ]);

        return redirect()->to('Active-News')->with('success', 'The News Has Been Created Successfully');
    }
 public function updatenewsdata()
    {
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}

 $id = $this->request->getPost('id');
        $newsModel = new NewsModel();

        // Validation
        $validation = \Config\Services::validation();
        $validation->setRules([
            'title' => 'required',
            'description' => 'required',
            
        ]);

        if (!$validation->withRequest($this->request)->run()) {
            return redirect()->back()->withInput()->with('error', $validation->getErrors());
        }

        // Insert into DB
        $data = [
            'title' => $this->request->getPost('title'),
            'description' => $this->request->getPost('description'),
            
            
        ];
      $result =   $newsModel->update($id, $data);
      $newsDtata = $newsModel->where('id', $id)->first();
        if($result && $newsDtata['status']=="active" ){
          return redirect()->to('Active-News')->with('success', 'The News Has Been Updated Successfully!');
        }
        
        if($result && $newsDtata['status']=="pending" ){
          return redirect()->to('Pending-News')->with('success', 'The News Has Been Updated Successfully!');
        }
        else{
           return redirect()->back()->with('error', 'News Update Faild!');  
            
        }

       
    }

public function ShowActiveNews(){
   $data['heading'] ="Active News";
        $newsModel = new NewsModel();
        $data['news'] = $newsModel->where('status', "active")->orderBy('id', 'DESC')->findAll();
       
   return view('admin_dashboard/Show-Active-News', $data);  
    
}

    public function ActiveNews()
    {
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}      
          $data['heading'] ="Active News";
        $newsModel = new NewsModel();
        $data['news'] = $newsModel->where('status', "active")->orderBy('id', 'DESC')->findAll();

        return view('admin_dashboard/Active-News', $data);
    }
    
    public function InactiveNews()
    {
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}       
       $data['heading'] ="Inactive News";
        $newsModel = new NewsModel();
        $data['news'] = $newsModel->where('status', "pending")->orderBy('id', 'DESC')->findAll();

        return view('admin_dashboard/Active-News', $data);
    }
     
    
    public function NewsDetails($id)
    {
        $newsModel = new NewsModel();
        $data= $newsModel->where('id', $id)->first();
        if($data){
        $data['news'] = $newsModel->where('id', $id)->first();

        return view('admin_dashboard/News-Details', $data);
        }else{
            return redirect()->back();
        }        
        
    }
    
     public function NewsEdit($id)
    {
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        
        $newsModel = new NewsModel();
        $data= $newsModel->where('id', $id)->first();
        if($data){
        $data['news'] = $newsModel->where('id', $id)->first();

        return view('admin_dashboard/News-Edit', $data);
        }else{
            return redirect()->back();
        }        
        
    }
    
     public function NewsDelete($id)
    {
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        
        $newsModel = new NewsModel();
        $data= $newsModel->where('id', $id)->first();
        if($data){
        $result = $newsModel->delete($id);
        if($result){
        return redirect()->back()->with('success', 'The News Has Been Deleted Successfully!');
        }else{
            
          return redirect()->back()->with('error', 'News Deleted Fail!');   
        }
        }else{
            return redirect()->back();
        }        
        
    }
    
    
     public function NewsStatus($id)
    {
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        
        $newsModel = new NewsModel();
        $data= $newsModel->where('id', $id)->first();
        if($data){
            if($data['status']=="active"){
                $status = "pending";
            }else{
                 $status = "active";
            }
            $datas = [
                'status'=> $status
                ];
        $result = $newsModel->update($id, $datas);
        if($result){
        return redirect()->back()->with('success', 'The News Has Been Marked as '.ucfirst($status));
        }else{
            
          return redirect()->back()->with('error', 'News Status Fail!');   
        }
        }else{
            return redirect()->back();
        }        
        
    }
    
    public function RegisterateredInternship(){
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
    $data['heading'] =" ";
   $InternshipModel = new InternshipApplicationModel();   
       $data['application'] = $InternshipModel->where('certi_status', "pending")->orderBy('id', 'DESC')->findAll();
       
        return view('admin_dashboard/Registeratered-Internship', $data);
     }
    
    
public function certificatedownload($id = null)
{
    try {
        
        $internId = $id ?? $this->request->getPost('internId');

        if (empty($internId) || !is_numeric($internId)) {
            return redirect()->back()
                ->with('error', 'Invalid Request: Intern ID is required.')
                ->withInput();
        }

        $InternshipModel = new InternshipApplicationModel();   
        $application = $InternshipModel->where('id', $internId)->first();

        if (!$application) {
            return redirect()->back()
                ->with('error', 'Application not found.')
                ->withInput();
        }

        $Internship = new InternshipModel();   
        $internship = $Internship->where('id', $application['internship_id'])->first();

        $data = [
            'application' => $application,
            'internship'  => $internship,
        ];

        return view('Front/InternCertificateDownload', $data);

    } catch (\Exception $e) {
        log_message('error', '[CERTIFICATE_DOWNLOAD] ' . $e->getMessage());
        return redirect()->back()
            ->with('error', 'Something went wrong while generating the certificate. Please try again later.')
            ->withInput();
    }
}


        public function intern_user_details($id){
        
        
    $data['heading'] ="Registeratered-Internship-Details";
   $InternshipModel = new InternshipApplicationModel();   
       $data['application'] = $InternshipModel->where('id', $id)->first();
       
        return view('admin_dashboard/intern_user_details', $data);
    }
    
    
       public function intern_user_delete($id){
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
    $data['heading'] ="Registeratered-Internship-Details";
   $InternshipModel = new InternshipApplicationModel();   
       $result = $InternshipModel->delete($id);
       if($result){
         return redirect()->back()->with('msg', 'Intern Users Data Deleted Successfully!');  
       }else{
           return redirect()->back()->with('error', 'Intern Users Data Deleted Fail!');  
       }
        
    }
    
    public function delete_registered_internship(){
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
    $data['heading'] ="Registeratered-Internship-Details";
  
       $ids = $this->request->getPost('selectedUsers'); 

        if (!empty($ids) && is_array($ids)) {
           $InternshipModel = new InternshipApplicationModel();   

            // Bulk delete
            $result = $InternshipModel->whereIn('id', $ids)->delete();
       if($result){
         return redirect()->back()->with('msg', 'Intern Users Data Deleted Successfully!');  
       }else{
           return redirect()->back()->with('errors', 'Intern Users Data Deleted Fail!');  
       }
        }else{
           return redirect()->to('signiin')->with('errors', 'Intern Users Data Deleted Fail!');  
       } 
        
    }
    
       public function intern_user_edit($id){
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
    $data['heading'] ="Registeratered-Internship-Uodate-Details";
   $InternshipModel = new InternshipApplicationModel();   
       $data['application'] = $InternshipModel->where('id', $id)->first();
        return view('admin_dashboard/intern_user_edit', $data);
    }
    
    
    
    
    
    
     public function ApplyUpdateData()
     {
             $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
     

    helper(['form']);
    $validation = \Config\Services::validation();

   
    $rules = [
        'full_name'     => 'required',
        'email'         => 'required|valid_email',
        'mobile_number' => 'required|numeric',
        'qualification' => 'required',
        'college_name'  => 'required',
       
        'address'       => 'required',
    ];

    
    $id  = $this->request->getPost('id');
    if (!$this->validate($rules)) {
        return redirect()->back()
            ->withInput()
            ->with('errors', $validation->getErrors());
    }

    $InternshipModel = new InternshipApplicationModel();
    
    $data = [
       
        'full_name'      => $this->request->getPost('full_name'),
        'email'          => $this->request->getPost('email'),
        'mobile_number'  => $this->request->getPost('mobile_number'),
        'qualification'  => $this->request->getPost('qualification'),
        'college_name'   => $this->request->getPost('college_name'),
        'state'          => $this->request->getPost('state'),
        'district'       => $this->request->getPost('district'),
        'address'        => $this->request->getPost('address'),
       
    ];

    $photo = $this->request->getFile('photo');
    if ($photo && $photo->isValid() && !$photo->hasMoved()) {
        $newName = $photo->getRandomName();
        $photo->move('InternImage', $newName); 
        $data['photo'] = $newName;
    } 

   
    $resume = $this->request->getFile('resume');
    if ($resume->isValid() && !$resume->hasMoved()) {
        $newNameresume = $resume->getRandomName();
        $resume->move('ResumeImage', $newNameresume);
        $data['resume'] = $newNameresume;
    } 

    
    try {
        $result = $InternshipModel->update($id, $data);
       
        
        if ($result) {
            return redirect()->to('Registeratered-Internship')
                ->with('msg', 'Application Update Successfully.');
        } else {
            return redirect()->back()
                ->withInput()
                ->with('error', 'Failed to Update application');
        }
    } catch (\Exception $e) {
        return redirect()->back()
            ->withInput()
            ->with('error', 'Database error: ' . $e->getMessage());
    }
}

    
    
    
    
    
    
    
    
    
 public function AddCampaignDataUpdate()
{
    $campaignModel = new \App\Models\CampaignModel();
    $id = $this->request->getPost('id');
    $campaign = $campaignModel->find($id);
    
    if (!$campaign) {
        return redirect()->back()->with('error', 'Campaign not found.');
    }

    
    $validation = \Config\Services::validation();
    $validation->setRules([
        'title' => 'required|min_length[3]|max_length[255]',
        'category' => 'required',
        'description' => 'required|min_length[10]',
        'goal_amount' => 'required|numeric|greater_than[0]',
        'start_date' => 'required|valid_date',
        'end_date' => 'required|valid_date|after_or_equal[start_date]'
    ]);

    if (!$validation) {
        return redirect()->back()->withInput()->with('errors', $validation->getErrors());
    }

    
    $data = [
        'title'         => $this->request->getPost('title'),
        'category'      => $this->request->getPost('category'),
        'description'   => $this->request->getPost('description'),
        'goal_amount'   => $this->request->getPost('goal_amount'),
        'start_date'    => $this->request->getPost('start_date'),
        'end_date'      => $this->request->getPost('end_date'),
        'video_url'     => $this->request->getPost('video_url'),
        'update_at'     => date('Y-m-d H:i:s'),
    ];

  
    $featuredImage = $this->request->getFile('featured_image');
    if ($featuredImage && $featuredImage->isValid() && !$featuredImage->hasMoved()) {
        
        if (!$featuredImage) {
            return redirect()->back()->withInput()->with('error', 'Invalid image file for featured image.');
        }

        $newName = $featuredImage->getRandomName();
        $featuredImage->move('CampaignsImage', $newName);
        $data['featured_image'] = $newName;

        
        if (!empty($campaign['featured_image']) && file_exists('CampaignsImage/' . $campaign['featured_image'])) {
            unlink('CampaignsImage/' . $campaign['featured_image']);
        }
    }

    
    $galleryImages = $this->request->getFiles()['gallery_images'] ?? [];
    $galleryFilenames = [];
    
    if (!empty($galleryImages)) {
        
        $existingGallery = json_decode($campaign['gallery_images'], true) ?? [];
        if (!empty($existingGallery)) {
            foreach ($existingGallery as $oldImage) {
                if (file_exists('CampaignsGallery/' . $oldImage)) {
                    unlink('CampaignsGallery/' . $oldImage);
                }
            }
        }
        
        
        foreach ($galleryImages as $file) {
            if ($file->isValid() && !$file->hasMoved()) {
                if (!$file) {
                    continue; 
                }
                
                $name = $file->getRandomName();
                $file->move('CampaignsGallery', $name);
                $galleryFilenames[] = $name;
            }
        }
        
        if (!empty($galleryFilenames)) {
            $data['gallery_images'] = json_encode($galleryFilenames);
        } else {
            
            $data['gallery_images'] = json_encode([]);
        }
    }

    try {
        $campaignModel->update($id, $data);
        return redirect()->to('Campaigns')->with('msg', 'Your campaign details have been updated successfully.');
    } catch (\Exception $e) {
        return redirect()->back()->withInput()->with('error', 'Failed to update campaign: ' . $e->getMessage());
    }
}
    
    public function AddCampaignData()
    {
        helper(['form', 'url']);
        $model = new CampaignModel();

        $data = [
            'title'        => $this->request->getPost('title'),
            'category'     => $this->request->getPost('category'),
            'description'  => $this->request->getPost('description'),
            'goal_amount'  => $this->request->getPost('goal_amount'),
            'start_date'   => $this->request->getPost('start_date'),
            'end_date'     => $this->request->getPost('end_date'),
            'video_url'    => $this->request->getPost('video_url'),
            'status'=>"active",
        ];
       

                $featured = $this->request->getFile('featured_image');
        if ($featured && $featured->isValid() && !$featured->hasMoved()) {
            $newName = $featured->getRandomName();
            $featured->move('CampaignsImage', $newName);
            $data['featured_image'] = $newName;
        }

        
        $galleryFiles = $this->request->getFiles();
        $galleryImageNames = [];

        if (isset($galleryFiles['gallery_images'])) {
            foreach ($galleryFiles['gallery_images'] as $img) {
                if ($img->isValid() && !$img->hasMoved()) {
                    $name = $img->getRandomName();
                    $img->move('CampaignsGallery', $name);
                    $galleryImageNames[] = $name;
                }
            }
            $data['gallery_images'] = json_encode($galleryImageNames);
        }

        $model->insert($data);

        return redirect()->to('Campaigns')->with('msg', 'The Campaign Has Been Created Successfully!');
    }
    
    
    public function CampaignsDonationDashboard(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Campaigns-Donation-Dashboard";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/Campaigns-Donation-Dashboard', $data);
        
         }
    
     public function Donation()
{
    $session = session();
    $model = new UserModel();
    $user = $model->where('id', $session->id)->first();

   
    if (!$user || $user['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }

   
    $data['heading'] = "Donations";
    $data['users'] = $user;

    
    $DonatonCamModel = new DonateCampaignModel();
    $data['donation'] = $DonatonCamModel
        ->whereIn('payment_status', ['captured', 'COMPLETED', 'success'])
        ->orderBy('id', 'DESC')
        ->findAll();

    return view('admin_dashboard/Donation', $data);
}

    
    public function DonationFail(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Fail Donations";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
    
     $DonatonCamModel = new DonateCampaignModel();

$data['donation'] = $DonatonCamModel
    ->groupStart()
        ->where('payment_status', 'fail')->orWhere('payment_status IS NULL')->groupEnd()->findAll();
        return view('admin_dashboard/Donation', $data);
        
        
    } 
    
      public function ListCampaignDoners($id){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Donations";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
    
    /* $DonatonCamModel = new DonateCampaignModel();
     $data['donation'] = $DonatonCamModel->where('campaign_id', $id)->where('payment_status', "['captured', 'success']")->orderBy('id', 'DESC')->findAll();*/
     $DonatonCamModel = new DonateCampaignModel();
     $data['donation'] = $DonatonCamModel->where('campaign_id', $id)->findAll();
     
        return view('admin_dashboard/Donation', $data);
        
        
    }
    
       public function Categories(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Categories";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
   
        return view('admin_dashboard/Categories', $data);
        
        
    }
    
     public function Settings(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Settings";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/Settings', $data);
        
        
    }
    
     public function Campaigns(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
      $Dmodel = new CampaignModel();
    $ExpenseModel = new DonateCampaignModel();
    $projects = $Dmodel->where('status', "active")->orderBy('id', 'DESC')->findAll();
      foreach ($projects as &$project) {
        $totalExpense = $ExpenseModel->where('campaign_id', $project['id'])->where('payment_status', "captured")->selectSum('amount')
                                   ->first()['amount'] ?? 0;
         if ($totalExpense >= $project['goal_amount']) {
            $Dmodel->update($project['id'], ['status' => 'success']);
            $project['status'] = 'success'; 
        }
    }
    
    
    
    $data['heading'] ="Campaigns";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
     $CampModel = new CampaignModel();
     $data['campaign'] = $CampModel->where('status', "active")->orderBy('id', 'DESC')->findAll();
     $ExpenseModel = new DonateCampaignModel();
    
   
        return view('admin_dashboard/Campaigns', $data);
   }
   
 public function search_filture_campaigns()
{     
    $session = session();
    $CampModel = new CampaignModel();
    $date1 = $this->request->getVar('date1');
    $date2 = $this->request->getVar('date2');

    // Validate and format dates
    $startDate = date('Y-m-d', strtotime($date1));
    $endDate   = date('Y-m-d', strtotime($date2));

    // Fetch data from model with ordering inside query
    $campaigns = $CampModel->getDataByDateRange($startDate, $endDate);

    if (!empty($campaigns)) {
        $data['heading']   = "Campaigns";
        $model             = new UserModel();
        $data['users']     = $model->where('id', $session->id)->first();
        $data['campaign']  = $campaigns;

        return view('admin_dashboard/Campaigns', $data);
    } else {
        $session->setFlashdata("msg", "No Data Found");
        return redirect()->to('admin_dashboard');
    }
}

            
   
    public function CampaignsComplete(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
     $Dmodel = new CampaignModel();
    $ExpenseModel = new DonateCampaignModel();
    $projects = $Dmodel->where('status', "active")->orderBy('id', 'DESC')->findAll();
      foreach ($projects as &$project) {
        $totalExpense = $ExpenseModel->where('campaign_id', $project['id'])
                                   ->selectSum('amount')
                                   ->first()['amount'] ?? 0;
         if ($totalExpense >= $project['goal_amount']) {
            $Dmodel->update($project['id'], ['status' => 'success']);
            $project['status'] = 'success'; 
        }
    }
    
    $data['heading'] ="Campaigns";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
     $CampModel = new CampaignModel();
     $data['campaign'] = $CampModel->where('status', "success")->orderBy('id', 'DESC')->findAll();
     
        return view('admin_dashboard/Campaigns', $data);
   }
   
 public function CampaignsViews() {
    $data['heading'] = "Campaigns";
    $Dmodel = new CampaignModel();
    $ExpenseModel = new DonateCampaignModel();

    $perPage = 6;
    
    // Get paginated campaigns
    $projects = $Dmodel->where('status', "active")
                       ->orderBy('id', 'DESC')
                       ->paginate($perPage, 'default');
    
    // Process each campaign
    foreach ($projects as &$project) {
        $totalExpense = $ExpenseModel->where('campaign_id', $project['id'])
                                     ->where('payment_status', "captured")
                                     ->selectSum('amount')
                                     ->first();
        
        $totalExpense = $totalExpense ? $totalExpense['amount'] : 0;
        
        if ($totalExpense >= $project['goal_amount']) {
            $Dmodel->update($project['id'], ['status' => 'success']);
            $project['status'] = 'success';
        }
    }

    $data['campaign'] = $projects;
    $data['pager'] = $Dmodel->pager;
    
    // Get all donations
    $DonatonCamModel = new DonateCampaignModel();
    $data['donation'] = $DonatonCamModel->where('payment_status', "captured")
                                        ->orderBy('id', 'DESC')
                                        ->findAll();

    return view('Front/Campaigns-Views', $data);
}

  

public function CertficateInternship()
{
    require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
    $today = date('Y-m-d');
    $db    = \Config\Database::connect();

    // internships join internship_applications
    $builder = $db->table('internships');
    $builder->select('internships.id as internship_id, internships.title, internships.end, internship_applications.id as app_id, internship_applications.full_name, internship_applications.email, internship_applications.certi_status');
    $builder->join('internship_applications', 'internship_applications.internship_id = internships.id');
    $builder->orderBy('internship_applications.id', 'DESC');
    $result = $builder->get()->getResultArray();

    // email credentials from DB
    require 'db_config.php';
    $queryli    = "SELECT * FROM `email_credentials`";
    $resultli   = mysqli_query($connection, $queryli);
    $email_data = mysqli_fetch_array($resultli, MYSQLI_ASSOC);

    $queryliweb = "SELECT * FROM `admin_website_update`";
    $resultweb  = mysqli_query($connection, $queryliweb);
    $web_data   = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);

    $weblogo = base_url('websiteLogoImages/' . $web_data['web_logo']);
    $datawebname = $web_data['web_name'];
    $webemail_1  = $web_data['webemail_1'];
    $site_mobile_1 = $web_data['site_mobile_1'];
    $certificate_provider_name = $web_data['certificate_provider_name'];
    $designation = $web_data['designation'];
    $web_tag_line = $web_data['web_tag_line'];

    if (!empty($result)) {
        foreach ($result as $row) {
            // Internship complete hai
            if ($row['end'] <= $today) {
                if ($row['certi_status'] != 'complete') {
                    // certi_status update to complete
                    $db->table('internship_applications')
                       ->where('id', $row['app_id'])
                       ->update(['certi_status' => 'complete']);
//Load Composer's autoloader

//Create an instance; passing `true` enables exceptions

                    // PHPMailer setup
                    $mail = new PHPMailer(true);
                    try {
                        $mail->isSMTP();
                        $mail->Host       = $email_data['host'];
                        $mail->SMTPAuth   = true;
                        $mail->Username   = $email_data['by_email'];
                        $mail->Password   = $email_data['by_password'];
                        $mail->SMTPSecure = 'tls';
                        $mail->Port       = 587;

                        $mail->setFrom($email_data['by_email'], $email_data['subject']);
                        $mail->addAddress($row['email'], $row['full_name']);

                        $mail->isHTML(true);
                        $mail->Subject = "Internship Completed - Certificate Available";

                        // Mail Body
                        $downloadurl = base_url('certificate/download/' . $row['internship_id']);
                       $mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto; 
    border: 5px solid transparent; 
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b); 
    border-image-slice: 1; 
    background: #f9f9f9; 
    border-radius: 15px; 
    overflow: hidden; 
    font-family: Arial, sans-serif; 
    color: #000;'>

  <!-- Background watermark container -->
  <div style=\"
    background-image: url({$weblogo});
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <!-- Content box -->
    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
      </div>

      <!-- Message Body -->
      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear <strong>{$row['full_name']}</strong>,<br><br>

        <strong>Congratulations on successfully completing your internship!</strong><br><br>

        We are delighted to inform you that your internship titled 
        <strong>{$row['title']}</strong> has been successfully completed on 
        <strong>{$row['end']}</strong>.<br><br>

        Your dedication, consistency, and performance throughout this period have been greatly appreciated by our team. 
        We hope this experience has helped you enhance your professional skills and gain valuable insights into real-world work environments.<br><br>

         <strong>Download Your Certificate</strong><br>
        You can now download your official Internship Completion Certificate from the link below:<br><br>

        <a href='{$downloadurl}' 
           style='display:inline-block; padding:12px 22px; background:#28a745; 
                  color:#fff; text-decoration:none; font-weight:bold; border-radius:8px;'>
           Download Certificate
        </a><br><br>
        Please keep this certificate safe, as it stands as a recognition of your hard work and achievement.<br><br>

         For any queries or support, feel free to contact us at 
        <a href='mailto:{$webemail_1}' style='color:#ff4b2b;'>{$webemail_1}</a> 
        or call us at <strong>{$site_mobile_1}</strong>.<br><br>

        Wishing you continued success in your future endeavors!<br><br>

        Best Regards,<br>
        <strong>{$certificate_provider_name}</strong><br>
        {$designation}<br>
        <a href='https://www.{$datawebname}' target='_blank' style='color:#ff416c;'>www.{$datawebname}</a><br>
        <strong>{$web_data['web_name']}</strong>
      </div>

    </div>
  </div>
</div>";


                        $mail->AltBody = "Congratulations {$row['full_name']}, your internship '{$row['title']}' has been completed. Download your certificate here: {$downloadurl}";

                        $mail->send();
                      
                       return redirect()->to('Intern-Certificate-Complete');
                    } catch (Exception $e) {
                          
                         return redirect()->to('Intern-Certificate-Complete');
                    }
                }else{
                   
                  return redirect()->to('Intern-Certificate-Complete');   
                }
            } else {
                 
                // Internship abhi khatam nahi hui -> certi_status pending
                if ($row['certi_status'] != 'pending') {
                    $db->table('internship_applications')
                       ->where('id', $row['app_id'])
                       ->update(['certi_status' => 'pending']);
                       
                       return redirect()->to('Intern-Certificate-Complete');
                }else{
                    return redirect()->to('Intern-Certificate-Complete');
                }
            }
        }
        
    } else {
        return redirect()->to('Intern-Certificate-Complete');
    }
}

public function InternCertificateComplete(){
   $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
    $data['heading'] ="Complete";
   $InternshipModel = new InternshipApplicationModel();   
       $data['application'] = $InternshipModel->where('certi_status', "complete")->orderBy('id', 'DESC')->findAll();
        return view('admin_dashboard/Registeratered-Internship', $data);  
    
}


/* Corn Job*/

public function sendCompletionMails()
{
    require 'vendor/autoload.php';
    require 'phpmailer/src/PHPMailer.php';
    require 'phpmailer/src/Exception.php';
    require 'phpmailer/src/SMTP.php';

    $today = date('Y-m-d');
    $db    = \Config\Database::connect();

    // internships join internship_applications
    $builder = $db->table('internships');
    $builder->select('internships.id as internship_id, internships.title, internships.end, 
                      internship_applications.id as app_id, internship_applications.full_name, 
                      internship_applications.email, internship_applications.certi_status');
    $builder->join('internship_applications', 'internship_applications.internship_id = internships.id');
    $builder->orderBy('internship_applications.id', 'DESC');
    $result = $builder->get()->getResultArray();

    // email credentials from DB
    require 'db_config.php';
    $queryli    = "SELECT * FROM `email_credentials`";
    $resultli   = mysqli_query($connection, $queryli);
    $email_data = mysqli_fetch_array($resultli, MYSQLI_ASSOC);

    $queryliweb = "SELECT * FROM `admin_website_update`";
    $resultweb  = mysqli_query($connection, $queryliweb);
    $web_data   = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);

    $weblogo = base_url('websiteLogoImages/' . $web_data['web_logo']);
    $datawebname = $web_data['web_name'];
    $webemail_1  = $web_data['webemail_1'];
    $site_mobile_1 = $web_data['site_mobile_1'];
    $certificate_provider_name = $web_data['certificate_provider_name'];
    $designation = $web_data['designation'];

    if (!empty($result)) {
        foreach ($result as $row) {
            // Internship complete hai
            if ($row['end'] <= $today) {
                if ($row['certi_status'] != 'complete') {
                    // certi_status update to complete
                    $db->table('internship_applications')
                       ->where('id', $row['app_id'])
                       ->update(['certi_status' => 'complete']);

                    // PHPMailer setup
                    $mail = new PHPMailer(true);
                    try {
                        $mail->isSMTP();
                        $mail->Host       = $email_data['host'];
                        $mail->SMTPAuth   = true;
                        $mail->Username   = $email_data['by_email'];
                        $mail->Password   = $email_data['by_password'];
                        $mail->SMTPSecure = 'tls';
                        $mail->Port       = 587;

                        $mail->setFrom($email_data['by_email'], $email_data['subject']);
                        $mail->addAddress($row['email'], $row['full_name']);

                        $mail->isHTML(true);
                        $mail->Subject = "Internship Completed - Certificate Available";

                        // Mail Body
                        $downloadurl = base_url('certificate/download/' . $row['internship_id']);
                        $mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto; 
    border: 5px solid transparent; 
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b); 
    border-image-slice: 1; 
    background: #f9f9f9; 
    border-radius: 15px; 
    overflow: hidden; 
    font-family: Arial, sans-serif; 
    color: #000;'>

  <!-- Background watermark container -->
  <div style=\"
    background-image: url({$weblogo});
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <!-- Content box -->
    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
      </div>

      <!-- Message Body -->
      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear <strong>{$row['full_name']}</strong>,<br><br>

         <strong>Congratulations on successfully completing your internship!</strong><br><br>

        We are delighted to inform you that your internship titled 
        <strong>{$row['title']}</strong> has been successfully completed on 
        <strong>{$row['end']}</strong>.<br><br>

        Your dedication, consistency, and performance throughout this period have been greatly appreciated by our team. 
        We hope this experience has helped you enhance your professional skills and gain valuable insights into real-world work environments.<br><br>

         <strong>Download Your Certificate</strong><br>
        You can now download your official Internship Completion Certificate from the link below:<br><br>

        <a href='{$downloadurl}' 
           style='display:inline-block; padding:12px 22px; background:#28a745; 
                  color:#fff; text-decoration:none; font-weight:bold; border-radius:8px;'>
           Download Certificate
        </a><br><br>

        Please keep this certificate safe, as it stands as a recognition of your hard work and achievement.<br><br>

         For any queries or support, feel free to contact us at 
        <a href='mailto:{$webemail_1}' style='color:#ff4b2b;'>{$webemail_1}</a> 
        or call us at <strong>{$site_mobile_1}</strong>.<br><br>

        Wishing you continued success in your future endeavors!<br><br>

        Best Regards,<br>
        <strong>{$certificate_provider_name}</strong><br>
        {$designation}<br>
        <a href='https://www.{$datawebname}' target='_blank' style='color:#ff416c;'>www.{$datawebname}</a><br>
        <strong>{$web_data['web_name']}</strong>
      </div>

    </div>
  </div>
</div>";

                        $mail->AltBody = "Congratulations {$row['full_name']}, your internship '{$row['title']}' has been completed. Download your certificate here: {$downloadurl}";

                        $mail->send();
                        echo "Mail sent";
                    } catch (Exception $e) {
                        echo "Failed to send mail ";
                    }
                }
            } else {
                // Internship abhi khatam nahi hui -> certi_status pending
                if ($row['certi_status'] != 'pending') {
                    $db->table('internship_applications')
                       ->where('id', $row['app_id'])
                       ->update(['certi_status' => 'pending']);
                }
            }
        }
    } else {
        echo "No internship applications found.";
    }
}


public function VerifyFormCertficateInternship(){
  
  return view('Front/Verify-Form-Certficate-Internship');  
    
}

public function verifycertificate()
{
    $request = service('request');

    $validation = \Config\Services::validation();
    $validation->setRules([
        'id' => 'required',
    ]);

    if (!$validation->withRequest($request)->run()) {
        return $this->response->setJSON([
            'status'  => false,
            'message' => 'Validation failed.',
            'errors'  => $validation->getErrors()
        ])->setStatusCode(422);
    }

    $internship_id = $request->getJSON()->id ?? $request->getPost('id');

    $InternshipModel = new \App\Models\InternshipApplicationModel();
    $certificate = $InternshipModel->where('id', $internship_id)->first();

    if (!$certificate) {
        return $this->response->setJSON([
            'status'   => false,
            'verified' => false,
            'message'  => 'No matching certificate found.'
        ]);
    }

    return $this->response->setJSON([
        'status'    => true,
        'verified'  => true,
        'full_name' => $certificate['full_name'],
        'internship_id' => $certificate['internship_id'],
         'id' => $certificate['id'],
        'email'     => $certificate['email'],
        'college_name'  => $certificate['college_name'],
        'internship_field' => $certificate['internship_field'],
        'created_at'    => $certificate['created_at'],
        'message'       => 'ertificate is authentic.'
    ]);
}




    
    public function campaign_delete($id){
        
      $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Campaigns";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
     $CampModel = new CampaignModel();
     $result = $CampModel->delete($id);
         if($result){
             return redirect()->back()->with('msg', 'Campaign Delete successfully!');
         }else{
            return redirect()->back()->with('msg', 'Campaign Delete Fail!'); 
         }
        
    }
     public function campaign_details($id){
        
     
   
    $data['heading'] ="Campaigns";

     $CampModel = new CampaignModel();
     $result = $CampModel->where('id', $id)->first();
         if($result){
             $CampModel = new CampaignModel();
     $data['campaign'] = $CampModel->where('id', $id)->first();
     
             return view('admin_dashboard/campaign_details', $data);
         }else{
            return redirect()->back()->with('success', 'Campaign Not Found!'); 
         }
        
    }
    
    
      
    public function CreateCampaigns(){
        
      $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Campaigns";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
    
             
     
             return view('admin_dashboard/CreateCampaigns', $data);
         
        
    }
    
    
    
    public function campaign_edit($id){
      
      $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Campaigns";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
     $CampModel = new CampaignModel();
     $result = $CampModel->where('id', $id)->first();
         if($result){
             $CampModel = new CampaignModel();
     $data['campaign'] = $CampModel->where('id', $id)->first();
     
             return view('admin_dashboard/campaign_edit', $data);
         }else{
            return redirect()->back()->with('success', 'Campaign Not Found!'); 
         }
        
    }
    
    
    public function CreateDonationProject(){
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Create-Donation-Project";
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/Create-Donation-Project', $data);
       
        
    }
    public function ProjectEdit($id){
        
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Update-Project-Form";
     $Dmodel = new DonationProjectModel();
      $data['project'] = $Dmodel->where('id', $id)->first();
 $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
      
          return view('admin_dashboard/Project-Edit', $data);
        
    }
    
    
      public function ProjectDetails($id){
        
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

   
    $data['heading'] ="Update-Project-Form";
     $Dmodel = new DonationProjectModel();
      $data['project'] = $Dmodel->where('id', $id)->first();
 
     
          return view('admin_dashboard/Project-Details', $data);
        
    }
    public function DonationProjectData(){
        
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    
     helper(['form']);

        if ($this->request->getMethod() === 'post') {
            $Dmodel = new DonationProjectModel();

            // Validate input
            $rules = [
                'title'         => 'required|min_length[3]',
                'description'   => 'required',
                'target_amount' => 'required|numeric',
                'category'      => 'required'
            ];

            if (!$this->validate($rules)) {
                return view('admin_dashboard/Create-Donation-Project', [
                    'validation' => $this->validator
                ]);
            }

            // Handle image upload (optional)
            $image = $this->request->getFile('image');
            $imageName = null;

            if ($image && $image->isValid() && !$image->hasMoved()) {
                $imageName = $image->getRandomName();
                $image->move('DonationProjectsImage', $imageName);
            }

  $category      = $this->request->getPost('category');
  if($category == "other"){
    
       $category1      = $this->request->getPost('other_category');  
  }else
       $category1      = $this->request->getPost('category'); 
  }
            // Save data
            $data = [
                'title'         => $this->request->getPost('title'),
                'description'   => $this->request->getPost('description'),
                'target_amount' => $this->request->getPost('target_amount'),
                'category'      => $category1,
                'location'      => $this->request->getPost('location'),
                'status'=>"active",
                'image'         => $imageName
            ];
             $Dmodel->save($data); 

            return redirect()->to('/Active-Donation-Project')->with('msg', 'The Project Has Been Created Successfully!');
        
     $model = new UserModel();
    $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/Create-Donation-Project', $data);  
        
    }
    
    
    
    
    
    
    
    public function donationprojectupdatedata(){
        
       $projectModel = new \App\Models\DonationProjectModel();

    $id = $this->request->getPost('id');
    
     $category      = $this->request->getPost('category');
  if($category == "other"){
    
       $category1      = $this->request->getPost('other_category');  
  }else{
       $category1      = $this->request->getPost('category'); 
  }
    
    $data = [
        'title'          => $this->request->getPost('title'),
        'description'    => $this->request->getPost('description'),
        'target_amount'  => $this->request->getPost('target_amount'),
        'category'       => $category1,
        'location'       => $this->request->getPost('location'),
    ];

    // Check if image is uploaded
    $image = $this->request->getFile('image');
    if ($image && $image->isValid() && !$image->hasMoved()) {
        // Move new image
        $newName = $image->getRandomName();
        $image->move('DonationProjectsImage', $newName);

        // Get old image
        $oldProject = $projectModel->find($id);
        if ($oldProject && !empty($oldProject['image']) && file_exists('DonationProjectsImage/' . $oldProject['image'])) {
            unlink('DonationProjectsImage/' . $oldProject['image']);
        }

        $data['image'] = $newName;
    }

    $projectModel->update($id, $data);

     return redirect()->to('/Active-Donation-Project')->with('msg', 'The Project Has Been Updated Successfully!');
 
        
    }
    
    public function ProjectDelete($id){
           
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Active-Donation-Project";
    
   $Dmodel = new DonationProjectModel();
     $result = $Dmodel->delete($id);
     if($result){
          return redirect()->back()->with('msg', 'The Project Has Been Deleted Successfully!'); 
     }else{
        return redirect()->back()->with('msg', 'Project Delete Fail!');   
     }
        
    }
    public function ProjectExpenseEdit($id){
     
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Active-Donation-Project";
    
 $DFmodel = new ProjectExpenseModel();
     $result = $DFmodel->where('id', $id)->first();
     if($result){
         $Dmodel = new DonationProjectModel();
          $data['project'] = $Dmodel->where('id', $result['project_id'])->first();
        $DFmodel = new ProjectExpenseModel();
     $data['expense'] = $DFmodel->where('id', $id)->first();
     return view('admin_dashboard/Project-Expense-Edit', $data);
     
     }else{
        return redirect()->back()->with('success', 'Project Details Not Fount!');   
     } 
     
     
        
    }
    
    
      public function ProjectExpenseDetails($id){
     
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    $data['heading'] ="Project-Expense-Details";
    
 $DFmodel = new ProjectExpenseModel();
     $result = $DFmodel->where('id', $id)->first();
     if($result){
         $Dmodel = new DonationProjectModel();
          $data['project'] = $Dmodel->where('id', $result['project_id'])->first();
        $DFmodel = new ProjectExpenseModel();
     $data['expense'] = $DFmodel->where('id', $id)->first();
     
     
     return view('admin_dashboard/Project-Expense-Details', $data);
     }else{
        return redirect()->back()->with('success', 'Project Details Not Fount!');   
     } 
     
     
        
    }
    
    
    public function project_expense_Update(){
     helper(['form', 'url']);
    $expenseModel = new \App\Models\ProjectExpenseModel();

    $id = $this->request->getPost('expenseId');
$expense_category  = $this->request->getPost('expense_category');
 if($expense_category=="Others"){
      $expense_category1  = $this->request->getPost('expense_other');
 }else{
      $expense_category1  = $this->request->getPost('expense_category');
 }
    $data = [
        'receipt_id'       => $this->request->getPost('receiptId'),
        'name'             => $this->request->getPost('name'),
        'amount'           => $this->request->getPost('amount'),
        'product_name'     => $this->request->getPost('productName'),
        'expense_category' => $expense_category1,
        'paid_to'          => $this->request->getPost('paid_to'),
        'payment_mode'     => $this->request->getPost('payment_mode'),
        'project_name'     => $this->request->getPost('project_name'),
        'description'      => $this->request->getPost('description'),
        'expense_date'     => $this->request->getPost('expense_date')
    ];

    // Handle image upload
    $receiptImage = $this->request->getFile('receiptImage');
    if ($receiptImage && $receiptImage->isValid() && !$receiptImage->hasMoved()) {
        $newName = $receiptImage->getRandomName();
        $receiptImage->move('ProjectExpenseImage', $newName);

        // Delete old image
        $old = $expenseModel->find($id);
        if ($old && !empty($old['receipt_image']) && file_exists('ProjectExpenseImage/' . $old['receipt_image'])) {
            unlink('ProjectExpenseImage/' . $old['receipt_image']);
        }

        $data['receipt_image'] = $newName;
    }

   $result= $expenseModel->update($id, $data);
if($result){
  return redirect()->to('/Active-Donation-Project')->with('msg', 'The Expense Receipt Has Been Updated Successfully!');    
}else{
    return redirect()->to('/Active-Donation-Project')->with('error', 'Project Expense Update Fail!');  
}
    }
    
    public function ProjectExpenseDelete($id){
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Active-Donation-Project";
    
 $DFmodel = new ProjectExpenseModel();
     $result = $DFmodel->where('id', $id)->first();
     if($result){
          $DFmodel = new ProjectExpenseModel();
     $result = $DFmodel->delete($id);
         if($result){
  return redirect()->back()->with('msg', 'The Project Expense Receipt Has Been Deleted Successfully!');    
}else{
    return redirect()->to()->with('error', 'Project Expense Delete Fail!');  
}
     
     }else{
        return redirect()->back()->with('msg', 'Project Details Not Fount!');   
     }   
        
    }
    
   public function ActiveDonationProject() {
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }

    $data['heading'] = "Active-Donation-Project";
    $Dmodel = new DonationProjectModel();
    $ExpenseModel = new ProjectExpenseModel();

    // Get all pending projects
    $projects = $Dmodel->where('status', "active")
                       ->orderBy('id', 'DESC')
                       ->findAll();

    foreach ($projects as &$project) {
        $totalExpense = $ExpenseModel->where('project_id', $project['id'])
                                    ->selectSum('amount')
                                    ->first()['amount'] ?? 0;

        if ($totalExpense >= $project['target_amount']) {
            
            $Dmodel->update($project['id'], ['status' => 'success']);
            $project['status'] = 'success';
        } else {
           
            $Dmodel->update($project['id'], ['status' => 'active']);
            $project['status'] = 'active';
        }
    }

    // Get only active projects for display
    $data['project'] = $Dmodel->where('status', "active")
                              ->orderBy('id', 'DESC')
                              ->findAll();

    $data['expense'] = $ExpenseModel->orderBy('id', 'DESC')->findAll();

    return view('admin_dashboard/Active-Donation-Project', $data);
}

    
    public function PublicReportProject(){
     $data['heading'] = "Active-Donation-Project";
    $Dmodel = new DonationProjectModel();
    $ExpenseModel = new ProjectExpenseModel();   
       $data['project'] = $Dmodel->orderBy('id', 'DESC')->findAll();
    echo "hujh";die;
    
    return view('Front/Public-Report-Project', $data);
    
    }
    
    public function CompleteDonationProject() {
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }

    $data['heading'] = "Complete-Donation-Project";
    $Dmodel = new DonationProjectModel();
    $ExpenseModel = new ProjectExpenseModel();

    // Get all pending or active projects (to recheck their status)
    $projects = $Dmodel->whereIn('status', ["success", "active"])
                       ->orderBy('id', 'DESC')
                       ->findAll();

    foreach ($projects as &$project) {
        $totalExpense = $ExpenseModel->where('project_id', $project['id'])
                                    ->selectSum('amount')
                                    ->first()['amount'] ?? 0;

        if ($totalExpense >= $project['target_amount']) {
           
            $Dmodel->update($project['id'], ['status' => 'success']);
            $project['status'] = 'success';
        } else {
           
            $Dmodel->update($project['id'], ['status' => 'active']);
            $project['status'] = 'active';
        }
    }

    // Fetch updated data
    $data['project'] = $Dmodel->where('status', "success")->orderBy('id', 'DESC')->findAll();
    $data['expense'] = $ExpenseModel->orderBy('id', 'DESC')->findAll();

    return view('admin_dashboard/Active-Donation-Project', $data);
}

public function ProjectAddExpense($id) {
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }

    $data['heading'] = "Active-Donation-Project";

    // Models
    $Dmodel   = new DonationProjectModel();
    $EModel   = new ProjectExpenseModel();

    // Get project details (only pending or active)
    $data['project'] = $Dmodel->whereIn('status', ["pending", "active"])
                              ->where('id', $id)
                              ->first();

    // Get all expenses for this project
    $data['expenses'] = $EModel->where('project_id', $id)
                               ->orderBy('id', 'DESC')
                               ->findAll();

    // Calculate total expense
    $data['total_expense'] = $EModel->where('project_id', $id)
                                    ->selectSum('amount')
                                    ->first()['amount'] ?? 0;

    return view('admin_dashboard/Project-Add-Expense', $data);
}


    public function project_expense_add(){
      $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    
    
     helper(['form', 'url']);

        $validation = \Config\Services::validation();
        
        // Validate required fields
        $rules = [
            'name'              => 'required',
            'amount'            => 'required|numeric',
            'productName'       => 'required',
            'expense_category'  => 'required',
            'paid_to'           => 'required',
            'payment_mode'      => 'required',
            'expense_date'      => 'required|valid_date',
            'projectId'         => 'required|numeric',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $validation->getErrors());
        }

        $DFmodel = new ProjectExpenseModel();

        // Handle receipt image upload
        $receiptImage = $this->request->getFile('receiptImage');
        $imageName = null;

        if ($receiptImage && $receiptImage->isValid() && !$receiptImage->hasMoved()) {
            $imageName = $receiptImage->getRandomName();
            $receiptImage->move('ProjectExpenseImage', $imageName); 
        }

 $expense_category  = $this->request->getPost('expense_category');
 if($expense_category=="Others"){
      $expense_category1  = $this->request->getPost('expense_other');
 }else{
      $expense_category1  = $this->request->getPost('expense_category');
 }


        $data = [
            'project_id'        => $this->request->getPost('projectId'),
            'receipt_id'        => $this->request->getPost('receiptId'),
            'receipt_image'     => $imageName,
            'name'              => $this->request->getPost('name'),
            'amount'            => $this->request->getPost('amount'),
            'product_name'      => $this->request->getPost('productName'),
            'expense_category'  => $expense_category1,
            'paid_to'           => $this->request->getPost('paid_to'),
            'payment_mode'      => $this->request->getPost('payment_mode'),
            'project_name'      => $this->request->getPost('project_name'),
            'description'       => $this->request->getPost('description'),
            'expense_date'      => $this->request->getPost('expense_date'),
        ];

       $result =  $DFmodel->insert($data);
     if($result){
      return redirect()->to('Active-Donation-Project')->with(
    'msg',
    'Expense added successfully for project: ' . $this->request->getPost('project_name')
);
}else{
     return redirect()->back()->withInput()->with('errors', $validation->getErrors());
}

    
  
   
        
    }
    public function EnquiryRequest(){
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Enquiry Request Data";
   $Enmodel = new EnquiryModel();  
      $data['enquiry'] =  $Enmodel->where('status', "pending")->orderBy('id', 'DESC')->findAll();
        return view('admin_dashboard/Enquiry-Data', $data);
       
        
    }
    
    
       public function EnquiryResponse(){
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Enquiry Response Data";
   $Enmodel = new EnquiryModel();  
      $data['enquiry'] =  $Enmodel->where('status', "success")->orderBy('id', 'DESC')->findAll();
        return view('admin_dashboard/Enquiry-Data', $data);
       
        
    }
    
    public function enquirydatadetails($id){
        
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Enquiry Data";
   $Enmodel = new EnquiryModel();  
      $data['enquiry'] =  $Enmodel->where('id', $id)->first();
     
        return view('admin_dashboard/enquiry-data-details', $data);   
        
    }
     public function enquirydatadelete($id){
        echo $id;die;
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Enquiry Data";
   $Enmodel = new EnquiryModel();  
      $result =  $Enmodel->delete($id);
     if($result){
         return redirect()->back()->with('msg', 'The Enquiry Data Has Been Deleted Successfully.');
     }else{
         return redirect()->back()->with('msg', 'Enquiry Data Delete Fail');
     }
           
        
    }
    
    
      public function delete_enquiry_data() {
           $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
     $Enmodel = new EnquiryModel();  
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No Enquiry selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $Enmodel->whereIn('id', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' Enquiry(s)', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No enquiry were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'Enquiry deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting Enquiry. Please try again later.')
            ->with('msg_type', 'danger');
    }
}
   
    
    

    
    
    
    
    public function admin_enquiry_response($id) {
    $session = session();
    $model = new UserModel();
    $userData = $model->where('id', $session->id)->first();

    if (!$userData || $userData['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }

    $response_msg = $this->request->getPost('response_msg');

    $Enmodel = new EnquiryModel();
    $updateData = [
        'response' => $response_msg,
        'status' => "success",
        'res_date' => date('Y-m-d'),
    ];
    $result = $Enmodel->update($id, $updateData);

    if ($result) {
        $EnqData = $Enmodel->where('id', $id)->first();

        $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
        $name = $EnqData['name'];
        $email = $EnqData['email'];
        $phone = $EnqData['phone'];
        $subject = $EnqData['subject'];
        $message = $EnqData['message'];
        $response = $response_msg ?? 'Thank you for contacting us. We will respond soon.';
        $created_at = $EnqData['created_at'];

        require 'vendor/autoload.php';
        require 'phpmailer/src/PHPMailer.php';
        require 'phpmailer/src/Exception.php';
        require 'phpmailer/src/SMTP.php';

        require 'db_config.php';

        // Fetch email config
        $email_data = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `email_credentials`"), MYSQLI_ASSOC);
        $dataweb = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `admin_website_update`"), MYSQLI_ASSOC);
        $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

        // ===================== SEND TO USER =====================
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = $email_data['host'];
            $mail->SMTPAuth = true;
            $mail->Username = $email_data['by_email'];
            $mail->Password = $email_data['by_password'];
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mail->addAddress($email, $name);
            $mail->isHTML(true);
            $mail->Subject = "Important Update Regarding Your Inquiry - Here is the Response from {$dataweb['web_name']} Team.";

            $mail->Body = "
<div style='width: 100%;
    max-width: 700px;
    margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

    <div style='
        background-image: url({$weblogo});
        background-repeat: no-repeat;
        background-position: center;
        background-size: 280px 280px;
        background-color: #ffffff;
        padding: 40px;
        font-family: Arial, sans-serif;
        color: #000;
    '>

        <!-- Logo & Website Name -->
        <div style='text-align: center; margin-bottom: 30px;'>
            <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
            <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
        </div>

        <!-- Main Content -->
        <div style='
            background-color: rgba(255, 255, 255, 0.92);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        '>
            <h2 style='color: #ff4b2b; margin-top: 0;'>{$dataweb['web_name']} - Response to Your Enquiry</h2>
            
            <p>Dear {$name},</p>
            <p><strong>Our Response:</strong></p>
            <div style='background:#eee;padding:10px;border-left:4px solid #ff4b2b;'>{$response}</div><br>

            <p><strong>Your Enquiry:</strong></p>
            <ul>
                <li><strong>Name:</strong> {$name}</li>
                <li><strong>Email:</strong> {$email}</li>
                <li><strong>Phone:</strong> {$phone}</li>
                <li><strong>Subject:</strong> {$subject}</li>
                <li><strong>Message:</strong> {$message}</li>
            </ul>

            <p>Best Regards,<br>
            {$dataweb['certificate_provider_name']}<br>
            {$dataweb['designation']}<br>
            <a href='https://www.{$dataweb['site_url']}' target='_blank'>www.{$dataweb['site_url']}</a>
            </p>

            
        </div>
    </div>
</div>";

            
            $mail->send();
        } catch (Exception $e) {
            return redirect()->back()->with('msg', 'Response saved, but user email failed to send.');
        }

        // ===================== SEND TO ADMIN =====================
        $mailAdmin = new PHPMailer(true);
        try {
            $mailAdmin->isSMTP();
            $mailAdmin->Host = $email_data['host'];
            $mailAdmin->SMTPAuth = true;
            $mailAdmin->Username = $email_data['by_email'];
            $mailAdmin->Password = $email_data['by_password'];
            $mailAdmin->SMTPSecure = 'tls';
            $mailAdmin->Port = 587;

            $mailAdmin->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mailAdmin->addAddress($adminEmail, 'Enquiry from ' . $name);
            $mailAdmin->isHTML(true);
            $mailAdmin->Subject = 'New Enquiry Received from ' . $name;

            $mailAdmin->Body = "
            <div style='font-family: Arial, sans-serif; padding: 20px; background: #f9f9f9;'>
                <h2 style='color: #ff4b2b;'>New Enquiry Notification</h2>
                <p><strong>From:</strong> {$name}</p>
                <p><strong>Email:</strong> {$email}</p>
                <p><strong>Phone:</strong> {$phone}</p>
                <p><strong>Subject:</strong> {$subject}</p>
                <p><strong>Message:</strong> {$message}</p>
                <p><strong>Submitted At:</strong> {$created_at}</p>
            </div>";
            $mailAdmin->send();
        } catch (Exception $e) {
            return redirect()->back()->with('msg', 'User email sent, but admin email failed to send.');
        }

        return redirect()->back()->with('msg', 'Response has been sent successfully to the user. Please check your email inbox or spam folder.');
    } else {
        return redirect()->back()->with('msg', 'Failed to send response.');
    }
}

    
 public function addOccupationData()
{
    try {
        helper(['form', 'url']);
        $validation = \Config\Services::validation();

        // Validation rules
        $rules = [
            'designation' => 'required|is_unique[occupations.designation]',
            'fee'         => 'required|numeric',
        ];

        if (!$this->validate($rules)) {
            return $this->response->setJSON([
                'status' => false,
                'errors' => $validation->getErrors()
            ])->setStatusCode(422);
        }

        $userId      = $this->request->getPost('user_id');
        $occupation  = $this->request->getPost('designation');
        $fee         = $this->request->getPost('fee');

        $data = [
            'user_id'     => $userId,
            'designation' => $occupation,
            'fee'         => $fee,
        ];

        $db      = \Config\Database::connect();
        $builder = $db->table('occupations');
        $insert  = $builder->insert($data);

        if (!$insert) {
            return $this->response->setJSON([
                'status'  => false,
                'message' => 'Failed to save occupation. Please try again.'
            ])->setStatusCode(500);
        }

        return $this->response->setJSON([
            'status'  => true,
            'message' => 'Occupation added successfully.'
        ]);

    } catch (\Throwable $e) {
        return $this->response->setJSON([
            'status'  => false,
            'message' => 'Unexpected server error occurred.',
            'error'   => $e->getMessage()
        ])->setStatusCode(500);
    }
}



public function getOccupations()
{
    try {
        $userId = session()->get('id');
        if(!$userId){
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Unauthorized access. Please login.'
            ])->setStatusCode(401);
        }

        $db = \Config\Database::connect();
        $builder = $db->table('occupations')->orderBy('id', 'DESC');
        $data = $builder->orderBy('id', 'DESC')->get()->getResult();

        if(!$data){
            return $this->response->setJSON([
                'status' => false,
                'message' => 'No occupations found.'
            ]);
        }

        // Build HTML
        $html = '<table class="table table-bordered" id="users-list">
                    <thead>
                        <tr>
                            <th><input type="checkbox" id="select-all"></th>
                            <th>Sr.No.</th>
                            <th>Designation</th>
                            <th>Fee</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>';

        $i = 1;
        foreach ($data as $row) {
            $html .= '<tr>
                        <td><input type="checkbox" class="row-checkbox" value="' . (int)$row->id . '"></td>
                        <td>' . $i++ . '</td>
                        <td>' . esc($row->designation) .'</td>
                        <td>' . esc($row->fee) . '</td>
                        <td>
                            <button class="btn btn-sm btn-primary edit-btn" 
                                    data-id="' . $row->id . '" 
                                    data-designation="' . esc($row->designation) . '" 
                                    data-fee="' . esc($row->fee) . '">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </button>
                            <button class="btn btn-sm btn-danger delete-btn" 
                                    data-id="' . $row->id . '">
                                <i class="fa-solid fa-trash-can"></i>
                            </button>
                        </td>
                      </tr>';
        }

        $html .= '</tbody></table>
                  <button id="delete-selected" class="btn btn-danger btn-sm mt-2">Delete Selected</button>';

        return $this->response->setBody($html);

    } catch (\Throwable $e) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Something went wrong while fetching data.',
            'error'   => $e->getMessage()
        ])->setStatusCode(500);
    }
}

public function deleteMultiple()
{
    try {
        $ids = $this->request->getPost('ids');

        if (empty($ids) || !is_array($ids)) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'No records selected for deletion.'
            ])->setStatusCode(400);
        }

        $db = \Config\Database::connect();
        $builder = $db->table('occupations');

       
        $deleted = $builder->whereIn('id', $ids)->delete();

        if (!$deleted) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Failed to delete records.'
            ]);
        }

        return $this->response->setJSON([
            'status' => true,
            'message' => 'Selected records deleted successfully.'
        ]);

    } catch (\Throwable $e) {
        return $this->response->setJSON([
            'status' => false,
            'message' => 'Error: ' . $e->getMessage()
        ])->setStatusCode(500);
    }
}








use ResponseTrait;
public function updateOccupation()
{
    helper(['form', 'url']);

    $rules = [
        'designation' => "required|is_unique[occupations.designation,id,{$this->request->getPost('id')}]",
        'fee'         => 'required|numeric',
    ];

    if (!$this->validate($rules)) {
        return $this->response->setJSON([
            'status' => 'error',
            'errors' => $this->validator->getErrors()
        ])->setStatusCode(422); // Unprocessable Entity
    }

    $id          = $this->request->getPost('id');
    $designation = $this->request->getPost('designation');
    $fee         = $this->request->getPost('fee');

    $db      = \Config\Database::connect();
    $builder = $db->table('occupations');
    $builder->where('id', $id)->update([
        'designation' => $designation,
        'fee'         => $fee,
    ]);

    return $this->response->setJSON([
        'status'  => 'success',
        'message' => 'Occupation updated successfully.'
    ]);
}


public function deleteOccupation($id)
{
    $userId = session()->get('id'); // security check

    $db = \Config\Database::connect();
    $builder = $db->table('occupations');

   
    $builder->where(['id' => $id]);
    
    if ($builder->delete()) {
        return $this->response->setJSON(['status' => 'success']);
    } else {
        return $this->response->setJSON(['status' => 'error']);
    }
}

    public function admin_generate_poster(){
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Generate Poster";
  
       
        return view('admin_dashboard/admin_generate_poster', $data);
        
        
    }
    
public function adminReferralDonation($id) {
    $session = session();
    $userModel = new UserModel();
    $data = $userModel->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorized Access!']);
    }
    
    $data['heading'] = "Referral Donation";
    
    $donateModel = new Donote_TransactionModel();
    
    $data['TotalDonation'] = $donateModel->where('referralId', $id)
                                        ->whereIn('payment_status', ['captured', 'PAYMENT_SUCCESS','COMPLETED'])
                                        ->selectSum('amount')
                                        ->first()['amount'] ?? 0;
     $data['users'] = $userModel->where('id', $id)->first();

    $data['doner'] = $donateModel->where('referralId', $id)
                               ->whereIn('payment_status', ['captured', 'PAYMENT_SUCCESS', 'COMPLETED'])
                               ->findAll();
    
    
    return view('admin_dashboard/adminReferralDonation', $data);
}
    public function ActiveReferralAdmin(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $userModel = new UserModel();
    $dataP = $userModel->where('referralId !=','direct')->where('status', 'active')->findAll();
    
   $data['heading'] = 'Active Referral <mark style="
    height: 22px;
    width: 22px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background-color: #fcf8e3;
    border-radius: 50%;
    font-weight: bold;
    font-size: 15px;
">' . count($dataP) . '</mark>';


    $userModel = new UserModel();
        $data['users'] = $userModel->where('referralId !=','direct')->where('status', 'active')->findAll();
       
         return view('admin_dashboard/admin_show_verifie_user',$data);
    }
    
    public function EventUpdateData(){
            helper(['form']);
 $id = $this->request->getPost('id');
        $Emodel = new EventTicketModel();


        $data = [
         
            'name'     => $this->request->getPost('name'),
            'email'    => $this->request->getPost('email'),
            'mobile'   => $this->request->getPost('mobile'),
            'address'  => $this->request->getPost('address'),
            'pin'      => $this->request->getPost('pin'),
            'state'    => $this->request->getPost('state'),
            'district' => $this->request->getPost('district'),
          
        ];

        if ($Emodel->update($id, $data)) {
             return redirect()->to('Registeratered-Event')->with('msg', 'The Applicant Form Has Been Successfully Updated!')->withInput();   
        
    }else{
        return redirect()->back()->with('msg', 'Ticket Data Update Fail!')->withInput();       
    }
    }
   
   public function EventRegisterationData(){
     
      
      helper(['form']);
 $event_id = $this->request->getPost('event_id');
 

            $name     = $this->request->getPost('name');
            $email    = $this->request->getPost('email');
            $mobile   = $this->request->getPost('mobile');
            $address  = $this->request->getPost('address');
            $pin     = $this->request->getPost('pin');
            $state    = $this->request->getPost('state');
            $district = $this->request->getPost('district');
 
        $Emodel = new EventTicketModel();
$order_id = 'ORD_' . time() . '_' . uniqid();

        $data = [
            'event_id' => $this->request->getPost('event_id'),
            'name'     => $this->request->getPost('name'),
            'email'    => $this->request->getPost('email'),
            'mobile'   => $this->request->getPost('mobile'),
            'address'  => $this->request->getPost('address'),
            'pin'      => $this->request->getPost('pin'),
            'state'    => $this->request->getPost('state'),
            'district' => $this->request->getPost('district'),
            'transactionId'=>$order_id,
        ];

        if ($Emodel->insert($data)) {
            $id = $Emodel->getInsertId();
             $Eventmodel = new EventModel();
        $data =   $Eventmodel->where('id',$event_id)->first();
            if($data && $data['fee']>0){
              $amount = $data['fee'];
              $amountF = $data['fee'];
              
              
              
              
              $paymentsModel=new Payments_Mode_Models();
          $dataphonepe=$paymentsModel->first(); 
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first();
          
          require 'db_config.php';
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                       
          
if($datapayu['status']=="payu"){
   $key  = getenv('PAYU_KEY');
        $salt =getenv('PAYU_SALT');

        // Required fields (apni data source se lo)
        $txnid      = $order_id;
        $amount = round($amount, 2); 
        $firstname  = $name ?? 'Buyer';
        $email      = $email ?? 'no@domain.com';
        $productinfo= $productinfo ?? 'Donation';
        $phone      = $mobile ?? '';

        // Build params
        $params = [
            'key'        => $key,
            'txnid'      => $txnid,
            'amount'     => $amount,
            'productinfo'=> $productinfo,
            'firstname'  => $firstname,
            'email'      => $email,
            'udf1' => '', 'udf2' => '', 'udf3' => '', 'udf4' => '', 'udf5' => '',
            
            'phone' => $phone,
            'Salt'=> $salt,
             'surl' => base_url().'payu/Eventnresponse',
             'furl' => base_url().'payu/Eventresponse'
        ];

        // Generate correct hash
        $hash = $this->generatePayuRequestHash($params, $salt);

        // Prepare data for auto-post form
        $data = $params;
        $data['hash']   = $hash;
        $data['action'] = $this->payuUrl();
         
 $trans = [
    
     'payment_status'=>"fail",
     ];
     
 
 $Emodel = new EventTicketModel();
$transid= $Emodel->update($id, $trans);
 if($transid){
        return view('Front/payuEvent_form', $data);
    }else{
        
        return redirect()->back()->with('msg', 'Server Not Response');
    }
          }   
              
              
              
              
              
            $paymentsModel=new Payments_Mode_Models();
          $dataPayment = $paymentsModel->first();
          if($dataPayment['status']=="phonepe") {
              
              
                $webname=$dataPayment['name']; 
$webemail=$dataPayment['email']; 
$client_id = $dataPayment['merchantId']; 
$client_secret = $dataPayment['apiKey']; 
$demo_link = $dataPayment['demo_link'];
$init_link = $dataPayment['init_link'];
//$mobile=9999999999;
// amount in INR
$description = $dataPayment['description']; 

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $demo_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 
  'client_id='.$client_id.'&client_version=1&client_secret='.$client_secret.'&grant_type=client_credentials',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$jsonResponse = curl_exec($curl);
$response = json_decode($jsonResponse, true);
if (empty($response)) {
    $session = session();
    $session->setFlashdata('msg', 'Server not responding, please try again later.');
    return redirect()->to('Registeration-Event/'.$event_id)->with('error', 'Server not responding, please try again later.');
}

$token = $response['access_token'];
 $order_id = uniqid();
 
 $trans = [
     'transactionId'=>$order_id,
     'payment_status'=>"fail",
     ];
   
 $Emodel = new EventTicketModel();
$transid= $Emodel->update($id, $trans);
 if($transid){
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $init_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "merchantOrderId": "'.$order_id.'",
    "amount": '.$amountF.',
    "expireAfter": 1200,
    "metaInfo": {
        "udf1": "'.$order_id.'",
        "udf2": "additional-information-2",
        "udf3": "additional-information-3",
        "udf4": "additional-information-4",
        "udf5": "additional-information-5"
    },
    "paymentFlow": {
        "type": "PG_CHECKOUT",
        "message": "Payment message used for collect requests",
        "merchantUrls": {
            "redirectUrl": "'.base_url('Event_success_payment').'"
        }
    } 
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$token,
  ),
));

$responseURL = curl_exec($curl);

curl_close($curl);
$response = json_decode($responseURL, true);
if (empty($response['redirectUrl'])) {
   return redirect()->to('Registeration-Event/'.$event_id)->with('error', 'Server not responding, please try again later.');
}

$tokenurl = $response['redirectUrl'];
$session = session();
$sessdata =[
    'transactionId'=>$order_id,
'token_id'=>$token,
];
$session->set($sessdata);
return redirect()->to($tokenurl);
die;
 
//end pay
}

else{
    $session=session();
                $session->set("msg","Server Not Respond Try Now");
                $session->markAsFlashdata('msg');
                return redirect()->to('user_dashboard');
    
}
              
              
              
              
              // error
         
      $webname=$dataPayment['name']; 
$webemail=$dataPayment['email']; 
$client_id = $dataPayment['merchantId']; 
$client_secret = $dataPayment['apiKey']; 
$demo_link = $dataPayment['demo_link'];
$init_link = $dataPayment['init_link'];
//$mobile=9999999999;
// amount in INR
$description = $dataPayment['description']; 
$uniqid = uniqid();
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $demo_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 
  'client_id='.$client_id.'&client_version=1&client_secret='.$client_secret.'&grant_type=client_credentials',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$jsonResponse = curl_exec($curl);
$response = json_decode($jsonResponse, true);
$token = $response['access_token'];

 $trans = [
     'transactionId'=>$uniqid,
     'payment_status'=>"fail",
     ];
     
 
 $Emodel = new EventTicketModel();
$transid= $Emodel->update($id, $trans);
 if($transid){
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $init_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "merchantOrderId": '.$uniqid.',
    "amount": '.$amountF.',
    "expireAfter": 1200,
    "metaInfo": {
        "udf1": '.$uniqid.',
        "udf2": "additional-information-2",
        "udf3": "additional-information-3",
        "udf4": "additional-information-4",
        "udf5": "additional-information-5"
    },
    "paymentFlow": {
        "type": "PG_CHECKOUT",
        "message": "Payment message used for collect requests",
        "merchantUrls": {
            "redirectUrl": "'.base_url('Event_success_payment').'"
        }
    } 
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$token,
  ),
));

$responseURL = curl_exec($curl);
echo $responseURL;
die;
curl_close($curl);
$response = json_decode($responseURL, true);

$tokenurl = $response['redirectUrl'];
$session = session();
$sessdata =[
    'transactionId'=>$order_id,
'token_id'=>$token,
];
$session->set($sessdata);
return redirect()->to($tokenurl);
die;
 
//end pay
}

else{
    $session=session();
                $session->set("msg","Server Not Respond Try Now");
                $session->markAsFlashdata('msg');
                return redirect()->to('user_dashboard');
    
}
}else{
   $session = session();
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $Emodel = new EventTicketModel();
    $user = $Emodel->where('id', $id)->first();
     $Eventmodel = new EventModel();
        $data =   $Eventmodel->where('id',$event_id)->first();
    if(!$user) {
        return redirect()->back()->with('msg', 'Failed to register ticket.');
    }

    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    // Create order
    $orderData = [
        'amount'          => $amount * 100,
        'currency'        => 'INR',
        'receipt'         => $order_id,
        'payment_capture' => 1
    ];

    try {
        $razorpayOrder = $api->order->create($orderData);
        $data = [
            'users'    => $user,
            'event'    => $data,
            'amount'   => $amount,
            'order_id' => $razorpayOrder->id,
            'dataweb'  => $dataweb
        ];
        
        return view('admin_dashboard/payment-ticket-form', $data);
        
    } catch (Exception $e) {
        log_message('error', 'Razorpay Order Creation Error: '.$e->getMessage());
        session()->setFlashdata('error', 'Payment gateway error. Please try again.');
        return redirect()->back();
    }
    
    /*end pay*/
    
}
            
          
            }else{
                $trans = [
    
     'payment_status'=>"captured",
     ];
     
 
 $Emodel = new EventTicketModel();
$transid= $Emodel->update($id, $trans);
             return redirect()->to('event_registeration_receipt_download/'.$id)->with('msg', 'Ticket successfully registered!');    
            }
        } else {
            return redirect()->back()->with('msg', 'Failed to register ticket.');
        }
       
   }
   
   
   public function Eventnresponse(){
       $session = session();
       
        $posted = $this->request->getPost();
   
        if (! isset($posted['status'], $posted['txnid'], $posted['hash'])) {
            return view('payment_error', ['msg' => 'Invalid response from PayU']);
        }
        
            $Emodel = new EventTicketModel();
            $ticketData= $Emodel->where('transactionId', $posted['txnid'])->first();
               $dataid = $ticketData['id'];
               $fee = $posted['amount'];
            $trans_data = [
                "amount" => $posted['amount'],
                "payment_status" => $posted['status'],
               "pay_at" => date('Y-m-d H:i:s'),
               
            ];

            // Save transaction
          $result =   $Emodel->update($dataid, $trans_data);
          if($result){
        return   $this->PaymentEventFeeSendMail($dataid);
       
          }else{
             return view('payment_error', ['msg' => 'Invalid response from PayU']); 
              
          }
       
   }
   private function PaymentEventFeeSendMail($id){
       
    $Emodel = new EventTicketModel();
            $ticketData= $Emodel->where('transactionId', $id)->Orwhere('id', $id)->first();
               $dataid = $ticketData['id'];
               $fee = $ticketData['amount'];
   if($ticketData){
           
                $event_id = $ticketData['event_id'];
            $name     = $ticketData['name'];
            $email    = $ticketData['email'];
            $mobile   = $ticketData['mobile'];
            $event_id = $ticketData['event_id'];
             $Eventmodel = new EventModel();
        $EventData =   $Eventmodel->where('id',$event_id)->first();
            $event_name =$EventData['name'];
            $event_date = $EventData['date'];
            $event_venue = $EventData['venue'];
          }
          
            
                // Send confirmation email
                $dataurl= base_url();
 $downloadurl=base_url('event_registeration_receipt_download/'.$dataid);
                
                try {
        require 'vendor/autoload.php';
        require 'phpmailer/src/PHPMailer.php';
        require 'phpmailer/src/Exception.php';
        require 'phpmailer/src/SMTP.php';
        
        // Get email credentials
         require 'db_config.php';
        $query = "SELECT * FROM `email_credentials` LIMIT 1";
        $result = mysqli_query($connection, $query);
        $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
        
        $mail = new PHPMailer(true);
        
       
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
         $weblogo = base_url('websiteLogoImages/' . $web_data['web_logo']);
        // Server settings
        $mail->SMTPDebug = 0;
        $mail->isSMTP();
                              
    $mail->Host       = $email_data['host'];
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;  
        
        // Recipients
        $mail->setFrom($email_data['by_email'], $email_data['subject']);
        $mail->addAddress($email, $name);
        
        // Content
        $downloadurl = base_url('membership_receipt_download/'.$dataid);
        $mail->isHTML(true);
        $mail->Subject = 'Confirmation of Event Registration and Payment Receipt';

$mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto; 
    border: 5px solid transparent; 
    border-image: linear-gradient(135deg, #36d1dc, #5b86e5); 
    border-image-slice: 1; 
    background: #f9f9f9; 
    border-radius: 15px; 
    overflow: hidden; 
    font-family: Arial, sans-serif; 
    color: #000;'>

    <div style='background-image: url({$weblogo}); 
        background-repeat: no-repeat; 
        background-position: center; 
        background-size: 280px 280px; 
        background-color: #ffffff; 
        padding: 40px; 
        font-family: Arial, sans-serif; 
        color: #000;'>

        <!-- Logo and site name -->
        <div style='text-align: center; margin-bottom: 30px;'>
            <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
            <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
        </div>

        <!-- Main content block -->
        <div style='background-color: rgba(255,255,255,0.9); 
            padding: 30px; 
            border-radius: 10px; 
            box-shadow: 0 0 10px rgba(0,0,0,0.05);'>

            Dear {$name},<br><br>

             Thank you for registering for the <b>{$event_name}</b> organized by <b>{$web_data['web_name']}</b>!<br><br>

            We are pleased to confirm that your registration and payment of 
            <span style='font-weight:600;'>₹{$fee}</span> have been successfully received.<br><br>

             <b>Event Details:</b><br>
            <ul style='margin-top: 10px; margin-bottom: 15px;'>
                <li><b>Event:</b> {$event_name}</li>
                <li><b>Date:</b> {$event_date}</li>
                <li><b>Venue:</b> {$event_venue}</li>
            </ul>

            ️ <span style='font-weight:600;'>Download Ticket / Receipt:</span> 
            <a href='{$downloadurl}' target='_blank' style='color:#007BFF;'>Click Here</a><br><br>

             If you have any questions or need assistance, please contact us at 
            <a href='mailto:{$web_data['webemail_1']}'>{$web_data['webemail_1']}</a> or call  {$web_data['site_mobile_1']}.<br><br>

            We appreciate your participation and look forward to seeing you at the event! <br><br>

            Best regards,<br>
            <a href='https://www.{$site_url}' target='_blank'> www.{$site_url}</a><br>
            {$certificate_provider_name}<br>
            {$designation}<br>
            {$datawebname}
        </div>
    </div>
</div>";


        
        $mail->send();
        
      
 return redirect()->to('event_registeration_receipt_download/'.$dataid);
        
    } catch (\Exception $e) {
      
   
       $session->setFlashdata('msg', '<h1>Congratulations</h1> Payment successfully processed');
       
                return redirect()->to('event_registeration_receipt_download/'.$dataid);
    }
   }
   
    private function generatePayuRequestHash($params, $salt)
{
    $key = $params['key'];
    $txnid = $params['txnid'];
    $amount = $params['amount'];
    $productinfo = $params['productinfo'];
    $firstname = $params['firstname'];
    $email = $params['email'];
    $udf1 = $params['udf1'] ?? '';
    $udf2 = $params['udf2'] ?? '';
    $udf3 = $params['udf3'] ?? '';
    $udf4 = $params['udf4'] ?? '';
    $udf5 = $params['udf5'] ?? '';

    // PayU sequence
    $hashString = $key . '|' . $txnid . '|' . $amount . '|' . $productinfo . '|' .
                  $firstname . '|' . $email . '|' . $udf1 . '|' . $udf2 . '|' .
                  $udf3 . '|' . $udf4 . '|' . $udf5 . '||||||' . $salt;

    // Generate hash (case should be exact)
    return hash('sha512', $hashString);
}



       private function payuUrl()
    {
        return (getenv('PAYU_ENV') === 'production')
            ? 'https://secure.payu.in/_payment'
            : 'https://test.payu.in/_payment';
    }
   
   
    public function Event_success_payment(){
        
         $response=  $this->request->getPost();
        
           $response=  $this->request->getVar();
        $session = session();
$transactionId = $session->get('transactionId');
$tokenId = $session->get('token_id');

$curl = curl_init();
 $paymentsModel=new Payments_Mode_Models();
          $dataPayment=$paymentsModel->first();           
   $paymentMode = $dataPayment['payment_mode'];
if($paymentMode=="test"){
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
// CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
}
else{
    
    curl_setopt_array($curl, array(
//   CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
 CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
    
}


$response = curl_exec($curl);

curl_close($curl);
$responseUrl = json_decode($response, true);
      
             $staff_id = $transactionId;
            
              $amount = $responseUrl['amount']/100;
              
               $trans_status = $responseUrl['state'];
               if($trans_status =="COMPLETED"  or $trans_status =="captured"){
               $staff_id = $this->request->getPost('staff_id');
               $cust_id = $this->request->getPost('cust_id');
               $providerReferenceId = $responseUrl['orderId'];
               $cust_mobile = $this->request->getPost('cust_mobile');
                $userModel = new UserModel();
                
            
            $Emodel = new EventTicketModel();
            $ticketData= $Emodel->where('transactionId', $transactionId)->first();
               $dataid = $ticketData['id'];
            
            $trans_data = [
                "amount" => $amount,
                "payment_status" => $trans_status,
               "pay_at" => date('Y-m-d H:i:s'),
               
            ];

            // Save transaction
          $result =   $Emodel->update($dataid, $trans_data);
          if($result){
            
                $event_id = $ticketData['event_id'];
            $name     = $ticketData['name'];
            $email    = $ticketData['email'];
            $mobile   = $ticketData['mobile'];
            $event_id = $ticketData['event_id'];
             $Eventmodel = new EventModel();
        $EventData =   $Eventmodel->where('id',$event_id)->first();
            $event_name =$EventData['name'];
            $event_date = $EventData['date'];
            $event_venue = $EventData['venue'];
          }
          
            
            return   $this->PaymentEventFeeSendMail($dataid);
                
      
               }else{
                 $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg"); 
                     return redirect()->to('user_dashboard');
               }  
        
        
    }
    public function EventPayment(){
       
        
    // Initialize session and get input
    $session = session();
    $input = $this->request->getPost();
    
    // Validate payment ID
    if (empty($input['razorpay_payment_id'])) {
        $session->setFlashdata('error', 'Payment ID missing');
        return redirect()->back();
    }
 $dataid = $input['user_id'];
 
    // Load database configuration
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    // Initialize Razorpay API
    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    try {
        // Verify payment signature
        $attributes = [
            'razorpay_order_id' => $input['razorpay_order_id'],
            'razorpay_payment_id' => $input['razorpay_payment_id'],
            'razorpay_signature' => $input['razorpay_signature']
        ];
        $api->utility->verifyPaymentSignature($attributes);

        // Process payment
        $payment = $api->payment->fetch($input['razorpay_payment_id']);
        
        // Capture payment if authorized
        if ($payment->status == 'authorized') {
            $payment->capture(['amount' => $payment->amount]);
        }

        // Process successful payment
        if (in_array(strtolower($payment->status), ['captured', 'authorized'])) {
             $dataid = $input['user_id'];
            $Emodel = new EventTicketModel();
            $ticketData= $Emodel->where('id', $dataid)->first();
              
            
            $trans_data = [
                "amount" => $payment->amount / 100,
                "payment_status" => $payment->status,
               "pay_at" => date('Y-m-d H:i:s'),
               
            ];

            // Save transaction
          $result =   $Emodel->update($dataid, $trans_data);
          if($result){
            
                $event_id = $ticketData['event_id'];
            $name     = $ticketData['name'];
            $email    = $ticketData['email'];
            $mobile   = $ticketData['mobile'];
            $event_id = $ticketData['event_id'];
             $Eventmodel = new EventModel();
        $EventData =   $Eventmodel->where('id',$event_id)->first();
            $event_name =$EventData['name'];
            $event_date = $EventData['date'];
            $event_venue = $EventData['venue'];
          }
          
            
                // Send confirmation email
                 return   $this->PaymentEventFeeSendMail($dataid);
                
                 
               
            
        }

    } catch (\Exception $e) {
       
        
        $session->setFlashdata('error', 'Payment failed: '.$e->getMessage());
        return redirect()->back();
    }
        
        
        
        
        
    }
    
    public function event_registeration_receipt_download($id){
       $Emodel = new EventTicketModel();
         $data= $Emodel->where('id', $id)->first(); 
         if($data){
         $event_id = $data['event_id'];
         $word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['created_at'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ];
            $data['payments']= $Emodel->where('id', $id)->first();  
            $Eventmodel = new EventModel();
        $data['event'] =   $Eventmodel->where('id',$event_id)->first();
         return view('admin_dashboard/event_registeration_receipt_download', $data);
         }else{
             $session->setFlashdata('error', 'Data Not Fount');
        return redirect()->back(); 
         }
    }
    
   public function updateeventdata()
{
    helper(['form', 'url']);

    $model = new EventModel();
    $id = $this->request->getPost('id');
    
    // Get the existing event data
    $event = $model->where('id', $id)->first();
    if (!$event) {
        return redirect()->to('Active-Event')->with('error', 'Event not found!');
    }

    // Handle banner upload
    $bannerFile = $this->request->getFile('banner');
    $bannerName = $event['banner']; // Default to existing banner

    if ($bannerFile->isValid() && !$bannerFile->hasMoved()) {
        // Delete old banner if it exists
        if (!empty($event['banner'])) {
            $filePath = FCPATH . 'EventBanners/' . $event['banner'];
            if (file_exists($filePath)) {
                unlink($filePath);
            }
        }
        
        // Upload new banner
        $bannerName = $bannerFile->getRandomName();
        $bannerFile->move('EventBanners/', $bannerName);
    }

    // Prepare data for update
    $data = [
        'name'        => $this->request->getPost('name'),
        'description' => $this->request->getPost('description'),
        'stime'       => $this->request->getPost('stime'),
        'etime'       => $this->request->getPost('etime'),
        'date'        => $this->request->getPost('date'),
        'fee'         => $this->request->getPost('fee'),
        'venue'       => $this->request->getPost('venue'),
        'event_type'  => $this->request->getPost('eventType'),
        'banner'      => $bannerName
    ];

    // Validate data before updating
    $validation = \Config\Services::validation();
    $validation->setRules([
        'name' => 'required|min_length[3]',
        'description' => 'required',
        'date' => 'required|valid_date',
        'fee' => 'required|numeric',
        // Add more validation rules as needed
    ]);

    if (!$validation->run($data)) {
        return redirect()->back()->withInput()->with('msg', $validation->getErrors());
    }

    // Update the event
    try {
        $result = $model->update($id, $data);
        
        if ($result) {
            return redirect()->to('Active-Event')->with('msg', 'The Event Has Been Updated Successfully!');
        } else {
            return redirect()->to('Active-Event')->with('msg', 'Failed to update event!');
        }
    } catch (\Exception $e) {
        return redirect()->to('Active-Event')->with('msg', 'Error: ' . $e->getMessage());
    }
}
    
    
    public function createeventdata(){
        helper(['form', 'url']);

        $model = new EventModel();

        
        $bannerFile = $this->request->getFile('banner');
        $bannerName = '';

        if ($bannerFile->isValid() && !$bannerFile->hasMoved()) {
            $bannerName = $bannerFile->getRandomName();
            $bannerFile->move('EventBanners/', $bannerName);
        }

        $data = [
            'name'        => $this->request->getPost('name'),
            'description' => $this->request->getPost('description'),
            'stime'        => $this->request->getPost('stime'),
            'etime' => $this->request->getPost('etime'),
            'date'        => $this->request->getPost('date'),
            'fee'         => $this->request->getPost('fee'),
            'venue'       => $this->request->getPost('venue'),
            'event_type'  => $this->request->getPost('eventType'),
            'banner'      => $bannerName,
            'status'=>"active",
        ];

      $result =   $model->insert($data);
if($result){
        return redirect()->to('Active-Event')->with('msg', 'The Event Has Been Created Successfully!');
}else{
   return redirect()->to('Active-Event')->with('msg', 'Event Created Fail!');  
}
    }
    
    
   public function  ActiveCardEvent(){
       
       $Evmodel = new EventModel();
    $today = date('Y-m-d');

    $data['event'] = $Evmodel
        ->where('date', $today)
        ->Orwhere('date >', $today)
        ->orderBy('date', 'ASC')
        ->findAll();
     
       return view('Active-Card-Event',$data);
   }
   
   
   
    
     use ResponseTrait;

    public function activeEvents()
    {
        try {
            $model = new EventModel();
            $events = $model->orderBy('id', 'DESC')->findAll();
            
            // Format the events data if needed
            $formattedEvents = array_map(function($event) {
                return [
                    'id' => $event['id'],
                    'name' => $event['name'],
                    'description' => $event['description'],
                    'date' => $event['date'],
                    'venue' => $event['venue'],
                    'start_time' => $event['stime'],
                    'end_time' => $event['etime'],
                    'fee' => $event['fee'],
                    'banner' => base_url('EventBanners/'.$event['banner']),
                    
                ];
            }, $events);

            return $this->respond([
                'status' => 'success',
                'message' => 'Events retrieved successfully',
                'data' => $formattedEvents
            ]);
            
        } catch (\Exception $e) {
            return $this->failServerError('Server error: ' . $e->getMessage());
        }
    }
    
    public function CreateEvent(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Create Event";
    
       
        return view('admin_dashboard/Create-Event', $data);
    }
    
    
    public function CreateInternship(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Create Internship";
    
       
        return view('admin_dashboard/Create-Internship', $data);
    }
    
    public function CreateInternshipData(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    
        if ($this->request->getMethod() === 'post') {
            $model = new InternshipModel();

            $data = [
                'title'         => $this->request->getPost('title'),
                'category'      => $this->request->getPost('category'),
                'type'          => $this->request->getPost('type'),
                'description'   => $this->request->getPost('description'),
                'skills'        => $this->request->getPost('skills'),
                'country'       => $this->request->getPost('country'),
                'state'         => $this->request->getPost('state'),
                'district'      => $this->request->getPost('district'),
                'address'       => $this->request->getPost('address'),
                'start'         => $this->request->getPost('start'),
                'end'           => $this->request->getPost('end'),
                'duration'      => $this->request->getPost('duration'),
                'timing'        => $this->request->getPost('timing'),
                'stipend'       => $this->request->getPost('stipend'),
                'stipendAmount' => $this->request->getPost('stipendAmount'),
                'benefits'      => $this->request->getPost('benefits'),
                'qualification' => $this->request->getPost('qualification'),
                'age'           => $this->request->getPost('age'),
                'language'      => $this->request->getPost('language'),
                'status'=>"Approved",
            ];

            if ($model->insert($data)) {
                return redirect()->to('Active-Internship')->with('msg', 'Internship created successfully.');
            } else {
                return redirect()->back()->withInput()->with('error', 'Something went wrong!');
            }
        }

        return redirect()->to('signin');
    
    
    }
    
    public function UpdateInternshipData(){
        
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    
        if ($this->request->getMethod() === 'post') {
            $id         = $this->request->getPost('id');
            $model = new InternshipModel();

            $data = [
                'title'         => $this->request->getPost('title'),
                'category'      => $this->request->getPost('category'),
                'type'          => $this->request->getPost('type'),
                'description'   => $this->request->getPost('description'),
                'skills'        => $this->request->getPost('skills'),
                'country'       => $this->request->getPost('country'),
                'state'         => $this->request->getPost('state'),
                'district'      => $this->request->getPost('district'),
                'address'       => $this->request->getPost('address'),
                'start'         => $this->request->getPost('start'),
                'end'           => $this->request->getPost('end'),
                'duration'      => $this->request->getPost('duration'),
                'timing'        => $this->request->getPost('timing'),
                'stipend'       => $this->request->getPost('stipend'),
                'stipendAmount' => $this->request->getPost('stipendAmount'),
                'benefits'      => $this->request->getPost('benefits'),
                'qualification' => $this->request->getPost('qualification'),
                'age'           => $this->request->getPost('age'),
                'language'      => $this->request->getPost('language'),
               
            ];

            if ($model->update($id, $data)) {
                return redirect()->to('Active-Internship')->with('msg', 'Internship Update successfully.');
            } else {
                return redirect()->back()->withInput()->with('error', 'Something went wrong!');
            }
        }

        return redirect()->to('signin');
        
        
    }
    
    public function InternshipEdit($id){
        
         $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Update Internship";
      $model = new InternshipModel();
        $data['intern'] =   $model->where('id', $id)->first();
        return view('admin_dashboard/Internship-Edit', $data);
        
        
    }
    public function ActiveInternship(){
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Active Internship";
      $model = new InternshipModel();
        $data['intern'] =   $model->where('status', "Approved")->orderBy('id','DESC')->findAll();
        return view('admin_dashboard/Active-Internship', $data);
    }
    
    public function ActiveCardInternship(){
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

  
    $data['heading'] ="Active Internship";
      $model = new InternshipModel();
        $data['intern'] =   $model->where('status', "Approved")->orderBy('id','DESC')->findAll();
        return view('Front/Active-Card-Internship', $data);
    }
    
    
     use ResponseTrait;

   public function ActiveEvent(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Active Event";
    
         $Evmodel = new EventModel();
    $today = date('Y-m-d');

    
    $data['upcoming_events'] = $Evmodel
        ->where('date >', $today)
        ->orderBy('id', 'ASC')
        ->findAll();

    
    $data['event'] = $Evmodel
        ->where('date', $today)
         ->Orwhere('date >', $today)
        ->orderBy('date', 'ASC')
        ->findAll();
        
        
        return view('admin_dashboard/Active-Event', $data);
    }
    
     public function CompleteEvent(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
  
  
         $Evmodel = new EventModel();
    $today = date('Y-m-d');

     $data['heading'] ="Complete Event";
    $data['event'] = $Evmodel
        ->where('date <', $today)
        ->orderBy('date', 'ASC')
        ->findAll();
        
        
        return view('admin_dashboard/Active-Event', $data);
    }
    
    
    public function InternshipDetails($id){
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Internship Details";
    
        $Emodel = new InternshipModel();
        $data['internship'] =   $Emodel->where('id',$id)->first();
      
        return view('admin_dashboard/Internship-Details', $data);
    }
    
    public function EventDetails($id){
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Event Details";
    
        $Emodel = new EventModel();
        $data['event'] =   $Emodel->where('id',$id)->first();
       
        return view('admin_dashboard/Event-Details', $data);
    }
    
    
        public function InternshipDelete($id){
        
     $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Internship Details";
    
        $Emodel = new InternshipModel();
       $result =   $Emodel->delete($id);
if($result){
        return redirect()->back()->with('msg', 'Internship Delete Successfully!');
}else{
   return redirect()->back()->with('errors', 'Internship Delete Fail!');  
} 
    }
    
    public function delete_active_internship(){
        
      
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $ids = $this->request->getPost('selectedUsers'); // array of IDs

        if (!empty($ids) && is_array($ids)) {
            $Intmodel = new InternshipModel();

            // Bulk delete
            $result = $Intmodel->whereIn('id', $ids)->delete();
if($result){
        return redirect()->back()->with('msg', 'Internship Delete Successfully!');
}else{
   return redirect()->back()->with('errors', 'Internship Delete Fail!');  
} 
}
        
    }
    public function EventDelete($id){
        
     $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Event Details";
    
        $Emodel = new EventModel();
       $result =   $Emodel->delete($id);
if($result){
        return redirect()->to('Active-Event')->with('msg', 'The Event Has Been Deleted Successfully!');
}else{
   return redirect()->to('Active-Event')->with('msg', 'Event Delete Fail!');  
} 
    }
    public function EventEdit($id){
     $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Event Details";
    
        $Emodel = new EventModel();
        $data['event'] =   $Emodel->where('id',$id)->first();
       
        return view('admin_dashboard/Event-Edit', $data);   
        
    }
    
public function RegisterationEvent($id){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();


    $data['heading'] ="Registeration-Event";
    $Emodel = new EventModel();
        $data['event'] =   $Emodel->where('id',$id)->first();
       
        return view('admin_dashboard/Registeration-Event', $data);
    }
    
      public function RegisterateredEvent(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Registeratered Event";
   $Emodel = new EventTicketModel();
$data['users'] = $Emodel
    ->whereIn('payment_status', ['success','captured','COMPLETED'])
    ->orderBy('id', 'DESC')
    ->findAll();

       
        return view('admin_dashboard/Registeratered-Event', $data);
    }
    
     public function EventJoinUser($id){
         
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Registeratered Event";
    $Emodel = new EventTicketModel();
            $data['users']= $Emodel->orderBy('id', 'DESC')->where('event_id', $id)->findAll();
       
        return view('admin_dashboard/Registeratered-Event', $data);
        
    }
    public function event_tickets_edit($id){
      $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    
     $Emodel = new EventTicketModel();
            $dataE = $Emodel->where('id', $id)->first();
           if (!$dataE) {
        return redirect()->back()->with('msg' , 'This Event Already Deleted');
    }
    
    $data['heading'] ="Registeratered Event";
    $Emodel = new EventTicketModel();
            $data['user']= $Emodel->where('id', $id)->first();
       
        return view('admin_dashboard/event_tickets_edit', $data);  
        
    }
    public function event_tickets_delete($id){
      
       $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Registeratered Event";
    $Emodel = new EventTicketModel();
            $result= $Emodel->delete($id);
       
     if ($result) {
    return redirect()->back()->with('msg', 'Event registration application deleted successfully!');
} else {
    return redirect()->back()->with('msg', 'Failed to delete event registration application!');
}

        
    }
    public function event_tickets_details($id){
     $data['heading'] ="Registeratered Event";
    $Etmodel = new EventTicketModel();
    $data= $Etmodel->where('id', $id)->first();
    if($data){
    $event_id = $data['event_id'];
    $Emodel = new EventModel();
        $data['event'] =   $Emodel->where('id',$event_id)->first();
    
            $data['users']= $Etmodel->where('id', $id)->first();
      
        return view('admin_dashboard/event_tickets_details', $data);  
    }else{
        return redirect()->back();
    }
        
    }
    public function referral_donation_details($id){
        
          $DonateModel = new Donote_TransactionModel();
$data = $DonateModel->where('id', $id)->first();
$referralId = $data['referralId'];

         $model = new UserModel();
    $data['users'] = $model->where('id', $referralId)->first();
         $DonateModel = new Donote_TransactionModel();
$data['doner'] = $DonateModel->where('id', $id)->first();

        return view('admin_dashboard/referral_donation_details', $data);   
    }
    
    public function admin_referral_donation() {
    $session = session();
    $userModel = new UserModel();

    // Validate admin access
    $admin = $userModel->find($session->id);
    if (!$admin || $admin['user_type'] !== 'admin') {
        return view('signin', ['msg' => 'Unauthorized Access!']);
    }

    $db = \Config\Database::connect();
    $builder = $db->table('users');
    $builder->select('users.*, donate_transactions.*');
    $builder->join('donate_transactions', 'donate_transactions.referralId = users.id');
    $builder->whereIn('donate_transactions.payment_status', ['captured', 'PAYMENT_SUCCESS','success','COMPLETED']);

    $donations = $builder->get()->getResultArray();

    // Get total donation amount from referral donations
    $donateModel = new Donote_TransactionModel();
    $totalDonation = $donateModel
        ->where('referralId IS NOT NULL') // Optional: filter only referrals
        ->whereIn('payment_status', ['captured', 'PAYMENT_SUCCESS','success','COMPLETED'])
        ->selectSum('amount')
        ->first()['amount'] ?? 0;

    $data = [
        'heading'        => 'Referral Donation',
        'TotalDonation'  => $totalDonation,
        'doner'          => $donations,
    ];

    

    return view('admin_dashboard/adminReferralDonation', $data);
}

    
     public function InactiveReferralAdmin(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="Inactive Referral ";
    $userModel = new UserModel();
        $data['users'] = $userModel->where('referralId !=','direct')->where('status', 'inactive')->findAll();
       
        return view('admin_dashboard/ReferralDataAdmin', $data);
    }
    public function admin_refferal_data($id){
        
          $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] =" Referral ";
    $userModel = new UserModel();
     $data['member'] = $userModel->where('id',$id)->first();
        $data['users'] = $userModel->where('referralId =',$id)->findAll();
       
        return view('admin_dashboard/ReferralDataAdmin', $data);
    }
    
    // For single deletion
public function delete_doner() {
    $session = session();
    $userModel = new UserModel();
    $user = $userModel->where('id', $session->id)->first();

    if (!$user || $user['user_type'] != "admin") {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Unauthorized Access!'
        ]);
    }

    $id = $this->request->getPost('id');
    if (!$id) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'No ID provided'
        ]);
    }

    $donateModel = new Donote_TransactionModel();
    try {
        $donateModel->delete($id);
        return $this->response->setJSON([
            'success' => true,
            'message' => 'Record deleted successfully'
        ]);
    } catch (\Exception $e) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Failed to delete record: ' . $e->getMessage()
        ]);
    }
}

// For multiple deletions
public function delete_multiple_doners() {
    $session = session();
    $userModel = new UserModel();
    $user = $userModel->where('id', $session->id)->first();

    if (!$user || $user['user_type'] != "admin") {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Unauthorized Access!'
        ]);
    }

    $ids = $this->request->getPost('ids');
    if (empty($ids)) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'No records selected'
        ]);
    }

    $donateModel = new Donote_TransactionModel();
    try {
        $donateModel->whereIn('id', $ids)->delete();
        return $this->response->setJSON([
            'success' => true,
            'message' => 'Selected records deleted successfully'
        ]);
    } catch (\Exception $e) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Failed to delete records: ' . $e->getMessage()
        ]);
    }
}
  public function coming_expire_member()
{
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin');
    }

    $data['users'] = $data;

     
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }
    $data['heading'] ="Comming Soon 1 Months After Expire  Members Accounts";
    $startDate = date('Y-m-d', strtotime('-12 months')); 
    $endDate   = date('Y-m-d', strtotime('-11 months')); 

   
    $data['comming_expire_data'] = $model->where('status', 'active')
        ->where('verifie_date >=', $startDate)
        ->where('verifie_date <=', $endDate)
        ->findAll();

    return view('admin_dashboard/expire_member', $data);
}

   public function expire_member()
{
    $session = session();
    $model = new UserModel();
 $data = $model->where('id', $session->id)->first();
    if (!$data || $data['user_type'] != "admin") {
        return view('signin');
    }

    $data['heading'] = "Expire Members Accounts";
    $data['users'] = $data;

   
    $today = date('Y-m-d');

  
    $expiredUsers = $model->where('status', 'active')
                          ->where('verifie_date <=', date('Y-m-d', strtotime('-1 year')))
                          ->findAll();

    if (!empty($expiredUsers)) {
        foreach ($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }

   
    $data['comming_expire_data'] = $model->where('status', 'inactive')
                                         ->where('expire_date <', $today)
                                         ->findAll();

    return view('admin_dashboard/expire_member', $data);
}

      public function Expence_Form()
    {  
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
             if($data['user_type']=="admin"){
        $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/Expence_Form',$data);
         
         }else{
             return view('signin');
         }
         }
         else{
             return view('signin');
         }
    }
    
    
    
          public function edit_expenseId($id)
    {  
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
             if($data['user_type']=="admin"){
        $data['users'] = $model->where('id', $session->id)->first();
         $Expensemodel = new ExpenseModel();
         $data['expense'] = $Expensemodel->where('id', $id)->first();
        return view('admin_dashboard/edit_expenseId',$data);
         
         }else{
             return view('signin');
         }
         }
         else{
             return view('signin');
         }
    }
    
    public function expense_update()
    {
        if ($this->request->getMethod() === 'post') {
            $model = new ExpenseModel();

            $id = $this->request->getPost('id');

            $data = [
                'user_id'      => $this->request->getPost('user_id'),
                'name'         => $this->request->getPost('name'),
                'amount'       => $this->request->getPost('amount'),
                'productName'  => $this->request->getPost('productName'),
                'expense_category'=> $this->request->getPost('expense_category'),
                'paid_to'=> $this->request->getPost('paid_to'),
                'payment_mode'=> $this->request->getPost('payment_mode'),
                'project_name'=> $this->request->getPost('project_name'),
                'description'  => $this->request->getPost('description'),
                'expense_date' => $this->request->getPost('expense_date'),
            ];

            $model->update($id, $data);

            return redirect()->to(base_url('expense_list'))->with('msg', 'Expense updated successfully!');
        }
    }
    public function expense_report_download(){
        $session = session();
        $model=new UserModel();
         $Expensemodel = new ExpenseModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
            $ExpData = $Expensemodel->orderBy('id', 'DESC')->findAll();
                  $totalExpense =0;
                  foreach($ExpData as $AmountData){
                      $totalExpense += $AmountData['amount'];
                  }
                  $data['totalExpense'] =$totalExpense;
        $data['users'] = $model->where('id', $session->id)->first();
        
          $data['expence'] = $Expensemodel->orderBy('id', 'DESC')->findAll();
        
        $mpdf = new \Mpdf\Mpdf();
		$html = view('admin_dashboard/expense_report_download',$data);
		$mpdf->WriteHTML($html);
		$this->response->setHeader('Content-Type', 'application/pdf');
		$mpdf->Output('Expense Report.pdf','D');
     // return view('admin_dashboard/expense_report_download',$data);
        }
        else {
            return view('404error'); 
            
        }
    
        
    }
     public function expense_list()
    {  
        $session = session();
        $model=new UserModel();
         $Expensemodel = new ExpenseModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
             if($data['user_type']=="admin"){
                 
                  $ExpData = $Expensemodel->orderBy('id', 'DESC')->findAll();
                  $totalExpense =0;
                  foreach($ExpData as $AmountData){
                      $totalExpense += $AmountData['amount'];
                  }
                  $data['totalExpense'] =$totalExpense;
        $data['users'] = $model->where('id', $session->id)->first();
        
          $data['expence'] = $Expensemodel->orderBy('id', 'DESC')->findAll();
        return view('admin_dashboard/expense_view',$data);
         
         }else{
             return view('signin');
         }
         }
         else{
             return view('signin');
         }
    }
    public function search_filture_expense(){
        
         $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
       
           $Expensemodel = new ExpenseModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
       
      
        // Pass the data to your view
      if($data){
          
            $ExpData = $Expensemodel->getDataByDateRange($startDate, $endDate);
                  $totalExpense =0;
                  foreach($ExpData as $AmountData){
                      $totalExpense += $AmountData['amount'];
                  }
                  $data['totalExpense'] =$totalExpense;
           $data['user'] = $model->where('id', $session->id)->first();
           
           $data['expence'] = $Expensemodel->getDataByDateRange($startDate, $endDate);
        return view('admin_dashboard/expense_view',$data);  
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
         }else{
                     
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->back()  ; 
         }
       
    }
    
      public function delete_expense() {
           $session = session();
        $model=new UserModel();
         $Expensemodel = new ExpenseModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
             if($data['user_type']=="admin"){
    $Expensemodel = new ExpenseModel();
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No users selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $Expensemodel->whereIn('id', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' Expense(s)', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No users were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'User deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting users. Please try again later.')
            ->with('msg_type', 'danger');
    }
             }else{
             return view('signin');
         }
         }
         else{
             return view('signin');
         }
}
   
    
public function birthdayMessage()
{
    // Verify AJAX request
    if (!$this->request->isAJAX()) {
        return $this->response->setStatusCode(405)->setJSON([
            'success' => false,
            'error' => 'Method not allowed',
            'data' => null
        ]);
    }

    try {
        // Get and validate input
        $input = $this->request->getJSON(true);
        $validation = service('validation');
        $validation->setRules([
            'subject' => 'required|max_length[255]',
            'message' => 'required'
        ]);

        if (!$validation->run($input)) {
            throw new Exception(implode(' ', $validation->getErrors()));
        }

        // Prepare data
        $data = [
            'subject' => trim($input['subject']),
            'message' => trim($input['message']),
            
        ];

        // Insert data
        $BirthdayMessageModel = new BirthdayMessageModel();
        if (!$BirthdayMessageModel->insert($data)) {
            throw new Exception('Database error: ' . print_r($BirthdayMessageModel->errors(), true));
        }

        return $this->response->setJSON([
            'success' => true,
            'message' => 'Birthday message saved!',
            'data' => [
                'id' => $BirthdayMessageModel->getInsertID(),
                'saved_data' => $data,
                'redirect_url' => base_url('success-page') // Optional redirect
            ]
        ]);

    } catch (Exception $e) {
        log_message('error', 'Birthday message error: ' . $e->getMessage());
        return $this->response->setStatusCode(400)->setJSON([
            'success' => false,
            'error' => $e->getMessage(),
            'validation_errors' => $validation->getErrors() ?? null,
            'input_data' => $input ?? null
        ]);
    }
}
    public function view_expense_details($id){
    
     $Expensemodel = new ExpenseModel();
     $data['users'] = $Expensemodel->where('id', $id)->first();
     return view('admin_dashboard/view_expense_details',$data);
    }
      
            
       public function delete_expenseId($id){
           
            
        if (!$this->request->isAJAX()) {
            return $this->failForbidden('Direct access not allowed');
        }
        
        
        $Expensemodel = new \App\Models\ExpenseModel();
        
        
        if ($Expensemodel->delete($id)) {
            return $this->respond([
                'success' => true,
                'message' => 'Expense deleted successfully'
            ]);
        } else {
            return $this->respond([
                'success' => false,
                'message' => 'Failed to delete Expense'
            ], 400);
        }
    
     }
    
    public function expense_create()
    {
        // Handle form POST
        if ($this->request->getMethod() === 'post') {
            
            $model = new ExpenseModel();

            $data = [
                'user_id'      => $this->request->getPost('user_id'),
                'name'         => $this->request->getPost('name'),
                'amount'       => $this->request->getPost('amount'),
                'productName'  => $this->request->getPost('productName'),
                'expense_category'=> $this->request->getPost('expense_category'),
                'paid_to'=> $this->request->getPost('paid_to'),
                'payment_mode'=> $this->request->getPost('payment_mode'),
                'project_name'=> $this->request->getPost('project_name'),
                
                'description'  => $this->request->getPost('description'),
                'expense_date' => $this->request->getPost('expense_date'),
            ];
            
            $ReceiptImage = $this->request->getFile('receiptImage');
            if(is_file($ReceiptImage)){
                $fileName = $ReceiptImage->getName();
                $fileArray = explode(".",$fileName);
                $newFileName = time().".".end($fileArray);
                if($ReceiptImage->move("ReceiptImage", $newFileName)){
                    $data['receiptImage']=$newFileName;
                }
                
            }

            $model->insert($data);

            return redirect()->to(base_url('expense_list'))->with('success', 'Expense saved successfully!');
        }

        // Load form view
         return redirect()->to(base_url('Expence_Form'))->with('success', 'Expense saved Failed!');
    }


    public function list()
    {
        $model = new ExpenseModel();
        $data['expenses'] = $model->orderBy('expense_date', 'DESC')->findAll();

        return view('expense/list', $data);
    }

    
      public function Income_Form()
    {  
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
             if($data['user_type']=="admin"){
        $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/Income_Form',$data);
         
         }else{
             return view('signin');
         }
         }
         else{
             return view('signin');
         }
    }
    
     
     public function admin_payment_update_data_razorpay_process(){
        
        $data= $this->request->getPost();
         $admin_id= $this->request->getPost('id');
       $payment_website_name= $this->request->getPost('payment_website_name');
       $email= $this->request->getPost('email');
       $mobile= $this->request->getPost('mobile');
        $description= $this->request->getPost('description');
       $merchantId= $this->request->getPost('merchantId');
       $apiKey= $this->request->getPost('apiKey');
       $demo_link= $this->request->getPost('demo_link');
       $web_tag_line = $this->request->getPost('web_tag_line');
       
      
       
       $data=[
           'admin_id'=>$admin_id,
           'name'=>$payment_website_name,
           'email'=>$email,
           'mobile'=>$email,
           'description'=>$description,
           'merchantId'=>$merchantId,
           'apiKey'=>$apiKey,
           'demo_link'=>$demo_link,
           'web_tag_line'=>$web_tag_line,
           'create_at'=> date('Y-m-d H:i:s'),
           
           ];
           
           $session = session();
               
                        require 'db_config.php';
                         $queryli = "SELECT * FROM `website_razor_transaction`";
                         $result = mysqli_query($connection, $queryli);
                         $payments = mysqli_fetch_all($result, MYSQLI_ASSOC);
                         
                        
                      if($payments){
           
         $paymentsModel=new Payments_Razor_Mode_Model();
       
        $result = $paymentsModel->where(["admin_id" =>$admin_id])
                   ->set($data)
                   ->update();
         
          $session=session();
            $session->set("msg","Website Transaction Mode Update Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                      }
                      else{
                           echo "check save";
                           $paymentsModel = new Payments_Razor_Mode_Model();
         $result = $paymentsModel->save($data);
         
          $session=session();
            $session->set("msg","Website Transaction Mode Save Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                          
                      }
           
    }
    
    
    
     public function delete_news_Bulk() {
         
           $session = session();
    $model = new UserModel();
 $data = $model->where('id', $session->id)->first();
    if (!$data || $data['user_type'] != "admin") {
        return view('signin');
    }
         
    $Nmodel = new NewsModel();
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No News selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $Nmodel->whereIn('id', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' News(s)', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No News were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'News deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting News. Please try again later.')
            ->with('msg_type', 'danger');
    }
}
    
    
    public function delete_users() {
    $model = new UserModel();
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No users selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $model->whereIn('id', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' user(s)', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No users were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'User deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting users. Please try again later.')
            ->with('msg_type', 'danger');
    }
}


public function delete_campaign_data() {
    $Cmodel = new CampaignModel();
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No Campaign selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $Cmodel->whereIn('id', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' Campaign(s)', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No Campaign were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'Campaign deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting Campaign. Please try again later.')
            ->with('msg_type', 'danger');
    }
}






    
public function updateStatus()
    {
       
        $model=new UserModel();
         $data = $model->where('user_type', "admin")->first();
     $id = $this->request->getPost('id'); 
    
      $status = $this->request->getPost('status'); 
  
    if(!empty($id)){
    if($status == "active") {
        
        $action = 'inactive';
    }
    else{
        $action = 'active';
        }
    $data = [
           "status" => $action,
           
    ];
    
    
    /*$updateStatus = $this->model->update("users",["user_id =>$user_id"], $data);*/
    $paymentsModel = new Payments_Mode_Models();
    $result = $paymentsModel->update($id, $data);
            
                   
    if($result == TRUE){

        $session=session();
        $session->set("msg","Payment Mode Change");
        $session->markAsFlashdata("msg");
        
        return redirect()->to('admin_payment_update_data');
       
    }
    else{
         
        $session=session();
        $session->set("msg","Payment Mode Not Update");
        $session->markAsFlashdata("msg");
        
        return redirect()->to('admin_payment_update_data');
    }
}
    else{
        $session=session();
        $session->set("msg","No Record Found ");
        $session->markAsFlashdata("msg");
            return redirect()->to('admin_payment_update_data');
    }
       
    }
public function verifyUser()
{
    $session = session();
    $userModel = new UserModel();
// echo "<pre>";
// print_r($this->request->getPost());
// die;
    // POST Inputs
    $id            = $this->request->getPost('user_id');
    $status        = $this->request->getPost('status');

    $zone_id       = $this->request->getPost('zone_id');
    $state_id      = $this->request->getPost('state_id');
    $district_id   = $this->request->getPost('district_id');
    $block_id      = $this->request->getPost('block_id');
    $panchayat_id  = $this->request->getPost('panchayat_id');

    if (empty($id)) {
        $session->setFlashdata("msg", "No Record Found");
        return redirect()->back();
    }

    
    if (!empty($zone_id)) {

        if (empty($state_id)) {
            $session->setFlashdata("msg", "Please select State");
            return redirect()->back();
        }

        if (!empty($state_id) && empty($district_id)) {
            $session->setFlashdata("msg", "Please select District");
            return redirect()->back();
        }

        if (!empty($district_id) && empty($block_id)) {
            $session->setFlashdata("msg", "Please select Block");
            return redirect()->back();
        }

        if (!empty($block_id) && empty($panchayat_id)) {
            $session->setFlashdata("msg", "Please select Panchayat");
            return redirect()->back();
        }
    }


    $exist = $userModel
        ->where('zone_id', $zone_id)
        ->where('state_id', $state_id)
        ->where('district_id', $district_id)
        ->where('block_id', $block_id)
        ->where('panchayat_id', $panchayat_id)
        ->where('id !=', $id) 
        ->first();

    if ($exist) {
        $session->setFlashdata("msg", "This Location Coordinator Already Assigned to Another User!");
        return redirect()->back();
    }

 
    $user = $userModel->where('id', $id)->first();
    if (!$user) {
        $session->setFlashdata("msg", "User Not Found!");
        return redirect()->back();
    }

    // Toggle Status
    $newStatus = ($status == "active") ? "inactive" : "active";

   
    $updateData = [
        "status"       => $newStatus,
        "zone_id"      => $zone_id,
        "state_id"     => $state_id,
        "district_id"  => $district_id,
        "block_id"     => $block_id,
        "panchayat_id" => $panchayat_id,
        "verifie_date" => date('Y-m-d'),
        "expire_date"  => date('Y-m-d', strtotime('+1 year')),
        "verifie_by"   => 'admin'
    ];
// echo "<pre>";
// print_r($updateData);
// die;
    $update = $userModel->update($id, $updateData);

    if ($update) {

        // SEND EMAIL
        $this->VerifySendMail($id);

        $session->setFlashdata("msg", "User Verified + Location Updated + Email Sent");
        return redirect()->back();
    } else {

        $session->setFlashdata("msg", "Update Failed");
        return redirect()->back();
    }
}



private function VerifySendMail($userId)
{
    // MODELS
    $userModel  = new UserModel();
    $ZoneModel  = new ZoneModel();
    $StateModel = new StateModel();
    $DistrictModel = new DistrictModel();
    $BlockModel = new BlockModel();
    $PanchayatsModel = new PanchayatModel();

    // USER DATA
    $user = $userModel->where('id', $userId)->first();
    if (!$user) return false;

    $email  = $user['email'];
    $name   = $user['name'];
    $mobile = $user['mobile'];

    // LOCATION ID GET
    $zone_id      = $user['zone_id'];
    $state_id     = $user['state_id'];
    $district_id  = $user['district_id'];
    $block_id     = $user['block_id'];
    $panchayat_id = $user['panchayat_id'];

    // LOCATION NAME OR “Not Assigned”
    $zoneName      = $zone_id      ? $ZoneModel->find($zone_id)['name'] : "Not Assigned";
    $stateName     = $state_id     ? $StateModel->find($state_id)['name'] : "Not Assigned";
    $districtName  = $district_id  ? $DistrictModel->find($district_id)['name'] : "Not Assigned";
    $blockName     = $block_id     ? $BlockModel->find($block_id)['name'] : "Not Assigned";
    $panchayatName = $panchayat_id ? $PanchayatsModel->find($panchayat_id)['name'] : "Not Assigned";

    // SMTP SETTINGS FROM DB
    require 'db_config.php';

    $email_q = mysqli_query($connection, "SELECT * FROM email_credentials");
    $email_data = mysqli_fetch_array($email_q, MYSQLI_ASSOC);

    $web_q = mysqli_query($connection, "SELECT * FROM admin_website_update");
    $web = mysqli_fetch_array($web_q, MYSQLI_ASSOC);

    $webName    = $web['web_name'];
    $webLogo    = base_url('websiteLogoImages/' . $web['web_logo']);
    $adminEmail = $web['webemail_1'];

   require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
    require 'vendor/autoload.php';
   $mail = new PHPMailer(true);

    try {

        // SMTP CONFIG
        $mail->isSMTP();
        $mail->Host       = $email_data['host'];
        $mail->SMTPAuth   = true;
        $mail->Username   = $email_data['by_email'];
        $mail->Password   = $email_data['by_password'];
        $mail->Port       = 587;
        $mail->SMTPSecure = 'tls';

        // USER MAIL
        $mail->setFrom($email_data['by_email'], $webName);
        $mail->addAddress($email, $name);
        $mail->isHTML(true);
        $mail->Subject = "Your Account Verification – {$webName}";

        // Beautiful HTML template
        $mail->Body = "
        <div style='background:#f4f4f4; padding:25px; font-family:Arial;'>
            <div style='max-width:650px; margin:auto; background:white; padding:30px; border-radius:10px;
                box-shadow:0 4px 12px rgba(0,0,0,0.1);'>

                <center>
                    <img src='{$webLogo}' width='90'>
                    <h2 style='margin-top:10px; color:#333;'>{$webName}</h2>
                </center>

                <p style='font-size:16px; color:#444;'>Dear <b>{$name}</b>,</p>
                <p style='font-size:15px; color:#444;'>
                    Your account has been successfully <b>verified</b> by the Admin.
                </p>

                <h3 style='color:#222; margin-top:25px;'>Assigned Location Details</h3>

                <table style='width:100%; font-size:14px; border-collapse:collapse;'>
                    <tr><td><b>Zone:</b></td><td>{$zoneName}</td></tr>
                    <tr><td><b>State:</b></td><td>{$stateName}</td></tr>
                    <tr><td><b>District:</b></td><td>{$districtName}</td></tr>
                    <tr><td><b>Block:</b></td><td>{$blockName}</td></tr>
                    <tr><td><b>Panchayat:</b></td><td>{$panchayatName}</td></tr>
                </table>

                <br>
                <p style='font-size:15px; color:#555;'>
                    If you have any questions, feel free to contact us.
                </p>

                <p style='font-size:14px; color:#888; text-align:center; margin-top:30px;'>
                    Thank you for being with us.<br>
                    <b>{$webName}</b>
                </p>
            </div>
        </div>";

        $mail->send();

        // ---------------------------------
        // SEND MAIL TO ADMIN
        // ---------------------------------
        $mailAdmin = new PHPMailer(true);

        $mailAdmin->isSMTP();
        $mailAdmin->Host = $email_data['host'];
        $mailAdmin->SMTPAuth = true;
        $mailAdmin->Username = $email_data['by_email'];
        $mailAdmin->Password = $email_data['by_password'];
        $mailAdmin->SMTPSecure = 'tls';
        $mailAdmin->Port = 587;

        $mailAdmin->setFrom($email_data['by_email'], $webName);
        $mailAdmin->addAddress($adminEmail);
        $mailAdmin->isHTML(true);

        $mailAdmin->Subject = "User Verified – {$name}";

        $mailAdmin->Body = "
        <div style='background:#fff; padding:20px; font-family:Arial;'>
            <h3>User Verification Notification</h3>
            <b>Name:</b> {$name}<br>
            <b>Email:</b> {$email}<br>
            <b>Mobile:</b> {$mobile}<br><br>

            <b>Assigned Location:</b><br>
            Zone: {$zoneName}<br>
            State: {$stateName}<br>
            District: {$districtName}<br>
            Block: {$blockName}<br>
            Panchayat: {$panchayatName}<br><br>
        </div>";

        $mailAdmin->send();

        return true;

    } catch (Exception $e) {
        return false;
    }
}


  public function admin_payment_update_data()
    {  
         $session = session();
    $model = new UserModel();
 $data = $model->where('id', $session->id)->first();
    if (!$data || $data['user_type'] != "admin") {
        return view('signin');
    }
        
         $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
             
             $paymentsModel=new Payments_Mode_Models();
          $data['dataPayment']=$paymentsModel->first(); 
            $paymentsModel=new Payments_Mode_Models();
          $data['phonepe']=$paymentsModel->first(); 
           $payuModel=new Payments_Payu_Mode_Model();
          $data['payu']=$payuModel->first(); 
           $razorModel=new Payments_Razor_Mode_Model();
          $data['razor']=$razorModel->first(); 
        $data['users'] = $model->where('id', $session->id)->first();
       
        return view('admin_dashboard/admin_payment_update_data',$data);
         }
         else{
             return view('signin');
         }
    }
    
    public function campaign_donate_edit($trans_id){
         $trans= new DonateCampaignModel();
       $data = $trans->where('transaction_id', $trans_id)
              ->orWhere('id', $trans_id)
              ->first();
        $CampModel = new CampaignModel();
     $data['campaign'] = $CampModel->where('id', $data['campaign_id'])->first();
      $trans= new DonateCampaignModel();
       $data['donation'] = $trans->where('transaction_id', $trans_id)
              ->orWhere('id', $trans_id)
              ->first();
              
         return view('admin_dashboard/Campaign-Donate-Update-Form',$data);
    }
    

      public function DonoateCampaignDataUpdate(){
        
    $id=    $this->request->getPost('id');
     
       
        $name= $this->request->getVar('name');
         $email= $this->request->getVar('email');
        $mobile= $this->request->getVar('mobile');
        $amount=$this->request->getVar('amount');
         $address=$this->request->getVar('address');
        $DonationPurpose=$this->request->getPost('DonationPurpose');
          $bank_name=$this->request->getVar('bank_name');
         $branch_name=$this->request->getVar('branch_name');
          $pan_no =$this->request->getVar('pan_no');
          $Dmodel = new DonateCampaignModel();

        $data = [
           
            'name'             => $this->request->getPost('name'),
            'email'            => $this->request->getPost('email'),
            'mobile'           => $this->request->getPost('mobile'),
            'amount'           => $this->request->getPost('amount'),
            'donation_purpose' => $this->request->getPost('DonationPurpose'),
            'bank_name'=>$this->request->getVar('bank_name'),
            'branch_name'=>$this->request->getVar('branch_name'),
            'pan_no' =>$this->request->getVar('pan_no'),
            'address'          => $this->request->getPost('address'),
            
        ];

       $success = $Dmodel->update($id, $data);
       if($success){
          $session=session();
            $session->set("msg","The Donor Details Have Been Updated Successfully!");
            $session->markAsFlashdata("msg");
            return redirect()->to('Donation');
       }else{
           return redirect()->back()->with('msg', 'The Donor Details Have Been Updated Successfully!')->withInput(); 
       }
      }
      public function campaign_donate_delete($id){
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data && $session->user_type =="admin"){
             $Dmodel = new DonateCampaignModel();
          $result =$Dmodel->delete($id); 
         if($result){
          $session=session();
            $session->set("msg","The Donor Receipt Has Been Deleted Successfully!");
            $session->markAsFlashdata("msg");
            return redirect()->back();
       }else{
           return redirect()->back()->with('msg', 'Donation Details Delete Fail')->withInput(); 
       }
         }
         else{
             return view('signin');
         }   
          
          
      }
      
      
      
     public function delete_campaignDonation_data()
{
    $session = session();
    $model = new UserModel();

    $data = $model->where('id', $session->id)->first();

    if ($data && $session->user_type == "admin") {
        $ids = $this->request->getPost('selectedUsers'); // array of IDs

        if (!empty($ids) && is_array($ids)) {
            $Dmodel = new DonateCampaignModel();

            // Bulk delete
            $result = $Dmodel->whereIn('id', $ids)->delete();

            if ($result) {
                $session->set("msg", "The selected donor receipts have been deleted successfully!");
                $session->markAsFlashdata("msg");
                return redirect()->back();
            } else {
                return redirect()->back()->with('msg', 'Donation details delete failed')->withInput();
            }
        } else {
            return redirect()->back()->with('msg', 'No users selected for deletion');
        }
    } else {
        return view('signin');
    }
}

      
     public function sent_notice_all_user()
    {  
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
        $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/sent_notice_all_user',$data);
         }
         else{
             return view('signin');
         }
    }
    public function admin_appointment_update_data()
    {  
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
             $appoint_data = new Admin_Appointment_updataModel();
             $data['appoint'] =$appoint_data->first();
              $Webmodel=new Admin_Website_Model();
           $data['dataweb']=$Webmodel->first();
              $model=new UserModel();
        $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/admin_appointment_update_data',$data);
         }
         else{
             return view('signin');
         }
    }
    
     public function admin_email_update_data()
    {  
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
        $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/admin_email_update_data',$data);
         }
         else{
             return view('signin');
         }
    }
    public function admin_email_update_data_process(){
        
        
        $modelEmail = new Admin_email_credentials();
        
         $data= $this->request->getPost();
         $admin_id= $this->request->getPost('id');
       $by_email= $this->request->getPost('by_email');
       $host= $this->request->getPost('host');
       $by_password= $this->request->getPost('by_password');
       $subject= $this->request->getPost('subject');
        $message= $this->request->getPost('message');
      
       
      
       
       $data=[
           'admin_id'=>$admin_id,
           'by_email'=>$by_email,
           'host'=>$host,
           'by_password'=>$by_password,
           'subject'=>$subject,
           'message'=>$message,
           
           'create_at'=> date('Y-m-d H:i:s'),
           
           ];
           
           
           $session = session();
               
                        require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $payments = mysqli_fetch_all($result, MYSQLI_ASSOC);
                         
                        
                      if($payments){
           
         $modelEmail = new Admin_email_credentials();
       
        $result = $modelEmail->where(["admin_id" =>$admin_id])
                   ->set($data)
                   ->update();
         
          $session=session();
            $session->set("msg","Website Email Mode Update Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                      }
                      else{
                           
                           $modelEmail = new Admin_email_credentials();
         $result = $modelEmail->save($data);
         
          $session=session();
            $session->set("msg","Website Email Mode Save Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                          
                      }
        
    }
    
     public function admin_payment_update_data_process(){
        
        $data= $this->request->getPost();
         $id= $this->request->getPost('id');
       $payment_website_name= $this->request->getPost('payment_website_name');
       $email= $this->request->getPost('email');
       $mobile= $this->request->getPost('mobile');
        $description= $this->request->getPost('description');
       $merchantId= $this->request->getPost('merchantId');
       $apiKey= $this->request->getPost('apiKey');
       $demo_link= $this->request->getPost('demo_link');
       $init_link= $this->request->getPost('init_link');
       $init_live_live= $this->request->getPost('init_live_live');
       $payment_mode= $this->request->getPost('payment_mode');
       $web_tag_line = $this->request->getPost('web_tag_line');
       
      
       
       $data=[
          
           'name'=>$payment_website_name,
           'email'=>$email,
           'mobile'=>$email,
           'description'=>$description,
           'merchantId'=>$merchantId,
           'apiKey'=>$apiKey,
           'demo_link'=>$demo_link,
           'init_live_live'=>$init_live_live,
           'init_link'=>$init_link,
           'payment_mode'=>$payment_mode,
           'web_tag_line'=>$web_tag_line,
           'create_at'=> date('Y-m-d H:i:s'),
           
           ];
        
           $session = session();
               
                        require 'db_config.php';
                         $queryli = "SELECT * FROM `website_transaction`";
                         $result = mysqli_query($connection, $queryli);
                         $payments = mysqli_fetch_all($result, MYSQLI_ASSOC);
                         
                        
                      if($payments){
           
         $paymentsModel=new Payments_Mode_Models();
       
        $result = $paymentsModel->update($id,$data);
         
          $session=session();
            $session->set("msg","Website Transaction Mode Update Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                      }
                      else{
                           echo "check save";
                           $paymentsModel = new Payments_Mode_Models();
         $result = $paymentsModel->save($data);
         
          $session=session();
            $session->set("msg","Website Transaction Mode Save Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                          
                      }
           
    }


    public function admin_dashboard()
    {  
       
       
    //   $today = date('m-d');
    //     $tomorrow = date('m-d', strtotime('+1 day'));

    //     $userModel = new UserModel();

    //     // Today's Birthday
    //     $todayUsers = $userModel->where("DATE_FORMAT(dob, '%m-%d')", $today)->findAll();
    //     foreach ($todayUsers as $user) {
    //         $this->sendBirthdayEmail($user, 'today');
    //     }

    //     // Tomorrow's Birthday
    //     $tomorrowUsers = $userModel->where("DATE_FORMAT(dob, '%m-%d')", $tomorrow)->findAll();
    //     foreach ($tomorrowUsers as $user) {
    //         $this->sendBirthdayEmail($user, 'tomorrow');
    //     }

    //   /*automatic send wishes mail*/
        
    //      $model=new UserModel();
          
    // $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    // $expiredUsers = $model->where('status', 'active')
    //                      ->where('verifie_date <=', $oneYearAgo)
    //                      ->findAll();
    
    
    // if(!empty($expiredUsers)) {
    //     foreach($expiredUsers as $user) {
    //         $model->update($user['id'], ['status' => 'inactive']);
    //     }
    // }
        
        
    
       
        
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
        $data['user'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/index',$data);
         }
         else{
             return view('signin');
         }
    }
    
    private function sendBirthdayEmail($user, $type = 'today')
{
   //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);


   $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

    // Load DB config manually if needed
   require 'db_config.php';
          //$mail = new PHPMailer(true);              
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $result = mysqli_query($connection, "SELECT * FROM email_credentials LIMIT 1");
    $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $resultweb = mysqli_query($connection, "SELECT * FROM admin_website_update LIMIT 1");
    $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);

    try {
        // SMTP Config
        $mail->isSMTP();
          $mail->Host       = $email_data['host'];
        $mail->SMTPAuth   = true;
        $mail->Username   = $email_data['by_email'];
        $mail->Password   = $email_data['by_password'];
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        // Recipients
        $mail->setFrom($email_data['by_email'], $email_data['subject']);
        $mail->addAddress($user['email'], $user['name']);

        // Content
        $mail->isHTML(true);

        if ($type === 'today') {
            $mail->Subject = ' Happy Birthday!';
            $message = view('emails/birthday_today', ['name' => $user['name']]);
        } else {
            $mail->Subject = ' Early Birthday Wishes!';
            $message = view('emails/birthday_tomorrow', ['name' => $user['name']]);
        }

        $mail->Body = $message;

        $mail->send();
       
    } catch (\PHPMailer\PHPMailer\Exception $e) {
        CLI::error("Failed to send to {$user['email']}: {$mail->ErrorInfo}");
    }
}
    public function admin_profile($user_id){
        
         $model=new UserModel();
         $data['users'] = $model->where('user_id', $user_id)->first();
         
        
        return view('admin_dashboard/admin_profile_update',$data);
    }
    
   public function admin_view_profile($user_id){
        
         $model=new UserModel();
         $data['user'] = $model->where('id', $user_id)->first();
         
        
        return view('admin_dashboard/admin_view_profile',$data);
    } 

   
    
     public function CommingBirthday() {
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    // Check admin authentication
    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorized Access!']);
    }

    // Get current date components
    $todayDay = date('d');
    $todayMonth = date('m');
    $currentYear = date('Y');

    // Get date 7 days from now
    $nextWeek = date('Y-m-d', strtotime('+7 days'));
    $nextWeekDay = date('d', strtotime($nextWeek));
    $nextWeekMonth = date('m', strtotime($nextWeek));

    // Get all users with non-empty dob
    $users = $model->where('dob IS NOT NULL AND dob != ""')
                  ->orderBy('id', 'DESC')
                  ->findAll();

    $upcomingBirthdays = [];
    $todayBirthdays = [];

    foreach ($users as $user) {
        try {
            // Convert DD-MM-YYYY to YYYY-MM-DD for comparison
            $dobParts = explode('-', $user['dob']);
            if (count($dobParts) !== 3) continue;
            
            $mysqlDate = $dobParts[2] . '-' . $dobParts[1] . '-' . $dobParts[0];
            $birthDay = date('d', strtotime($mysqlDate));
            $birthMonth = date('m', strtotime($mysqlDate));
            
            // Check if birthday is today
            if ($birthDay == $todayDay && $birthMonth == $todayMonth) {
                $user['birthday_type'] = 'today';
                $user['age'] = $currentYear - date('Y', strtotime($mysqlDate));
                $todayBirthdays[] = $user;
            }
            // Check if birthday is in next 7 days
            elseif (
                ($birthMonth == $todayMonth && $birthDay > $todayDay && $birthDay <= $nextWeekDay) ||
                ($birthMonth == $nextWeekMonth && $birthDay <= $nextWeekDay)
            ) {
                $user['birthday_type'] = 'upcoming';
                $user['days_until'] = (strtotime($currentYear . '-' . $birthMonth . '-' . $birthDay) - time()) / (60 * 60 * 24);
                $upcomingBirthdays[] = $user;
            }
        } catch (\Exception $e) {
            // Skip invalid dates
            continue;
        }
    }

    // Combine today and upcoming birthdays
    $allBirthdays = array_merge($upcomingBirthdays);
    
    // Sort by days until birthday
    usort($allBirthdays, function($a, $b) {
        $aDays = $a['birthday_type'] === 'today' ? 0 : $a['days_until'];
        $bDays = $b['birthday_type'] === 'today' ? 0 : $b['days_until'];
        return $aDays <=> $bDays;
    });

    // Prepare data for view
    $data = [
        'heading' => "This Week's Birthday Members",
        'users' => $allBirthdays,
        'todayCount' => count($todayBirthdays),
        'upcomingCount' => count($upcomingBirthdays),
        'adminData' => $data
    ];

    return view('admin_dashboard/user_show_by_admin', $data);
}
  public function TodayBirthday() {
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    // Check admin authentication
    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorized Access!']);
    }

    // Get current date components
    $todayDay = date('d');
    $todayMonth = date('m');
    $currentYear = date('Y');

    // Get date 7 days from now
    $nextWeek = date('Y-m-d', strtotime('+7 days'));
    $nextWeekDay = date('d', strtotime($nextWeek));
    $nextWeekMonth = date('m', strtotime($nextWeek));

    // Get all users with non-empty dob
    $users = $model->where('dob IS NOT NULL AND dob != ""')
                  ->orderBy('id', 'DESC')
                  ->findAll();

    $upcomingBirthdays = [];
    $todayBirthdays = [];

    foreach ($users as $user) {
        try {
            // Convert DD-MM-YYYY to YYYY-MM-DD for comparison
            $dobParts = explode('-', $user['dob']);
            if (count($dobParts) !== 3) continue;
            
            $mysqlDate = $dobParts[2] . '-' . $dobParts[1] . '-' . $dobParts[0];
            $birthDay = date('d', strtotime($mysqlDate));
            $birthMonth = date('m', strtotime($mysqlDate));
            
            // Check if birthday is today
            if ($birthDay == $todayDay && $birthMonth == $todayMonth) {
                $user['birthday_type'] = 'today';
                $user['age'] = $currentYear - date('Y', strtotime($mysqlDate));
                $todayBirthdays[] = $user;
            }
            // Check if birthday is in next 7 days
            elseif (
                ($birthMonth == $todayMonth && $birthDay > $todayDay && $birthDay <= $nextWeekDay) ||
                ($birthMonth == $nextWeekMonth && $birthDay <= $nextWeekDay)
            ) {
                $user['birthday_type'] = 'upcoming';
                $user['days_until'] = (strtotime($currentYear . '-' . $birthMonth . '-' . $birthDay) - time()) / (60 * 60 * 24);
                $upcomingBirthdays[] = $user;
            }
        } catch (\Exception $e) {
            // Skip invalid dates
            continue;
        }
    }

    // Combine today and upcoming birthdays
    $allBirthdays = array_merge($todayBirthdays);
    
    // Sort by days until birthday
    usort($allBirthdays, function($a, $b) {
        $aDays = $a['birthday_type'] === 'today' ? 0 : $a['days_until'];
        $bDays = $b['birthday_type'] === 'today' ? 0 : $b['days_until'];
        return $aDays <=> $bDays;
    });

    // Prepare data for view
    $data = [
        'heading' => "Today Birthday Members",
        'users' => $allBirthdays,
        'todayCount' => count($todayBirthdays),
        'upcomingCount' => count($upcomingBirthdays),
        'adminData' => $data
    ];

    return view('admin_dashboard/user_show_by_admin', $data);
}
       
    
public function admin_show_manager(){
    
 
        $userModel=new UserModel();
        $data['users'] = $userModel->orderBy('id', 'DESC')->findAll();
      
        return view('admin_dashboard/manager_show_by_admin',$data);  
}

public function search_filture_manager(){
      $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
       
        $model=new UserModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $model->getDataByDateRange_manager($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
           $data['user'] = $model->where('id', $session->id)->first();
           
            $data['users'] = $model->getDataByDateRange_manager($startDate, $endDate);
       return view('admin_dashboard/manager_show_by_admin',$data);  
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
         }else{
                     
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->back()  ; 
         }
}
   
   public function delete_visitor_certificate(){
       
   } 

public function admin_show_block_manager(){
    
 
        $userModel=new UserModel();
        $data['users'] = $userModel->orderBy('id', 'DESC')->findAll();
      
        return view('admin_dashboard/admin_show_block_manager',$data);  
}
public function admin_show_franchise(){
    
 
        $userModel=new UserModel();
        $data['users'] = $userModel->orderBy('id', 'DESC')->findAll();
      
        return view('admin_dashboard/admin_show_franchise',$data);  
}

public function admin_show_user_under_manager($manager_id){
    
    $model=new UserModel();
    
    $data = [
'users' => $model->where('manager_id', $manager_id)->paginate(12),
            'pager' => $model->pager
        ];
         
        
return view('admin_dashboard/admin_show_user_under_manager',$data);  
         
}
    
    public function generate_id_card_byadmin($user_id=nill, $status=null){

      $userModel = new UserModel();
       $status['status'] = 'status';

        $users= $userModel->where('user_id', $user_id)->first();
        
        $sess_data = [
                     'status'       => $users['status']
                    
                 ];

                  $session=session();
                $session->set($sess_data);
                if($users['status']=="active"){
                    //go to user pageprint_id_card_by_user
                   $session->set("msg","  Yor are Qualified for Print Id Card");
            $session->markAsFlashdata("msg");
            return redirect()->to('print_id_card_by_user');
                }
         
         
       
       else{
        $session=session();
           
       $session->set("msg", "Your registration is under processing ðŸ˜ž ");
            $session->markAsFlashdata("msg");
            return redirect()->to('user_dashboard');
         }  


    }
    
    public function message_user($msg_user_id){
        
       $model=new UserModel();
         $data['users'] = $model->where('user_id', $msg_user_id)->first();
        $msgModel = new Message_controller();
            $data['users_msg'] = $msgModel->where('msg_user_id', $msg_user_id)->first();
           
        return view('admin_dashboard/message_user_show', $data); 
        
    }
    
    public function send_message_by_admin_data()
    {
         
       $id = $this->request->getVar('msg_user_id');
        $message_id = $this->request->getVar('id');
      $reply_id = $this->request->getVar('reply_id');
       $reply_msg = $this->request->getVar('reply_msg');
        $user_name = $this->request->getVar('user_name');
    $userModel = new UserModel();
   
       
 $data = [       'message_id'=> $message_id,
                'msg_user_id'     => $id,
                'reply_id' => $reply_id,
                'reply_msg'     => $reply_msg,
                  'user_name'    =>$user_name,
                    'user_type' => "admin",
                       
            'msg_date'=> date('Y-m-d H:i:s'),

                
    ];
   
   
 if($data){
     $msgModel = new Message_controller();
       $result= $msgModel->update($message_id, $data);
         if($result){
             
      $model=new UserModel();
         $data['users'] = $model->where('user_id', $id)->first();
           $msgModel = new Message_controller();
            $data['users_msg'] = $msgModel->where('msg_user_id', $id)->first();
            
            
         $session=session();
                    $session->set("msg","Send Message Successfully !");
                    $session->markAsFlashdata("msg");
        return view('admin_dashboard/message_user_show', $data);
         }
         else{
            $session=session();
                    $session->set("msg","Message Not Send");
                    $session->markAsFlashdata("msg");
                     $model=new UserModel();
         $data['users'] = $model->where('user_id', $user_id)->first(); 
            echo view('admin_dashboard/index', $data);
         }
 }
 else
 {
     $session=session();
                    $session->set("msg","Message Not Send");
                    $session->markAsFlashdata("msg");
                     $model=new UserModel();
         $data['users'] = $model->where('user_id', $user_id)->first(); 
            echo view('admin_dashboard/index', $data);
 }
                
        
    }
  public function admin_show_inactive_user() {
    $session = session();
    
    // Get logged-in user data
    $userData = (new UserModel())->find($session->id);
    
    if (!$userData || $userData['user_type'] !== 'admin') {
        return redirect()->to('signin');
    }

    $data = [];
    $data['heading'] = "New Members Application";

   $data['zones'] = (new ZoneModel())->orderBy('name')->findAll();
    $userModel = new UserModel();
    $data['users'] = $userModel
                        ->where('status', 'inactive')
                        ->where('user_type', 'user')
                        ->orderBy('id', 'DESC')
                        ->findAll();

    return view('admin_dashboard/admin_show_verifie_user', $data);
}


public function bulkDeleteUser(){
     $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (!empty($ids)) {
         $UserModel = new \App\Models\UserModel();
    $deleted = $UserModel->whereIn('id', $ids)->delete();
        return $this->response->setJSON(['success' => true]);
    }
return redirect()->back()->with('success', 'Selected users deleted successfully!');

    return $this->response->setJSON(['success' => false, 'message' => 'No users selected']);
    
}


       
       public function report_unverified_download_admin(){

         $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
     $model=new UserModel();
       $userModel = new UserModel();
         $data['users'] = $userModel
                        ->where('status', 'inactive')
                        ->where('user_type', 'user')
                        ->orderBy('id', 'DESC')
                        ->findAll();
        
        $mpdf = new \Mpdf\Mpdf();
		$html = view('admin_dashboard/report_verified_download_admin',$data);
		$mpdf->WriteHTML($html);
		$this->response->setHeader('Content-Type', 'application/pdf');
		$mpdf->Output('Unverified-user.pdf','D');
      return view('admin_dashboard/report_verified_download_admin',$data);
     // return view('admin_dashboard/report_unverified_download_admin',$data);
         }
        else {
            return view('404error'); 
            
        }
       }
       
        public function report_verified_download_admin(){
             $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
            $model=new UserModel();
       $userModel = new UserModel();
         $data['users'] = $userModel
                        ->where('status', 'active')
                        ->where('user_type', 'user')
                        ->orderBy('id', 'DESC')
                        ->findAll();
        
        $mpdf = new \Mpdf\Mpdf();
		$html = view('admin_dashboard/report_verified_download_admin',$data);
		$mpdf->WriteHTML($html);
		$this->response->setHeader('Content-Type', 'application/pdf');
		$mpdf->Output('Verified-user.pdf','D');
     // return view('admin_dashboard/report_verified_download_admin',$data);
        }
        else {
            return view('404error'); 
            
        }
       }
       
       
        public function report_membership_fee_download_admin(){
            $TransModel=new TransactionModel();
      
        $data['users'] = $TransModel->orderBy('id', 'DESC')->findAll();
        
        $mpdf = new \Mpdf\Mpdf();
		$html = view('admin_dashboard/report_membership_fee_download_admin',$data);
		$mpdf->WriteHTML($html);
		$this->response->setHeader('Content-Type', 'application/pdf');
		$mpdf->Output('Membership_fee-user.pdf','D');

     // return view('admin_dashboard/report_membership_fee_download_admin',$data);
       }
       
        public function report_donate_receipt_view_admin(){
             $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
            $model=new Donote_TransactionModel();
      
        $data['users'] = $model->orderBy('id', 'DESC')->findAll();
        
      $mpdf = new \Mpdf\Mpdf();
		$html = view('admin_dashboard/report_donate_receipt_view_admin',$data);
		$mpdf->WriteHTML($html);
		$this->response->setHeader('Content-Type', 'application/pdf');
		$mpdf->Output('Donate_receipt-user.pdf','D');
     // return view('admin_dashboard/report_donate_receipt_view_admin',$data);
         }
     else {
            
            return view('404error');
             
        }
       }
       
       public function report_visitor_receipt_view_admin(){
             $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
            $transModel= new Donote_TransactionModel();
       $id ="direct";
         $data['users'] = $transModel->where('user_id',$id)->orderBy('id', 'DESC')->findAll();
         
        $mpdf = new \Mpdf\Mpdf();
		$html = view('admin_dashboard/report_visitor_receipt_view_admin',$data);
		$mpdf->WriteHTML($html);
		$this->response->setHeader('Content-Type', 'application/pdf');
		$mpdf->Output('Visitor_receipt-user.pdf','D');
     // return view('admin_dashboard/report_visitor_receipt_view_admin',$data);
         }
     else {
            
            return view('404error');
             
        }
       }
       
    public function admin_show_verifie_user(){
         $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data['user_type']=="admin"){ 
            $data['lasturl']=previous_url(); 
            
      $model=new UserModel();
      $data['heading'] ="Verify Members ";
       $userModel = new UserModel();
        $data['users'] = $userModel->where('status', "active")->where('user_type', 'user')->orderBy('id', 'DESC')->findAll();

                      return view('admin_dashboard/admin_show_verifie_user',$data);
         } else {
        return redirect()->to('signin');
    }
      }
      
      
     public function user_show_by_admin(){
        $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return view('signin', ['msg' => 'Unauthorised Access!']);
    }
    $data['heading'] ="All Members ";
    
      $userModel=new UserModel();
        $data['users'] = $userModel->where('user_type', "user")->orderBy('id', 'DESC')->findAll();
      
        return view('admin_dashboard/admin_show_verifie_user',$data);
    }
   public function membership_receipt_download_admin(){
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data['user_type']=="admin"){
         $trans= new TransactionModel();
        $data['receipt'] = $trans->whereIn('trans_status', 
                                ['PAYMENT_SUCCESS', 'success', 'captured'])
                        ->orderBy('id', 'DESC')
                        ->findAll();
        
        $donations = $trans->whereIn('trans_status', 
                                ['PAYMENT_SUCCESS', 'success', 'captured'])
                        ->orderBy('id', 'DESC')
                        ->findAll();
      
        // Calculate total amount
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; // Using null coalescing operator for safety
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
       
         
        return view('admin_dashboard/membership_receipt_download_admin',$data);
    } else {
        return redirect()->to('signin');
    }
        
     }
     
     
      public function membership_receipt_fail_admin(){
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data['user_type']=="admin"){
         $trans= new TransactionModel();
         $data['receipt'] = $trans->where('trans_status', "fail")->orderBy('id', 'DESC')->findAll();
        
        $donations = $trans->where('trans_status', "fail")->orderBy('id', 'DESC')->findAll();
        
        // Calculate total amount
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; // Using null coalescing operator for safety
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
       
       
        return view('admin_dashboard/membership_receipt_download_admin',$data);
    } else {
        return redirect()->to('signin');
    }
        
     }
     
        public function search_filture_memebership()
  {      
          $transModel = new TransactionModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $transModel->getDataByDateRange($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
           $transModel = new TransactionModel();
           
            
            $donations = $transModel->getDataByDateRange($startDate, $endDate);
        
        
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
        return view('admin_dashboard/membership_receipt_download_admin',$data);
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
            }
             
     
       public function delete_users_membership_receipt() {
    $model = new TransactionModel();
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No users selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $model->whereIn('id', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' Member Receipt', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No users were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'User deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting users. Please try again later.')
            ->with('msg_type', 'danger');
    }
}
    
        public function donate_receipt_view_admin()
{
    $session = session();
    $userModel = new UserModel();
    $adminData = $userModel->find($session->get('id'));

    if ($adminData && $adminData['user_type'] === "admin") {
        $db = \Config\Database::connect();
        $builder = $db->table('donate_transactions dt');
        $builder->select('
            dt.id as transaction_id,
            dt.user_id,
            dt.user_name,
            dt.email,
            dt.mobile,
            dt.amount,
            dt.payment_status,
            dt.created_at,
            users.name as donor_name,
            users.email as donor_email,
            users.mobile as donor_mobile
        ');
        $builder->join('users', 'users.id = dt.user_id', 'left');
        $builder->whereNotIn('dt.user_id', [0]); // or valid numeric exclusions if applicable
        $builder->whereIn('dt.payment_status', ['PAYMENT_SUCCESS', 'success', 'captured','COMPLETED']);
        $builder->orderBy('dt.id', 'DESC');

        $donations = $builder->get()->getResultArray();
        $totalAmount = array_sum(array_column($donations, 'amount'));

        $data = [
            'heading' => 'Donation Receipts',
            'receipt' => $donations,
            'totalAmount' => $totalAmount,
        ];

        return view('admin_dashboard/donate_receipt_view_admin', $data);
    } else {
        return redirect()->to('signin')->with('msg', 'Unauthorized Access!');
    }
}


      
      
        public function donate_receipt_view_fail(){
          $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data['user_type']=="admin"){
       $transModel= new Donote_TransactionModel();
         $donations = $transModel->where('payment_status', "fail")->orderBy('id', 'DESC')->findAll();
         // Calculate total amount
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; // Using null coalescing operator for safety
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
       
         return view('admin_dashboard/donate_receipt_view_admin',$data); 
         }
         else{
             return redirect()->to('signin');
         }
      }
      
      
      
        public function search_filture_member_donation()
  {      
          $transModel = new Donote_TransactionModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $transModel->getDataByDateRange($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
           $transModel = new Donote_TransactionModel();
           
            
            $donations = $transModel->getDataByDateRange($startDate, $endDate);
        
        
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
      return view('admin_dashboard/donate_receipt_view_admin',$data); 
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
            }
      
      public function deleteAllDonationMember(){
           $model = new Donote_TransactionModel();
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No users selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $model->whereIn('id', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' Member Receipt', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No users were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'User deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting users. Please try again later.')
            ->with('msg_type', 'danger');
    }
      }
   
      
      
      public function admin_show_visitor_donation_receipt(){
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();
    
    if($data['user_type'] == "admin") {
        $transModel = new Donote_TransactionModel();
        $id = "visitor";
        
        
     $donations = $transModel->where('user_id', $id)
                        ->whereIn('payment_status', ['captured', 'success', 'PAYMENT_SUCCESS','COMPLETED'])
                        ->orderBy('id', 'DESC')
                        ->findAll();

        
        
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
        
        return view('admin_dashboard/admin_show_visitor_donation_receipt', $data); 
    } else {
        return redirect()->to('signin');
    }
}



 public function reffral_donation_fail(){
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();
    
    if($data['user_type'] == "admin") {
        $transModel = new Donote_TransactionModel();
        $id = "visitor";
        
        
     $donations = $transModel->where('referance_id', "referral")
                        ->whereIn('payment_status', ['fail', NULL, 'PAYMENT_SUCCESS'])
                        ->orderBy('id', 'DESC')
                        ->findAll();

        
        
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
        $data['heading']="Reffral Donation Fail";
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
        
        return view('admin_dashboard/admin_show_visitor_donation_receipt', $data); 
    } else {
        return redirect()->to('signin');
    }
}

 public function admin_show_visitor_donation_fail(){
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();
    
    if($data['user_type'] == "admin") {
        $transModel = new Donote_TransactionModel();
        $id = "visitor";
        
        
        $donations = $transModel->where('user_id', $id)->where('payment_status',"fail")
                               ->orderBy('id', 'DESC')
                               ->findAll();
        
        
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
         $data['heading']="Visitor Donation Fail";
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
        
        return view('admin_dashboard/admin_show_visitor_donation_receipt', $data); 
    } else {
        return redirect()->to('signin');
    }
}
    
      public function search_filture_donation()
  {      
          $transModel = new Donote_TransactionModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $transModel->getDataByDateRange($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
           $transModel = new Donote_TransactionModel();
           
            
            $donations = $transModel->getDataByDateRange($startDate, $endDate);
        
        
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
         return view('admin_dashboard/admin_show_visitor_donation_receipt', $data); 
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
            }
    
     public function deleteAllDonation($ids = null)
    {
        if ($ids === null) {
            return redirect()->back()->with('error', 'No users selected.');
        }

         $transModel = new Donote_TransactionModel();
        $idArray = explode(",", $ids); 

        if (!empty($idArray)) {
            $transModel->whereIn('id', $idArray)->delete(); 
            return redirect()->back()->with('msg', 'Selected Donation Details deleted successfully.');
        } else {
            return redirect()->back()->with('msg', 'Invalid Donation Details selection.');
        }
    }
    public function notification_user($user_id){
         $model=new UserModel();
         $data['users'] = $model->where('user_id', $user_id)->first();
        
        return view('admin_dashboard/notification_user', $data);
        
    }
    
    
            
            public function search_filture()
  {      
        $model=new UserModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $model->getDataByDateRange($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
            $model=new UserModel();
            $data['users'] = $model->where('status', "inactive")->getDataByDateRange($startDate, $endDate);
        return view('admin_dashboard/inactive_user',$data);
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->back();  
        }
            }
            
               public function search_filture_verify()
  {      
        $model=new UserModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $model->getDataByDateRange($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
            $model=new UserModel();
            $data['users'] = $model->where('status', "active")->getDataByDateRange($startDate, $endDate);
        return view('admin_dashboard/admin_show_verifie_user',$data);
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
            }
            
            
    
public function send_message_by_admin($user_id){
    $model=new UserModel();
         $data['users'] = $model->where('user_id', $user_id)->first();
        
        return view('admin_dashboard/send_message_by_user', $data);
    
}
    public function admin_show_active_user()
{
    $session = session();

    
    $userData = (new UserModel())->find($session->id);

    if (!$userData && $userData['user_type'] !== 'admin') {
        return redirect()->to('signin');
    }

    $data = [];
    $data['heading'] = "Verified Members";

    
    $zoneModel      = new ZoneModel();
    $stateModel     = new StateModel();
    $districtModel  = new DistrictModel();
    $blockModel     = new BlockModel();
    $panchModel     = new PanchayatModel();

    
    $userModel = new UserModel();
    $users = $userModel
        ->where('status', 'active')
        ->where('user_type', 'user')
        ->orderBy('id', 'DESC')
        ->findAll();
 $data['zones'] = (new ZoneModel())->orderBy('name')->findAll();
   
    $finalUsers = [];

    foreach ($users as $u) {
        $u['zone_name']      = !empty($u['zone_id'])      ? $zoneModel->find($u['zone_id'])['name']        : '-';
        $u['state_name']     = !empty($u['state_id'])     ? $stateModel->find($u['state_id'])['name']     : '-';
        $u['district_name']  = !empty($u['district_id'])  ? $districtModel->find($u['district_id'])['name'] : '-';
        $u['block_name']     = !empty($u['block_id'])     ? $blockModel->find($u['block_id'])['name']       : '-';
        $u['panchayat_name'] = !empty($u['panchayat_id']) ? $panchModel->find($u['panchayat_id'])['name']   : '-';

        $finalUsers[] = $u;
    }

    $data['users'] = $finalUsers;

    return view('admin_dashboard/admin_show_verifie_user', $data);
}

  public function InactiveHealthCard(){
   
    $session = session();
    $userModel = new UserModel();

    // Admin check
    $userData = $userModel->find($session->id);
    if (!$userData || $userData['user_type'] !== 'admin') {
        return redirect()->to('signin');
    }

    $data['heading'] = "Active Health Cards";

    // Models
    $zoneModel     = new ZoneModel();
    $stateModel    = new StateModel();
    $districtModel = new DistrictModel();
    $blockModel    = new BlockModel();
    $panchModel    = new PanchayatModel();

    $healthModel   = new HealthCardModel();
    $txnModel      = new HealthCardTransactionModel();
    $memberModel   = new HealthCardMemberModel();

    // Fetch ALL health cards
    $cards = $healthModel->where('status',"inactive")->orderBy('id', 'DESC')->findAll();

    $finalList = [];

    foreach ($cards as $card) {

        $cardId = $card['id'];

        // 1. Card Creator (User name + ID)
        $creator = $userModel->find($card['user_id']);

        $card['creator_id']   = $creator['id'] ?? '';
        $card['creator_name'] = $creator['name'] ?? '';

        // 2. Members inside this health card
        $members = $memberModel->where('card_id', $cardId)->findAll();

        // 3. Transactions (payment history)
        $transactions = $txnModel->where('card_id', $cardId)
                                 ->orderBy('id', 'DESC')
                                 ->findAll();

        // 4. Total amount paid so far
        $totalAmount = 0;
        foreach ($transactions as $t) {
            $totalAmount += floatval($t['amount']);
        }

        // 5. Attach location names
        $card['zone_name']      = !empty($card['zone_id'])      ? $zoneModel->find($card['zone_id'])['name'] : '-';
        $card['state_name']     = !empty($card['state_id'])     ? $stateModel->find($card['state_id'])['name'] : '-';
        $card['district_name']  = !empty($card['district_id'])  ? $districtModel->find($card['district_id'])['name'] : '-';
        $card['block_name']     = !empty($card['block_id'])     ? $blockModel->find($card['block_id'])['name'] : '-';
        $card['panchayat_name'] = !empty($card['panchayat_id']) ? $panchModel->find($card['panchayat_id'])['name'] : '-';

        // Push merged data
        $finalList[] = [
            'card'          => $card,
            'members'       => $members,
            'transaction'   => $transactions,
            'total_amount'  => $totalAmount
        ];
    }

    $data['healthcards'] = $finalList;

    // For view sidebar
    $data['zones'] = $zoneModel->orderBy('name')->findAll();
    $data['users'] = $userData;

    return view('admin_dashboard/ActiveHealthCard', $data);   
  }
  
 public function ActiveHealthCard() 
{
    $session = session();
    $userModel = new UserModel();

    // Admin check
    $userData = $userModel->find($session->id);
    if (!$userData || $userData['user_type'] !== 'admin') {
        return redirect()->to('signin');
    }

    $data['heading'] = "Active Health Cards";

    // Models
    $zoneModel     = new ZoneModel();
    $stateModel    = new StateModel();
    $districtModel = new DistrictModel();
    $blockModel    = new BlockModel();
    $panchModel    = new PanchayatModel();

    $healthModel   = new HealthCardModel();
    $txnModel      = new HealthCardTransactionModel();
    $memberModel   = new HealthCardMemberModel();

    // Fetch ALL health cards
    $cards = $healthModel->where('status',"active")->orderBy('id', 'DESC')->findAll();

    $finalList = [];

    foreach ($cards as $card) {

        $cardId = $card['id'];

        // 1. Card Creator (User name + ID)
        $creator = $userModel->find($card['user_id']);

        $card['creator_id']   = $creator['id'] ?? '';
        $card['creator_name'] = $creator['name'] ?? '';

        // 2. Members inside this health card
        $members = $memberModel->where('card_id', $cardId)->findAll();

        // 3. Transactions (payment history)
        $transactions = $txnModel->where('card_id', $cardId)
                                 ->orderBy('id', 'DESC')
                                 ->findAll();

        // 4. Total amount paid so far
        $totalAmount = 0;
        foreach ($transactions as $t) {
            $totalAmount += floatval($t['amount']);
        }

        // 5. Attach location names
        $card['zone_name']      = !empty($card['zone_id'])      ? $zoneModel->find($card['zone_id'])['name'] : '-';
        $card['state_name']     = !empty($card['state_id'])     ? $stateModel->find($card['state_id'])['name'] : '-';
        $card['district_name']  = !empty($card['district_id'])  ? $districtModel->find($card['district_id'])['name'] : '-';
        $card['block_name']     = !empty($card['block_id'])     ? $blockModel->find($card['block_id'])['name'] : '-';
        $card['panchayat_name'] = !empty($card['panchayat_id']) ? $panchModel->find($card['panchayat_id'])['name'] : '-';

        // Push merged data
        $finalList[] = [
            'card'          => $card,
            'members'       => $members,
            'transaction'   => $transactions,
            'total_amount'  => $totalAmount
        ];
    }

    $data['healthcards'] = $finalList;

    // For view sidebar
    $data['zones'] = $zoneModel->orderBy('name')->findAll();
    $data['users'] = $userData;

    return view('admin_dashboard/ActiveHealthCard', $data);
}

 public function updateCard($cardId)
{
    $session = session();
    $userModel = new UserModel();

    // Logged in user
    $loggedUser = $userModel->find($session->id);
    if (!$loggedUser) {
        return redirect()->to('signin')->with('msg', 'Please login first');
    }

    $cardModel   = new HealthCardModel();
    $memberModel = new HealthCardMemberModel();

   
    $card = $cardModel->find($cardId);
    if (!$card) {
        return redirect()->back()->with('msg', 'Invalid Card ID');
    }

    
    if ($loggedUser['user_type'] !== 'admin' &&  $session->id) {
        return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
    }

    
    $dob = $this->request->getPost('dob');
    $age = null;
    if (!empty($dob)) {
        try {
            $age = date_diff(date_create($dob), date_create('today'))->y;
        } catch (\Throwable $e) {
            $age = null;
        }
    }

    
   
    $fileinfo = $this->request->getFile('photo');
  if(is_file($fileinfo) &&  !empty($fileinfo)){
    $filename= $fileinfo->getName();
                $nameArray = explode(".",$filename);
                $newfileName= time().".". end($nameArray); 
                if($fileinfo->move("member_images",$newfileName)){
                    $data['photo'] = $newfileName;
                }

           
            if (!empty($card['photo'])) {
                $oldPath ="member_images".$card['photo'];
                if (is_file($oldPath)) {
                    unlink($oldPath);
                }
            }
        } 

 
    $mainData = [
        'name'         => $this->request->getPost('name'),
        'father_name'  => $this->request->getPost('father_name'),
        'email'        => $this->request->getPost('email'),
        'mobile'       => $this->request->getPost('mobile'),
        'state'        => $this->request->getPost('state'),
        'district'     => $this->request->getPost('district'),
        'full_address' => $this->request->getPost('full_address'),
        'aadhar_no'    => $this->request->getPost('aadhar_no'),
        'dob'          => $dob ?: $card['dob'],
        'age'          => $age !== null ? $age : $card['age'],
    ];

    if (!empty($newfileName) && $newfileName) {
        $mainData['photo'] = $newfileName;
    }

   
    $cardModel->update($cardId, $mainData);

    
    $memberModel->where('card_id', $cardId)->delete();

    $member_names     = (array) $this->request->getPost('member_name');
    $member_relations = (array) $this->request->getPost('member_relation');
    $member_aadhars   = (array) $this->request->getPost('member_aadhar');
    $member_ages      = (array) $this->request->getPost('member_age');

  
    $count = max(
        count($member_names),
        count($member_relations),
        count($member_aadhars),
        count($member_ages)
    );

    for ($i = 0; $i < $count; $i++) {
        $mName = trim($member_names[$i] ?? '');
        if ($mName === '') {
            continue; 
        }

        $memberModel->insert([
            'card_id'   => $cardId,
            'name'      => $mName,
            'relation'  => $member_relations[$i] ?? '',
            'aadhar_no' => $member_aadhars[$i] ?? '',
            'age'       => $member_ages[$i] ?? null,
        ]);
    }

    return redirect()->to('ActiveHealthCard')->with('msg', 'Health Card updated successfully');
}

  
    public function deleteCard($id){
        
         $session = session();
    $userModel = new UserModel();

    
    $userData = $userModel->find($session->id);
    if (!$userData || $userData['user_type'] !== 'admin') {
        return redirect()->to('signin');
    }
        
       $healthModel  = new HealthCardModel();
    $memberModel  = new HealthCardMemberModel();
    $txnModel     = new HealthCardTransactionModel();


    $card = $healthModel->find($id);
    if (!$card) {
        return redirect()->back()->with('msg', 'Card not found');
    }

 
    $memberModel->where('card_id', $id)->delete();

    $txnModel->where('card_id', $id)->delete();

    $healthModel->delete($id);

    return redirect()->back()
                     ->with('msg', 'Health Card deleted successfully!');  
        
        
    }
    
    public function healthCardStatus($cardId){
        
        $session = session();
    $userModel = new UserModel();

   
    $userData = $userModel->find($session->id);
    if (!$userData && $userData['user_type'] !== 'admin') {
        return redirect()->to('signin');
    }
    
    $healthModel  = new HealthCardModel();
    $memberModel  = new HealthCardMemberModel();

   
    $card = $healthModel->find($cardId);
    if (!$card) {
        return redirect()->back()->with('msg', 'Invalid Card ID');
    }

    if($card['status']=="active"){
        $action= "inactive";
        
    }else{
        $action= "active";
    }
   

    $data = [
        'status'=>$action
    ];
 $result =   $healthModel->update($cardId, $data);
    if($result){
        return redirect()->back()->with('msg', "This Card Status Update! ".ucfirst($action));
        
    }else{
       return redirect()->back()->with('msg', "This Card Status Update Fail!"); 
    }

        
        
    }
    
    public function editCard($id)
{
     $session = session();
    $userModel = new UserModel();

   
    $userData = $userModel->find($session->id);
    if (!$userData && $userData['user_type'] !== 'admin') {
        return redirect()->to('signin');
    }
    
    $healthModel  = new HealthCardModel();
    $memberModel  = new HealthCardMemberModel();

   
    $card = $healthModel->find($id);
    if (!$card) {
        return redirect()->back()->with('msg', 'Invalid Card ID');
    }

    
    $members = $memberModel->where('card_id', $id)->findAll();

    $data = [
        'heading' => "Edit Health Card",
        'card'    => $card,
        'members' => $members
    ];
// echo "<pre>";
// print_r($data);
// die;
    return view('user_dashboard/create_health_card', $data);
}

    public function admin_send_notice_user(){
        
         $userModel=new UserModel();
       $data['users'] = $userModel->orderBy('id', 'DESC')->findAll();
  
        return view('admin_dashboard/admin_send_notice_user',$data);
        }
        
          public function admin_send_notice_single_user($id){
        
         $model=new UserModel();
        $data['users'] = $model->where('id',$id)->first();
       
        return view('admin_dashboard/admin_send_notice_single_user',$data);
        }
    
    public function admin_show_block_user(){
       
      $userModel=new UserModel();
       $data['users'] = $userModel->orderBy('id', 'DESC')->findAll();

        return view('admin_dashboard/admin_show_block_user',$data);
        }
    
 public function   admin_update_user_status($user_id=null, $status=null){
        $userModel = new UserModel();
   
     $user_id = $this->request->getVar('user_id');
     $status=   $this->request->getVar('status');
     $data['user_obj'] = $userModel->where('user_id', $user_id)->first();
        return view('admin_dashboard/update_status_process', $data);
        
 }
 public function visitor_certificate_generate_admin(){
     $session = session();
      $model=new UserModel();
        $data = $model->where('id', $session->id)->first();
        if($data['user_type']=="admin"){
    $model=new UserModel();
        $data['users'] = $model->where('id', $session->id)->first();
    
return view('admin_dashboard/visitor_certificate_generate_admin', $data);
}else{
    return redirect()->to('signin');
}
  
 }
 public function update_status(){


      $userModel = new UserModel();
     $user_id = $this->request->getVar('user_id');   
      $data = [
                
                
                'status'     => $this->request->getVar('status')
                
    ];

/*UPDATE `users` SET `status` = 'active' WHERE `users`.`user_id` = 3
    */   
         $userModel = new UserModel();
         $userModel->set('status', $data)
         ->where('user_id',$user_id)
         ->update();
        echo view('admin_dashboard/index');
 }

 public function admin_by_certificate_generate(){
$session = session();
      $model=new UserModel();
        $data = $model->where('id', $session->id)->first();
        if($data['user_type']=="admin"){

    $userModel=new UserModel();
         $data['users'] = $userModel->orderBy('id', 'DESC')->findAll();
 
                      return view('admin_dashboard/admin_by_certificate_generate',$data);
        }else{
            return redirect()->to('signin');
        }
   
 }
 
 public function admin_by_certificate_generate_id()
{
    $session = session();
    $userModel = new UserModel();
    $currentUser = $userModel->where('id', $session->id)->first();

    if (!$currentUser || $currentUser['user_type'] != "admin") {
        return redirect()->to('signin');
    }

    $certModel = new CertificateModel();

    // JOIN certificates with users
    $data['users'] = $certModel
        ->select('certificate.*, users.name, users.email, users.mobile, users.status, users.user_type, users.id, users.created_at, users.verifie_date') 
        ->join('users', 'users.id = certificate.user_id', 'left')
        ->where('certificate.apply_type', 'member')
        ->orderBy('certificate.certificate_no', 'DESC')
        ->findAll();

    $data['heading'] = 'Certificate Generate';
    $data['admin'] = $currentUser;

    return view('admin_dashboard/admin_by_certificate_generate_id', $data);
}

 public function bulkDeleteUserCertificate(){
     $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (!empty($ids)) {
         $CertiModel = new \App\Models\CertificateModel();
    $deleted = $CertiModel->whereIn('certificate_no', $ids)->delete();
        return $this->response->setJSON(['success' => true]);
    }
return redirect()->back()->with('success', 'Selected Certificate deleted successfully!');

    return $this->response->setJSON(['success' => false, 'message' => 'No users selected']);
    
}
public function bulkDeleteNotice(){
     $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (!empty($ids)) {
         $AdminNoticeModel = new \App\Models\AdminNoticeModel();
    $deleted = $AdminNoticeModel->whereIn('id', $ids)->delete();
        return $this->response->setJSON(['success' => true]);
    }
return redirect()->back()->with('success', 'Selected Notice deleted successfully!');

    return $this->response->setJSON(['success' => false, 'message' => 'No users selected']);
    
}
 
 
 public function bulkDeleteBeneficiary(){
     $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (!empty($ids)) {
         $BeneficiaryModel = new \App\Models\BeneficiaryModel();
    $deleted = $BeneficiaryModel->whereIn('id', $ids)->delete();
        return $this->response->setJSON(['success' => true]);
    }
return redirect()->back()->with('success', 'Selected Beneficiary deleted successfully!');

    return $this->response->setJSON(['success' => false, 'message' => 'No users selected']);
    
}


 public function visitor_certificate_show_admin(){

$session = session();
      $model=new UserModel();
        $data = $model->where('id', $session->id)->first();
        if($data['user_type']=="admin"){
     $certmodel=new CertificateModel();
           $data['users'] = $certmodel->orderBy('certificate_no', 'DESC')->findAll();

                      return view('admin_dashboard/visitor_certificate_show_admin',$data);
        }else{
            return redirect()->to('signin');
        }
   
 }
 
  public function search_filture_certificate_visitor(){
      $transModel = new CertificateModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $transModel->getDataByDateRangeVisitor($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
           $transModel = new CertificateModel();
           
            
            $donations = $transModel->getDataByDateRangeVisitor($startDate, $endDate);
        
        
        
        
        $data['users'] = $donations;
      
      return view('admin_dashboard/visitor_certificate_show_admin',$data);
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
 
     
 }
 
 public function admin_by_certificate_user($id){

$session = session();
      $model=new UserModel();
        $data = $model->where('id', $session->id)->first();
        if($data['user_type']=="admin"){
     $certmodel=new CertificateModel();
          $data['users'] = $certmodel->where('user_id',$id)->orderBy('certificate_no', 'DESC')->findAll();

                      return view('admin_dashboard/admin_by_certificate_show',$data);
        }else{
            return redirect()->to('signin');
        }
   
 }
 public function search_filture_certificate(){
      $transModel = new CertificateModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $transModel->getDataByDateRange($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
           $transModel = new CertificateModel();
           
            
            $donations = $transModel->getDataByDateRange($startDate, $endDate);
        
        
        
        
        $data['users'] = $donations;
      
      return view('admin_dashboard/admin_by_certificate_show',$data);
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
 
     
 }
  
     public function delete_users_certificate(){
         $model = new CertificateModel();
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No users selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $model->whereIn('certificate_no', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' Certificate(s)', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No users were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'User deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting users. Please try again later.')
            ->with('msg_type', 'danger');
    }
     
         
     }
 
 public function admin_by_certificate_show(){

$session = session();
      $model=new UserModel();
        $data = $model->where('id', $session->id)->first();
        if($data['user_type']=="admin"){
    $certmodel=new CertificateModel();
         $data = [
            'users' => $certmodel->paginate(21),
            'pager' => $certmodel->pager
        ];

                      return view('admin_dashboard/admin_by_certificate_show',$data);
        }else{
            return redirect()->to('signin');
        }
   
 }
 
 
 public function admin_by_certificate_generate_form($id=NULL){
     $model=new UserModel();
        $data['users'] = $model->where('id', $id)->first();
        
     
return view('admin_dashboard/admin_by_certificate_generate_form', $data);


 }

 public function certificate_by_admin_process(){

$id = $this->request->getVar('id');
$user_id = $this->request->getVar('id');
$userModel = new UserModel();
$data =$userModel->where('id',$user_id)->first();
$email = $data['email'];
$name = $data['name'];
$mobile = $data['mobile'];
   helper(['form']);
        /* set rules validation form */
     
$filePath = $this->request->getVar('qrcode');
$parts = explode('/', $filePath);
$filename = end($parts);


           
$data = [
                'user_id'     => $this->request->getVar('id'),
                'name'     => $this->request->getVar('name'),
                'father_name'    => $this->request->getVar('father_name'),
                 'program_name'    => $this->request->getVar('program_name'),
                  'certi_content'    => $this->request->getVar('certi_content'),
              
                 'certificate_img'    => $this->request->getVar('certificate'),
                 'certificate_id'=>$this->request->getVar('certificate_id'),
                 'certi_qrcode'=>$filename,
                  'certificate_id'=>$this->request->getVar('certificate_id'),
                 'gen_date'       => date('Y-m-d H:i:s'),
                 'certi_issue_date'=>date('Y-m-d'),
                 'certificate_provider_name'=>"Admin",
                 'apply_type'=>"member",
               
            ];
         
         
        
            $certimodel=new CertificateModel();
            $certimodel->save($data);
           $ceti_id = $certimodel->insertID;
$downloadurl=base_url('certificate_download_by_admin/'.$ceti_id);
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                           $ngo_id=$web_data['ngo_id'];
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
   $weblogo = base_url('websiteLogoImages/' . $web_data['web_logo']);

$mail->Subject = "Congratulations You Have Achieved A Certificate At {$datawebname}";

$mail->Body = "
<div style='
    width: 100%;
    max-width: 700px;
    margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;
'>
    <!-- Header -->
    <div style='
        background-image: url({$weblogo});
        background-repeat: no-repeat;
        background-position: center;
        background-size: 280px 280px;
        background-color: #ffffff;
        padding: 40px;
        font-family: Arial, sans-serif;
        color: #000;
    '>
        <!-- Logo and site name -->
        <div style='text-align: center; margin-bottom: 30px;'>
            <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
            <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
        </div>

        <!-- Main content block -->
        <div style='
            background-color: rgba(255,255,255,0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
            font-size: 15px;
            line-height: 1.6;
        '>
            Dear {$name},<br><br>

            We hope this email finds you well. <br>
            We are excited to inform you that you have achieved a certificate at <b>{$datawebname}</b>.<br>
            Your Certificate of Achievement is now available for download.<br><br>

            <strong>To download your certificate, please click the link below:</strong><br>
            <a href='{$downloadurl}' target='_blank' style='
                display:inline-block;
                padding:10px 18px;
                margin-top:8px;
                background:#007BFF;
                color:#fff;
                text-decoration:none;
                border-radius:6px;
                font-weight:bold;
            '>⬇ Download Certificate</a><br><br>

            <strong>Certificate No:</strong> {$ngo_id}/CRT/{$ceti_id}<br><br>

            Should you encounter any difficulties accessing your certificate or have any questions, please do not hesitate to contact our support team:<br><br>
            <a href='mailto:{$webemail_1}' style='color:#007BFF;'>{$webemail_1}</a><br>
             {$site_mobile_1}<br><br>

            Congratulations once again on your achievement, and we hope you find this certificate to be a valuable acknowledgment of your involvement.<br><br>

            Best regards,<br>
             <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a><br>
            {$certificate_provider_name}<br>
            {$designation}<br>
            {$datawebname}
        </div>
    </div>
</div>";



    $mail->AltBody = $email_data['message'];

    $mail->send();

     
            
            $certificate = [
                
                'certificate_status' => 'yes',
                ];
 $userModel = new UserModel();
      $userModel->update($id, $certificate);
            $session=session();
            $session->set("msg","Certificate Generated Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_by_certificate_generate_id');
}catch(Exception $e){
  
  $session=session();
            $session->set("msg","  Certificate Generated Successfully ! Not Email Sent");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_by_certificate_generate_id');
    
}

 }
 
  public function visitor_certificate_by_admin_process(){
$data = $this->request->getPost();

$id = $this->request->getVar('id');


$email = $this->request->getPost('email');
$name = $this->request->getPost('name');
$mobile = $this->request->getPost('mobile');
   helper(['form']);
        /* set rules validation form */
     



           
$data = [
                'user_id'     => $this->request->getVar('id'),
                'name'     => $this->request->getVar('name'),
                'father_name'    => $this->request->getVar('father_name'),
                'program_name'    => $this->request->getVar('program_name'),
                'email'    => $this->request->getVar('email'),
                'mobile'    => $this->request->getVar('mobile'),
                'certificate_img'    => $this->request->getVar('certificate'),
                'apply_type'=>"visitor",
                'gen_date'       => date('Y-m-d H:i:s'),
                'certi_issue_date'=>date('Y-m-d'),
               
            ];
        
         
        
            $certimodel=new CertificateModel();
            $certimodel->save($data);
           $ceti_id = $certimodel->insertID;
           
$downloadurl=base_url('certificate_download_by_admin/'.$ceti_id);
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                           $ngo_id=$web_data['ngo_id'];
                           $weblogo = base_url('websiteLogoImages/'.$web_data['web_logo']);
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = "Congratulations You Have Achieved An Certificate At $datawebname";
    $mail->Body = "
<div style='
    width: 100%;
    max-width: 700px;
    margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;
'>
    <!-- Header -->
    <div style='
        background-image: url({$weblogo});
        background-repeat: no-repeat;
        background-position: center;
        background-size: 280px 280px;
        background-color: #ffffff;
        padding: 40px;
        font-family: Arial, sans-serif;
        color: #000;
    '>
        <!-- Logo and site name -->
        <div style='text-align: center; margin-bottom: 30px;'>
            <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
            <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
        </div>

        <!-- Main content block -->
        <div style='
            background-color: rgba(255,255,255,0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
            font-size: 15px;
            line-height: 1.6;
        '>
            Dear {$name},<br><br>

            We hope this email finds you well.<br>
            We are excited to inform you that you have achieved a certificate at <b>{$datawebname}</b>.<br>
            Your Certificate of Achievement is now available for download.<br><br>

            <strong>To download your certificate, please click the link below:</strong><br>
            <a href='{$downloadurl}' target='_blank' style='
                display:inline-block;
                padding:10px 18px;
                margin-top:8px;
                background:#007BFF;
                color:#fff;
                text-decoration:none;
                border-radius:6px;
                font-weight:bold;
            '> Click Here to Download</a><br><br>

            <strong>Certificate No:</strong> {$ngo_id}/CRT/{$ceti_id}<br><br>

            Should you encounter any difficulties accessing your certificate or have any questions, please do not hesitate to contact our support team at:<br><br>
            <a href='mailto:{$webemail_1}' style='color:#007BFF;'>{$webemail_1}</a><br>
            {$site_mobile_1}<br><br>

            Congratulations once again on your participation, and we hope you find this certificate to be a valuable acknowledgment of your involvement.<br><br>

            Best regards,<br>
             <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a><br>
            {$certificate_provider_name}<br>
            {$designation}<br>
            {$datawebname}
        </div>
    </div>
</div>";
        
        
        
        
        
        
        
    $mail->AltBody = $email_data['message'];

    $mail->send();

     
            
           
            $session=session();
            $session->set("msg","Certificate Generated Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('visitor_certificate_show_admin');
}catch(Exception $e){
  
  $session=session();
            $session->set("msg","Certificate Generated Successfully ! Not Email Sent");
            $session->markAsFlashdata("msg");
             return redirect()->to(previous_url());
    
}

 }
 
 
 public function admin_by_certificate_generate_show(){

     $model=new CertificateModel();
        $users= $model->findall();

                      return view('admin_dashboard/admin_by_certificate_show',['users'=>$users]);


 }
 public function certificate_download_by_admin($user_id=null){

 $model=new CertificateModel();
        $data['user'] = $model->where('certificate_no', $user_id)->first();

        return view('admin_dashboard/certificate_download_by_admin', $data);
     
 }
 
 public function delete_certificate_pdf($user_id=null){
    $model=new CertificateModel();

$certificate = [
                
                 'certificate_status' => 'no'
               
            ];
 $userModel = new UserModel();
      $userModel->update($user_id,$certificate);

 $certmodel=new CertificateModel();
 $data['users'] = $certmodel->where('certificate_no', $user_id)->delete();
 $session=session();
        $session->set("msg","Certificate Deleted For This User.  ");
        $session->markAsFlashdata("msg");
 return redirect()->back();
     
 }
   use ResponseTrait;
public function delete_certificate_pdf_AJAX($id)
{
    
      
        // Validate request is AJAX
        if (!$this->request->isAJAX()) {
            return $this->failForbidden('Direct access not allowed');
        }
        
        // Load model
        $certmodel=new CertificateModel();
        
        // Attempt to delete
        if ($certmodel->delete($id)) {
            return $this->respond([
                'success' => true,
                'message' => 'The user has been deleted successfully and all related data has been removed from the system.'
            ]);
        } else {
            return $this->respond([
                'success' => false,
                'message' => 'Failed to delete user'
            ], 400);
        }

}
 public function download_certificate_pdf($user_id=null){
     
     $model=new CertificateModel();
        $data['users'] = $model->where('user_id', $user_id)->first();
        // $dompdf = new \Dompdf\Dompdf(); 
        // //$dompdf->set('isRemoteEnabled', TRUE);
        // //$dompdf->set_option('isRemoteEnabled', TRUE);
        //  $dompdf->set_option('isRemoteEnabled', TRUE);
        // $dompdf->set_option('defaultMediaType', 'all');
        // $dompdf->set_option('isFontSubsettingEnabled', true);
        // $dompdf->set_option('isPhpEnabled', true);
        // $dompdf->loadHtml(view('admin_dashboard/download_certificate_by_admin.php', $data));
        // $dompdf->setPaper('A4', 'landscape');
        // $dompdf->render();
        // $dompdf->stream();
        return view('admin_dashboard/download_certificate_by_admin.php', $data);
     
 }
 public function admin_status($status, $id){
    
       $model=new UserModel();
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }
    
    $model=new UserModel();
    $selectdata =  $data['users'] = $model->where('id', $id)->first();

if(!empty($selectdata)){
    if($status==="active"){
        $action = 'inactive';
    }
    else{
        $action = 'active';

    }
    $data = [
           "status" => $action,
           "verifie_date" => date('Y-m-d'),
           "expire_date" => date('Y-m-d', strtotime('+1 year')),
           "verifie_by"=>'admin',
    ];
    
    /*$updateStatus = $this->model->update("users",["user_id =>$user_id"], $data);*/
     $model=new UserModel();
    $updateStatus  = $model->update($id, $data);
    if( $updateStatus){
        
        $Webmodel=new Admin_Website_Model();
           $dataweb=$Webmodel->first();
           $web_name = $dataweb['web_name'];
           $owner_name = $dataweb['certificate_provider_name'];
           $designation = $dataweb['designation'];
         $model=new UserModel();
         $data = $model->where('id', $id)->first();
        $name = $data['name'];
           $email = $data['email'];
           $mobile = $data['mobile'];
            //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 
                         
    $dataurl = base_url();                     

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                           $ngo_id=$web_data['ngo_id'];
    
  
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Your Account Has Been Verified At '.$web_name.'';
   $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$mail->Subject = "Account Activated Notification - {$web_name}";

$mail->Body = "
<div style='width: 100%; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background-color: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>
<div style='
    width: 100%;
    max-width: 700px;
    margin: 0 auto;
    padding: 40px;
    background-color: #ffffff;
    background-image: url({$weblogo});
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 280px 280px;
    font-family: Arial, sans-serif;
    color: #000;
    border-radius: 15px;
    box-shadow: 0 0 10px rgba(0,0,0,0.08);
'>

    <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px; margin-bottom: 0;'>{$web_name}</p>
    </div>

    <div style='
        background-color: rgba(255,255,255,0.95);
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.05);
        font-size: 15px;
        line-height: 1.6;
    '>
        Dear {$name},<br><br>

        We regret to inform you that your account on the 
        <span style='font-weight:600;'>{$web_name}</span> website has been 
        <span style='color: red; font-weight: bold;'>blocked</span>.<br><br>

        If you believe this is a mistake or if you have any questions, please contact our support team at 
        <a href='mailto:{$dataweb['webemail_1']}' style='color: #0073e6;'>{$dataweb['webemail_1']}</a> 
        or call us at <span style='font-weight: 600;'>{$dataweb['site_mobile_1']}</span>.<br><br>

        Thank you for your understanding.<br><br>

        Best regards,<br>
        <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a><br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        {$datawebname}
    </div>
</div>
</div>
";


    $mail->AltBody = $email_data['message'];

    $mail->send();
          $session=session();
        $session->set("msg"," User Verified & User Status Now Activated ");
        $session->markAsFlashdata("msg");
            return redirect()->back();
       
    } catch(Exceprion $e){
        $session=session();
        $session->set("msg"," User Verified & User Status Now Activated ");
        $session->markAsFlashdata("msg");
            return redirect()->back();
        
    }
       
       
    }
    else{
        $result =[
            "status" => 404,
             "data" => "Some Error",
         ];
    }
}
    else{
         $result =[
            "status" => 404,
             "data" => "No Record",
         ];
    }
 
}

 public function admin_status_inactive($id, $status){

 
    $model=new UserModel();
    $selectdata =  $data['users'] = $model->where('id', $id)->first();

if(!empty($selectdata)){
    if($status=="active"){
        $action = 'inactive';
    }
    else{
        $action = 'active';

    }
    $data = [
           "status" => $action,
           
         
    ];
    
    
     $model=new UserModel();
    $updateStatus  = $model->update($id, $data);
    if( $updateStatus){
        $session=session();
        $session->set("msg","Deactivate & Unverified User Successfully  ");
        $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
       
    }
    else{
        $result =[
            "status" => 404,
             "data" => "Some Error",
         ];
           return redirect()->back();
    }
}
    else{
         $result =[
            "status" => 404,
             "data" => "No Record",
         ];
           return redirect()->back();
    }
 
}

public function admin_status_inactive_id($id, $status){

 
    $model=new UserModel();
    $selectdata =  $data['users'] = $model->where('id', $id)->first();

if(!empty($selectdata)){
    if($status==="active"){
        $action = 'inactive';
    }
    else{
        $action = 'active';

    }
    $data = [
           "status" => $action,
           
         
    ];
    
    
     $model=new UserModel();
    $updateStatus  = $model->update($id, $data);
    if( $updateStatus){
        
      
          $Webmodel=new Admin_Website_Model();
           $dataweb=$Webmodel->first();
           $datawebname =$dataweb['web_name'];
           $web_name = $dataweb['web_name'];
           $owner_name = $dataweb['certificate_provider_name'];
           $certificate_provider_name  = $dataweb['certificate_provider_name'];
           $designation = $dataweb['designation'];
            $site_url = $dataweb['site_url'];
         $model=new UserModel();
         $data = $model->where('id', $id)->first();
        $name = $data['name'];
           $email = $data['email'];
           $mobile = $data['mobile'];
            //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 
                         
    $dataurl = base_url();                     

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
    
  
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Your Account Has Been '.$action.'. At '.$web_name.'';
   $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$mail->Subject = "Account '.$action.' Notification - {$web_name}";

$mail->Body = "
 <div style='width: 100%; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background-color: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>
 
<div style='
    background-image: url({$weblogo});
    background-repeat: no-repeat;
    background-position: center;
    background-size: 280px 280px;
    background-color: #ffffff;
    padding: 40px;
    font-family: Arial, sans-serif;
    color: #000;
'>

   
    <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_name}</p>
    </div>

    
    <div style='
        background-color: rgba(255,255,255,0.9);
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.05);
    '>
        Dear {$name},<br><br>

        We regret to inform you that your account on the 
        <span style='font-weight:600;'>{$web_name}</span> website has been <span style='color: red; font-weight: bold;'>blocked</span>.<br><br>

   

        If you believe this is a mistake or if you have any questions, please contact our support team at 
        <a href='mailto:{$dataweb['webemail_1']}'>{$dataweb['webemail_1']}</a> or call us at {$dataweb['site_mobile_1']}.<br><br>

        Thank you for your understanding.<br><br>

        Best regards,<br>
        <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a><br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        {$datawebname}
    </div>
</div>
</div>
";

    $mail->AltBody = $email_data['message'];

    $mail->send();
         $session=session();
        $session->set("msg","This User $action Successfully");
        $session->markAsFlashdata("msg");
            return redirect()->back();
       
    } catch(Exceprion $e){
        $session=session();
        $session->set("msg","User $action successfully. Account access is restricted until '.$action.' by admin.");
        $session->markAsFlashdata("msg");
            return redirect()->back();
        
    }
      
        
        
        
        $session=session();
        $session->set("msg","User $action successfully. Account access is restricted until '.$action.' by admin.");
        $session->markAsFlashdata("msg");
            return redirect()->back();
       
    }
    else{
        $result =[
            "status" => 404,
             "data" => "Some Error",
         ];
         return redirect()->back();
    }
}
    else{
         $result =[
            "status" => 404,
             "data" => "No Record",
         ];
           return redirect()->back();
    }
 
}
public function admin_user_status_block($id, $status){
    $model=new UserModel();
  $response_msg = $this->request->getVar('response_msg');
  
  /*$model=new CommonModel();*/
  $selectdata = $model->where('id', $id)->first();

if(!empty($selectdata)){
    if($status==="active"){
        $action = 'block';
    }
    else{
        $action = 'active';

    }
    $data = [
           "status" => $action,
           "response_msg" => $response_msg,
            "response_by" => 'Admin',
            "block_date"       => date('Y-m-d H:i:s'),
    ];
    
    $model=new UserModel();
    $updateStatus = $model->update($id, $data);
    if( $updateStatus){
     
          $Webmodel=new Admin_Website_Model();
           $dataweb=$Webmodel->first();
           $web_name = $dataweb['web_name'];
           $owner_name = $dataweb['certificate_provider_name'];
           $designation = $dataweb['designation'];
         $model=new UserModel();
         $data = $model->where('id', $id)->first();
        $name = $data['name'];
           $email = $data['email'];
           $mobile = $data['mobile'];
           $Webmodel=new Admin_Website_Model();
           $dataweb=$Webmodel->first();
           $datawebname = $dataweb['web_name'];
           $certificate_provider_name = $dataweb['certificate_provider_name'];
           $designation = $dataweb['designation'];
           $webemail = $dataweb['webemail_1'];
           $webmobile = $dataweb['site_mobile_1'];
         $model=new UserModel();
         $data = $model->where('id', $id)->first();
        $name = $data['name'];
           $email = $data['email'];
           $mobile = $data['mobile'];
           $site_url = $dataweb['site_url'];
            //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 
                         
    $dataurl = base_url();                     

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
     $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                           
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
        $weblogo = base_url('websiteLogoImages/'.$web_data['web_logo']);
  
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Your '.$web_name.' Account Has Been Temporarily Suspended';
$weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$mail->Subject = "Account Blocked Notification - {$web_name}";

$mail->Body = "
<div style='width: 100%;
    max-width: 700px;
    margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

    <div style=\"
        background-image: url({$weblogo});
        background-repeat: no-repeat;
        background-position: center;
        background-size: 280px 280px;
        background-color: #ffffff;
        padding: 40px;
        font-family: Arial, sans-serif;
        color: #000;
    \">

        <!-- Logo & Site Name Header -->
        <div style='text-align: center; margin-bottom: 30px;'>
            <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
            <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'> {$web_name}</p>
        </div>

        <!-- Main Content Area -->
        <div style='
            background-color: rgba(255,255,255,0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        '>
             Dear {$name},<br><br>

            We regret to inform you that your account on the  
            <span style='font-weight:600;'>{$web_name}</span> website has been 
            <span style='color: red; font-weight: bold;'> blocked</span>.<br><br>

        <strong>Reason for Blocking:</strong><br>
            {$response_msg}<br><br>

             If you believe this is a mistake or if you have any questions, please contact our support team at  
            <a href='mailto:{$dataweb['webemail_1']}'> {$dataweb['webemail_1']}</a> or call us at  {$dataweb['site_mobile_1']}.<br><br>

            Thank you for your understanding.<br><br>

            Best regards,<br>
            {$certificate_provider_name}<br>
            {$designation}<br>
            {$datawebname}<br>
            <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a>
        </div>
    </div>
</div>
";


    $mail->AltBody = $email_data['message'];

    $mail->send();
         $session=session();
        $session->set("msg","User blocked successfully. Account access is restricted until unblocked by admin.");
        $session->markAsFlashdata("msg");
            return redirect()->back();
       
    } catch(Exceprion $e){
        $session=session();
        $session->set("msg","User blocked successfully. Account access is restricted until unblocked by admin.");
        $session->markAsFlashdata("msg");
            return redirect()->back()->withInput();
        
    }
        
    }
    else{
        $result =[
            "status" => 404,
             "data" => "Some Error",
         ];
         $session=session();
        $session->set("error","Some Issues Here");
        $session->markAsFlashdata("msg");
            return redirect()->back()->withInput();
    }
}
    else{
         $result =[
            "status" => 404,
             "data" => "No Record",
         ];
         $session=session();
       $session->set("error","Some Issues Here");
        $session->markAsFlashdata("msg");
            return redirect()->back()->withInput();
    }
    
    
}
public function admin_user_status_unblock($id, $status){
    



  $response_msg = $this->request->getVar('response_msg');
  
  $model=new UserModel();
  $selectdata=  $model->where('id', $id)->first();

if(!empty($selectdata)){
    if($status==="active"){
        $action = 'block';
    }
    else{
        $action = 'active';

    }
    $data = [
           "status" => $action,
           "response_msg" => $response_msg,
    ];
   
    $model=new UserModel();
    $updateStatus = $model->update($id, $data);
    if( $updateStatus){
        
         $Webmodel=new Admin_Website_Model();
           $dataweb=$Webmodel->first();
           $web_name = $dataweb['web_name'];
           $owner_name = $dataweb['certificate_provider_name'];
           $designation = $dataweb['designation'];
           $site_url= $dataweb['site_url'];
         $model=new UserModel();
         $data = $model->where('id', $id)->first();
        $name = $data['name'];
           $email = $data['email'];
           $mobile = $data['mobile'];
            //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 $dataurl = base_url();                     

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
    
     $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                           
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
        $weblogo = base_url('websiteLogoImages/'.$web_data['web_logo']);
    
  
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Account Unblocked Notification At  '.$web_name.'';
    $mail->Body = "
<div style='width: 100%;
    max-width: 700px;
    margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

    <div style=\"
        background-image: url({$weblogo});
        background-repeat: no-repeat;
        background-position: center;
        background-size: 280px 280px;
        background-color: #ffffff;
        padding: 40px;
        font-family: Arial, sans-serif;
        color: #000;
    \">

        <!-- Logo and site name -->
        <div style='text-align: center; margin-bottom: 30px;'>
            <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
            <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'> {$web_name}</p>
        </div>

        <!-- Main content block -->
        <div style='
            background-color: rgba(255,255,255,0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        '>
             Dear {$name},<br><br>

            We are pleased to inform you that your account on the <span style='font-weight:600;'>{$web_name}</span> website has been unblocked and you can now access all features and services.<br><br>

            If you have any questions or need further assistance, please feel free to contact our support team at 
            <a href='mailto:{$dataweb['webemail_1']}'>{$dataweb['webemail_1']}</a> or call us  {$dataweb['site_mobile_1']}.<br><br>

            Thank you for your understanding.<br><br>

            Best regards,<br>
            {$owner_name}<br>
            {$designation}<br>
            {$web_name}<br>
            <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a>
        </div>
    </div>
</div>";




    $mail->AltBody = $email_data['message'];

    $mail->send();
        
          $session=session();
        $session->set("msg","This User Unblocked  & User Status Verified Successfully");
        $session->markAsFlashdata("msg");
            return redirect()->back();
       
    }catch(Exception $e){
        
          $session=session();
        $session->set("msg","This User Unblocked  & User Status Verified Successfully ! But Email Not Sent");
        $session->markAsFlashdata("msg");
            return redirect()->back();
    }
        
    }
    else{
        $result =[
            "status" => 404,
             "data" => "Some Error",
         ];
    }
}
    else{
         $result =[
            "status" => 404,
             "data" => "No Record",
         ];
    }
    
    
}
public function indcard_verifie($id){
       
        $model=new UserModel();
      $data['users'] = $model->where('id', $id)->first();
      
        return view('admin_dashboard/indcard_verifie', $data);
}

public function admin_show_user_details($id){
       
        $model=new UserModel();
      $data['users'] = $model->where('id', $id)->first();
        return view('admin_dashboard/admin_show_user_details', $data);
}
public function admin_send_reason_user(){
    
   $reason_msg = $this->request->getVar('reason_msg');
    $id = $this->request->getVar('id');
  
    $data = [
           
           "reason_msg" => $reason_msg,
    ];
    
   if($data){
   
    $model=new UserModel();
    $updateStatus = $model->update($id, $data);
    if( $updateStatus){
        
          $session=session();
        $session->set("msg","Message Sent User ");
        $session->markAsFlashdata("msg");
            return redirect()->to('admin_show_inactive_user');
       
    }
    else{
        $result =[
            "status" => 404,
             "data" => "Some Error",
         ];
    }
}
    else{
         $result =[
            "status" => 404,
             "data" => "No Record",
         ];
    } 
    
}

public function payment_status($user_id, $payment_status){
   
   
   $model=new CommonModel();
$selectdata = $this->model->selectRow("users",["user_id" =>$user_id]);

if(!empty($selectdata)){
    
    if($payment_status===0){
        $action = "0";
    }
    else{
        $action = "1";

    }
    $data = [
           "payment_status" => $action
    ];
   
    /*$updateStatus = $this->model->update("users",["user_id =>$user_id"], $data);*/
    $updateStatus = $this->model->set('payment_status', $data)->where('user_id',$user_id)->update();
    if( $updateStatus){
                      
             
            return redirect()->to('admin_dashboard');
       
    }
    else{
        $result =[
            "status" => 404,
             "data" => "Some Error",
         ];
    }
}
    else{
         $result =[
            "status" => 404,
             "data" => "No Record",
         ];
    }
}
public function notice_board_show($user_id=null){
      
    $userModel = new UserModel();
    $users['users'] = $userModel->where('user_id', $user_id)->first();

                  return view('admin_dashboard/admin_by_notice_form', $users);

}
public function aadmin_user_notice_data(){
    $id = $this->request->getVar('id');
   $tittle= $this->request->getVar('tittle');
   $subject = $this->request->getVar('subject');
  $description= $this->request->getVar('description');
     $userModel = new UserModel();
     $data = $userModel->where('id', $id)->first();
     $name=$data['name'];
       $email = $data['email'];
         $mobile = $data['mobile'];
    helper(['form']);
    /* set rules validation form */
    $rules = [
        'tittle'          => 'required|min_length[3]|max_length[50]',
        'description'         => 'required',
        
    ];
     
    if($this->validate($rules)){
      $data = [
            'user_id'     => $this->request->getVar('id'),
            'subject'     => $this->request->getVar('subject'),
            'tittle'    => $this->request->getVar('tittle'),
             'description'    => $this->request->getVar('description'),
             'notice_date'       => date('Y-m-d H:i:s'),
           
        ];

        $modelNotice=new AdminNoticeModel();
        $notice=$modelNotice->save($data);
       if($notice == TRUE){
    $Webmodel=new Admin_Website_Model();
           $dataweb=$Webmodel->first();
           $datawebname = $dataweb['web_name'];
           $certificate_provider_name = $dataweb['certificate_provider_name'];
           $designation = $dataweb['designation'];
           $webemail = $dataweb['webemail_1'];
           $webmobile = $dataweb['site_mobile_1'];
         $model=new UserModel();
         $data = $model->where('id', $id)->first();
        $name = $data['name'];
           $email = $data['email'];
           $mobile = $data['mobile'];
           $site_url = $dataweb['site_url'];
            //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 
                         
    $dataurl = base_url();                     

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
    
  
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Important Notice From '.$datawebname.'';
  $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$mail->Subject = "Important Notice from {$datawebname}";

$mail->Body = "
<div style='width: 100%;
    max-width: 700px;
    margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark -->
  <div style=\"
      background-image: url({$weblogo});
      background-repeat: no-repeat;
      background-position: center;
      background-size: 280px 280px;
      background-color: #ffffff;
      padding: 40px;
      font-family: Arial, sans-serif;
      color: #000;
  \">

    <!-- Logo & Title -->
    <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$datawebname}</p>
    </div>

    <!-- Notice Message Box -->
    <div style='
        background-color: rgba(255,255,255,0.92);
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.05);
        font-size: 16px;
        line-height: 1.6;
        color: #333;
    '>
        Dear {$name},<br><br>

        We hope this email finds you well. We have an important notice for you. Please read it carefully and respond if required.<br><br>

        <strong>Notice Title:</strong> {$tittle}<br>
        <strong>Notice Subject:</strong> {$subject}<br>
        <strong>Notice Message:</strong><br>
        {$description}<br><br>

        If you have any questions, please do not hesitate to contact our support team:<br><br>

        <!-- Email icon -->
         <a href='mailto:{$webemail}' style='color:#ff4b2b;'>{$webemail}</a><br>
        <!-- Phone icon -->
         {$webmobile}<br>
        <!-- Website icon -->
         <a href='https://www.{$site_url}' target='_blank' style='color:#ff416c;'>www.{$site_url}</a><br><br>

        Thank you for your understanding.<br><br>

        Best regards,<br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        <strong>{$datawebname}</strong>
    </div>
  </div>
</div>
";


    $mail->AltBody = $email_data['message'];

    $mail->send();
        $session=session();
        $session->set("msg","  Notice has been sent to this user successfully.");
        $session->markAsFlashdata("msg");
         return redirect()->to('admin_send_notice_user');
}  catch(Exception $e){
      $session=session();
        $session->set("msg","  Notice has been sent to this user successfully. ! Not Sent Email");
        $session->markAsFlashdata("msg");
         return redirect()->to('admin_send_notice_user');
}
        
    }
}


    else
    {
        $data['validation'] = $this->validator;
        $session=session();
        $session->set("msg","  User ! Details somethings wrong ? ");
        $session->markAsFlashdata("msg");
        echo view('admin_dashboard/index',$data);
    }
}

public function view_notice_details($id){
     $model=new AdminNoticeModel();
    
     $data['users'] = $model->where('id', $id)->first();
    
      return view('admin_dashboard/view_notice_details', $data);
}

public function aadmin_alluser_notice_data(){
    $id = $this->request->getVar('id');
   $tittle= $this->request->getVar('tittle');
   $subject = $this->request->getVar('subject');
  $description= $this->request->getVar('description');
  $userModel = new UserModel();
        $users = $userModel->findAll();
        
   helper(['form']);
    /* set rules validation form */
    $rules = [
        'tittle'          => 'required|min_length[3]|max_length[50]',
        'description'         => 'required',
        
    ];
     
    if($this->validate($rules)){
      $data = [
            'user_id'     => "direct",
            'subject'     => $this->request->getVar('subject'),
            'tittle'    => $this->request->getVar('tittle'),
             'description'    => $this->request->getVar('description'),
            'notice_date'       => date('Y-m-d H:i:s'),
           
        ];
  
 
        $model=new AdminNoticeModel();
       $sendMail =  $model->save($data);
       
       if($sendMail == TRUE){
           $Webmodel=new Admin_Website_Model();
           $dataweb=$Webmodel->first();
           $web_name = $dataweb['web_name'];
           $datawebname = $dataweb['web_name'];
           $owner_name = $dataweb['certificate_provider_name'];
           $certificate_provider_name = $dataweb['certificate_provider_name'];
           $designation = $dataweb['designation'];
           $site_url = $dataweb['site_url'];
           
         //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 
                         
    $dataurl = base_url();                     

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
    
                                 
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
 foreach ($users as $user) {
    
    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($user['email'], $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
     $mail->addCC($user['email']);
    // $mail->addBCC($user['email']);
}
    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Important Notice From  '.$datawebname.'';
   $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);
$web_name = $dataweb['web_name'];
$webemail = $dataweb['webemail_1'];
$webmobile = $dataweb['site_mobile_1'];
$owner_name = $dataweb['certificate_provider_name'];
$designation = $dataweb['designation'];

$mail->Subject = "Important Notice from {$web_name}";

$mail->Body = "
<div style='width: 100%;
    max-width: 700px;
    margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark -->
  <div style=\"
      background-image: url({$weblogo});
      background-repeat: no-repeat;
      background-position: center;
      background-size: 280px 280px;
      background-color: #ffffff;
      padding: 40px;
      font-family: Arial, sans-serif;
      color: #000;
  \">

    <!-- Header with logo -->
    <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
        <p style='font-size: 24px; font-weight: bold; margin-top: 10px;'>{$web_name}</p>
    </div>

    <!-- Notice content -->
    <div style='
        background-color: rgba(255, 255, 255, 0.94);
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.05);
    '>
        Dear <b>Member</b>,<br><br>

        We hope this email finds you well. We have some notice for you — please read it carefully & respond if required.<br><br>

        <b>Notice Title:</b> {$tittle}<br>
        <b>Notice Subject:</b> {$subject}<br>
        <b>Notice Message:</b> {$description}<br><br>

        If you have any questions, please do not hesitate to contact our support team:<br><br>

        <!-- Email icon -->
         <a href='mailto:{$webemail}'>{$webemail}</a><br>
        <!-- Phone icon -->
         {$webmobile}<br>
        <!-- Website icon -->
         <a href='https://www.{$dataweb['site_url']}' target='_blank'>www.{$dataweb['site_url']}</a><br><br>

        Thank you for your understanding.<br><br>

        Best regards,<br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        {$datawebname}
    </div>
  </div>
</div>
";

    $mail->AltBody = $email_data['message'];

    $mail->send();
              
        
        $session=session();
        $session->set("msg","  Notice Sent All Member Successfully");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_send_notice_user');
 

 
    }
    catch(Exception $e){
        $session=session();
        $session->set("msg","  Notice Sent All Member Successfully ! Email Not Send");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_send_notice_user');
        
    }
           
       }
        
    }



    else
    {
        $data['validation'] = $this->validator;
        $session=session();
        $session->set("msg","  User ! Details somethings wrong ? ");
        $session->markAsFlashdata("msg");
        echo view('admin_dashboard/index',$data);
    }  
    
}
public function post_board_show($user_id=null){

       
    $userModel = new UserModel();
    $users['users'] = $userModel->where('user_id', $user_id)->first();

                  return view('admin_dashboard/admin_by_post_form', $users);
}

public function admin_by_post_generate(){

 helper(['form']);
    /* set rules validation form */
    $rules = [
        'tittle'          => 'required|min_length[3]|max_length[50]',
        'description'         => 'required',
        
    ];
    $fileinfo = $this->request->getFile('post_img');
    if(!empty($fileinfo))
    {
        $filename = $fileinfo->getName();
        $nameArray = explode(".",$filename);
        $newfileName = time().".". end($nameArray); 
        if($fileinfo->move("post_images",$newfileName))
         {
    if($this->validate($rules))
    {
      $data = [
            'user_id'     => $this->request->getVar('user_id'),
            'user_type'     => $this->request->getVar('user_type'),
            'tittle'    => $this->request->getVar('tittle'),
             'description'    => $this->request->getVar('description'),
             'deadline_date'    => $this->request->getVar('deadline_date'),
             'post_img'  =>   $newfileName,
             'post_date'       => date('Y-m-d H:i:s'),
           
        ];
       


        $model=new AdminPostModel();
        $model->save($data);
        $session=session();
        $session->set("msg","  Notice Board Generate Successfully ");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard');
    }

        }
    }

    else
    {
        $data['validation'] = $this->validator;
        $session=session();
        $session->set("msg","  User ! Details somethings wrong ? ");
        $session->markAsFlashdata("msg");
        echo view('admin_dashboard',$data);
    }


}

public function admin_by_post_form()
{
    return view('admin_dashboard/post_frame_by_admin');

}
public function comment_post(){
    helper(['form']);
    /* set rules validation form */
    $rules = [
       
        'comment_text'         => 'required',
        
    ];
    
         
    if($this->validate($rules))
    {
      $data = [
            'user_id'     => $this->request->getVar('user_id'),
            'post_id'     => $this->request->getVar('post_id'),
           
           
             
             'comment_text'    => $this->request->getVar('comment_text'),
            
             'comment_date'       => date('Y-m-d H:i:s'),
           
        ];
  


        $model=new Comment_Model();
        $model->save($data);
        $session=session();
        $session->set("msg","  Hi, This Post on Comment You  ðŸ˜Š ");
        $session->markAsFlashdata("msg");
        return redirect()->to('user_dashboard');
    }

        
    

    else
    {
        $data['validation'] = $this->validator;
        $session=session();
        $session->set("msg","  User ! Details somethings wrong ? ");
        $session->markAsFlashdata("msg");
        echo view('user_dashboard',$data);
    }

}
public function like_post(){

    helper(['form']);
    /* set rules validation form */
    $rules = [
       
        'like'         => 'required',
        
    ];
    
         
    if($this->validate($rules))
    {
      $data = [
            'user_id'     => $this->request->getVar('user_id'),
            'post_id'     => $this->request->getVar('post_id'),
           
           
             
             'like'    => $this->request->getVar('like'),
            
             'like_date'       => date('Y-m-d H:i:s'),
           
        ];
  


        $model=new Like_Model();
        $model->save($data);
        $session=session();
        $session->set("msg","  Hi, This Post on Like You  ðŸ˜Š ");
        $session->markAsFlashdata("msg");
        return redirect()->to('user_dashboard');
    }

        
    

    else
    {
        $data['validation'] = $this->validator;
        $session=session();
        $session->set("msg","  User ! Details somethings wrong ? ");
        $session->markAsFlashdata("msg");
        echo view('user_dashboard/user_dashboard',$data);
    }
}
public function delete($user_id=null){
    $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
        } else {
      return redirect()->back()
                         ->with('msg', 'Not Access');
    }
      $userModel = new UserModel();

 $data['users'] = $userModel->where('id', $user_id)->delete();

 return redirect()->to( base_url('user_show_by_admin') );
    
}

public function delete_notice($id){
    $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
        
 $noticeModel = new AdminNoticeModel();

 $data = $noticeModel->where('id', $id)->delete();
 if($data){
      $session=session();
        $session->set("msg","This notice has been deleted successfully!");
        $session->markAsFlashdata("msg");
      return redirect()->to( base_url('notice_view_admin') );    
 }else{
     $session=session();
        $session->set("msg","This Notice Deleted Fail!");
        $session->markAsFlashdata("msg");
      return redirect()->to( base_url('notice_view_admin') );    
 }


    
}
public function delete_donation_receipt_pdf($user_id){
    $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
      $trans= new Donote_TransactionModel();

 $data = $trans->where('id', $user_id)->delete();
$session=session();
          if($data){      

            return redirect()->back()
                         ->with('msg', 'Donation Receipt Delete Successfully !');
          }else{
             return redirect()->back()
                         ->with('msg', 'Donation Receipt Delete Fail !');
          }
    
}
 
public function admin_by_user_delete($user_id=null)
{
     $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
    
      $userModel = new UserModel();

 $data['users'] = $userModel->where('id', $user_id)->delete();

 return redirect()->to( base_url('admin_show_verifie_user') );
    
}
 
    use ResponseTrait;
  

public function deleteAjax($id)
{ 
   $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
    $session = session();
    $userModel = new \App\Models\UserModel();

    if (!is_numeric($id)) {
        return redirect()->back()->with('msg', 'Invalid user ID');
    }

    if ($userModel->delete($id)) {
      return redirect()->back()
                         ->with('msg', 'The user has been deleted successfully and all related data has been removed from the system.');
    } else {
      return redirect()->back()
                         ->with('msg', 'Failed to delete user');
    }
        
}


public function admin_by_manager_delete($user_id=null){
    $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
    
      $userModel = new UserModel();

 $data['users'] = $userModel->where('id', $user_id)->delete();

 return redirect()->to( base_url('admin_show_manager') );
    
}

public function edit_user_view($user_id, $redirectURL){
    $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
   $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
    if($data){
        $data['redirectURL'] =$redirectURL;
    $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
      
        return view('admin_dashboard/update_profile', $data);
    }else{
        return redirect()->back();
    }
    
}

public function update_admin_profile(){
   
    $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
   
    helper(['form']);

    $rules = [
        'name'        => 'required',
        'father_name' => 'required',
    ];

    if (!$this->validate($rules)) {
        // Agar validation fail ho jaye to redirect back with errors
        return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
    }
     
  
    
     $token = bin2hex(random_bytes(50));
     $userModel = new UserModel();
    $session = session();

    $id = $this->request->getPost('id');
    $postData = $this->request->getPost();
$redirectURL = $this->request->getPost('redirectURL');
    $data = [
        'name'            => $this->request->getPost('name'),
        'father_name'     => $this->request->getPost('father_name'),
        'blood_group'  => $this->request->getPost('blood_group'),
        'married_status'  => $this->request->getPost('married_status'),
        'gender'          => $this->request->getPost('gender'),
        'mobile'          => $this->request->getPost('mobile'),
        'state'           => $this->request->getPost('state'),
        'district'        => $this->request->getPost('district'),
        'address'         => $this->request->getPost('address'),
        'designation'     => $this->request->getPost('designation'),
        'aadhar_card_no'  => $this->request->getPost('aadhar_card_no'),
        'profile_update'  => date('Y-m-d H:i:s')
    ];
    
    if (!empty($postData['day']) && !empty($postData['month']) && !empty($postData['year'])) {
        $data['dob'] = "{$postData['day']}-{$postData['month']}-{$postData['year']}";
    }
    
    $profileImage = $this->request->getFile('profile');
    if ($profileImage && $profileImage->isValid() && !$profileImage->hasMoved()) {
        try {
            $newFileName = $profileImage->getRandomName();
            if ($profileImage->move("images", $newFileName)) {
                $data['profile'] = $newFileName;
                
               
                $oldUser = $userModel->find($postData['id']);
                if (!empty($oldUser['profile']) && file_exists("images/".$oldUser['profile'])) {
                    unlink("images/".$oldUser['profile']);
                }
            }
        } catch (\Exception $e) {
            log_message('error', 'Profile image upload failed: '.$e->getMessage());
        }
    }
    
    if ($userModel->update($id, $data)) {
        if($redirectURL =="admin_show_verifie_user"){
        $session->setFlashdata('msg', 'User profile details have been updated successfully.');
          return redirect()->to(base64_encode('adminShowVerifieUser'."_".$token));
    }
    
    if($redirectURL =="admin_show_inactive_user"){
        $session->setFlashdata('msg', 'User profile details have been updated successfully.');
          return redirect()->to('admin_show_inactive_user');
    }
    
    if($redirectURL =="user_show_by_admin"){
        $session->setFlashdata('msg', 'User profile details have been updated successfully.');
          return redirect()->to('user_show_by_admin');
    }
    } else {
        $session->setFlashdata('msg', 'Something went wrong while updating your profile.');
        return redirect()->back()->withInput();
    }    
                    
    }

public function admin_update_user_profile(){
    
    $userModel = new UserModel();
   
     $user_id = $this->request->getPost('user_id');
     $dob = $this->request->getPost('dob');
      $name = $this->request->getPost('name');
     $father_name = $this->request->getPost('father_name'); 
     $reference_name = $this->request->getPost('reference_name'); 
     $mobile = $this->request->getPost('mobile'); 
     $address = $this->request->getPost('address');
      $district = $this->request->getPost('district');
        $state = $this->request->getPost('state');
     $aadhar_card_no = $this->request->getPost('aadhar_card_no');
     $nationality = $this->request->getPost('nationality');
     $designation = $this->request->getPost('designation');
     $level = $this->request->getPost('level');
     $profile = $this->request->getFile('profile');


/*image upload*/
$fileinfo = $this->request->getFile('profile');
      
      
            if (file_exists($fileinfo)){
                $filename= $fileinfo->getName();
                $nameArray = explode(".",$filename);
                $newfileName= time().".". end($nameArray); 
                if($fileinfo->move("images",$newfileName)){

                   $data = [
                'user_id'     => $user_id,
                'name'=>$name,
                 'dob'     => $dob,
                 'father_name'     => $father_name,

                  'reference_name'     => $reference_name,

                    'mobile'     => $mobile,

                     'address'     => $address,
                      'district'     => $district,
                      'state'=>$state,
                      'aadhar_card_no'     => $aadhar_card_no,

                      'nationality'     => $nationality,

                      'designation'     => $designation,

                      'level'     => $level,

                      'profile'=>$newfileName,
                       
                      'profile_update'=> date('Y-m-d H:i:s'),

                
    ];
   
  
     $userModel = new UserModel();
         $result = $userModel->where(["id" =>$user_id])
                   ->set($data)
                   ->update();
         /*= $this->userModel->update($user_id, $data);*/
         if($result){
             $userModel = new UserModel();
        $data['user_obj'] = $userModel->where('id', $user_id)->first();
       
             
               $session=session();
                    $session->set("msg","Your Profile Details Update Successfully ! ");
                    $session->markAsFlashdata("msg");
                    
            return redirect()->to('admin_show_verifie_user');
         }
         else{
            $session=session();
                    $session->set("msg","Your Profile Details Update Successfully ! ");
                    $session->markAsFlashdata("msg");
                    
            return view('admin_dashboard/index');
         }
                }
                
                else{
                     $session=session();
                    $session->set("msg","Your Details Some things Wrong ? ");
                    $session->markAsFlashdata("msg");
                    
             return view('admin_dashboard/index');
                }
                    
                }
                else
                    {
                         $session=session();
                    $session->set("msg","User profile details updated successfully!");
                    $session->markAsFlashdata("msg");
                    
             return view('admin_dashboard/index');
                
                }
                    
                   
                }

public function add_manager_by_admin($id = null)
{
     $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
    
    $userModel = new UserModel();

    $data['heading'] = "Add Manager";
    $data['user'] = $id ? $userModel->where('id', $id)->first() : null;

    return view('admin_dashboard/add_manager_by_admin', $data);
}

public function edit_manager($id)
{
     $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
    $session = session();
    $userModel = new UserModel();

    $data['heading'] = "Update Manager";
    $data['manager'] = $userModel->where('id', $id)->first();
    $data['session'] = $session; // Pass session to view

    return view('admin_dashboard/add_manager_by_admin', $data);
}

public function signup_manager_by_admin()
{
     $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
    helper(['form']);
    $session = session();
    $model = new UserModel();

    $manager_id = $this->request->getVar('manager_id'); // Check if updating
    $is_update = !empty($manager_id);

    // Common fields
    $name      = $this->request->getVar('name');
    $email     = $this->request->getVar('email');
    $mobile    = $this->request->getVar('mobile');
    $user_type = $this->request->getVar('user_type');
    $password  = $this->request->getVar('password');

    // Validation rules
    $rules = [
        'name'  => 'required|min_length[3]|max_length[50]',
        'mobile' => 'required|numeric|min_length[10]|max_length[10]',
        'profile' => $is_update ? 'if_exist|uploaded[profile]|max_size[profile,2048]|is_image[profile]' 
                                : 'uploaded[profile]|max_size[profile,2048]|is_image[profile]',
    ];

    // For insert, require email unique + password
    if (!$is_update) {
        $rules['email'] = 'required|valid_email|is_unique[users.email]';
        $rules['password'] = 'required|min_length[6]';
    }

    if (!$this->validate($rules)) {
        return view('admin_dashboard/add_manager_by_admin', [
            'validation' => $this->validator,
            'heading' => $is_update ? 'Update Manager' : 'Add Manager'
        ]);
    }

    // File upload (if any)
    $file = $this->request->getFile('profile');
    $newFileName = null;
    if ($file && $file->isValid() && !$file->hasMoved()) {
        $newFileName = time() . '_' . $file->getRandomName();
        $file->move(FCPATH . 'images', $newFileName);
    }

    // Prepare data array
    $data = [
        'name'       => $name,
        'mobile'     => $mobile,
        'email'      => $email,
        'admin_id'   => $this->request->getVar('user_id'),
        'user_type'  => $user_type,
        'status'     => 'active',
    ];

    // Set profile if uploaded
    if ($newFileName) {
        $data['profile'] = $newFileName;
    }

    // If not update, hash password
    if (!$is_update) {
        $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        $data['created_at'] = date('Y-m-d H:i:s');
    } else {
        $data['updated_at'] = date('Y-m-d H:i:s');
    }


    if ($is_update) {
        $model->update($manager_id, $data);
        $session->setFlashdata('msg', 'Manager updated successfully!');
    } else {
        $model->insert($data);
        $session->setFlashdata('msg', 'Manager created successfully!');

        // Optionally send email to new manager
        $this->sendManagerWelcomeEmail($email, $name, $password, $user_type);
    }

    return redirect()->to(base_url('admin_show_manager'));
}

 
 public function sendManagerWelcomeEmail($email, $name, $password, $user_type){
    
                 
                 
                 require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 
                         
              

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                            
                             $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                       $site_url=$dataweb['site_url'];
                        $certificate_provider_name= $dataweb['certificate_provider_name'];
                              $designation= $dataweb['designation'];
                              $datawebname= $dataweb['web_name'];
                              
             $weblogo = base_url('websiteLogoImages/'.$dataweb['web_logo']);
  
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
   $mail->Subject = ' You Are Invited As A Manager At '.$dataweb['web_name'].'';
   
    $mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark -->
  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center;
    background-size: 280px 280px;
    background-color: #ffffff;
    padding: 40px;
    font-family: Arial, sans-serif;
    color: #000;
  \">

    <!-- Logo and site name -->
    <div style='text-align: center; margin-bottom: 30px;'>
      <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;' alt='Logo'>
      <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
    </div>

    <!-- Main content block -->
    <div style='
        background-color: rgba(255,255,255,0.9);
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.05);
        font-size: 16px;
        line-height: 1.6;
        color: #333;
    '>
      Dear {$name},<br><br>

      I hope this email finds you well.<br><br>

      I am pleased to inform you that a <span style='font-weight:600;'>manager account</span> has been successfully created for you on our organization website, 
      <a href='https://www.{$dataweb['site_url']}' target='_blank'>www.{$dataweb['site_url']}</a>, 
      to assist in managing various aspects of our online presence.<br><br>

      <strong>Your manager account credentials are as follows:</strong><br><br>
      <span style='font-weight:600;'>Username:</span> {$email}<br>
      <span style='font-weight:600;'>Password:</span> {$password}<br>
      <span style='font-weight:600;'>Account Type:</span> {$user_type}<br><br>

      As a manager, you will have access to the backend of our website, where you can perform tasks such as content management, user administration, and website customization.<br><br>

      Please log in to your account using the provided credentials and familiarize yourself with the available features and functionalities. 
      If you encounter any difficulties or have any questions, feel free to reach out to me or our technical support team for assistance.<br><br>

      We trust that you will utilize this privilege responsibly and contribute to the effective management and optimization of our website.<br><br>

       <strong>Please ensure to keep your password secure</strong> and do not share it with anyone. You can use the provided credentials to log in to your account and explore our services.<br><br>

      If you have any questions or require assistance, feel free to contact our support team at 
      <a href='mailto:{$dataweb['webemail_1']}' style='color:#ff4b2b;'>{$dataweb['webemail_1']}</a>. 
      We are here to help you every step of the way.<br><br>

      Thank you for your cooperation and dedication to our website 
      <a href='https://www.{$dataweb['site_url']}' target='_blank'>www.{$dataweb['site_url']}</a>.<br><br>

      Best regards,<br>
        <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a><br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        {$datawebname}
    </div>
  </div>
</div>
";




    $mail->AltBody = $email_data['message'];

    $mail->send();
   $session=session();
            $data['validation'] = $this->validator;
            
              
            $userModel = new UserModel();
            $data = $userModel->where('id', $session->id)->first();
            
            $sess_data = [
                           'id'=> $data['id'],
                            'loginned' =>'loginned',
                ];

                 $session=session();
               $session->set($sess_data);
               
               
               
               
             
            $session=session();
            $session->set("msg","Manager Created Successfully");
            $session->markAsFlashdata("msg");
            $this->updateNotificationCount();
            return redirect()->to('admin_show_manager');
} 



catch (Exception $e) {
    $session=session();
            $data['validation'] = $this->validator;
            $session->set("msgemail","Email Id Not Registered Enter Valid Email ?");
            $session->markAsFlashdata("msgemail");
            return view('admin_show_manager');
}
           
         
    } 
    
     private function updateNotificationCount()
    {
        $session = \Config\Services::session();

        // Get the current count or initialize to 0
        $adminNotificationCount = $session->get('admin_notification_count') ?? 0;

        // Increment the count
        $adminNotificationCount++;

        // Update the session
        $session->set('admin_notification_count', $adminNotificationCount);
    }
    
    public function notice_view_admin(){
        
         $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
        
    $noticeModel=  new  AdminNoticeModel();
    $data['notice']= $noticeModel->findAll();
    if( $data['notice'] !=NULL)
    {
         $noticeModel=  new  AdminNoticeModel();
    $data['notice']= $noticeModel->orderBy('id', 'DESC')->findAll();
     $model = new UserModel();
     $data['users']= $model->findAll();
      return view('admin_dashboard/notice_view_admin',$data);
    }
    else{
        $session = session();
      $session->set("msg","You Didn't Sent Any Notice To Anyone.");
            $session->markAsFlashdata("msg");
         return redirect()->to('admin_dashboard');  
    }
        
    }
    
    
    public function admin_by_reason($id){
      $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
      $user_reason = $this->request->getVar('user_reason');
      $data =[
          'reason_msg'=>$user_reason,
          ];
      
        $model=new UserModel();
        
        $model->update($id,$data);
         $session=session();
            $session->set("msg","This  Send Response Message Successfully? ");
            $session->markAsFlashdata("msg");
         return redirect()->to('admin_dashboard');
        
  }
 


  public function admin_by_course_registration_form(){
       $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
      $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
        $data['users'] = $model->where('id', $session->id)->first();
        return view('admin_dashboard/admin_by_course_registration_form',$data);
         }
         else{
             return view('signin');
         }
       }
 
 public function admin_by_student_registration_mode(){
     $session = session();
    $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if(empty($data) && $data['user_type']!="admin"){
             return redirect()->back()
                         ->with('msg', 'Not Access');
        }
        
      $userModel = new UserModel();
   
     $user_id = $this->request->getPost('user_id');
     $dob = $this->request->getPost('dob');
      $name = $this->request->getPost('name');
     $father_name = $this->request->getPost('father_name'); 
     $mother_name = $this->request->getPost('mother_name'); 
     $mobile = $this->request->getPost('mobile'); 
     $address = $this->request->getPost('address');
      $state = $this->request->getPost('state');
      $block = $this->request->getPost('block');
       $gender = $this->request->getPost('gender');
      $district = $this->request->getPost('district');
     $aadhar_card_no = $this->request->getPost('adhar_no');
      $pin_code = $this->request->getPost('pin_code');
     $qualification = $this->request->getPost('qualification');
     
    $training_picture = $this->request->getFile('training_picture');

     $order_id = uniqid();
   

 


/*image upload*/
$fileinfo = $this->request->getFile('profile');
   
      
            if (file_exists($fileinfo)){
                $filename= $fileinfo->getName();
                $nameArray = explode(".",$filename);
                $newfileName= time().".". end($nameArray); 
                if($fileinfo->move("student_images",$newfileName)){


$filenametraining= $training_picture->getName();
                $nameArraytraining = explode(".",$filenametraining);
                $newfileNametraining = time().".". end($nameArraytraining); 
                if($training_picture->move("student_images",$newfileNametraining)){
                   $data = [
                'user_id'     => $user_id,
                'name'=>$name,
                 'dob'     => $dob,
                 'father_name'     => $father_name,
                 'mother_name'=>$mother_name,
                 'state'=>$state,
                 'block'=>$block,
                 'gender'=>$gender,
                 'pin_code'=>$pin_code,
                    'mobile'     => $mobile,
                     'payment_status'=>'faild',
                     'address'     => $address,
                      'district'     => $district,

                      'adhar_no'     => $aadhar_card_no,
                      'qualification'     => $qualification,
                      'transaction_id' => $order_id,

                      'profile'=>$newfileName,
                      'training_picture'=>$newfileNametraining,
                       
                      'created_at'=> date('Y-m-d H:i:s'),

                
    ];
    
    
 
     $studentModel = new Student_Model();
         $result = $studentModel->save($data);
         /*= $this->userModel->update($user_id, $data);*/
         if($result){
             
             
             
             
              // phonepay
 $merchantId = 'PGTESTPAYUAT'; // sandbox or test merchantId
$apiKey="099eb0cd-02cf-4e2a-8aca-3e6c6aff0399"; 
$saltKey = 1;// sandbox or test APIKEY
//$redirectUrl = base_url('success_payment');
 
// // Set transaction details
 
 
    
   
$amount=100; 

$name="Winggo Soft";
$email="winggo@tutorialswebsite.com";
$mobile=9999999999;
// amount in INR
$description = 'Payment Test By Winggo Sofft';
 
 
$paymentData = [
  "merchantId"=> "PGTESTPAYUAT",
  "merchantTransactionId"=>$order_id ,
  "merchantUserId"=> $user_id,
  "amount"=> $amount*100,
  
  "redirectUrl"=> base_url('admin_by_registration_success_payment'),// payment status
  "redirectMode"=> "POST",
  "callbackUrl"=>base_url('admin_callback_payment'), // backend chek mathch
  "mobileNumber"=> $data['mobile'],
  "paymentInstrument"=> [
    "type"=> "PAY_PAGE"
  ],
];

 $jsonencode = json_encode($paymentData);
 $payloadMain = base64_encode($jsonencode);
 $salt_index = 1; //key index 1
 $payload = $payloadMain . '/pg/v1/pay' . $apiKey;
 $sha256 = hash("sha256", $payload);
 $final_x_header = $sha256 . '###' . $salt_index;
 $ch = curl_init();
 curl_setopt($ch,CURLOPT_URL,"https://api-preprod.phonepe.com/apis/pg-sandbox/pg/v1/pay");
 curl_setopt($ch,
 CURLOPT_HTTPHEADER,
 array(
  'Content-Type: application/json',
  'accept: application/json',
  'X-VERIFY:' .$final_x_header,
 )
);
curl_setopt($ch,CURLOPT_POST,1);
curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode(array('request' => $payloadMain)));
curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);

$response = curl_exec($ch);
$final = json_decode($response,true);
// echo "<pre>";
// print_r($final);
// die;
if($final){
 $data= $userModel->where('id', $user_id)->first();
           
             $sess_data = [
                     'id'       => $user_id,
                     
                      'loginned' =>'loginned',
                 ];

                  $session=session();
                $session->set($sess_data);
                
               $session=session();
                    $session->set("msg","Student Registration  Successfully ! ");
                    $session->markAsFlashdata("msg");
 return redirect()->to($final['data']['instrumentResponse']['redirectInfo']['url']);
             
         }
         }
         else{
            $session=session();
                    $session->set("msg","Your Profile Details Update Successfully ! ");
                    $session->markAsFlashdata("msg");
                    
            return view('admin_dashboard/index');
         }
                } else{
                     $session=session();
                    $session->set("msg","Student Training Photo Not Select ? ");
                    $session->markAsFlashdata("msg");
                    
             return view('admin_dashboard/index');
                }
                }
                
                else{
                     $session=session();
                    $session->set("msg","Your Details Some things Wrong ? ");
                    $session->markAsFlashdata("msg");
                    
             return view('admin_dashboard/index');
                }
                    
                }
                else
                    {
                         $session=session();
                    $session->set("msg","Student Profile Photo Not Select!");
                    $session->markAsFlashdata("msg");
                    
             return view('admin_dashboard/index');
                
                }
 }
     public function admin_show_student(){
         $studentModel = new Student_Model();  
          $data['users'] = $studentModel->orderBy('id', 'DESC')->findAll();
           return view('admin_dashboard/admin_show_student',$data); 
     }
     
     public function admin_by_registration_success_payment(){
         
       
        
         $response=  $this->request->getPost();
            
                   
             $transaction_id = $this->request->getPost('transactionId');
              $amount = $this->request->getPost('amount');
              
               $trans_status = $this->request->getPost('code');
               $staff_id = $this->request->getPost('staff_id');
               $cust_id = $this->request->getPost('cust_id');
               $providerReferenceId = $this->request->getPost('providerReferenceId');
               $merchantId = $this->request->getPost('merchantId');
               $cust_mobile = $this->request->getPost('cust_mobile');
                $userModel = new UserModel();
                
                 $userModel = new UserModel();
                  $studentModel = new Student_Model();
        $data = $studentModel->where('transaction_id', $this->request->getPost('transactionId'))->first();
      
        $student_id = $data['id'];
         $user_id = $data['user_id'];
  
               $data=[
                  
                   'providerReferenceId' =>$providerReferenceId,
                   
                   'merchantId'=>$merchantId,
                   
                   'payment_status'=>'success',
                   'amount'=>$amount/100,
                   'payment_date' =>date('Y-m-d H:i:s'),
                   ];
                
       
                  $studentModel = new Student_Model();
                   $success = $studentModel->update($student_id,$data);
                   // sms start
                   if($success==TRUE) {
            
          
            // end sms
       
         
          
          
             $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
          
               $session=session();
                    $session->set("msg",'<h1>'."Congratulations".'</h1>'." Payment successfully");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data = $userModel->where('id', $user_id)->first();
             
             
             
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
                 ]; 

                  $session=session();
                $session->set($sess_data);
                  $studentModel = new Student_Model();
         $data = $studentModel->where('transaction_id', $transaction_id)->first();
       
          $word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['payment_date'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ];
         
          $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
         $studentModel = new Student_Model();
         $data['receipt'] = $studentModel->where('transaction_id', $transaction_id)->first();
          return view('admin_dashboard/student_payment_fee_receipt',$data);
                   
                  
                    }
         }
         
         public function numberToWord($num = '')
	{
		$num    = (string) ((int) $num);

		if ((int) ($num) && ctype_digit($num)) {
			$words  = array();

			$num    = str_replace(array(',', ' '), '', trim($num));

			$list1  = array(
				'', 'one', 'two', 'three', 'four', 'five', 'six', 'seven',
				'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen',
				'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
			);

			$list2  = array(
				'', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty',
				'seventy', 'eighty', 'ninety', 'hundred'
			);

			$list3  = array(
				'', 'thousand', 'million', 'billion', 'trillion',
				'quadrillion', 'quintillion', 'sextillion', 'septillion',
				'octillion', 'nonillion', 'decillion', 'undecillion',
				'duodecillion', 'tredecillion', 'quattuordecillion',
				'quindecillion', 'sexdecillion', 'septendecillion',
				'octodecillion', 'novemdecillion', 'vigintillion'
			);

			$num_length = strlen($num);
			$levels = (int) (($num_length + 2) / 3);
			$max_length = $levels * 3;
			$num    = substr('00' . $num, -$max_length);
			$num_levels = str_split($num, 3);

			foreach ($num_levels as $num_part) {
				$levels--;
				$hundreds   = (int) ($num_part / 100);
				$hundreds   = ($hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ($hundreds == 1 ? '' : 's') . ' ' : '');
				$tens       = (int) ($num_part % 100);
				$singles    = '';

				if ($tens < 20) {
					$tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
				} else {
					$tens = (int) ($tens / 10);
					$tens = ' ' . $list2[$tens] . ' ';
					$singles = (int) ($num_part % 10);
					$singles = ' ' . $list1[$singles] . ' ';
				}
				$words[] = $hundreds . $tens . $singles . (($levels && (int) ($num_part)) ? ' ' . $list3[$levels] . ' ' : '');
			}
			$commas = count($words);
			if ($commas > 1) {
				$commas = $commas - 1;
			}

			$words  = implode(', ', $words);

			$words  = trim(str_replace(' ,', ',', ucwords($words)), ', ');
			if ($commas) {
				$words  = str_replace(',', ' and', $words);
			}

			return $words;
		} else if (!((int) $num)) {
			return 'Zero';
		}
		return '';
	}
 
 public function admin_generate_certificate_form($id){
 $session = session();
   $userModel = new UserModel();
        $data['user'] = $userModel->where('id', $session->id)->first();
     $studentModel = new Student_Model();
         $data['users'] = $studentModel->where('id', $id)->first();
     return view('admin_dashboard/admin_generate_certificate_form',$data);
     
 }
 
 public function student_certificate_by_admin_process(){
     
    $id = $this->request->getVar('id');
$user_id = $this->request->getVar('id');
$certi_issue_date = $this->request->getVar('certi_issue_date');

   helper(['form']);
        /* set rules validation form */
     
$filePath = $this->request->getVar('qrcode');
$parts = explode('/', $filePath);
$filename = end($parts);


           
$data = [
                'user_id'     => $this->request->getVar('id'),
                 'state'     => $this->request->getVar('state'),
                  'district'     => $this->request->getVar('district'),
                   'grade'     => $this->request->getVar('grade'),
                'name'     => $this->request->getVar('name'),
                'father_name'    => $this->request->getVar('father_name'),
                 'program_name'    => $this->request->getVar('program_name'),
                  'certi_content'    => $this->request->getVar('certi_content'),
                  'certi_content'    => $this->request->getVar('certi_content'), 'completion_date'=>  $this->request->getVar('completion_date'),
                  'place'=>  $this->request->getVar('place'),
                 'certificate_img'    => $this->request->getVar('certificate'),
                 'certificate_id'=>$this->request->getVar('certificate_id'),
                 'certi_qrcode'=>$filename,
                  'certificate_id'=>$this->request->getVar('certificate_id'),
                 'created_at'       => date('Y-m-d H:i:s'),
                 'certi_issue_date'=>$certi_issue_date,
                 
               
            ];
           
             
            $certimodel=new Student_certificate_Model();
            $certimodel->save($data);
            

            $session=session();
            $session->set("msg","  Certificate generate Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_by_student_certificate_show');
    
 }
 
 public function admin_by_student_certificate_show(){
     
      $certimodel=new Student_certificate_Model();
       $data['users'] = $certimodel->orderBy('id', 'DESC')->findAll();
       
       return view('admin_dashboard/admin_by_student_certificate_show',$data);
 }
 
 public function student_certificate_download_by_admin($id)
 {
     
      $certimodel=new Student_certificate_Model();
       $data = $certimodel->where('id', $id)->first();
       $user_id=$data['user_id'];
        
       // Assuming you have a date string
$completion_date = $data['completion_date'];
$created_at = $data['created_at'];

// Create a Time instance from the date string
$datec = Time::parse($completion_date);
$dateat = Time::parse($created_at);

// Format the date
$formattedDatec = $datec->toLocalizedString('dd-MM-yyyy');
$formattedDateat = $dateat->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datadate']=['completion_date'=>$formattedDatec,
                                  'created_at'=>$formattedDateat
                                ];
         
        
        $studentModel = new Student_Model();
           $data['users'] = $studentModel->where('id', $user_id)->first();
       
      $certimodel=new Student_certificate_Model();
       $data['certi'] = $certimodel->where('id', $id)->first();
       
      
       return view('admin_dashboard/student_certificate_download_by_admin',$data); 
  
 }
 
 public function delete_student_certificate_pdf($id){
     
     
        $certimodel=new Student_certificate_Model();

 $data['users'] = $certimodel->where('id', $id)->delete();

 $session=session();
            $session->set("msg","  Certificate Deleted Successfully");
            $session->markAsFlashdata("msg");
 return redirect()->to( base_url('admin_by_student_certificate_show') );
     
 }
 
 public function admin_by_student_certificate_user($user_id){
        
        
           
      $certimodel=new Student_certificate_Model();
       $data = $certimodel->where('user_id', $user_id)->findAll();  
		
                
        
      $certimodel=new Student_certificate_Model();
       $data['users'] = $certimodel->where('user_id', $user_id)->findAll();  
       
       return view('admin_dashboard/admin_by_student_certificate_user',$data); 
 }
 
 public function admin_show_student_details($id)
 {
      $studentModel = new Student_Model();
           $data['users'] = $studentModel->where('id', $id)->first(); 
           
           return view('admin_dashboard/admin_show_student_details',$data); 
 }
  public function admin_certificate_student_verify(){
     
     $id = $this->request->getPost('roll_no');
     
     $certimodel=new Student_certificate_Model();
       $data = $certimodel->where('id', $id)->first();
       if($data){
       $user_id=$data['user_id'];
        
       // Assuming you have a date string
$completion_date = $data['completion_date'];
$created_at = $data['created_at'];

// Create a Time instance from the date string
$datec = Time::parse($completion_date);
$dateat = Time::parse($created_at);

// Format the date
$formattedDatec = $datec->toLocalizedString('dd-MM-yyyy');
$formattedDateat = $dateat->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datadate']=['completion_date'=>$formattedDatec,
                                  'created_at'=>$formattedDateat
                                ];
         
        
        $studentModel = new Student_Model();
           $data['users'] = $studentModel->where('id', $user_id)->first();
       
      $certimodel=new Student_certificate_Model();
       $data['certi'] = $certimodel->where('id', $id)->first();
       
      
       return view('admin_dashboard/student_certificate_download_by_admin',$data); 
       }
       else{
           $model=new CertificateModel();
        $data = $model->where('user_id', $id)->first();
        if($data){
          $data['user'] = $model->where('user_id', $id)->first();
        return view('admin_dashboard/certificate_download_by_admin', $data);
        }else{
            
             $session=session();
            $session->set("msg","This Roll No. Not Exist  Here");
            $session->markAsFlashdata("msg");
            return redirect()->to('signin');
            
        }
       }
    
 }
 
 public function admin_update_data(){
     
     $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
        
         if($data && $data['user_type']!="admin"){
              return redirect()->to('signin');
         }
 
      $web_data = new Admin_Website_Model();
     $data['dataweb']=$web_data->first();
   
       return view('admin_dashboard/admin_update_data',$data);
 }
 
public function admin_update_data_website()
{
    helper(['filesystem']);
    $session = session();
    $request = service('request');
    $adminModel = new \App\Models\Admin_Website_Model();

    // Basic data
    $admin_id  = $request->getPost('id') ?? $request->getPost('admin_id');
    $data = [
        'member_fee'                 => $request->getPost('member_fee'),
        'web_name'                   => $request->getPost('web_name'),
        'web_short_name'             => $request->getPost('web_short_name'),
        'site_mobile_1'              => $request->getPost('site_mobile_1'),
        'site_mobile_2'              => $request->getPost('site_mobile_2'),
        '80G_id'                     => $request->getPost('80G_id'),
        'ngo_id'                     => $request->getPost('ngo_id'),
        'niti_id'                    => $request->getPost('niti_id'),
        '12a_id'                     => $request->getPost('12a_id'),
        'pan_no'                     => $request->getPost('pan_no'),
        'website_address'            => $request->getPost('website_address'),
        'web_tag_line'               => $request->getPost('web_tag_line'),
        'webemail_1'                 => $request->getPost('webemail_1'),
        'webemail_2'                 => $request->getPost('webemail_2'),
        'site_url'                   => $request->getPost('site_url'),
        'certificate_provider_name'  => $request->getPost('certificate_provider_name'),
        'designation'                => $request->getPost('designation'),
        'web_update_at'              => date('Y-m-d H:i:s'),
        'admin_id'                   => $admin_id,
    ];

    // Upload files if present
    $web_logo = $request->getFile('web_logo');
    if ($web_logo && $web_logo->isValid() && !$web_logo->hasMoved()) {
        $newLogo = time() . '_' . $web_logo->getRandomName();
        $web_logo->move(FCPATH . 'websiteLogoImages', $newLogo);
        $data['web_logo'] = $newLogo;
    }

    $signature = $request->getFile('certificate_provider_signature');
    if ($signature && $signature->isValid() && !$signature->hasMoved()) {
        $newSignature = time() . '_' . $signature->getRandomName();
        $signature->move(FCPATH . 'certificateProviderSignature', $newSignature);
        $data['certificate_provider_signature'] = $newSignature;
    }

    // Fetch existing record
    $existing = $adminModel->first();

    if ($existing) {
        // Delete old files if new ones uploaded
        if (isset($data['web_logo']) && !empty($existing['web_logo']) && file_exists(FCPATH . 'websiteLogoImages/' . $existing['web_logo'])) {
            unlink(FCPATH . 'websiteLogoImages/' . $existing['web_logo']);
        }
        if (isset($data['certificate_provider_signature']) && !empty($existing['certificate_provider_signature']) && file_exists(FCPATH . 'certificateProviderSignature/' . $existing['certificate_provider_signature'])) {
            unlink(FCPATH . 'certificateProviderSignature/' . $existing['certificate_provider_signature']);
        }

        // Update
        $adminModel->update($existing['id'], $data);
        $session->setFlashdata('msg', 'Website updated successfully.');
    } else {
        // Insert new record
        $adminModel->insert($data);
        $session->setFlashdata('msg', 'Website saved successfully.');
    }

    return redirect()->to('admin_dashboard');
}

                  
                  
                  
                  public function admin_appointment_update_data_process(){
                      
                     $admin_id = $this->request->getPost('user_id');
                  $tittle = $this->request->getPost('tittle');
     $subject = $this->request->getPost('subject');
     
     $description = $this->request->getPost('description'); 
     $provided_name = $this->request->getPost('provided_name'); 
       $provided_name = $this->request->getPost('provided_name'); 
        $designation = $this->request->getPost('designation'); 
        
        $signature = $this->request->getFile('signature');
        if(file_exists($signature)){
     $filename_signature= $signature->getName();
                $nameArray_signature = explode(".",$filename_signature);
                $newfileName_signature= time().".". end($nameArray_signature); 
                  if($signature->move("letterSignatureImages",$newfileName_signature)){
                

               
        
        $data = [
        'admin_id'=>$admin_id,
        'tittle'=>$tittle,
        'subject'=>$subject,
        'description' =>$description,
        'provided_name'=>$provided_name,
        'designation'=>$designation,
        'signature'=>$signature,
        'signature'=>$newfileName_signature,
       
         'created_at'=> date('Y-m-d H:i:s'),
        
                ];
      
        $session = session();
               
                        require 'db_config.php';
                      
                        
                         $queryli = "SELECT * FROM `appointment_data`";
                         $result = mysqli_query($connection, $queryli);
                         $dataLetter = mysqli_fetch_all($result, MYSQLI_ASSOC);
                         
                        
                      if($dataLetter){
                         
         $dataLetter = new Admin_Appointment_updataModel();
        $result = $dataLetter->where(["admin_id" =>$admin_id])
                   ->set($data)
                   ->update();
         
          $session=session();
            $session->set("msg","Website Update Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                      }
                      else{
                           
                           $dataLetter = new Admin_Appointment_updataModel();
         $result = $dataLetter->save($data);
         
          $session=session();
            $session->set("msg","Website Save Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                          
                      }
                
                  }
        }else{
            
            $data = [
        'admin_id'=>$admin_id,
        'tittle'=>$tittle,
        'subject'=>$subject,
        'description' =>$description,
        'provided_name'=>$provided_name,
        'designation'=>$designation,
        
       
         'created_at'=> date('Y-m-d H:i:s'),
        
                ];
      
        $session = session();
               
                        require 'db_config.php';
                      
                        
                         $queryli = "SELECT * FROM `appointment_data`";
                         $result = mysqli_query($connection, $queryli);
                         $dataLetter = mysqli_fetch_all($result, MYSQLI_ASSOC);
                         
                        
                      if($dataLetter){
                         
         $dataLetter = new Admin_Appointment_updataModel();
        $result = $dataLetter->where(["admin_id" =>$admin_id])
                   ->set($data)
                   ->update();
         
          $session=session();
            $session->set("msg","Website Update Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                      }
                      else{
                           
                           $dataLetter = new Admin_Appointment_updataModel();
         $result = $dataLetter->save($data);
         
          $session=session();
            $session->set("msg","Website Save Successfully");
            $session->markAsFlashdata("msg");
            return redirect()->to('admin_dashboard');
                          
                      }
        }
            
        
                  }
 
 
 
 public function donation_details($id){
    $trans= new Donote_TransactionModel();
         $data['users'] = $trans->where('id', $id)->first(); 
        //  echo "<pre>";
        //  print_r($data);
        //  die;
         return view('admin_dashboard/donation_details',$data);
 }
 
 
  public function case_donation_form(){
    
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
         if($data['user_type']=="admin"){
             $data['users'] = $model->where('id', $session->id)->first();
             return view('admin_dashboard/case_donation_form',$data);
         }
         else{
             return redirect()->to('signin');
         }
         }else{
             return redirect()->to('signin');
         }
 }
 
 
 
 
  public function Generate_case_donation_form(){
    
        $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
         if($data['user_type']=="admin"){
             $data['users'] = $model->where('id', $session->id)->first();
             return view('admin_dashboard/Generate_case_donation_form',$data);
         }
         else{
             return redirect()->to('signin');
         }
         }else{
             return redirect()->to('signin');
         }
 }
 
 public function Generate_case_donation_show(){
     
     $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
         if($data['user_type']=="admin"){
             
            $donateModel = new GenerateDonateModel();
                 $donations = $donateModel->orderBy('id', 'DESC')->findAll();  
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
        
       
        $data['totalAmount'] = $totalAmount;
             $data['users'] = $model->where('id', $session->id)->first();
                $donateModel = new GenerateDonateModel();
                 $data['donation'] = $donateModel->orderBy('id', 'DESC')->findAll();
             return view('admin_dashboard/Generate_case_donation_show',$data);
         }
         else{
             return redirect()->to('signin');
         }
         }else{
             return redirect()->to('signin');
         }
 
     
 }
 
 public function Generate_delete_donation_receipt_pdf($id){
     
      $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
         if($data['user_type']=="admin"){
           $donateModel = new GenerateDonateModel();
           $result = $donateModel->delete($id);
           if($result){
               return redirect()->back()->with('msg', 'Generated Donation Receipt Successfully Delete!');
           }else{
              return redirect()->back()->with('msg', 'Generated Donation Receipt Fail Delete!'); 
           }
         }
         else{
             return redirect()->to('signin');
         }
         }else{
             return redirect()->to('signin');
         }
     
 }
   public function bulkDeleteGenerateReceipt() {
          $session = session();
    $model = new \App\Models\UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Unauthorized Access!'
        ])->setStatusCode(403);
    }

    $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (empty($ids)) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'No records selected!'
        ]);
    }

    $donateModel = new GenerateDonateModel();
    $deleted = $donateModel->whereIn('id', $ids)->delete();

    return $this->response->setJSON([
        'success' => $deleted ? true : false,
        'message' => $deleted ? 'Selected Receipt deleted successfully!' : 'Failed to delete Receipt.'
    ]);
}
 
 public function Generate_donation_details($id){
     $donateModel = new GenerateDonateModel(); 
   $data['users'] = $donateModel->where('id',$id)->first();
   
return view('admin_dashboard/Generate_donation_details',$data);   
     
 }
 public function Generate_donoate_case(){
      helper(['form', 'url']);

        $validation = \Config\Services::validation();
  
        $name= $this->request->getVar('name');
         $email= $this->request->getVar('email');
        $mobile= $this->request->getVar('mobile');
        $amount=$this->request->getVar('amount');
         $address=$this->request->getVar('address');
  $purpose=$this->request->getVar('purpose');
       
          $bank_name=$this->request->getVar('bank_name');
         $branch_name=$this->request->getVar('branch_name');
          $pan_no =$this->request->getVar('pan_no');
           
        $rules = [
            'name'         => 'required',
            'email'        => 'required|valid_email',
            'mobile'       => 'required|numeric|min_length[10]|max_length[10]',
            'address'      => 'required',
            'amount'       => 'required|numeric',
            'paymentMode'  => 'required',
            'payment_Image'=> 'uploaded[payment_Image]|max_size[payment_Image,2048]|ext_in[payment_Image,jpg,jpeg,png]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $validation->getErrors());
        }

        $image = $this->request->getFile('payment_Image');
        $imageName = $image->getRandomName();
        $image->move('GeneratePayments/', $imageName);

        $donateModel = new GenerateDonateModel();

        $donateModel->save([
            'name'         => $this->request->getPost('name'),
            'email'        => $this->request->getPost('email'),
            'mobile'       => $this->request->getPost('mobile'),
            'address'      => $this->request->getPost('address'),
            'amount'       => $this->request->getPost('amount'),
            'paymentMode'  => $this->request->getPost('paymentMode'),
            'pan_no'       => $this->request->getPost('pan_no'),
            'purpose'      => $this->request->getPost('purpose'),
             'transaction_id'      => $this->request->getPost('transaction_id'),
              'payment_status'      => "success",
            'payment_Image'=> $imageName
        ]);
$id = $donateModel->getInsertId();


$payementdate = date('Y-m-d H:i:s');
$payment_dateE  = date('Y-m-d H:i:s');
$amount_data=$amount;
 $downloadurl=base_url('Generate_donate_receipt_download/'.$id);
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                          $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                       $site_url=$dataweb['site_url'];
                        $certificate_provider_name= $dataweb['certificate_provider_name'];
                              $designation= $dataweb['designation'];
    
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
   $mail->Subject = 'Donation Receipt for Your Generous Contribution';

$weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$mail->Body = "
<div style='width: 100%; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background-color: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark -->
  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <!-- Content box -->
    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 80px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 24px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
      </div>

      <!-- Donation Receipt Body -->
      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear {$name},<br><br>

         On behalf of <strong>{$datawebname}</strong>, we would like to express our heartfelt gratitude for your generous donation.<br><br>

        Your support enables us to continue our mission of 
        <strong>{$web_tag_line}</strong>.<br><br>

        We are pleased to confirm that we have received your donation of 
        <span style='font-weight:600;'>₹{$amount_data} on $payment_dateE = date('d-m-Y h:i A', strtotime($payementdate));</span>.<br><br>

         As requested, we have attached your donation receipt to this email.<br>
        <span style='font-weight:600;'>Download Receipt Here:</span> 
        <a href='{$downloadurl}' style='color:#ff416c;' target='_blank'>Click to Download</a><br><br>

        If you have any questions, please contact us at 
        <a href='mailto:{$webemail_1}' style='color:#ff4b2b;'>{$webemail_1}</a> 
        or call {$site_mobile_1}.<br><br>

         Your support is invaluable to us, and we are deeply grateful for your contribution.<br><br>

        Best regards,<br>
        <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a><br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        {$datawebname}
      </div>

    </div>
  </div>
</div>
";

    
    $mail->AltBody = $email_data['message'];

    $mail->send();
   $session=session();
            
            
            
      
           return redirect()->to('Generate_donate_receipt_download/'.$id)->with('success', 'Donation successfully submitted!');
                   
                    
         }
                    
catch (Exception $e) {
    
    return redirect()->to('Generate_donate_receipt_download/'.$id)->with('success', 'Donation successfully submitted!');
}







       
    
     
     
 }
 
 public function Generate_donate_receipt_download($id){
    
       $donateModel = new GenerateDonateModel();
     $data = $donateModel->where('id', $id)->first();

        
        if($data) {
            
        $donateModel = new GenerateDonateModel();
     $data = $donateModel->where('id', $id)->first();
         
        
            
              $word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['created_at'];


// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ]; 
         
      
        $donateModel = new GenerateDonateModel();
     $data['payments'] = $donateModel->where('id', $id)->first();
          return view('Front/Generate_donate_receipt_download',$data);   
        
    }else{
        
        return redirect()->back();
        
    }
     
 }
 public function donoate_case(){
     
    //   $data=    $this->request->getPost();
        
        $name= $this->request->getVar('name');
         $email= $this->request->getVar('email');
        $mobile= $this->request->getVar('mobile');
        $amount=$this->request->getVar('amount');
         $address=$this->request->getVar('address');
  $purpose=$this->request->getVar('purpose');
       
          $bank_name=$this->request->getVar('bank_name');
         $branch_name=$this->request->getVar('branch_name');
          $pan_no =$this->request->getVar('pan_no');
           
          
        $fileinfo = $this->request->getFile('payment_Image');
         if($fileinfo !=''){ 
      
            if (file_exists($fileinfo)){
                $filename= $fileinfo->getName();
                $nameArray = explode(".",$filename);
                $newfileName= time().".". end($nameArray); 
                if($fileinfo->move("Payment_Image",$newfileName)){
          
          $order_id = uniqid();
          $payementdate =date('Y-m-d H:i:s');
 $data = [
     'user_name'=>$name,
     'payment_Image'=>$newfileName,
     'email'=>$email,
     'DonationPurpose'=>$purpose,
     'mobile'=>$mobile,
     'email'=>$email,
     'amount'=>$amount,
     'address'=>$address,
     'transaction_id'=>$order_id,
     'bank_name' =>$bank_name,
     'branch_name'=>$branch_name,
     'pan_no'=>$pan_no,
     'user_id'=> 'cash',
                   'referance_id' =>"admin",
                   
                   'merchantId'=>"admin",
                   
                   'payment_status'=>"success",
                   'amount'=>$amount,
                   'created_at'=> $payementdate ,
     ];
 
   
$trans= new Donote_TransactionModel();
                   $success = $trans->save($data);
                   
                     if($success==TRUE) {
            
             //These must be at the top of your script, not inside a function
$dataurl= base_url();
$amount_data=$amount;
 $downloadurl=base_url('donate_receipt_download/'.$order_id);
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                          $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                       $site_url=$dataweb['site_url'];
                        $certificate_provider_name= $dataweb['certificate_provider_name'];
                              $designation= $dataweb['designation'];
    
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
   $mail->Subject = 'Donation Receipt for Your Generous Contribution';

$weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$mail->Body = "
<div style='width: 60%; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background-color: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark -->
  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <!-- Content box -->
    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 80px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 24px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
      </div>

      <!-- Donation Receipt Body -->
      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear {$name},<br><br>

         On behalf of <strong>{$datawebname}</strong>, we would like to express our heartfelt gratitude for your generous donation.<br><br>

        Your support enables us to continue our mission of 
        <strong>{$web_tag_line}</strong>.<br><br>

        We are pleased to confirm that we have received your donation of 
        <span style='font-weight:600;'>₹{$amount_data} on {$payementdate}</span>.<br><br>

         As requested, we have attached your donation receipt to this email.<br>
        <span style='font-weight:600;'>Download Receipt Here:</span> 
        <a href='{$downloadurl}' style='color:#ff416c;' target='_blank'>Click to Download</a><br><br>

        If you have any questions or require further information, please contact us at 
        <a href='mailto:{$webemail_1}' style='color:#ff4b2b;'>{$webemail_1}</a> 
        or call {$site_mobile_1}.<br><br>

         Your support is invaluable to us, and we are deeply grateful for your contribution.<br><br>

        Best regards,<br>
        <a href='https://www.{$site_url}' target='_blank'>www.{$site_url}</a><br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        {$datawebname}
      </div>

    </div>
  </div>
</div>
";

$mail->AltBody = strip_tags("
Dear {$name}, 
On behalf of {$datawebname}, we would like to express our heartfelt gratitude for your generous donation.
We confirm that we have received your donation of ₹{$amount_data} on {$payementdate}.
Download Receipt Here: {$downloadurl}
For any queries contact: {$webemail_1}, {$site_mobile_1}
www.{$web_data['site_url']}
{$certificate_provider_name}, {$designation}, {$datawebname}
");


    $mail->send();
   $session=session();
            
            
            
             $trans= new Donote_TransactionModel();
                $data = $trans->where('transaction_id',$order_id)->first();
        $word = $this->numberToWord( $data['amount']);
        $dateString = $data['created_at'];
// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ];
            
          $trans= new Donote_TransactionModel();
                $data['payments'] = $trans->where('transaction_id',$order_id)->first();
                
         
           return redirect()->to('donate_receipt_download/'.$order_id);
                   
                    
         }
                    
catch (Exception $e) {
    
    $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." message could not be sent. Mailer Error ");
                    $session->markAsFlashdata("msg");
                   
         return redirect()->to('donate_receipt_download');
}}else{
    
    $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Enter Details Some Things Wrong Try Again !");
                    $session->markAsFlashdata("msg");
                   
         return redirect()->to('case_donation_form');
}
                
         
        
                }
                
            }else{
                $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'."Payment Image Not Upload Try Again !");
                    $session->markAsFlashdata("msg");
                   
         return redirect()->to('case_donation_form');
            }
             
         }else{
             
              $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'."Payment Image Not Select Try Again !");
                    $session->markAsFlashdata("msg");
                   
         return redirect()->to('case_donation_form');
             
         }
     
 }
 

 public function case_donation_show(){
     
     $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
         if($data){
         if($data['user_type']=="admin"){
             $data['users'] = $model->where('id', $session->id)->first();
            $transModel= new Donote_TransactionModel();
    $donations = $transModel->where('referance_id', "admin")->orderBy('id', 'DESC')->findAll();
         
         if($data){
          
        
        
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
         
             return view('admin_dashboard/case_donation_show',$data);
         }
         else{
             return redirect()->to('signin');
         }
         }
         else{
             return redirect()->to('signin');
         }
 }
 }
 public function search_filture_cashdonation(){
     
      $transModel = new Donote_TransactionModel();
       $date1 = $this->request->getVar('date1');
       
        $date2 = $this->request->getVar('date2');
          
      
   // Validate and format your date inputs as needed
        $startDate = date('Y-m-d', strtotime($date1));
        $endDate = date('Y-m-d', strtotime($date2));

        // Fetch data from the model based on the date range
        $data['results'] = $transModel->getDataByDateRangeCash($startDate, $endDate);
      
        // Pass the data to your view
      if($data){
           $transModel = new Donote_TransactionModel();
           
            
            $donations = $transModel->getDataByDateRangeCash($startDate, $endDate);
        
        
        $totalAmount = 0;
        foreach($donations as $donation) {
            $totalAmount += $donation['amount'] ?? 0; 
        }
        
        $data['receipt'] = $donations;
        $data['totalAmount'] = $totalAmount;
        return view('admin_dashboard/case_donation_show',$data);
        }
        else{
               
               
        $session=session();
        $session->set("msg","No Data Found");
        $session->markAsFlashdata("msg");
        return redirect()->to('admin_dashboard')  ;  
        }
 
     
 }
public function deleteAllDonationCash(){
       $model = new Donote_TransactionModel();
    $selectedUsers = $this->request->getVar('selectedUsers');
     $count = count($selectedUsers);
     
         
    if (!is_array($selectedUsers) || empty($selectedUsers)) {
        return redirect()->back()
            ->with('msg', 'No users selected for deletion')
            ->with('msg_type', 'danger');
    }

   
    $userIds = array_map('intval', $selectedUsers);

    try {
        
        $result = $model->whereIn('id', $userIds)->delete();
        
        if ($result) {
            $message = sprintf('Successfully deleted '.$count.' Receipt', $result);
            return redirect()->back()
                ->with('msg', $message)
                ->with('msg_type', 'success');
        }

        return redirect()->back()
            ->with('msg', 'No users were deleted')
            ->with('msg_type', 'warning');

    } catch (\Exception $e) {
        log_message('error', 'User deletion error: ' . $e->getMessage());
        return redirect()->back()
            ->with('msg', 'Error deleting users. Please try again later.')
            ->with('msg_type', 'danger');
    }
      }

public function admin_resetwebsite_data()
{
    $session = session();
    $userModel = new UserModel();
    $user = $userModel->find($session->id);

    // Check if user is logged in and admin
    if (!$user || $user['user_type'] !== 'admin') {
        return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
    }

    helper('filesystem');

    
    $folders = [
        'images',
        'websiteLogoImages',
        'certificateProviderSignature',
        'letterSignatureImages',
        'Payment_Image',
        'BannerPost',
        'CampaignsGallery',
        'CampaignsImage',
        'customer_images',
        'DonationProjectsImage',
        'EventBanners',
        'GeneratePayments',
        'InternImage',
        'managementbodyImage',
    ];

   
    foreach ($folders as $folder) {
        $path = FCPATH . $folder . '/';
        if (is_dir($path)) {
            $files = get_filenames($path);
            if ($files) {
                foreach ($files as $file) {
                    $filePath = $path . $file;
                    if (is_file($filePath)) {
                        @unlink($filePath);
                    }
                }
            }
        }
    }

   
    $models = [
        EnquiryModel::class,
        DesignationModel::class,
        ManagementBodyModel::class,
        EventModel::class,
        EventTicketModel::class,
        InternshipModel::class,
        ProjectExpenseModel::class,
        DonationProjectModel::class,
        BirthdayMessageModel::class,
        GenerateDonateModel::class,
        NewsModel::class,
        Message_controller::class,
        DonateCampaignModel::class,
        CampaignModel::class,
        InternshipApplicationModel::class,
        PostsModel::class,
        ImagePostsModel::class,
        Admin_Appointment_updataModel::class,
        ExpenseModel::class,
        TransactionModel::class,
        Donote_TransactionModel::class,
        CertificateModel::class,
        UserModel::class,
        AdminNoticeModel::class,
        BeneficiaryModel::class,
        BeneficiaryHelpModel::class,
    ];

   
    foreach ($models as $modelClass) {
        $model = new $modelClass();
        $model->truncate();
    }

   
    $session->setFlashdata('msg', 'Website Reset Successfully');
    $session->destroy();

    return redirect()->to('signup')->with('msg', 'The website software has been reset successfully.');

}


public function CreatePost() {
     
      $session = session();
        $model=new UserModel();
         $data = $model->where('id', $session->id)->first();
        
         if($data && $data['user_type']!="admin"){
              return redirect()->to('signin');
         }
         $data['heading']="Create Post Form";
          $data['users'] = $model->where('id', $session->id)->first();  
         return view('admin_dashboard/Create-Post',$data);
     
 }

public function PostEdit($id) {
    $session = session();
    $model = new UserModel();
    $postModel = new \App\Models\PostsModel();
    $imageModel = new \App\Models\ImagePostsModel();

    // Get logged-in user
    $data = $model->where('id', $session->id)->first();
 if($data && $data['user_type']!="admin"){
              return redirect()->to('signin');
         }
    // Get the post
    $post = $postModel->where('id', $id)->first();

    if ($post) {
        // Attach images to the post
        $post['images'] = $imageModel->where('post_id', $id)->findAll();
    }

    // Prepare data for view
    $data = [
        'user'  => $data,
        'post'  => $post,
        'heading'=>"Post Update Form",
    ];

    return view('admin_dashboard/Create-Post', $data);
}



public function postslist(){
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();
    
    if($data && $data['user_type'] != "admin"){
        return redirect()->to('signin');
    }
    
    $postModel = new \App\Models\PostsModel();
    $data['users'] = $model->where('id', $session->id)->first();  
    
    // Return JSON for AJAX requests
    if ($this->request->isAJAX()) {
        $posts = $postModel->orderBy('id', 'DESC')->findAll();
        return $this->response->setJSON([
            'success' => true,
            'posts' => $posts
        ]);
    }
    
 
    $data['post'] = $postModel->orderBy('id', 'DESC')->findAll();  
    
    return view('admin_dashboard/posts-list', $data);  
}

// AJAX Delete Single Post
public function deletePost($id) {
    $session = session();
    $model = new UserModel();
    $user = $model->where('id', $session->id)->first();
    
    if($user && $user['user_type'] != "admin"){
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Unauthorized access'
        ]);
    }
    
    $postModel = new \App\Models\PostsModel();
    $deleted = $postModel->delete($id);
    
    if ($deleted) {
        return $this->response->setJSON([
            'success' => true,
            'message' => 'Post deleted successfully'
        ]);
    } else {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Failed to delete post'
        ]);
    }
}

public function bulkDeletePosts()
{
    $json = $this->request->getJSON(true);
    $ids = $json['ids'] ?? [];

    if (!empty($ids)) {
         $postModel = new \App\Models\PostsModel();
    $deleted = $postModel->whereIn('id', $ids)->delete();
        return $this->response->setJSON(['success' => true]);
    }
return redirect()->back()->with('success', 'Selected users deleted successfully!');

    return $this->response->setJSON(['success' => false, 'message' => 'No users selected']);
}


// AJAX Bulk Delete Posts
public function bulkDeletePosts1() {
    $session = session();
    $model = new UserModel();
    $user = $model->where('id', $session->id)->first();
    
    if($user && $user['user_type'] != "admin"){
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Unauthorized access'
        ]);
    }
    
    $postIds = $this->request->getPost('post_ids');
    
    if (empty($postIds)) {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'No posts selected'
        ]);
    }
    
    $postModel = new \App\Models\PostsModel();
    $deleted = $postModel->whereIn('id', $postIds)->delete();
    
    if ($deleted) {
        return $this->response->setJSON([
            'success' => true,
            'message' => count($postIds) . ' posts deleted successfully'
        ]);
    } else {
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Failed to delete posts'
        ]);
    }
}

 public function publicPosts()
{
    $postModel = new \App\Models\PostsModel();
    $imageModel = new \App\Models\ImagePostsModel();

    $posts = $postModel->where('status', 'active')
                       ->orderBy('id', 'DESC')
                       ->findAll();

    // Attach images for each post
    foreach ($posts as &$post) {
        $post['images'] = $imageModel->where('post_id', $post['id'])->findAll();
    }

    $data['posts'] = $posts;
    
    return view('posts', $data);
}


public function createpostdata()
{
    $session = session();

    // Validation Rules
    $validation = \Config\Services::validation();
    $rules = [
        'name'        => 'required|max_length[255]',
        'description' => 'required',
        'category' => 'required',
        'banner'      => [
            'rules'  => 'uploaded[banner.0]|max_size[banner,2048]|mime_in[banner,image/jpeg,image/png,image/gif]|ext_in[banner,jpg,jpeg,png,gif]',
            'errors' => ['uploaded' => 'Please upload at least one image.']
        ]
    ];

    if (!$this->validate($rules)) {
        return redirect()->back()->withInput()->with('errors', $validation->getErrors());
    }

    // Handle Multiple File Uploads
    $bannerFiles = $this->request->getFiles()['banner'];
    $uploadedImages = [];

    if (!empty($bannerFiles)) {
        foreach ($bannerFiles as $file) {
            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move(FCPATH . 'BannerPost', $newName);
                $uploadedImages[] = $newName;
            }
        }
    }

    // Save Post
    $postModel = new \App\Models\PostsModel();
    $postData = [
        'name'        => $this->request->getPost('name'),
        'description' => $this->request->getPost('description'),
        'category' => $this->request->getPost('category'),
        'created_by'  => $session->get('admin_id'),
        'status'      => 'active',
        'created_at'  => date('Y-m-d H:i:s')
    ];

    if ($postModel->insert($postData)) {
        $postId = $postModel->getInsertId();

        // Insert each image separately into image_posts table
        $postImageModel = new \App\Models\ImagePostsModel();
        foreach ($uploadedImages as $img) {
            $postImageModel->insert([
                'post_id' => $postId,
                'banner'  => $img,
                'created_at' => date('Y-m-d H:i:s')
            ]);
        }

        return redirect()->to('posts-list')->with('msg', 'Activity Post Created Successfully!');
    } else {
        return redirect()->back()->with('error', 'Activity Post Created Fail!');
    }
}



public function updatepostdata($id)
{
    $session = session();

    $postModel = new \App\Models\PostsModel();
    $postImageModel = new \App\Models\ImagePostsModel();

  // $id= $this->request->getPost('id');
    $validation = \Config\Services::validation();
    $rules = [
        'name'        => 'required|max_length[255]',
        'description' => 'required',
        'category' => 'required',
    ];

    if (!$this->validate($rules)) {
        return redirect()->back()->withInput()->with('errors', $validation->getErrors());
    }

    
    $postData = [
        'name'        => $this->request->getPost('name'),
        'description' => $this->request->getPost('description'),
         'category' => $this->request->getPost('category'),
        'updated_by'  => $session->get('admin_id'),
        'updated_at'  => date('Y-m-d H:i:s')
    ];

    $postModel->update($id, $postData);

  
    $selectedImages = $this->request->getPost('selected_images'); 
   
    $newImages = $this->request->getFiles('new_images'); // New files chosen for selected images

    if ($selectedImages) {
        foreach ($selectedImages as $imgId) {
            $file = $newImages[$imgId] ?? null;
 
            if ($file && $file->isValid() && !$file->hasMoved()) {
                
                $oldImg = $postImageModel->where('id', $imgId)
                                         ->first();

                if ($oldImg) {
                    // Delete old file if exists
                    $oldPath = FCPATH . 'BannerPost/' . $oldImg['banner'];
                    if (is_file($oldPath)) {
                        unlink($oldPath);
                    }

                    // Move new file
                    $newName = $file->getRandomName();
                    $file->move(FCPATH . 'BannerPost', $newName);

                    // Update database
                    $postImageModel->update($imgId, [
                        'banner'     => $newName,
                        'updated_at' => date('Y-m-d H:i:s')
                    ]);
                }
            }
        }
    }

//echo "check"; die;
    $bannerFiles = $this->request->getFiles()['banner'] ?? [];
    if (!empty($bannerFiles)) {
        foreach ($bannerFiles as $file) {
            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move(FCPATH . 'BannerPost', $newName);

                $postImageModel->insert([
                    'post_id'    => $id,
                    'banner'     => $newName,
                    'created_at' => date('Y-m-d H:i:s')
                ]);
            }
        }
    }

    return redirect()->to('posts-list')->with('msg', 'Activity Post Updated Successfully!');
}

public function PostDelete($id)
{
    $session = session();
    $userModel = new UserModel();
    $postModel = new \App\Models\PostsModel();
    $imageModel = new \App\Models\ImagePostsModel();

  
    $user = $userModel->where('id', $session->id)->first();
    if (!$user || $user['user_type'] != "admin") {
        return redirect()->to('signin');
    }

    
    $images = $imageModel->where('post_id', $id)->findAll();

  
    if (!empty($images)) {
        foreach ($images as $img) {
            $filePath = FCPATH . 'BannerPost/' . $img['banner'];
            if (is_file($filePath)) {
                @unlink($filePath); // safely remove the file
            }
        }
    }

    
    $imageModel->where('post_id', $id)->delete();

    
    $deleted = $postModel->delete($id);

    if ($deleted) {
        return redirect()->back()->with('msg', 'Activity Post Deleted Successfully Along With All Images!');
    } else {
        return redirect()->back()->with('msg', 'Activity Post Deleted Fail Along With All Images!');
    }
}


public function deletepostimage($id){
     if (!$this->request->isAJAX()) {
        return $this->response->setJSON(['status' => 'error', 'message' => 'Invalid request.']);
    }

    $session = session();
    $imageModel = new \App\Models\ImagePostsModel();

    // Find the image by ID
    $image = $imageModel->where('id', $id)->first();

    if ($image) {
        $filePath = FCPATH . 'BannerPost/' . $image['banner'];

        // Delete image file if exists
        if (is_file($filePath)) {
            @unlink($filePath);
        }

        // Delete DB record
        $imageModel->delete($id);

        return $this->response->setJSON([
            'status' => 'success',
            'message' => 'Image deleted successfully',
            'image_id' => $id
        ]);
    }

    return $this->response->setJSON([
        'status' => 'error',
        'message' => 'Image not found or already deleted'
    ]);
    
}


public function BeneficiaryAdd(){
    
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
        $data['heading']="Beneficiary Add Form";
        return view('beneficiary/create-update',$data); 
    
    
}

public function BeneficiaryEdit($id){
    
   
 $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
     $data['heading']="Beneficiary Update Form";
     $beneficiaryModel = new BeneficiaryModel();  
     $data['member']= $beneficiaryModel->where('id', $id)->first();
    
      return view('beneficiary/create-update',$data);     
    
}
public function BeneficiaryDelete($id){
    
   
 $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
     $data['heading']="Beneficiary Update Form";
     $beneficiaryModel = new BeneficiaryModel();  
     $data= $beneficiaryModel->delete($id);
    if($data){
       return redirect()->back()->with('msg', 'Health Beneficiary data Delete Successfully!');       
        
    }else{
       return redirect()->back()->with('msg', 'Health Beneficiary data Delete Fail!');       
    }
      
    
}

public function Beneficiarydata()
{
    $session = session();
    $model = new UserModel();
    $userdata = $model->where('id', $session->id)->first();
   
    $heading = $this->request->getPost('heading');
if($heading != "Beneficiary Apply Form"){
    if (!$userdata || $userdata['user_type'] != "admin") {
        return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
    }
}
 

    // determine type and apply_status
    if ($session->user_type != "admin") {
        
        $apply_status = "inactive";
        $type = "direct";
        $status = "0";
       
    } else {
        $type = "admin";
        $apply_status = "active";
        $status = "1";
       
    }

    $beneficiaryModel = new BeneficiaryModel();

    $id = $this->request->getPost('id');

    // collect common data
    $data = [
        'full_name'           => $this->request->getPost('full_name'),
        'gender'              => $this->request->getPost('gender'),
        'age'                 => $this->request->getPost('age'),
        'dob'                 => $this->request->getPost('dob'),
        'father_name'         => $this->request->getPost('father_name'),
        'mobile'              => $this->request->getPost('mobile'),
        'email'               => $this->request->getPost('email'),
        'state'               => $this->request->getPost('state'),
        'district'            => $this->request->getPost('district'),
        'address'             => $this->request->getPost('address'),
        'pin'                 => $this->request->getPost('pin'),
        'identification_type' => $this->request->getPost('identification_type'),
        'identification_type2'=> $this->request->getPost('identification_type2'),
        'category'            => $this->request->getPost('category'),
        'category1'           => $this->request->getPost('category1'),
        'remark'              => $this->request->getPost('remark'),
        'type' =>$type,
        'apply_status'=>$apply_status,
        'status' =>$status,
    ];

    // handle profile upload
    if ($file = $this->request->getFile('profile')) {
        if ($file->isValid() && !$file->hasMoved()) {
            $filename = $file->getRandomName();
            $file->move('beneficiary/profile/', $filename);
            $data['profile'] = $filename;
        }
    }

    // handle idimage1 upload
    if ($idDoc = $this->request->getFile('idimage1')) {
        if ($idDoc->isValid() && !$idDoc->hasMoved()) {
            $filename = $idDoc->getRandomName();
            $idDoc->move('beneficiary/idproof/', $filename);
            $data['idimage1'] = $filename;
        }
    }

    // handle idimage2 upload
    if ($idDoc2 = $this->request->getFile('idimage2')) {
        if ($idDoc2->isValid() && !$idDoc2->hasMoved()) {
            $filename = $idDoc2->getRandomName();
            $idDoc2->move('beneficiary/idproof2/', $filename);
            $data['idimage2'] = $filename;
        }
    }

    // UPDATE or INSERT
    if (!empty($id)) {
        // Update record
        $result = $beneficiaryModel->update($id, $data);
        if ($result) {
            return redirect()
                ->to(base_url('Beneficiary-Active-List'))
                ->with('msg', 'Beneficiary data updated successfully!');
        } else {
            return redirect()
                ->back()
                ->with('msg', 'Failed to update Beneficiary data!')
                ->withInput();
        }
    } else {
        // Insert new record
        

        $result = $beneficiaryModel->insert($data);

        if ($result) {
            $newId = $beneficiaryModel->getInsertID();
            $this->BeneficiarySendMail($newId);
if($type=="direct"){
    $session = session();
    $dataset = [
         'id'           => $newId,
        'full_name'           => $this->request->getPost('full_name'),
        'gender'              => $this->request->getPost('gender'),
        'age'                 => $this->request->getPost('age'),
        'dob'                 => $this->request->getPost('dob'),
        'father_name'         => $this->request->getPost('father_name'),
        'mobile'              => $this->request->getPost('mobile'),
        'email'               => $this->request->getPost('email'),
        'state'               => $this->request->getPost('state'),
        'district'            => $this->request->getPost('district'),
        'address'             => $this->request->getPost('address'),
        'pin'                 => $this->request->getPost('pin'),
        'identification_type' => $this->request->getPost('identification_type'),
        'identification_type2'=> $this->request->getPost('identification_type2'),
        'category'            => $this->request->getPost('category'),
        'category1'           => $this->request->getPost('category1'),
        'remark'              => $this->request->getPost('remark'),
    
        ];
       
        $session->set($dataset);
    return redirect()
                ->back()
                ->with('response', 'Beneficiary data applied successfully! You will receive a response to your application via email as soon as possible.');  
}
            return redirect()
                ->to(base_url('Beneficiary-Active-List'))
                ->with('msg', 'Beneficiary data saved successfully!');
                
        
        } else {
            return redirect()
                ->back()
                ->with('msg', 'Failed to save Beneficiary data!')
                ->withInput();
        }
    }
}

private function BeneficiarySendMail($id){
    
    $beneficiaryModel = new BeneficiaryModel();  
     $data= $beneficiaryModel->where('id', $id)->first();
     $name = $data['full_name'];
     $email =$data['email'];
     $mobile=$data['mobile'];
     $gender = $data['gender'];
     $state = $data['state'];
     $district = $data['district'];
     $address = $data['address'];
     $category = $data['category'];
       $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
       

        require 'vendor/autoload.php';
        require 'phpmailer/src/PHPMailer.php';
        require 'phpmailer/src/Exception.php';
        require 'phpmailer/src/SMTP.php';

        require 'db_config.php';

        // Fetch email config
        $email_data = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `email_credentials`"), MYSQLI_ASSOC);
        $dataweb = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `admin_website_update`"), MYSQLI_ASSOC);
        $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

        // ===================== SEND TO USER =====================
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = $email_data['host'];
            $mail->SMTPAuth = true;
            $mail->Username = $email_data['by_email'];
            $mail->Password = $email_data['by_password'];
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mail->addAddress($email, $name);
            $mail->isHTML(true);
            $mail->Subject = "Thank You for Contacting  {$dataweb['web_name']}! Your Inquiry Has Been Received";

           $mail->Body = "
<div style='margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background-color: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 80px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 24px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
      </div>

      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear {$name},<br><br>

         <strong>Congratulations!</strong><br>
        You have been successfully registered as a <strong>Beneficiary</strong> under 
        <strong>{$dataweb['web_name']}</strong>.<br><br>

        Our Team, has added your details to our beneficiary database.
        Your profile will now be reviewed for eligibility to receive assistance under our programs.<br><br>

        <strong>Your Registered Details:</strong><br>
        <ul style='list-style: none; padding-left: 0;'>
         <li><strong>Registration No:</strong> {$id}</li>
          <li><strong>Full Name:</strong> {$name}</li>
          <li><strong>Gender:</strong> {$gender}</li>
          <li><strong>Mobile:</strong> {$mobile}</li>
          <li><strong>Category:</strong> {$category}</li>
          <li><strong>State:</strong> {$state}</li>
          <li><strong>District:</strong> {$district}</li>
          <li><strong>Address:</strong> {$address}</li>
        </ul><br>

         We’ll contact you soon with further updates or assistance details.<br><br>

        If you have any questions, feel free to reach out to us at 
        <a href='mailto:{$dataweb['webemail_1']}' style='color: #ff4b2b;'>{$dataweb['webemail_1']}</a> 
        or call us at {$dataweb['site_mobile_1']}.<br><br>

        Thank you for being part of our mission to bring positive change! <br><br>

        Warm regards,<br>
        {$dataweb['certificate_provider_name']}<br>
        {$dataweb['designation']}<br>
        <a href='https://www.{$dataweb['site_url']}' target='_blank' style='color: #ff416c;'>www.{$dataweb['site_url']}</a><br>
        <strong>{$dataweb['web_name']}</strong>
      </div>

    </div>
  </div>
</div>";

            $mail->send();
        } catch (Exception $e) {
            return redirect()->back()->with('msg', 'Response saved, but user email failed to send.');
        } 
    
}

public function BeneficiaryRequest(){
    
   $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
     $data['heading']="Beneficiary Request List";
     $beneficiaryModel = new BeneficiaryModel();  
     $data['member']= $beneficiaryModel->orderBy('id', 'DESC')->where('status', "0")->where('apply_status', "inactive")->findAll();
     
      return view('beneficiary/Beneficiary-List',$data);   
    
    
}
public function BeneficiaryActiveList(){
  $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
     $data['heading']="Beneficiary Active List";
     $beneficiaryModel = new BeneficiaryModel();  
     $data['member']= $beneficiaryModel->orderBy('id', 'desc')->where('status', "1")->where('apply_status', "active")->findAll();
     
      return view('beneficiary/Beneficiary-List',$data); 
}
public function BeneficiaryInactiveList(){

 $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
     $data['heading']="Beneficiary Inactive List";
     $beneficiaryModel = new BeneficiaryModel();  
     $data['member']= $beneficiaryModel->orderBy('id', 'desc')->where('status', "0")->where('apply_status', "active")->findAll();
     
      return view('beneficiary/Beneficiary-List',$data);    
    
}


public function createhelpdata(){
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
   
    $beneficiary_id=$this->request->getPost('beneficiary_id');
    $help_description=$this->request->getPost('help_description');
    $help_amount= $this->request->getPost('help_amount');
    $data = [
        
        'beneficiary_id'=>$beneficiary_id,
        'help_description'=>$help_description,
        'help_amount'=>$help_amount,
        ];
        
    $BeneficiaryHelp = new BeneficiaryHelpModel();
    $result =$BeneficiaryHelp->save($data);
    if($result){
      return redirect()
        ->to(base_url('Beneficiary-Active-List'))
        ->with('msg', 'Health Beneficiary data saved successfully!');  
        
    }else{
        
     return redirect()->back()->with('msg', 'Health Beneficiary data saved Fail!');     
    }
    
}
 
 public function updatehelpdata(){
    $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}
   
    $id=$this->request->getPost('help_id');
    $help_description=$this->request->getPost('help_description');
    $help_amount= $this->request->getPost('help_amount');
    $data = [
        
        
        'help_description'=>$help_description,
        'help_amount'=>$help_amount,
        ];
        
    $BeneficiaryHelp = new BeneficiaryHelpModel();
    $result =$BeneficiaryHelp->update($id,$data);
    if($result){
      return redirect()
        ->back()->with('msg', 'Health Beneficiary data Update successfully!');  
        
    }else{
        
     return redirect()->back()->with('msg', 'Health Beneficiary data saved Fail!');     
    }
    
}
 
 public function helpbeneficiarylist($id){
     
      $session = session();
    $model = new UserModel();
    $data = $model->where('id', $session->id)->first();

    if (!$data || $data['user_type'] != "admin") {
       
     return redirect()->to('signin')->with('msg', 'Unauthorised Access!');
}    
      $data['heading']="Help Beneficiary List";
       $beneficiaryModel = new BeneficiaryModel();  
     $data['beneficiary'] = $beneficiaryModel->where('id', $id)->first(); 
    $BeneficiaryHelp = new BeneficiaryHelpModel();
    $data['member'] =$BeneficiaryHelp->orderBy('id', 'DESC')->where('beneficiary_id', $id)->findAll(); 
    
      return view('beneficiary/Beneficiary-Help-List',$data); 
     
 }
 
 
 public function helpbeneficiarydetails($id){
     
   $beneficiaryModel = new BeneficiaryModel();  
     $data['beneficiary'] = $beneficiaryModel->where('id', $id)->first();  
     
       return view('beneficiary/Beneficiary-Details',$data);  
     
 }
 public function helpbeneficiarystop($id)
{
    $session = session();
    $userModel = new UserModel();

    // Check if logged-in user is admin
    $user = $userModel->where('id', $session->id)->first();
    if (!$user || $user['user_type'] !== "admin") {
        return redirect()->to('signin')->with('msg', 'Unauthorized Access!');
    }

    $beneficiaryModel = new BeneficiaryModel();
    $beneficiary = $beneficiaryModel->where('id', $id)->first();

    if ($beneficiary) {
        $updateData = [
            'status' => "0",
            'stop_at' => date('Y-m-d H:i:s'),
        ];

        if ($beneficiaryModel->update($id, $updateData)) {
            return $this->helpbeneficiarystopMail($id);
            
            return redirect()->back()->with('msg', 'Beneficiary stopped successfully — no further help will be provided.');
        } else {
            return redirect()->back()->with('msg', 'Failed to stop beneficiary. Please try again.');
        }
    } else {
        return redirect()->back()->with('msg', 'Beneficiary not found.');
    }
}

private function helpbeneficiarystopMail($id){
    
   $beneficiaryModel = new BeneficiaryModel();  
     $data= $beneficiaryModel->where('id', $id)->first();
     $name = $data['full_name'];
     $email =$data['email'];
     $mobile=$data['mobile'];
     $gender = $data['gender'];
     $state = $data['state'];
     $district = $data['district'];
     $address = $data['address'];
     $category = $data['category'];
     
     $help_type= $data['category'];
     $help_date=$data['created_at'];
      $BeneficiaryHelp = new BeneficiaryHelpModel();
    $dataamount =$BeneficiaryHelp->orderBy('id', 'DESC')->where('beneficiary_id', $id)->findAll(); 
    $totalAmount = 0;
    foreach($dataamount as $amount){
        
        $totalAmount+=$amount['help_amount'];
    }
     
     $help_amount =$totalAmount;
       $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
       

        require 'vendor/autoload.php';
        require 'phpmailer/src/PHPMailer.php';
        require 'phpmailer/src/Exception.php';
        require 'phpmailer/src/SMTP.php';

        require 'db_config.php';

        // Fetch email config
        $email_data = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `email_credentials`"), MYSQLI_ASSOC);
        $dataweb = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `admin_website_update`"), MYSQLI_ASSOC);
        $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

        // ===================== SEND TO USER =====================
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = $email_data['host'];
            $mail->SMTPAuth = true;
            $mail->Username = $email_data['by_email'];
            $mail->Password = $email_data['by_password'];
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mail->addAddress($email, $name);
            $mail->isHTML(true);
           

           $mail->Subject = "Assistance Provided - {$dataweb['web_name']}";
$mail->Body = "
<div style='margin:0 auto;border:5px solid transparent;border-image:linear-gradient(135deg,#2196f3,#21cbf3);border-image-slice:1;background-color:#f9f9f9;border-radius:15px;overflow:hidden;font-family:Arial,sans-serif;color:#000;'>
  <div style=\"
    background-image:url('{$weblogo}');
    background-repeat:no-repeat;
    background-position:center 60%;
    background-size:40%;
    background-color:#ffffff;
    border-radius:15px;
  \">
    <div style='background-color:rgba(255,255,255,0.92);padding:30px;border-radius:10px;max-width:650px;margin:0 auto;box-shadow:0 0 10px rgba(0,0,0,0.05);'>
      
      <div style='text-align:center;margin-bottom:30px;'>
        <img src='{$weblogo}' style='width:80px;display:block;margin:0 auto;' alt='Logo'>
        <p style='font-size:24px;font-weight:bold;margin-top:10px;'>{$dataweb['web_name']}</p>
      </div>

      <div style='font-size:16px;line-height:1.6;color:#333;'>
        Dear {$name},<br><br>
         <strong>Good News!</strong><br>
        We are pleased to inform you that <strong>{$dataweb['web_name']}</strong> has successfully <strong>provided assistance</strong> to you under our beneficiary support initiative.<br><br>

        <strong>Details of Support:</strong><br>
        <ul style='list-style:none;padding-left:0;'>
          <li><strong>Registration No:</strong> {$id}</li>
          <li><strong>Full Name:</strong> {$name}</li>
          <li><strong>Type of Assistance:</strong> {$help_type}</li>
          <li><strong>Amount / Aid Provided:</strong> ₹{$help_amount}</li>
         
         
        </ul><br>

        Your contribution request has now been <strong>completed successfully</strong> and recorded in our system.<br><br>

         We hope this support helps you in your journey toward better well-being and stability.<br><br>

        For any queries or follow-up, please contact our support team at 
        <a href='mailto:{$dataweb['webemail_1']}' style='color:#2196f3;'>{$dataweb['webemail_1']}</a> 
        or call us at {$dataweb['site_mobile_1']}.<br><br>

        Thank you for being part of our mission to create a positive social impact. <br><br>

        With Best Wishes,<br>
        {$dataweb['certificate_provider_name']}<br>
        {$dataweb['designation']}<br>
        <a href='https://www.{$dataweb['site_url']}' target='_blank' style='color:#2196f3;'>www.{$dataweb['site_url']}</a><br>
        <strong>{$dataweb['web_name']}</strong>
      </div>
    </div>
  </div>
</div>";


            $mail->send();
        } catch (Exception $e) {
            return redirect()->back()->with('msg', 'Response saved, but user email failed to send.');
        }     
    
}



 public function helpbeneficiarystart($id)
{
    $session = session();
    $userModel = new UserModel();

    // Check if logged-in user is admin
    $user = $userModel->where('id', $session->id)->first();
    if (!$user || $user['user_type'] !== "admin") {
        return redirect()->to('signin')->with('msg', 'Unauthorized Access!');
    }

    $beneficiaryModel = new BeneficiaryModel();
    $beneficiary = $beneficiaryModel->where('id', $id)->first();

    if ($beneficiary) {
        $updateData = [
            'status' => "1",
            'start_at' => date('Y-m-d H:i:s'),
        ];

        if ($beneficiaryModel->update($id, $updateData)) {
            return redirect()->back()->with('msg', 'Beneficiary Restart successfully — now further help will be provide.');
        } else {
            return redirect()->back()->with('msg', 'Failed to restart beneficiary. Please try again.');
        }
    } else {
        return redirect()->back()->with('msg', 'Beneficiary not found.');
    }
}
 
 
 
  public function BeneficiaryStart($id)
{
    $session = session();
    $userModel = new UserModel();

    // Check if logged-in user is admin
    $user = $userModel->where('id', $session->id)->first();
    if (!$user || $user['user_type'] !== "admin") {
        return redirect()->to('signin')->with('msg', 'Unauthorized Access!');
    }

    $beneficiaryModel = new BeneficiaryModel();
    $beneficiary = $beneficiaryModel->where('id', $id)->first();

    if ($beneficiary) {
        $updateData = [
            'status' => "1",
            'start_at' => date('Y-m-d H:i:s'),
            'apply_status'=>"active",
       
        ];

        if ($beneficiaryModel->update($id, $updateData)) {
            $this->BeneficiaryStartMail($id);
            return redirect()->back()->with('msg', 'Beneficiary Start Successfully — now further help will be provide.');
        } else {
            return redirect()->back()->with('msg', 'Failed to restart beneficiary. Please try again.');
        }
    } else {
        return redirect()->back()->with('msg', 'Beneficiary not found.');
    }
}
 
 
 public function BeneficiaryStartMail($id){
     
    $beneficiaryModel = new BeneficiaryModel();  
     $data= $beneficiaryModel->where('id', $id)->first();
     $name = $data['full_name'];
     $email =$data['email'];
     $mobile=$data['mobile'];
     $gender = $data['gender'];
     $state = $data['state'];
     $district = $data['district'];
     $address = $data['address'];
     $category = $data['category'];
       $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
       

        require 'vendor/autoload.php';
        require 'phpmailer/src/PHPMailer.php';
        require 'phpmailer/src/Exception.php';
        require 'phpmailer/src/SMTP.php';

        require 'db_config.php';

        // Fetch email config
        $email_data = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `email_credentials`"), MYSQLI_ASSOC);
        $dataweb = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `admin_website_update`"), MYSQLI_ASSOC);
        $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

        // ===================== SEND TO USER =====================
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = $email_data['host'];
            $mail->SMTPAuth = true;
            $mail->Username = $email_data['by_email'];
            $mail->Password = $email_data['by_password'];
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mail->addAddress($email, $name);
            $mail->isHTML(true);
           

           $mail->Subject = "Beneficiary Verification Approved - {$dataweb['web_name']}";
    $mail->Body = "
    <div style='margin:0 auto;border:5px solid transparent;border-image:linear-gradient(135deg,#00c853,#b2ff59);border-image-slice:1;background-color:#f9f9f9;border-radius:15px;overflow:hidden;font-family:Arial,sans-serif;color:#000;'>
      <div style=\"
        background-image:url('{$weblogo}');
        background-repeat:no-repeat;
        background-position:center 60%;
        background-size:40%;
        background-color:#ffffff;
        border-radius:15px;
      \">
        <div style='background-color:rgba(255,255,255,0.90);padding:30px;border-radius:10px;max-width:650px;margin:0 auto;box-shadow:0 0 10px rgba(0,0,0,0.05);'>
          <div style='text-align:center;margin-bottom:30px;'>
            <img src='{$weblogo}' style='width:80px;display:block;margin:0 auto;' alt='Logo'>
            <p style='font-size:24px;font-weight:bold;margin-top:10px;'>{$dataweb['web_name']}</p>
          </div>
          <div style='font-size:16px;line-height:1.6;color:#333;'>
            Dear {$name},<br><br>
            <strong>Congratulations!</strong><br>
            Your <strong>Beneficiary Application</strong> has been successfully <strong>verified and approved</strong> by <strong>{$dataweb['web_name']}</strong>.<br><br>

            You are now officially registered in our verified beneficiary list and eligible to receive assistance under our welfare programs.<br><br>

            <strong>Your Approved Details:</strong><br>
            <ul style='list-style:none;padding-left:0;'>
              <li><strong>Registration No:</strong> {$id}</li>
              <li><strong>Full Name:</strong> {$name}</li>
              <li><strong>Gender:</strong> {$gender}</li>
              <li><strong>Mobile:</strong> {$mobile}</li>
              <li><strong>Category:</strong> {$category}</li>
              <li><strong>State:</strong> {$state}</li>
              <li><strong>District:</strong> {$district}</li>
              <li><strong>Address:</strong> {$address}</li>
            </ul><br>

             Our team will reach out to you with further program details or next steps soon.<br><br>

            For any assistance, feel free to email us at 
            <a href='mailto:{$dataweb['webemail_1']}' style='color:#00c853;'>{$dataweb['webemail_1']}</a> 
            or call us at {$dataweb['site_mobile_1']}.<br><br>

            Thank you for trusting <strong>{$dataweb['web_name']}</strong> and joining our mission to serve humanity with compassion. 🌿<br><br>

            Warm regards,<br>
            {$dataweb['certificate_provider_name']}<br>
            {$dataweb['designation']}<br>
            <a href='https://www.{$dataweb['site_url']}' target='_blank' style='color:#00c853;'>www.{$dataweb['site_url']}</a><br>
            <strong>{$dataweb['web_name']}</strong>
          </div>
        </div>
      </div>
    </div>";

            $mail->send();
        } catch (Exception $e) {
            return redirect()->back()->with('msg', 'Response saved, but user email failed to send.');
        }  
     
 }
 public function BeneficiaryLandingView(){
    $beneficiaryModel = new BeneficiaryModel();
    $data['beneficiary'] = $beneficiaryModel->where('apply_status', "active")->where('status', "1")->orderBy('id', 'DESC')->findAll(); 
    
    return view('beneficiary/Beneficiary-Landing-View',$data);  
 }
 
 public function getHelpHistory($id)
{
   $BeneficiaryHelp = new BeneficiaryHelpModel();
    $helpData = $BeneficiaryHelp
                    ->where('beneficiary_id', $id)
                    ->orderBy('id', 'DESC')
                    ->findAll();

    if ($helpData) {
        return $this->response->setJSON([
            'status' => 'success',
            'data' => $helpData
        ]);
    } else {
        return $this->response->setJSON([
            'status' => 'error',
            'data' => []
        ]);
    }
}

public function BeneficiaryHealpDelete($id){
     $session = session();
    $userModel = new UserModel();

   
    $user = $userModel->where('id', $session->id)->first();
    if (!$user || $user['user_type'] !== "admin") {
        return redirect()->to('signin')->with('msg', 'Unauthorized Access!');
    }
  $BeneficiaryHelp = new BeneficiaryHelpModel();
    $helpData = $BeneficiaryHelp->delete($id);

    if ($helpData) {
        return redirect()->back()->with('msg', 'Beneficiary Healp Delete Successfully!');
    } else {
        return redirect()->back()->with('msg', 'Beneficiary Healp Delete Fail!');
    }  
    
}

public function updateadminaccess(){
     
   $session = session();
    $userModel = new UserModel();

   
    $user = $userModel->where('id', $session->id)->first();
    if (!$user || $user['user_type'] !== "admin") {
        return redirect()->to('signin')->with('msg', 'Unauthorized Access!');
    }
    $payment_auto_verify = $this->request->getPost('payment_auto_verify');
    
    $setingsModel = new SettingsModel();
    $data = [
        'payment_auto_verify'=>$payment_auto_verify,
        ];
         $resultdata = $setingsModel->first();
         
         if($resultdata){
             $id = $resultdata['id'];
       $result = $setingsModel->update($id, $data);
        return redirect()->back()->with('msg', 'Settings Update');
         }
       else {
            $result = $setingsModel->save($data);
        return redirect()->back()->with('msg', 'Settings Save');
       }
        
}

}

