    <?php
use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
 
 
$routes->get('/', 'Home::index');


// Card holder routes
$routes->get('card-login', 'Home::LoginHealthCard');
$routes->post('card-login', 'Home::login');
$routes->get('card-logout', 'Home::logout');
$routes->get('card-dashboard', 'Home::dashboard');


$routes->get('siteurl', 'Home::siteurl');
$routes->get('error_page', 'Home::error_page');
$routes->get('index', 'Home::index');
$routes->get('App-Download', 'Home::app_download');
$routes->get('contact', 'Home::contact');
$routes->get('gallery', 'Home::gallery');
$routes->get('mailSignup', 'Home::mailSignup');
$routes->get('pressrelease', 'Home::pressrelease');
$routes->get('ourproject1', 'Home::ourproject1');
$routes->get('ourproject2', 'Home::ourproject2');
$routes->get('ourproject3', 'Home::ourproject3');
$routes->get('bankinformation', 'Home::bankinformation');
$routes->get('donate_view', 'Home::donate_view');
$routes->get('about', 'Home::about');
$routes->get('werewework', 'Home::werewework');
$routes->get('ourmanegmentteam', 'Home::ourmanegmentteam');
$routes->get('achievement', 'Home::achievement');
$routes->get('update_profile', 'Home::update_profile');
$routes->get('signin', 'Home::signin');
$routes->get('Enquiry-Form', 'Home::EnquiryForm');
$routes->get('referral_nodate_form/(:any)', 'Home::referral_nodate_form/$1');
$routes->post('referralDonateData', 'Home::referralDonateData');

$routes->post('Enquiry-Form-Data', 'Home::EnquiryFormData');


$routes->get('Member-Data-Show', 'Home::MemberDataShow');

$routes->get('Apply-Beneficiary-form', 'Home::ApplyBeneficiaryform');

// API Routes for dependent dropdowns
$routes->get('api/zones', 'Location\LocationController::zones');
$routes->get('api/states/(:num)', 'Location\LocationController::states/$1');
$routes->get('api/districts/(:num)', 'Location\LocationController::districts/$1');
$routes->get('api/blocks/(:num)', 'Location\LocationController::blocks/$1');
$routes->get('api/gp/(:num)', 'Location\LocationController::gramPanchayats/$1');

// // Admin Zone CRUD
// $routes->get('zone', 'Location\LocationController::index');                  // list
// $routes->get('zones/create', 'Location\LocationController::create');         // add form
// $routes->post('zones/store', 'Location\LocationController::store');          // save new
// $routes->get('zones/edit/(:num)', 'Location\LocationController::edit/$1');   // edit form
// $routes->post('zones/update/(:num)', 'Location\LocationController::update/$1'); // update
// $routes->get('zones/delete/(:num)', 'Location\LocationController::delete/$1');  // delete



$routes->get('secure/(:any)', function ($encoded) {
    $decoded = base64_decode($encoded);
    
    if (str_starts_with($decoded, 'signin_')) {
        return (new \App\Controllers\Home())->signin();
    } 
    
    elseif (str_starts_with($decoded, 'signup_')) {
        return (new \App\Controllers\Home())->signup();
    }
      elseif (str_starts_with($decoded, 'donation_visitor_form_')) {
        return (new \App\Controllers\Home())->donation_visitor_form();
    }
    elseif (str_starts_with($decoded, 'member-referral-link_')) {
        return (new \App\Controllers\User_dashboard())->member_referral_link();
    }
    elseif (str_starts_with($decoded, 'dashboard_')) {
        return (new \App\Controllers\Dashboard())->index();
    } else {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
    }
});

$routes->get('Campaign-Donate-Form/(:num)', 'Home::CampaignDonateForm/$1');
$routes->get('Public-Report-Project', 'Home::PublicReportProject'); 

$routes->get('report_expense_Download/(:num)', 'Home::report_expense_Download/$1');
$routes->post('DonoateCampaignData', 'Home::donoate_campaign_data');

$routes->get('donation_visitor_form', 'Home::donation_visitor_form');
$routes->get('signup', 'Home::signup');


$routes->get('signin', 'Home::signin');

$routes->get('Member-Area-Data', 'Home::MemberAreaData');

$routes->post('forgot_password_otp', 'Home::forgot_password_otp');
$routes->post('match_otp_data', 'Home::match_otp_data');
$routes->post('match_password_data', 'Home::match_password_data');
$routes->get('nodate_form/(:any)', 'Home::nodate_form/$1');

$routes->post('nodate_now', 'Home::nodate_now');
$routes->get('donote_success_payment', 'Home::donote_success_payment');
$routes->get('referrral_donote_success_payment', 'Home::referrral_donote_success_payment');

$routes->get('donate_receipt_download/(:any)', 'Home::donate_receipt_download/$1');
$routes->get('campaign_donate_receipt_download/(:any)', 'Home::campaign_donate_receipt_download/$1');
$routes->post('donoate_visitor', 'Home::donoate_visitor');
$routes->get('visitor_donote_success_payment', 'Home::visitor_donote_success_payment');

$routes->get('camp_donote_success_payment', 'Home::camp_donote_success_payment');

$routes->post('payu/VisitorDonationResponse', 'Home::VisitorDonationResponse');
$routes->post('payu/payuCamp_success_payment', 'Home::payuCamp_success_payment');

$routes->post('payu/ReferralDonationresponse', 'Home::ReferralDonationresponse');
$routes->get('payudonate_receipt_download/(:any)', 'Home::payudonate_receipt_download/$1');


$routes->get('receipt_download/(:any)', 'Home::receipt_download/$1');
$routes->get('Apply-Internship-Form/(:num)', 'Home::ApplyInternshipForm/$1');
$routes->post('Apply-Internship-Data', 'Home::ApplyInternshipData');

$routes->get('internship_success/(:num)', 'Home::internship_success/$1');
$routes->get('member_ship_pay_now/(:num)', 'User_Controller::member_ship_pay_now/$1');

$routes->get('forgot-password', 'User_Controller::forgotPassword');
$routes->post('send-otp', 'User_Controller::sendOtp');
$routes->post('verify-otp', 'User_Controller::verifyOtp');
$routes->post('reset-password', 'User_Controller::resetPassword');

$routes->get('membership_receipt_download/(:any)', 'User_Controller::membership_receipt_download/$1'); 
$routes->get('show_admin_notice/(:any)', 'User_Controller::show_admin_notice/$1');
$routes->get('show_notice_user/(:any)', 'User_Controller::show_notice_user/$1');

$routes->get('membership_receipt_download_print/(:any)', 'User_Controller::membership_receipt_download_print/$1');
$routes->post('success_payment', 'User_Controller::success_payment');
$routes->get('success_payment', 'User_Controller::success_payment');
$routes->get('register_member', 'User_Controller::register_member');
$routes->get('loginsignup', 'User_Controller::loginsignup');
$routes->post('user_registration_mode', 'User_Controller::user_registration_mode');



$routes->post('payu/pay', 'User_Controller::pay');         
$routes->post('payu/response', 'User_Controller::response'); 
$routes->post('payu/Donationresponse', 'Home::Donationresponse'); 
/*API*/



$routes->post('login_auth', 'User_Controller::login_auth');
/*API*/
$routes->group('api', ['namespace' => 'App\Controllers\Api'], function($routes) {
     $routes->post('user/register', 'AuthController::register');
    $routes->post('auth/login', 'AuthController::login');
    $routes->get('user_success_payment/(:num)', 'AuthController::user_success_payment/$1');
    $routes->options('auth/login', 'AuthController::login'); // For CORS preflight
});

$routes->post('check-aadhar', 'User_Controller::checkAadhar');

$routes->get('logout', 'User_Controller::logout');
$routes->post('checkCredentials', 'User_dashboard::checkCredentials');
$routes->post('checkEmail', 'User_dashboard::checkEmail');
$routes->post('checkEmailF', 'User_dashboard::checkEmailF');  
$routes->post('checkMobile', 'User_dashboard::checkMobile');
$routes->get('Active-Referral/(:any)', 'User_dashboard::ActiveReferral/$1');
$routes->get('Inactive-Referral/(:any)', 'User_dashboard::InactiveReferral/$1');
$routes->get('user_dashboard/(:any)', 'User_dashboard::user_dashboard/$1');
$routes->get('user_dashboard/', 'User_dashboard::user_dashboard/');
$routes->get('profile/(:num)', 'User_dashboard::profile/$1');
$routes->get('edit_view_profile/(:num)', 'User_dashboard::edit_view_profile/$1');
$routes->post('edit_view_profile_data', 'User_dashboard::edit_view_profile_data');
$routes->post('admin_by_reason/(:num)', 'User_dashboard::admin_by_reason/$1');

$routes->get('donate_receipt_view/(:num)', 'User_dashboard::donate_receipt_view/$1');
$routes->get('profile/(:num)', 'User_dashboard::profile/$1'); 
$routes->post('update_user_profile', 'User_dashboard::update_user_profile');
$routes->get('user_upload_payment_data/(:num)', 'User_dashboard::user_upload_payment_data/$1');
$routes->post('user_upload_payment_data_save/', 'User_dashboard::user_upload_payment_data_save/');
$routes->get('print_id_card_by_user', 'User_dashboard::print_id_card_by_user');
$routes->get('print_id_card_by_user_process', 'User_dashboard::print_id_card_by_user_process/');
$routes->get('appointment_letter_by_user/(:num)', 'User_dashboard::appointment_letter_by_user/$1');

$routes->get('id_card_mobile_download/(:num)', 'User_dashboard::id_card_mobile_download/$1');

$routes->post('appointment_letter_by_process', 'User_dashboard::appointment_letter_by_process');
$routes->get('appointment_letter_by_process', 'User_dashboard::appointment_letter_by_process');
$routes->get('print_appointment_by_user_process/(:num)', 'User_dashboard::print_appointment_by_user_process/$1');
$routes->get('certificate_by_user/(:num)', 'User_dashboard::certificate_by_user/$1');
$routes->post('certificate_appointment_by_user_data', 'User_dashboard::certificate_appointment_by_user_data');
$routes->get('print_certificate_by_user_process', 'User_dashboard::print_certificate_by_user_process'); 

$routes->get('forgot_password', 'User_dashboard::forgot_password');
$routes->post('user_aadhar_verifie', 'User_dashboard::user_aadhar_verifie');
$routes->post('user_aadhar_verifie_process', 'User_dashboard::user_aadhar_verifie_process');
$routes->post('user_aadhar_verifie_process', 'User_dashboard::contact');
$routes->get('print_id_card_by_user/(:any)', 'User_dashboard::print_id_card_by_user/$1');
$routes->get('send_message_by_user/(:any)', 'User_dashboard::send_message_by_user/$1');
$routes->post('otp_form', 'User_dashboard::otp_form');
$routes->post('match_otp', 'User_dashboard::match_otp');
$routes->post('change_password_data', 'User_dashboard::change_password_data');
$routes->get('membership_status/(:any)', 'User_dashboard::membership_status/$1');
$routes->get('donate_view/(:any)', 'User_dashboard::donate_view/$1');

$routes->post('send_message_by_user_data', 'User_dashboard::send_message_by_user_data');
$routes->get('id_card_downlod__show_pdf/(:num)','User_dashboard::id_card_downlod__show_pdf/$1');
$routes->get('view_certificate/(:num)/(:any)','User_dashboard::view_certificate/$1/$2'); 
$routes->get('print_view_certificate/(:num)/(:any)','User_dashboard::print_view_certificate/$1/$2'); 
$routes->get('view_certificate_download/(:any)','User_dashboard::view_certificate_download/$1');
$routes->get('user_profile/(:num)','User_dashboard::user_profile/$1');
$routes->get('user_view_profile/(:num)', 'User_dashboard::user_view_profile/$1');
$routes->get('view_certificate/(:num)', 'User_dashboard::view_certificate/$1');
$routes->get('Membership-Certificate/(:num)', 'User_dashboard::MembershipCertificate/$1');


$routes->get('create_health_card', 'User_dashboard::create_health_card');
$routes->post('healthCardSave', 'User_dashboard::healthCardSave');
$routes->get('health-card', 'User_dashboard::healthcard');

$routes->get('healthCardDownload/(:num)', 'User_dashboard::healthCardDownload/$1');
$routes->get('cardDetails/(:num)', 'User_dashboard::cardDetails/$1');
$routes->get('health-card-payment/(:num)', 'User_dashboard::healthcardpayment/$1');

$routes->get('locationData/(:any)', 'User_dashboard::locationData/$1');
$routes->get('healthcard_success_payment', 'User_dashboard::healthcard_success_payment');
$routes->get('receiptHealthCard/(:num)', 'User_dashboard::receiptHealthCard/$1');

$routes->get('payemi/(:num)', 'User_dashboard::payemi/$1');
$routes->post('getTransactionHistory', 'User_dashboard::getTransactionHistory');

$routes->get('healthcardId/(:num)', 'User_dashboard::healthcardId/$1');



/* Admin Routes*/ 

$routes->get('deleteCard/(:num)', 'Admin_Controller::deleteCard/$1');
$routes->get('editCard/(:num)', 'Admin_Controller::editCard/$1');
$routes->post('updateCard/(:num)', 'Admin_Controller::updateCard/$1');
$routes->get('healthCardStatus/(:num)', 'Admin_Controller::healthCardStatus/$1');


$routes->get('InactiveHealthCard', 'Admin_Controller::InactiveHealthCard');

$routes->get('ActiveHealthCard', 'Admin_Controller::ActiveHealthCard');
$routes->get('Active-Management-Body', 'Admin_Controller::ActiveManagementBody');
$routes->post('bulkDeleteGenerateReceipt', 'Admin_Controller::bulkDeleteGenerateReceipt');
$routes->post('bulkDeleteEventUser', 'Admin_Controller::bulkDeleteEventUser');
$routes->post('bulkDeleteEvent', 'Admin_Controller::bulkDeleteEvent');
$routes->post('bulkDeleteEnquiry', 'Admin_Controller::bulkDeleteEnquiry');

$routes->post('bulkDeleteBeneficiary', 'Admin_Controller::bulkDeleteBeneficiary');
$routes->post('bulkDeleteNotice', 'Admin_Controller::bulkDeleteNotice');
$routes->post('bulkDeleteUserCertificate', 'Admin_Controller::bulkDeleteUserCertificate');
$routes->post('bulkDeleteUser', 'Admin_Controller::bulkDeleteUser');
$routes->get('certificate/download/(:num)', 'Admin_Controller::certificatedownload/$1');
$routes->post('update-admin-access', 'Admin_Controller::updateadminaccess');
$routes->get('Beneficiary-Healp-Delete/(:num)', 'Admin_Controller::BeneficiaryHealpDelete/$1');

$routes->get('Beneficiary-Request', 'Admin_Controller::BeneficiaryRequest');
$routes->get('Beneficiary-Start/(:num)', 'Admin_Controller::BeneficiaryStart/$1');

$routes->get('Beneficiary-Landing-View', 'Admin_Controller::BeneficiaryLandingView');
$routes->get('help-beneficiary-stop/(:num)', 'Admin_Controller::helpbeneficiarystop/$1');
$routes->get('help-beneficiary-details/(:num)', 'Admin_Controller::helpbeneficiarydetails/$1');
$routes->get('get-beneficiary-help-history/(:num)', 'Admin_Controller::getHelpHistory/$1');
$routes->get('help-beneficiary-start/(:num)', 'Admin_Controller::helpbeneficiarystart/$1');
$routes->get('Beneficiary-Edit/(:num)', 'Admin_Controller::BeneficiaryEdit/$1');
$routes->get('Beneficiary-Delete/(:num)', 'Admin_Controller::BeneficiaryDelete/$1');

$routes->get('help-beneficiary-list/(:num)', 'Admin_Controller::helpbeneficiarylist/$1');
$routes->post('create-help-data', 'Admin_Controller::createhelpdata');
$routes->post('update-help-data', 'Admin_Controller::updatehelpdata');

$routes->post('Beneficiary-data', 'Admin_Controller::Beneficiarydata');
$routes->get('Beneficiary-Active-List', 'Admin_Controller::BeneficiaryActiveList');
$routes->get('Beneficiary-Inactive-List', 'Admin_Controller::BeneficiaryInactiveList');


$routes->get('Beneficiary-Add', 'Admin_Controller::BeneficiaryAdd');

$routes->get('Create-Post', 'Admin_Controller::CreatePost');
$routes->post('update-post-data/(:num)', 'Admin_Controller::updatepostdata/$1');
$routes->get('posts-list', 'Admin_Controller::postslist');



// AJAX routes for posts
 $routes->get('postslist', 'Admin_Controller::postslist');


$routes->delete('deletePost/(:num)', 'Admin_Controller::deletePost/$1');
$routes->post('bulkDeletePosts', 'Admin_Controller::bulkDeletePosts');

$routes->get('Public-Posts', 'Admin_Controller::publicPosts');
$routes->get('Post-Edit/(:num)', 'Admin_Controller::PostEdit/$1');
$routes->get('Post-Delete/(:num)', 'Admin_Controller::PostDelete/$1');

$routes->post('delete-post-image/(:num)', 'Admin_Controller::deletepostimage/$1');

$routes->post('create-post-data', 'Admin_Controller::createpostdata');


$routes->get('Verify-Member-Data', 'Admin_Controller::VerifyMemberData');
$routes->get('Search-Donation-History', 'Admin_Controller::SearchDonationHistory');

$routes->post('Search-Donation-History-DataId', 'Admin_Controller::SearchDonationHistoryDataId'); 
$routes->post('Verify-Member-DataId', 'Admin_Controller::VerifyMemberDataId');

$routes->post('managementBodyStore', 'Admin_Controller::managementBodyStore');
$routes->post('ManagementBody-Delete-Multiple', 'Admin_Controller::ManagementBodyDeleteMultiple');

$routes->get('managementbodyList', 'Admin_Controller::managementbodyList');
$routes->get('Landing-Management-Body', 'Admin_Controller::LandingManagementBody');
$routes->get('Landing-Management4-Body', 'Admin_Controller::LandingManagement4Body');

$routes->get('ManagementBody-Edit/(:any)', 'Admin_Controller::ManagementBodyEdit/$1');
$routes->get('ManagementBody-Delete/(:any)', 'Admin_Controller::ManagementBodyDelete/$1');

$routes->get('Add-Management-Member', 'Admin_Controller::managementBodyCreate');
$routes->get('Verify-Member-Data', 'Admin_Controller::VerifyMemberData');
$routes->get('Search-Donation-History', 'Admin_Controller::SearchDonationHistory');

$routes->post('Search-Donation-History-DataId', 'Admin_Controller::SearchDonationHistoryDataId');
$routes->post('Verify-Member-DataId', 'Admin_Controller::VerifyMemberDataId');

$routes->post('managementBodyStore', 'Admin_Controller::managementBodyStore');
$routes->post('ManagementBody-Delete-Multiple', 'Admin_Controller::ManagementBodyDeleteMultiple');

$routes->get('managementbodyList', 'Admin_Controller::managementbodyList');
$routes->get('Landing-Management-Body', 'Admin_Controller::LandingManagementBody');

$routes->get('ManagementBody-Edit/(:any)', 'Admin_Controller::ManagementBodyEdit/$1');
$routes->get('ManagementBody-Delete/(:any)', 'Admin_Controller::ManagementBodyDelete/$1');

$routes->get('Add-Management-Member', 'Admin_Controller::managementBodyCreate');
$routes->get('reffral_donation_fail', 'Admin_Controller::reffral_donation_fail');
$routes->get('campaign_donation_fail', 'Admin_Controller::campaign_donation_fail');

$routes->post('delete_campaign_data', 'Admin_Controller::delete_campaign_data');
$routes->post('delete_news_Bulk', 'Admin_Controller::delete_news_Bulk');
$routes->post('delete_enquiry_data', 'Admin_Controller::delete_enquiry_data');
$routes->post('occupation/delete-multiple', 'Admin_Controller::deleteMultiple');
$routes->post('admin_payment_update_data_payu_process', 'Admin_Controller::admin_payment_update_data_payu_process');
$routes->get('Certficate-Internship', 'Admin_Controller::CertficateInternship');
$routes->get('sendCompletionMails', 'Admin_Controller::sendCompletionMails');
$routes->get('Verify-Form-Certficate-Internship', 'Admin_Controller::VerifyFormCertficateInternship');
$routes->post('verify-certificate', 'Admin_Controller::verifycertificate');

$routes->get('Intern-Certificate-Complete', 'Admin_Controller::InternCertificateComplete');
 
 $routes->post('certificate/download', 'Admin_Controller::certificatedownload');
$routes->post('paymentGatewayUpdateStatus', 'Admin_Controller::paymentGatewayUpdateStatus');
$routes->get('intern_user_details/(:num)', 'Admin_Controller::intern_user_details/$1');

$routes->get('intern_user_edit/(:num)', 'Admin_Controller::intern_user_edit/$1');

$routes->get('intern_user_delete/(:num)', 'Admin_Controller::intern_user_delete/$1');
$routes->post('Apply-Update-Data', 'Admin_Controller::ApplyUpdateData');


$routes->get('News-Status/(:num)', 'Admin_Controller::NewsStatus/$1');
$routes->get('News-Edit/(:num)', 'Admin_Controller::NewsEdit/$1');
$routes->get('News-Delete/(:num)', 'Admin_Controller::NewsDelete/$1');
$routes->get('News-Details/(:num)', 'Admin_Controller::NewsDetails/$1');
$routes->get('Active-News', 'Admin_Controller::ActiveNews');
$routes->get('Inactive-News', 'Admin_Controller::InactiveNews');
$routes->get('Pending-News', 'Admin_Controller::InactiveNews');
$routes->get('Show-Active-News', 'Admin_Controller::ShowActiveNews');
$routes->get('Create-News', 'Admin_Controller::createNews');
$routes->post('create-news-data', 'Admin_Controller::storeNews');
$routes->post('update-news-data', 'Admin_Controller::updatenewsdata');

$routes->get('Registeratered-Internship', 'Admin_Controller::RegisterateredInternship');

$routes->get('Generate_case_donation_show', 'Admin_Controller::Generate_case_donation_show');
$routes->post('Generate_donoate_case', 'Admin_Controller::Generate_donoate_case');
$routes->get('Generate_donate_receipt_download/(:num)', 'Admin_Controller::Generate_donate_receipt_download/$1');
$routes->get('Generate_delete_donation_receipt_pdf/(:num)', 'Admin_Controller::Generate_delete_donation_receipt_pdf/$1');

$routes->get('Generate_donation_details/(:num)', 'Admin_Controller::Generate_donation_details/$1');


$routes->get('Generate_case_donation_form', 'Admin_Controller::Generate_case_donation_form');
$routes->get('campaign_donate_delete/(:num)', 'Admin_Controller::campaign_donate_delete/$1');
$routes->post('DonoateCampaignDataUpdate', 'Admin_Controller::DonoateCampaignDataUpdate');
$routes->get('Create-Campaigns', 'Admin_Controller::CreateCampaigns');
$routes->get('campaign_edit/(:num)', 'Admin_Controller::campaign_edit/$1');
$routes->get('campaign_details/(:num)', 'Admin_Controller::campaign_details/$1');
$routes->get('campaign_delete/(:num)', 'Admin_Controller::campaign_delete/$1');
$routes->post('Add-Campaign-Data', 'Admin_Controller::AddCampaignData');
$routes->post('Add-Campaign-Data-Update', 'Admin_Controller::AddCampaignDataUpdate');

$routes->get('Campaigns-Donation-Dashboard', 'Admin_Controller::CampaignsDonationDashboard');
$routes->get('Campaigns', 'Admin_Controller::Campaigns');

$routes->get('Campaigns-View', 'Admin_Controller::CampaignsViews');

$routes->get('List-Campaign-Doners/(:num)', 'Admin_Controller::ListCampaignDoners/$1');
$routes->get('Donation', 'Admin_Controller::Donation');
$routes->get('Donation-Fail', 'Admin_Controller::DonationFail');




$routes->get('Categories', 'Admin_Controller::Categories');
$routes->get('Settings', 'Admin_Controller::Settings');

$routes->get('Project-Details/(:num)', 'Admin_Controller::ProjectDetails/$1');
$routes->get('Project-Expense-Details/(:num)', 'Admin_Controller::ProjectExpenseDetails/$1');
$routes->post('donation-project-update-data', 'Admin_Controller::donationprojectupdatedata');
$routes->get('Project-Edit/(:num)', 'Admin_Controller::ProjectEdit/$1');
$routes->get('Project-Delete/(:num)', 'Admin_Controller::ProjectDelete/$1');

$routes->get('Project-Expense-Edit/(:num)', 'Admin_Controller::ProjectExpenseEdit/$1');
$routes->post('project_expense_Update', 'Admin_Controller::project_expense_Update');
$routes->get('Project-Expense-Delete/(:num)', 'Admin_Controller::ProjectExpenseDelete/$1');

$routes->get('Create-Donation-Project', 'Admin_Controller::CreateDonationProject');

$routes->get('Campaigns-Complete', 'Admin_Controller::CampaignsComplete');
$routes->get('campaign_donate_edit/(:num)', 'Admin_Controller::campaign_donate_edit/$1');

$routes->post('donation-project-data', 'Admin_Controller::DonationProjectData');
$routes->get('Active-Donation-Project', 'Admin_Controller::ActiveDonationProject');

$routes->get('Complete-Donation-Project', 'Admin_Controller::CompleteDonationProject');

$routes->get('Project-Add-Expense/(:num)', 'Admin_Controller::ProjectAddExpense/$1');
$routes->post('project_expense_add', 'Admin_Controller::project_expense_add');
$routes->get('Event-Join-User/(:num)', 'Admin_Controller::EventJoinUser/$1');
$routes->get('event_tickets_details/(:num)', 'Admin_Controller::event_tickets_details/$1');
$routes->get('event_tickets_edit/(:num)', 'Admin_Controller::event_tickets_edit/$1');
$routes->get('event_tickets_delete/(:num)', 'Admin_Controller::event_tickets_delete/$1');
$routes->post('Event-Update-Data', 'Admin_Controller::EventUpdateData');
$routes->post('delete_doner', 'Admin_Controller::delete_doner');
$routes->post('delete_multiple_doners', 'Admin_Controller::delete_multiple_doners');
$routes->post('updateOccupation', 'Admin_Controller::updateOccupation');

$routes->post('Add-Occupation-Data', 'Admin_Controller::addOccupationData');

$routes->get('Get-Occupations', 'Admin_Controller::getOccupations');
$routes->post('Delete-Occupation/(:num)', 'Admin_Controller::deleteOccupation/$1');
$routes->get('Event-Details/(:num)', 'Admin_Controller::EventDetails/$1');
/*API */

$routes->get('api/event-details/(:num)', 'Api\EventController::getEventDetails/$1');


$routes->get('Enquiry-Request', 'Admin_Controller::EnquiryRequest');
$routes->get('Enquiry-Response', 'Admin_Controller::EnquiryResponse');
$routes->get('enquiry-data-delete/(:num)', 'Admin_Controller::enquirydatadelete/$1');

$routes->get('enquiry-data-details/(:num)', 'Admin_Controller::enquirydatadetails/$1');
$routes->post('admin_enquiry_response/(:num)/(:any)', 'Admin_Controller::admin_enquiry_response/$1/$2');
$routes->get('Create-Internship', 'Admin_Controller::CreateInternship');

$routes->post('Create-Internship-Data', 'Admin_Controller::CreateInternshipData');
$routes->post('Update-Internship-Data', 'Admin_Controller::UpdateInternshipData');


$routes->get('Active-Card-Internship', 'Admin_Controller::ActiveCardInternship');

$routes->get('Active-Internship', 'Admin_Controller::ActiveInternship');
$routes->get('Internship-Edit/(:num)', 'Admin_Controller::InternshipEdit/$1');
$routes->get('Internship-Delete/(:num)', 'Admin_Controller::InternshipDelete/$1');
$routes->get('Internship-Details/(:num)', 'Admin_Controller::InternshipDetails/$1');

$routes->get('Event-Edit/(:num)', 'Admin_Controller::EventEdit/$1');
$routes->get('Event-Delete/(:num)', 'Admin_Controller::EventDelete/$1');

$routes->get('Create-Event', 'Admin_Controller::CreateEvent');
$routes->post('create-event-data', 'Admin_Controller::createeventdata');
$routes->post('update-event-data', 'Admin_Controller::updateeventdata');
 
$routes->get('Active-Event', 'Admin_Controller::ActiveEvent');
$routes->get('Complete-Event', 'Admin_Controller::CompleteEvent');
$routes->get('Registeration-Event/(:num)', 'Admin_Controller::RegisterationEvent/$1');

$routes->post('Event-Registeration-Data', 'Admin_Controller::EventRegisterationData');


$routes->post('payu/Eventnresponse', 'Admin_Controller::Eventnresponse');
$routes->get('event_registeration_receipt_download/(:num)', 'Admin_Controller::event_registeration_receipt_download/$1');
$routes->get('Event_success_payment', 'Admin_Controller::Event_success_payment');

$routes->post('EventPayment', 'Admin_Controller::EventPayment');
$routes->get('Registeratered-Event', 'Admin_Controller::RegisterateredEvent');
$routes->get('Active-Card-Event', 'Admin_Controller::ActiveCardEvent');
/*API*/
$routes->group('api', ['namespace' => 'App\Controllers\Api'], function($routes) {
    $routes->get('events/active', 'EventController::activeEvents');
});

$routes->get('Comming-Birthday', 'Admin_Controller::CommingBirthday');
$routes->get('Today-Birthday', 'Admin_Controller::TodayBirthday');

$routes->post('birthdayMessage', 'Admin_Controller::birthdayMessage');
$routes->get('expense_report_download', 'Admin_Controller::expense_report_download');
$routes->get('coming_expire_member', 'Admin_Controller::coming_expire_member');
$routes->get('expire_member', 'Admin_Controller::expire_member');

$routes->post('expense_update', 'Admin_Controller::expense_update');
$routes->get('edit_expenseId/(:num)', 'Admin_Controller::edit_expenseId/$1');
$routes->post('delete_expenseId/(:any)', 'Admin_Controller::delete_expenseId/$1');
$routes->get('view_expense_details/(:num)', 'Admin_Controller::view_expense_details/$1');
$routes->post('search_filture_expense', 'Admin_Controller::search_filture_expense');
$routes->get('expense_list', 'Admin_Controller::expense_list');
$routes->post('expense_create', 'Admin_Controller::expense_create');
$routes->post('delete_expense', 'Admin_Controller::delete_expense');

$routes->get('Expence_Form', 'Admin_Controller::Expence_Form');
$routes->get('Income_Form', 'Admin_Controller::Income_Form');
$routes->post('search_filture_certificate_visitor', 'Admin_Controller::search_filture_certificate_visitor');
$routes->post('delete_visitor_certificate', 'Admin_Controller::delete_visitor_certificate');
$routes->post('search_filture_manager', 'Admin_Controller::search_filture_manager');
$routes->post('delete_users_certificate', 'Admin_Controller::delete_users_certificate');
$routes->post('search_filture_certificate', 'Admin_Controller::search_filture_certificate');
$routes->get('case_donation_show', 'Admin_Controller::case_donation_show');
$routes->post('donoate_case', 'Admin_Controller::donoate_case');
$routes->get('case_donation_form', 'Admin_Controller::case_donation_form');
$routes->get('visitor_certificate_show_admin', 'Admin_Controller::visitor_certificate_show_admin');
$routes->post('visitor_certificate_by_admin_process', 'Admin_Controller::visitor_certificate_by_admin_process');
$routes->get('visitor_certificate_generate_admin', 'Admin_Controller::visitor_certificate_generate_admin');
$routes->get('admin_resetwebsite_data', 'Admin_Controller::admin_resetwebsite_data');
$routes->post('admin_payment_update_data_razorpay_process', 'Admin_Controller::admin_payment_update_data_razorpay_process');
$routes->post('updateStatus', 'Admin_Controller::updateStatus');
$routes->post('verifyUser', 'Admin_Controller::verifyUser');
$routes->get('donation_details/(:num)', 'Admin_Controller::donation_details/$1');

$routes->post('search_filture_verify', 'Admin_Controller::search_filture_verify');
$routes->post('search_filture_campaigns', 'Admin_Controller::search_filture_campaigns');

$routes->post('search_filture_campaigns_donations', 'Admin_Controller::search_filture_campaigns_donations');

$routes->post('delete_users', 'Admin_Controller::delete_users');
$routes->post('delete_users_membership_receipt', 'Admin_Controller::delete_users_membership_receipt');
$routes->post('deleteAllDonationMember', 'Admin_Controller::deleteAllDonationMember');

$routes->post('search_filture_donation', 'Admin_Controller::search_filture_donation');
$routes->post('search_filture_cashdonation', 'Admin_Controller::search_filture_cashdonation');
$routes->post('deleteAllDonationCash', 'Admin_Controller::deleteAllDonationCash');

$routes->post('search_filtureMembership_receipt', 'Admin_Controller::search_filtureMembership_receipt');
$routes->post('search_filture_memebership', 'Admin_Controller::search_filture_memebership');
$routes->post('search_filture_member_donation', 'Admin_Controller::search_filture_member_donation');

$routes->get('admin_show_visitor_donation_receipt', 'Admin_Controller::admin_show_visitor_donation_receipt');

$routes->get('admin_show_visitor_donation_fail', 'Admin_Controller::admin_show_visitor_donation_fail');
$routes->get('view_notice_details/(:num)', 'Admin_Controller::view_notice_details/$1');
$routes->get('sent_notice_all_user', 'Admin_Controller::sent_notice_all_user');
$routes->post('admin_appointment_update_data_process', 'Admin_Controller::admin_appointment_update_data_process');
$routes->get('admin_appointment_update_data', 'Admin_Controller::admin_appointment_update_data');
$routes->post('admin_email_update_data_process', 'Admin_Controller::admin_email_update_data_process');
$routes->get('admin_email_update_data', 'Admin_Controller::admin_email_update_data');
$routes->post('admin_payment_update_data_process', 'Admin_Controller::admin_payment_update_data_process');
$routes->get('admin_payment_update_data', 'Admin_Controller::admin_payment_update_data');
$routes->post('admin_update_data_website', 'Admin_Controller::admin_update_data_website');
$routes->get('admin_update_data', 'Admin_Controller::admin_update_data');
$routes->get('admin_show_franchise', 'Admin_Controller::admin_show_franchise');
$routes->get('admin_send_notice_user', 'Admin_Controller::admin_send_notice_user');
$routes->get('notice_view_admin', 'Admin_Controller::notice_view_admin');

$routes->get('report_visitor_receipt_view_admin', 'Admin_Controller::report_visitor_receipt_view_admin');
$routes->get('report_donate_receipt_view_admin', 'Admin_Controller::report_donate_receipt_view_admin');
$routes->get('report_unverified_download_admin', 'Admin_Controller::report_unverified_download_admin');
$routes->get('report_verified_download_admin', 'Admin_Controller::report_verified_download_admin');
$routes->get('report_membership_fee_download_admin', 'Admin_Controller::report_membership_fee_download_admin');
$routes->post('delete_donation_receipt_pdf/(:any)', 'Admin_Controller::delete_donation_receipt_pdf/$1');

$routes->get('delete_notice/(:num)', 'Admin_Controller::delete_notice/$1');

$routes->get('admin_send_notice_single_user/(:num)', 'Admin_Controller::admin_send_notice_single_user/$1');
$routes->get('admin_by_manager_delete/(:num)', 'Admin_Controller::admin_by_manager_delete/$1');
$routes->get('edit_manager/(:num)', 'Admin_Controller::edit_manager/$1');
$routes->get('admin_by_user_delete/(:num)', 'Admin_Controller::admin_by_user_delete/$1');

$routes->post('admin_by_user_delete_AJAX/(:num)', 'Admin_Controller::admin_by_user_delete_AJAX/$1');

$routes->get('deleteAjax/(:any)', 'Admin_Controller::deleteAjax/$1');

$routes->get('admin_by_certificate_user/(:num)', 'Admin_Controller::admin_by_certificate_user/$1');
$routes->get('admin_by_certificate_show', 'Admin_Controller::admin_by_certificate_show');
$routes->get('admin_by_certificate_generate_id','Admin_Controller::admin_by_certificate_generate_id');
$routes->get('indcard_verifie/(:any)', 'Admin_Controller::indcard_verifie/$1');
$routes->get('certificate_download_by_admin/(:num)', 'Admin_Controller::certificate_download_by_admin/$1');
$routes->get('admin_by_certificate_show', 'Admin_Controller::admin_by_certificate_show');
$routes->get('admin_user_status_unblock/(:any)/(:any)','Admin_Controller::admin_user_status_unblock/$1/$2');
$routes->get('donate_receipt_view_admin', 'Admin_Controller::donate_receipt_view_admin');
$routes->get('donate_receipt_view_fail', 'Admin_Controller::donate_receipt_view_fail');
$routes->get('membership_receipt_download_admin', 'Admin_Controller::membership_receipt_download_admin');
$routes->get('membership_receipt_fail_admin', 'Admin_Controller::membership_receipt_fail_admin');
$routes->get('admin_status_inactive/(:num)/(:any)','Admin_Controller::admin_status_inactive/$1/$2');
$routes->get('admin_status_inactive_id/(:num)/(:any)','Admin_Controller::admin_status_inactive_id/$1/$2');
$routes->get('admin_show_user_details/(:any)', 'Admin_Controller::admin_show_user_details/$1');
$routes->post('admin_send_reason_user', 'Admin_Controller::admin_send_reason_user');
$routes->get('admin_show_verifie_user', 'Admin_Controller::admin_show_verifie_user');
$routes->get('admin_show_user_under_manager/(:any)', 'Admin_Controller::admin_show_user_under_manager/$1');
$routes->get('admin_show_manager', 'Admin_Controller::admin_show_manager');
$routes->post('update_admin_profile', 'Admin_Controller::update_admin_profile');
$routes->get('admin_profile/(:any)', 'Admin_Controller::admin_profile/$1');
$routes->post('search_user', 'Admin_Controller::search_user');
$routes->post('send_message_by_admin_data', 'Admin_Controller::send_message_by_admin_data');
$routes->post('search_filture', 'Admin_Controller::search_filture');
$routes->get('message_user/(:any)', 'Admin_Controller::message_user/$1');
$routes->get('admin_dashboard', 'Admin_Controller::admin_dashboard');
$routes->get('user_show_by_admin', 'Admin_Controller::user_show_by_admin');

$routes->get('edit_user_view/(:num)/(:any)', 'Admin_Controller::edit_user_view/$1/$2');

$routes->get('add_manager_by_admin/(:num)', 'Admin_Controller::add_manager_by_admin/$1');
$routes->get('generate_id_card_byadmin/(:num)', 'Admin_Controller::generate_id_card_byadmin/$1');
$routes->get('delete/(:num)', 'Admin_Controller::delete/$1');
$routes->get('admin_show_inactive_user', 'Admin_Controller::admin_show_inactive_user');


$routes->post('delete_campaignDonation_data', 'Admin_Controller::delete_campaignDonation_data');
$routes->post('delete_active_internship', 'Admin_Controller::delete_active_internship');

$routes->post('delete_registered_internship', 'Admin_Controller::delete_registered_internship');

$routes->get('admin_show_active_user', 'Admin_Controller::admin_show_active_user');
$routes->get('admin_update_user_status/(:num)/(:any)', 'Admin_Controller::admin_update_user_status/$1/$1');
$routes->get('payment_status/(:num)/(:any)', 'Admin_Controller::payment_status/$1/$1');
$routes->post('admin_update_user_status','Admin_Controller::admin_update_user_status');
$routes->post('signup-manager-by-admin','Admin_Controller::signup_manager_by_admin');
$routes->post('admin_update_user_profile','Admin_Controller::admin_update_user_profile');

$routes->post('update_status','Admin_Controller::update_status');
$routes->get('admin_by_certificate_generate','Admin_Controller::admin_by_certificate_generate');
$routes->get('admin_by_certificate_generate_form/(:num)','Admin_Controller::admin_by_certificate_generate_form/$1');
$routes->post('certificate_by_admin_process','Admin_Controller::certificate_by_admin_process');
$routes->get('admin_by_certificate_generate_show','Admin_Controller::admin_by_certificate_generate_show');
$routes->get('show_certificate_pdf/(:num)','Admin_Controller::show_certificate_pdf/$1');
$routes->get('delete_certificate_pdf/(:num)','Admin_Controller::delete_certificate_pdf/$1');

$routes->post('delete_certificate_pdf_AJAX/(:any)', 'Admin_Controller::delete_certificate_pdf_AJAX/$1');

$routes->get('download_certificate_pdf/(:num)','Admin_Controller::download_certificate_pdf/$1');
$routes->get('admin_status/(:any)/(:num)','Admin_Controller::admin_status/$1/$2');
$routes->get('admin_show_block_user','Admin_Controller::admin_show_block_user');
$routes->post('admin_user_status_block/(:num)/(:any)','Admin_Controller::admin_user_status_block/$1/$2');
$routes->get('notice_board_show/(:num)','Admin_Controller::notice_board_show/$1');
$routes->post('aadmin_user_notice_data','Admin_Controller::aadmin_user_notice_data');
$routes->post('aadmin_alluser_notice_data','Admin_Controller::aadmin_alluser_notice_data');
$routes->post('admin_by_post_generate','Admin_Controller::admin_by_post_generate');
$routes->get('post_board_show/(:num)','Admin_Controller::post_board_show/$1');
$routes->get('admin_by_post_form','Admin_Controller::admin_by_post_form');
$routes->post('comment_post','Admin_Controller::comment_post');
$routes->post('like_post','Admin_Controller::like_post');
$routes->get('notification_user/(:num)','Admin_Controller::notification_user/$1');
$routes->get('admin_view_profile/(:num)','Admin_Controller::admin_view_profile/$1');
$routes->post('admin_edit_view_profile_data', 'Admin_Controller::admin_edit_view_profile_data');
$routes->post('signup_manager_by_admin', 'Admin_Controller::signup_manager_by_admin');

$routes->get('admin_by_course_registration_form', 'Admin_Controller::admin_by_course_registration_form');

$routes->post('admin_by_student_registration_mode', 'Admin_Controller::admin_by_student_registration_mode');
$routes->post('admin_by_registration_success_payment', 'Admin_Controller::admin_by_registration_success_payment');

$routes->get('admin_show_student', 'Admin_Controller::admin_show_student');
$routes->get('admin_generate_certificate_form/(:num)', 'Admin_Controller::admin_generate_certificate_form/$1');

$routes->post('student_certificate_by_admin_process', 'Admin_Controller::student_certificate_by_admin_process');
$routes->get('admin_by_student_certificate_show', 'Admin_Controller::admin_by_student_certificate_show');

$routes->get('student_certificate_download_by_admin/(:num)', 'Admin_Controller::student_certificate_download_by_admin/$1');
$routes->get('delete_student_certificate_pdf/(:num)', 'Admin_Controller::delete_student_certificate_pdf/$1');

$routes->get('admin_by_student_certificate_user/(:num)', 'Admin_Controller::admin_by_student_certificate_user/$1');
$routes->get('admin_show_student_details/(:num)', 'Admin_Controller::admin_show_student_details/$1');
$routes->post('admin_certificate_student_verify', 'Admin_Controller::admin_certificate_student_verify');

$routes->get('admin_show_block_manager', 'Admin_Controller::admin_show_block_manager');
$routes->get('adminShowInactiveUser', 'Admin_Controller::adminShowInactiveUser');


$routes->get('delete_donation_receipt_pdf/(:num)', 'Admin_Controller::delete_donation_receipt_pdf/$1');
$routes->get('resetLocation', 'Admin_Controller::resetLocation');




/* manager Routes*/  

$routes->get('manager_show_student', 'Manager_Controller::manager_show_student');
$routes->post('registration_success_payment', 'Manager_Controller::registration_success_payment');
$routes->get('manager_by_course_registration_form', 'Manager_Controller::manager_by_course_registration_form');
$routes->post('student_registration_mode', 'Manager_Controller::student_registration_mode');
$routes->get('manager_send_notice_user', 'Manager_Controller::manager_send_notice_user');
$routes->get('notice_view_manager', 'Manager_Controller::notice_view_manager');
$routes->get('report_donate_receipt_view_manager', 'Manager_Controller::report_donate_receipt_view_manager');
$routes->get('report_unverified_download_manager', 'Manager_Controller::report_unverified_download_manager');
$routes->get('report_verified_download_manager', 'Manager_Controller::report_verified_download_manager');
$routes->get('report_membership_fee_download_manager', 'Manager_Controller::report_membership_fee_download_manager');


$routes->get('delete_notice/(:num)', 'Manager_Controller::delete_notice/$1');

$routes->get('manager_send_notice_single_user/(:num)', 'Manager_Controller::manager_send_notice_single_user/$1');

$routes->get('manager_by_user_delete/(:num)', 'Manager_Controller::manager_by_user_delete/$1');
$routes->get('manager_by_certificate_user/(:num)', 'Manager_Controller::manager_by_certificate_user/$1');
$routes->get('manager_by_certificate_show', 'Manager_Controller::manager_by_certificate_show');
$routes->get('manager_by_certificate_generate_id','Manager_Controller::manager_by_certificate_generate_id');
$routes->get('indcard_verifie/(:any)', 'Manager_Controller::indcard_verifie/$1');
$routes->get('certificate_download_by_manager/(:num)', 'Manager_Controller::certificate_download_by_manager/$1');
$routes->get('manager_by_certificate_show', 'Manager_Controller::manager_by_certificate_show');
$routes->get('manager_user_status_unblock/(:any)/(:any)','Manager_Controller::manager_user_status_unblock/$1/$2');
$routes->get('donate_receipt_view_manager', 'Manager_Controller::donate_receipt_view_manager');
$routes->get('membership_receipt_download_manager', 'Manager_Controller::membership_receipt_download_manager');
$routes->get('manager_status_inactive/(:num)/(:any)','Manager_Controller::manager_status_inactive/$1/$2');
$routes->get('manager_status_inactive_id/(:num)/(:any)','Manager_Controller::manager_status_inactive_id/$1/$2');
$routes->get('manager_show_user_details/(:any)', 'Manager_Controller::manager_show_user_details/$1');
$routes->post('manager_send_reason_user', 'Manager_Controller::manager_send_reason_user');
$routes->get('manager_show_verifie_user', 'Manager_Controller::manager_show_verifie_user');
$routes->get('manager_show_user_under_Manager/(:any)', 'Manager_Controller::manager_show_user_under_manager/$1');
$routes->get('manager_show_manager', 'Manager_Controller::Manager_show_manager');

$routes->get('manager_profile/(:any)', 'Manager_Controller::manager_profile/$1');
$routes->post('manager_search_user', 'Manager_Controller::manager_search_user');
$routes->post('send_message_by_manager_data', 'Manager_Controller::send_message_by_manager_data');
$routes->post('manager_search_filture', 'Manager_Controller::manager_search_filture');
$routes->get('message_user/(:any)', 'Manager_Controller::message_user/$1');
$routes->get('manager_dashboard', 'Manager_Controller::manager_dashboard');
$routes->get('user_show_by_manager', 'Manager_Controller::user_show_by_manager');

$routes->get('edit_user_view/(:num)', 'Manager_Controller::edit_user_view/$1');

$routes->get('add_manager_by_manager/(:num)', 'Manager_Controller::add_manager_by_manager/$1');
$routes->get('generate_id_card_bymanager/(:num)', 'Manager_Controller::generate_id_card_bymanager/$1');
$routes->get('delete/(:num)', 'Manager_Controller::delete/$1');
$routes->get('manager_show_inactive_user', 'Manager_Controller::manager_show_inactive_user');
$routes->get('manager_show_active_user', 'Manager_Controller::manager_show_active_user');
$routes->get('manager_update_user_status/(:num)/(:any)', 'Manager_Controller::manager_update_user_status/$1/$1');
$routes->get('payment_status/(:num)/(:any)', 'Manager_Controller::payment_status/$1/$1');
$routes->post('manager_update_user_status','Manager_Controller::manager_update_user_status');
$routes->post('signup-manager-by-manager','Manager_Controller::signup_manager_by_manager');
$routes->post('manager_update_user_profile','Manager_Controller::manager_update_user_profile');

$routes->post('update_status','Manager_Controller::update_status');
$routes->get('manager_by_certificate_generate','Manager_Controller::manager_by_certificate_generate');
$routes->get('manager_by_certificate_generate_form/(:num)','Manager_Controller::manager_by_certificate_generate_form/$1');
$routes->post('certificate_by_manager_process','Manager_Controller::certificate_by_manager_process');
$routes->get('manager_by_certificate_generate_show','Manager_Controller::manager_by_certificate_generate_show');
$routes->get('show_certificate_pdf/(:num)','Manager_Controller::show_certificate_pdf/$1');
$routes->get('delete_certificate_pdf/(:num)','Manager_Controller::delete_certificate_pdf/$1');
$routes->get('download_certificate_pdf/(:num)','Manager_Controller::download_certificate_pdf/$1');
$routes->get('manager_status/(:any)/(:num)','Manager_Controller::manager_status/$1/$2');
$routes->get('manager_show_block_user','Manager_Controller::manager_show_block_user');
$routes->post('manager_user_status_block/(:num)/(:any)','Manager_Controller::manager_user_status_block/$1/$2');
$routes->get('notice_board_show/(:num)','Manager_Controller::notice_board_show/$1');
$routes->post('amanager_user_notice_data','Manager_Controller::amanager_user_notice_data');
$routes->post('amanager_alluser_notice_data','Manager_Controller::amanager_alluser_notice_data');
$routes->post('manager_by_post_generate','Manager_Controller::manager_by_post_generate');
$routes->get('post_board_show/(:num)','Manager_Controller::post_board_show/$1');
$routes->get('manager_by_post_form','Manager_Controller::manager_by_post_form');
$routes->post('comment_post','Manager_Controller::comment_post');
$routes->post('like_post','Manager_Controller::like_post');
$routes->get('notification_user/(:num)','Manager_Controller::notification_user/$1');
$routes->post('manager_edit_view_profile_data', 'Manager_Controller::manager_edit_view_profile_data');
$routes->post('update_manager_profile', 'Manager_Controller::update_manager_profile'); 

$routes->get('manager_edit_view_profile/(:any)', 'Manager_Controller::manager_edit_view_profile/$1'); 
$routes->get('manager_show_student', 'Manager_Controller::manager_show_student');
$routes->get('manager_generate_certificate_form/(:num)', 'Manager_Controller::manager_generate_certificate_form/$1');

$routes->post('student_certificate_by_admin_process', 'Manager_Controller::student_certificate_by_manager_process');
$routes->get('manager_by_student_certificate_show', 'Manager_Controller::manager_by_student_certificate_show');

$routes->get('student_certificate_download_by_manager/(:num)', 'Manager_Controller::student_certificate_download_by_manager/$1');
$routes->get('delete_student_certificate_pdf/(:num)', 'Mdmin_Controller::delete_student_certificate_pdf/$1');

$routes->get('manager_by_student_certificate_user/(:num)', 'Manager_Controller::manager_by_student_certificate_user/$1');
$routes->get('manager_show_student_details/(:num)', 'Admin_Controller::manger_show_student_details/$1');

$routes->get('manager_delete_certificate_pdf/(:num)', 'Manager_Controller::manager_delete_certificate_pdf/$1');
$routes->get('manager_delete_donation_receipt_pdf/(:num)', 'Manager_Controller::manager_delete_donation_receipt_pdf/$1');

/*Franchise Member*/
$routes->get('franchise_dashboard', 'Franchise_Controller::franchise_dashboard');

$routes->get('franchise_by_course_registration_form', 'Franchise_Controller::franchise_by_course_registration_form');

$routes->post('franchise_by_student_registration_mode', 'Franchise_Controller::franchise_by_student_registration_mode');
$routes->post('franchise_by_registration_success_payment', 'Franchise_Controller::franchise_by_registration_success_payment');

$routes->get('franchise_show_student', 'Franchise_Controller::franchise_show_student');

$routes->get('franchise_generate_certificate_form/(:num)', 'Franchise_Controller::franchise_generate_certificate_form/$1');

$routes->post('student_certificate_by_franchise_process', 'Franchise_Controller::student_certificate_by_franchise_process');
$routes->get('franchise_by_student_certificate_show', 'Franchise_Controller::franchise_by_student_certificate_show');

$routes->get('student_certificate_download_by_franchise/(:num)', 'Franchise_Controller::student_certificate_download_by_franchise/$1');
$routes->get('franchise_delete_student_certificate_pdf/(:num)', 'Franchise_Controller::franchise_delete_student_certificate_pdf/$1');

$routes->get('franchise_by_student_certificate_user/(:num)', 'Franchise_Controller::franchise_by_student_certificate_user/$1');
$routes->get('franchise_show_student_details/(:num)', 'Franchise_Controller::franchise_show_student_details/$1');
//rozor payment 
$routes->post('vistordonatepayment', 'Home::vistordonatepaymentprocess');
$routes->post('campaigndonatepayment', 'Home::campaigndonatepaymentProcess');
$routes->post('userdonatepaymentprocess', 'Home::userdonatepaymentprocess');

$routes->post('Referraluserdonatepaymentprocess', 'Home::Referraluserdonatepaymentprocess');

$routes->get('referral_donate_receipt_download/(:any)', 'Home::referral_donate_receipt_download/$1');
$routes->get('payWithRazorpay/(:any)', 'User_Controller::payWithRazorpay/$1');
$routes->post('payment', 'User_Controller::processPayment');
$routes->post('visitor_donate_paymentProcess', 'Home::visitor_donate_paymentProcess');
$routes->post('donate_payment', 'Home::donate_processPayment');


// $routes->get('/(:any)', 'MyController::decodeAndRoute/$1');
// $routes->get('/', 'MyController::decodeAndRoute');
// $routes->get('/(:any)', 'MyController::handleEncodedData/$1');
//  $routes->post('/(:any)', 'MyController::handleEncodedData/$1');

 
 $routes->get('zones', 'Location\ZoneController::index');
    $routes->get('zones/create', 'Location\ZoneController::create');
     $routes->get('zones/edit/(:num)', 'Location\ZoneController::edit/$1');
    $routes->post('zones/store', 'Location\ZoneController::store');

    $routes->get('states', 'Location\StateController::index');
    $routes->get('states/create', 'Location\StateController::create');
     $routes->get('states/edit/(:num)', 'Location\StateController::edit/$1');
      $routes->post('states/updatestate/(:num)', 'Location\StateController::updatestate/$1');
     $routes->post('states/store', 'Location\StateController::store');

    $routes->get('districts', 'Location\DistrictController::index');
    $routes->get('districts/create', 'Location\DistrictController::create');
    $routes->get('districts/edit/(:num)', 'Location\DistrictController::edit/$1');
    $routes->post('districts/update/(:num)', 'Location\DistrictController::updateDistrict/$1');
     $routes->post('districts/store', 'Location\DistrictController::store');

    $routes->get('blocks', 'Location\BlockController::index');
     $routes->get('blocks/create', 'Location\BlockController::create');
    $routes->get('blocks/edit/(:num)', 'Location\BlockController::edit/$1');
    $routes->post('blocks/update/(:num)', 'Location\BlockController::blocksUpdate/$1');
    
    $routes->post('blocks/store', 'Location\BlockController::store');

 $routes->get('panchayats/create', 'Location\PanchayatController::create');
  $routes->get('panchayats/edit/(:num)', 'Location\PanchayatController::edit/$1');
    $routes->post('panchayats/update/(:num)', 'Location\PanchayatController::updatePanchayats/$1');
 
    $routes->get('panchayats', 'Location\PanchayatController::index');
    $routes->post('panchayats/store', 'Location\PanchayatController::store');


// AJAX CASCADING
$routes->get('/ajax/states/(:num)', 'Location\AjaxLocationController::states/$1');
$routes->get('/ajax/districts/(:num)', 'Location\AjaxLocationController::districts/$1');
$routes->get('/ajax/blocks/(:num)', 'Location\AjaxLocationController::blocks/$1');
$routes->get('/ajax/panchayats/(:num)', 'Location\AjaxLocationController::panchayats/$1');


?>