<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Membership Application</title>
  <style>
   
::-webkit-scrollbar {
  width: 4px !important;
}

::-webkit-scrollbar-track {
  background: #f1f1f1;
}

::-webkit-scrollbar-thumb {
  background: #888;
  border-radius: 0px !important;
}

::-webkit-scrollbar-thumb:hover {
  background: #555;
}
   
   
.card-container {
    /* perspective: 1000px; */
    /* width: 100%; */
    max-width: 440px;
    height:90vh;
    margin: auto;
    display: flex;
    margin-top: 65px;
    justify-content: center;
    }
    
.card {
    padding: 16px 40px;
    border-radius: 20px;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
    text-align: center;
    width: 89%;
    height: 524px;
    position: relative;
    overflow: hidden;
    transform-style: preserve-3d;
    transition: transform 0.6s ease;
    }
    
    .card:hover {
      transform: translateY(-5px);
    }
    
    .card::before {
      content: "";
      position: absolute;
      top: -40px;
      right: -40px;
      width: 120px;
      height: 120px;
      background: rgba(46, 204, 113, 0.1);
      border-radius: 50%;
      z-index: 0;
    }
    
    .card::after {
      content: "";
      position: absolute;
      bottom: -50px;
      left: -50px;
      width: 160px;
      height: 160px;
      background: rgba(52, 152, 219, 0.1);
      border-radius: 50%;
      z-index: 0;
    }
    
    .icon-container {
      width: 90px;
      height: 90px;
      background: #0a7e6b;
      border-radius: 50%;
      display: flex;
      justify-content: center;
      align-items: center;
      margin: 0 auto 20px;
      position: relative;
      z-index: 1;
      box-shadow: 0 8px 20px rgba(46, 204, 113, 0.3);
    }
    
    .icon {
      font-size: 40px;
      color: white;
    }
    
    .progress-container {
      width: 100%;
      background-color: #f1f8fe;
      height: 6px;
      border-radius: 3px;
      margin: 25px 0;
      overflow: hidden;
      position: relative;
    }
    
    .progress-bar {
      width: 50%;
      height: 100%;
      background: linear-gradient(to right, #2ecc71, #3498db);
      border-radius: 3px;
    }
    
    .progress-text {
      font-size: 14px;
      color: #7f8c8d;
      margin-bottom: 25px;
    }
    
    .card h2 {
      color: #2c3e50;
      margin-bottom: 15px;
      font-size: 28px;
      font-weight: 600;
      position: relative;
      z-index: 1;
    }
    
    .card p {
      font-size: 16px;
      color: #546e7a;
      margin-bottom: 30px;
      line-height: 1.6;
      position: relative;
      z-index: 1;
    }
    
    .apply_btn {
      background: #00a783;
      color: white;
      text-decoration: none;
      padding: 14px 35px;
      border-radius: 30px;
      font-size: 16px;
      font-weight: 600;
      display: inline-block;
      transition: all 0.3s ease;
      position: relative;
      z-index: 1;
      border: none;
      cursor: pointer;
      letter-spacing: 0.5px;
      box-shadow: 0 5px 15px rgba(52, 152, 219, 0.4);
    }
    
    .apply_btn:hover {
      background: #056d57;
      color: white !important;
      transform: translateY(-3px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.25);
    }
    
    .apply_btn:active {
      transform: translateY(0);
    }
    
    .features {
      display: flex;
      justify-content: space-between;
      margin: 30px 0;
      position: relative;
      z-index: 1;
    }
    
    .feature {
    flex: 1;
    padding: 0 10px;
    display: flex;
    flex-flow: column;
    }
    
    .feature i {
      font-size: 20px;
      color: #0a7e6b;
      margin-bottom: 8px;
    }
    
    .feature p {
      font-size: 13px;
      color: #7f8c8d;
      margin: 0;
    }
    
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-20px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    @keyframes pulse {
      0% { transform: scale(1); }
      50% { transform: scale(1.05); }
      100% { transform: scale(1); }
    }
    
    .card {
      animation: fadeIn 0.8s ease-out;
    }
    
    .icon-container {
      animation: pulse 2s infinite ease-in-out;
    }
    
    @media (max-width: 480px) {
      .card {
        padding: 15px 25px;
        margin-top: 30px;
        width: 100% !important;
      }
      
      .card-container{
          margin-top: 114px !important;
          padding-left: 15px;
          padding-right: 15px;
      }
      
      .features {
          margin: 10px 0 !important;
    }
        
    .progress-text{
        margin:0 !important;
    }    
    
    .card h2{
        margin-bottom:0 !important;
        margin-top: 5px !important;
    }
    
    .card p{
        margin-bottom:15px !important;
    }
    
    .card {
        height: 435px;

    }
    
     .icon-container {
         width: 50px !important;
         height: 50px !important;
    }
        
    .icon {
      font-size: 25px !important;
    }
    
    .apply_btn {
    padding: 9px 30px !important;
    margin-top: 10px !important;
        
    }
        
    }
  </style>
</head>
<body>
    
<div style="background: none !important;">    

  <div class="card-container">
    <div class="card">
      <div class="icon-container">
        <div class="icon"><i class="fas fa-check"></i></div>
      </div>
      
      <div class="progress-container">
        <div class="progress-bar"></div>
      </div>
      <div class="progress-text">Step 1 of 2 Completed</div>
      
      <h2>Congratulations! &#129395;</h2>
      <p>Your initial registration is successful. Now complete your membership application to access exclusive features and benefits.</p>
      
      <div class="features">
        <div class="feature">
          <i class="fa-solid fa-id-card"></i>
          <a href="<?= base_url('id_card_mobile_download/'.$users['id']) ?>" style="color:#5c7580;">Identity <br> Card</a>
        </div>
        <div class="feature">
          <i class="fa-solid fa-certificate"></i>
          <a href="<?= base_url('Membership-Certificate/'.$users['id']) ?>" style="color:#5c7580;">Membership Certificate</a>
        </div>
        <div class="feature">
          <i class="fa-regular fa-id-card"></i>
          <a href="<?= base_url('print_appointment_by_user_process/'.$users['id']) ?>" style="color:#5c7580;">Appointment Letter</a>
        </div>
      </div>
      
      <a href="<?php echo base_url('profile/'.$session->id)?>" class="apply_btn">Apply Now</a>
    </div>
  </div>
  
</div>  

</body>
</html>