<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Membership Application Success</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            padding: 20px;
        }
        
        .card {
            width: 100%;
            max-width: 500px;
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
            animation: fadeIn 0.6s ease-out;
        }
        
        .header {
            background: linear-gradient(to right, #4e73df, #3a56c4);
            color: white;
            padding: 30px 20px;
            position: relative;
        }
        
        .checkmark-container {
            width: 100px;
            height: 100px;
            background: white;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0 auto 20px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .checkmark {
            color: #4e73df;
            font-size: 50px;
        }
        
        h1 {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .content {
            padding: 30px;
        }
        
        .message {
            font-size: 18px;
            color: #555;
            line-height: 1.6;
            margin-bottom: 25px;
        }
        
        .registration-number {
            background: #f8f9fc;
            border-radius: 12px;
            padding: 20px;
            margin: 25px 0;
            border: 2px dashed #e3e6f0;
        }
        
        .number {
            font-size: 32px;
            font-weight: 800;
            color: #4e73df;
            letter-spacing: 2px;
            margin-top: 10px;
        }
        
        .label {
            font-size: 14px;
            color: #858796;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .note {
            background: #f0f7ff;
            border-radius: 10px;
            padding: 15px;
            margin: 20px 0;
            border-left: 4px solid #4e73df;
            text-align: left;
        }
        
        .note p {
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .note i {
            color: #4e73df;
            margin-right: 8px;
        }
        
        .actions {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 30px;
        }
        
        .btn {
            padding: 14px 25px;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: #4e73df;
            color: white;
            border: none;
            box-shadow: 0 4px 15px rgba(78, 115, 223, 0.3);
        }
        
        .btn-primary:hover {
            background: #3a56c4;
            transform: translateY(-2px);
            box-shadow: 0 6px 18px rgba(78, 115, 223, 0.4);
        }
        
        .btn-outline {
            background: white;
            color: #4e73df;
            border: 2px solid #4e73df;
        }
        
        .btn-outline:hover {
            background: #f8f9ff;
            transform: translateY(-2px);
        }
        
        .footer {
            padding: 20px;
            background: #f8f9fc;
            color: #858796;
            font-size: 14px;
        }
        
        .contact {
            margin-top: 10px;
        }
        
        .contact a {
            color: #4e73df;
            text-decoration: none;
        }
        
        @keyframes fadeIn {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
            100% {
                transform: scale(1);
            }
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
        
        @media (max-width: 576px) {
            .card {
                max-width: 100%;
            }
            
            .header {
                padding: 25px 15px;
            }
            
            .content {
                padding: 20px;
            }
            
            .actions {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="header">
            <div class="checkmark-container">
                <i class="fas fa-check checkmark"></i>
            </div>
            <h1>Congratulations!</h1>
        </div>
        
        <div class="content">
            <p class="message">
                Your membership application has been successfully submitted. Please wait for the administrator to verify your application.
            </p>
            
            <div class="registration-number">
                <div class="label">Your Registration Number</div>
                <div class="number pulse">245</div>
            </div>
            
            <div class="note">
                <p><i class="fas fa-info-circle"></i> What happens next?</p>
                <p><i class="fas fa-clock"></i> Verification typically takes 1-2 business days</p>
                <p><i class="fas fa-envelope"></i> You will receive an email notification once verified</p>
                <p><i class="fas fa-user-check"></i> You can then access all member benefits</p>
            </div>
            
            <div class="actions">
                <button class="btn btn-primary">
                    <i class="fas fa-download"></i> Save Receipt
                </button>
                <button class="btn btn-outline">
                    <i class="fas fa-home"></i> Return Home
                </button>
            </div>
        </div>
        
        <div class="footer">
            <p>Need assistance? Contact our support team</p>
            <p class="contact">
                <i class="fas fa-envelope"></i> <a href="mailto:support@example.com">support@example.com</a> | 
                <i class="fas fa-phone"></i> <a href="tel:+11234567890">+1 (123) 456-7890</a>
            </p>
        </div>
    </div>

    <script>
        // Simple animation for the registration number
        setInterval(function() {
            document.querySelector('.pulse').classList.toggle('pulse');
        }, 2000);
    </script>
</body>
</html>