<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Submitted Successfully</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            width: 100%;
            max-width: 900px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.2);
            overflow: hidden;
            position: relative;
        }
        
        .header {
            background: linear-gradient(90deg, #2563eb, #3b82f6);
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
        }
        
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
            font-weight: 700;
        }
        
        .header p {
            font-size: 1.1rem;
            opacity: 0.9;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .success-icon {
            width: 120px;
            height: 120px;
            background: #10b981;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: -60px auto 30px;
            position: relative;
            z-index: 2;
            box-shadow: 0 10px 20px rgba(16, 185, 129, 0.3);
            animation: pulse 2s infinite;
        }
        
        .success-icon i {
            font-size: 60px;
            color: white;
        }
        
        .content {
            padding: 40px;
            text-align: center;
        }
        
        .content h2 {
            font-size: 2rem;
            color: #2563eb;
            margin-bottom: 20px;
        }
        
        .content p {
            font-size: 1.1rem;
            color: #4b5563;
            line-height: 1.6;
            margin-bottom: 30px;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .application-details {
            background: #f3f4f6;
            border-radius: 15px;
            padding: 30px;
            margin: 30px auto;
            max-width: 600px;
            text-align: left;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }
        
        .detail-item {
            display: flex;
            margin-bottom: 15px;
            padding-bottom: 15px;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .detail-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        
        .detail-icon {
            width: 40px;
            height: 40px;
            background: #dbeafe;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            flex-shrink: 0;
        }
        
        .detail-icon i {
            color: #3b82f6;
            font-size: 18px;
        }
        
        .detail-content h3 {
            font-size: 1rem;
            color: #6b7280;
            margin-bottom: 5px;
        }
        
        .detail-content p {
            font-size: 1.1rem;
            color: #1f2937;
            margin: 0;
        }
        
        .next-steps {
            background: #ecfdf5;
            border-radius: 15px;
            padding: 30px;
            margin: 30px auto;
            max-width: 600px;
            text-align: left;
            border-left: 5px solid #10b981;
        }
        
        .next-steps h3 {
            font-size: 1.4rem;
            color: #065f46;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
        }
        
        .next-steps h3 i {
            margin-right: 10px;
        }
        
        .steps-list {
            list-style-type: none;
        }
        
        .steps-list li {
            position: relative;
            padding-left: 40px;
            margin-bottom: 20px;
            color: #4b5563;
            line-height: 1.6;
        }
        
        .steps-list li:last-child {
            margin-bottom: 0;
        }
        
        .steps-list li::before {
            content: counter(step);
            counter-increment: step;
            position: absolute;
            left: 0;
            top: 0;
            width: 30px;
            height: 30px;
            background: #10b981;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
        
        .buttons {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 40px;
            flex-wrap: wrap;
        }
        
        .btn {
            padding: 15px 30px;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-primary {
            background: linear-gradient(90deg, #2563eb, #3b82f6);
            color: white;
        }
        
        .btn-secondary {
            background: white;
            color: #3b82f6;
            border: 2px solid #3b82f6;
        }
        
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }
        
        .btn:active {
            transform: translateY(1px);
        }
        
        .btn i {
            margin-right: 10px;
        }
        
        .footer {
            text-align: center;
            padding: 20px;
            background: #f1f5f9;
            color: #64748b;
            font-size: 14px;
        }
        
        .footer a {
            color: #3b82f6;
            text-decoration: none;
        }
        
        .footer a:hover {
            text-decoration: underline;
        }
        
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(16, 185, 129, 0.7); }
            70% { box-shadow: 0 0 0 20px rgba(16, 185, 129, 0); }
            100% { box-shadow: 0 0 0 0 rgba(16, 185, 129, 0); }
        }
        
        @media (max-width: 768px) {
            .header h1 {
                font-size: 2rem;
            }
            
            .content {
                padding: 25px;
            }
            
            .buttons {
                flex-direction: column;
                gap: 15px;
            }
            
            .btn {
                width: 100%;
                text-align: center;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Internship Application</h1>
            <p>Thank you for applying to our internship program</p>
        </div>
        
        <div class="success-icon">
            <i class="fas fa-check"></i>
        </div>
        
        <div class="content">
            <h2>Application Submitted Successfully!</h2>
            <p>Thank you for applying to our internship program. We've received your application and will review it carefully. If your qualifications match our requirements, we'll contact you within 5-7 business days.</p>
            
            <div class="application-details">
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="detail-content">
                        <h3>Applicant Name</h3>
                        <p><?= $intern['full_name']?></p>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="detail-content">
                        <h3>Email Address</h3>
                        <p><?= $intern['email']?></p>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div class="detail-content">
                        <h3>Contact Number</h3>
                        <p><?= $intern['mobile_number']?></p>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <div class="detail-content">
                        <h3>Internship Field</h3>
                        <p><?= $internship['category']?></p>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <div class="detail-content">
                        <h3>Application Date</h3>
                        <p><?= $intern['created_at']?></p>
                    </div>
                </div>
            </div>
            
            <div class="next-steps">
                <h3><i class="fas fa-list-check"></i> What Happens Next?</h3>
                <ol class="steps-list">
                    <li>Our team will review your application and documents</li>
                    <li>If shortlisted, you'll receive an email for an interview</li>
                    <li>The interview may be conducted online or in-person</li>
                    <li>Final selection will be communicated within 2 weeks of the interview</li>
                    <li>Selected candidates will receive onboarding instructions</li>
                </ol>
            </div>
            
            <div class="buttons">
                <a href="#" class="btn btn-primary">
                    <i class="fas fa-download"></i> Download Application Copy
                </a>
                <a href="#" class="btn btn-secondary">
                    <i class="fas fa-home"></i> Return to Homepage
                </a>
            </div>
        </div>
        
        <div class="footer">
            <p>© 2023 Internship Program. All rights reserved. | 
            <a href="#">Privacy Policy</a> | <a href="#">Terms of Service</a></p>
        </div>
    </div>

    <script>
        // Initialize counter for steps list
        document.addEventListener('DOMContentLoaded', function() {
            const stepsList = document.querySelector('.steps-list');
            stepsList.style.counterReset = 'step';
        });
    </script>
</body>
</html>