<?php
               
               $session = session();
               $admin_id = $session->admin_id;
                        require 'db_config.php';
                        
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                        
                        ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Campaign Details</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        .campaign-image {
            max-width: 100%;
            border-radius: 10px;
        }

.campaign_details_page{
    width: 800px;
    background-color: white;
    border-radius: 10px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    padding: 30px;
    position: relative;
    margin: auto;
}  

.campaign_heading{
        color: black;
    margin-bottom: 20px !important;
    text-align: center;
    font-size: 24px;
    font-weight: 700;
    background: #e7ebd9;
    margin-top: 20px !important;
    padding: 5px;
    width: 50%;
    display: flex;
    justify-content: center;
    align-items: center;
    margin: auto;
    border-radius: 5px;
}

.campaign-image{
    width: 100%;
    height: 300px;
    border-radius: 8px;
    margin-bottom: 20px;
}

.details-grid{
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-bottom: 30px;
}

.detail-label {
    font-weight: 600;
    color: #7f8c8d;
    font-size: 14px;
    margin-bottom: 5px;
}

.detail-value {
    font-size: 16px;
    color: #2c3e50;
    padding: 8px 0;
    border-bottom: 1px solid #ecf0f1;
}

 .gallery-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin-bottom: 20px;
        }
        
.gallery-item {
            height: 120px;
            border-radius: 6px;
            overflow: hidden;
        }
        
        .gallery-item img {
            width: 100%;
            height: 100%;
        } 
        
.member_ship_box{
    width: 90px;
    height: 90px;
    border-radius: 50%;
    padding: 4px;
    background: white;
    margin: auto;
    transform: translate(0px, 35px);
    box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
    position:relative;
    z-index:1;
}

.winggo_logo_radius{
    width:100%;
    height:100%;
}    

.back_btn{
    margin: auto;
    display: flex;
    border: none;
    background: #00a783;
    color: white;
    width: 122px;
    height: 30px;
    align-items: center;
    justify-content: center;
    border-radius: 5px;
}

.background_color {
    background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.03) 25%, transparent 25%), linear-gradient(-45deg, rgba(255, 255, 255, 0.03) 25%, transparent 25%), linear-gradient(45deg, transparent 75%, rgba(255, 255, 255, 0.03) 75%), linear-gradient(-45deg, transparent 75%, rgba(255, 255, 255, 0.03) 75%);
    /* display: flex
; */
    justify-content: center;
    align-items: center;
    background-color: #00665f !important;
    overflow: auto;
    height: 100vh;
}
        
@media (max-width: 768px) {
            .details-grid {
                grid-template-columns: 1fr;
            }
            
            .campaign_details_page{
                width:100% !important;
            }
            
        }
        
        @media (max-width: 480px) {
            .gallery-grid {
                grid-template-columns: 1fr;
            }
            
            .gallery-item {
                height: 200px !important;
                
            }
            
            .campaign-image{
                width: 400px important;
                height: 200px important;
            }
            
            .campaign_heading{
                width:100% !important;
            }
        }        
        
    </style>
</head>
<body>

<div class="background_color">
    <div class="container py-5">
    <div class="member_ship_box">
		    <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
		</div>
   <div class="campaign_details_page">
        <h1 class="campaign_heading">Campaign Details</h1>
        <h3 style="text-align: center;
    font-size: 23px;
    font-weight: 600;
    padding-bottom: 10px;"><?= esc($campaign['title']) ?></h3>
            <div>
               <img src="<?= base_url('CampaignsImage/' . $campaign['featured_image']) ?>" class="campaign-image" alt="Featured Image">
            </div>
    
    
    
    <div class="details-grid">
            <div class="detail-item">
                <div class="detail-label">Category</div>
                <div class="detail-value"><?= esc($campaign['category']) ?></div>
            </div>
            <div class="detail-item">
                <div class="detail-label">Start Date</div>
                <div class="detail-value"><?= date('d M Y, h:i A', strtotime(($campaign['start_date']))) ?> </div>
            </div>
            <div class="detail-item">
                <div class="detail-label">End Date</div>
                <div class="detail-value"><?= date('d M Y, h:i A', strtotime(($campaign['end_date']))) ?></div>
            </div>
            <div class="detail-item">
                <div class="detail-label">Goal Amount</div>
                <div class="detail-value">₹<?= number_format($campaign['goal_amount']) ?></div>
            </div>
            <div class="detail-item">
                <div class="detail-label">Status</div>
                <div class="detail-value status-active"><?= esc($campaign['status']) ?></div>
            </div>
            <div class="detail-item">
                <div class="detail-label">Created At</div>
                <div class="detail-value"><?= date('d M Y, h:i A', strtotime($campaign['created_at'])) ?></div>
            </div>
        </div>

    <div class="mb-4">
        <h5>Description</h5>
        <p><?= esc($campaign['description']) ?></p>
    </div>

    <?php if (!empty($campaign['gallery_images'])): ?>
        <?php $gallery = json_decode($campaign['gallery_images'], true); ?>
        <?php if (is_array($gallery) && count($gallery)): ?>
            <div class="mb-4">
                <h5>Gallery Images</h5>
                <div class="gallery-grid">
                    <?php foreach ($gallery as $img): ?>
                        <div class="gallery-item">
                            <img src="<?= base_url('CampaignsGallery/' . $img) ?>" class="img-fluid gallery-image" alt="Gallery Image">
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <?php if (!empty($campaign['video_url'])): ?>
        <div class="mb-4">
            <h5>Video</h5>
            <div class="ratio ratio-16x9">
              <?php
$videoUrl = $campaign['video_url']; 

if (strpos($videoUrl, 'watch?v=') !== false) {
    parse_str(parse_url($videoUrl, PHP_URL_QUERY), $params);
    if (isset($params['v'])) {
        $videoId = $params['v'];
        $videoUrl = "https://www.youtube.com/embed/" . $videoId;
    }
}
?>
<iframe width="560" height="315"
        src="<?= esc($videoUrl) ?>"
        title="Campaign Video"
        frameborder="0"
        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen>
</iframe>

            </div>
        </div>
    <?php endif; ?>

<button class="back_btn" onclick="history.back()">Go Back</button>
   
   </div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
