
<?php
               
               $session = session();
               $admin_id = $session->admin_id;
                        require 'db_config.php';
                        
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                        
                        ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Internship Opportunities</title>
  <style>
    :root {
      --primary-color: #3498db;
      --secondary-color: #2c3e50;
      --accent-color: #e74c3c;
      --light-bg: #f8f9fa;
      --dark-text: #343a40;
      --light-text: #6c757d;
    }
    
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f5f7fa;
      color: var(--dark-text);
      line-height: 1.6;
      margin: 0;
      padding: 0;
    }
    
    header {
      background: #f0f7f4;
      box-shadow: 0 2px 15px rgba(0,0,0,0.1);
      padding: 15px 20%;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 1000;
    }

    header .logo-area {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    header .logo-area img {
      height: 50px;
      width: 50px;
      object-fit: contain;
    }

    header h2 {
      margin: 0;
      font-size: 22px;
      color: black;
      font-weight: 700;
    }

header nav a {
    margin-left:10px;
    text-decoration: none;
    color: white;
    font-weight: 500;
    transition: color 0.3s;
    position: relative;
    background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    padding: 8px 20px;
    border-radius: 9px;
    text-decoration:none;
}

    header nav a:hover {
      color: white;
    }

  
/* Hero Section */
    .hero {
      background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
      color: white;
      padding: 80px 5%;
      text-align: center;
    }

    .hero h1 {
      font-size: 2.8rem;
      margin-bottom: 20px;
      font-weight: 700;
    }

    .hero p {
      font-size: 1.2rem;
      max-width: 700px;
      margin: 0 auto 30px;
    }

    .cta-button {
      display: inline-block;
      background: white;
      color: #1a936f;
      padding: 12px 30px;
      border-radius: 50px;
      text-decoration: none;
      font-weight: 600;
      transition: all 0.3s;
      box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }

    .cta-button:hover {
      transform: translateY(-3px);
      box-shadow: 0 6px 20px rgba(0,0,0,0.15);
    }    
    
    
 /* Benefits Section */
    .benefits {
      background: #f0f7f4;
      padding: 80px 5%;
    }

    .benefits-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 30px;
      max-width: 1200px;
      margin: 0 auto;
    }

    .benefit-item {
      text-align: center;
      padding: 30px 20px;
      background: white;
      border-radius: 10px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.05);
      transition: transform 0.3s;
    }

    .benefit-item:hover {
      transform: translateY(-5px);
    }

    .benefit-icon {
      font-size: 2.5rem;
      color: #08314f;
      margin-bottom: 20px;
    }

    .benefit-item h3 {
      margin-bottom: 15px;
      color:#08314f;
    }    
    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 20px;
    }
    
   
    .logo {
      font-size: 24px;
      font-weight: 700;
      color: var(--primary-color);
    }
    
    .search-filter {
      background-color: white;
      padding: 25px;
      border-radius: 8px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.05);
      margin-bottom: 30px;
    }
    
    .search-bar {
      display: flex;
      gap: 10px;
      margin-bottom: 20px;
    }
    
    .search-bar input {
      flex: 1;
      padding: 12px 15px;
      border: 1px solid #ddd;
      border-radius: 6px;
      font-size: 16px;
    }
    
    .search-bar button {
      background-color: #08314f;
      color: white;
      border: none;
      padding: 0 25px;
      border-radius: 6px;
      cursor: pointer;
      font-weight: 500;
    }
    
    .filters {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
    }
    
    .filter-group {
      flex: 1;
      min-width: 180px;
    }
    
    .filter-group select {
      width: 100%;
      padding: 10px;
      border: 1px solid #ddd;
      border-radius: 6px;
    }
    
    .internship-list {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
      gap: 25px;
    }
    
    .internship-card {
      background-color: white;
      border-radius: 8px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.08);
      overflow: hidden;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .internship-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .card-header {
      padding: 20px;
      border-bottom: 1px solid #eee;
    }
    
.card-title {
    margin: 0;
    font-size: 18px;
    font-weight: 700;
    text-align: center;
    color: white;
    padding-top: 16px;
    
}
    
.card-company {
    font-weight: 500;
    padding-bottom: 17px;
    text-align: center;
    color: white;
}
    
    .card-type {
      display: inline-block;
      padding: 3px 8px;
      background-color: #f1f8fe;
      color: #08314f;
      border-radius: 4px;
      font-size: 12px;
      font-weight: 500;
    }
    
    .card-body {
      padding: 20px;
    }
    
    .card-details {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      margin-bottom: 15px;
    }
    
    .detail-item {
      display: flex;
      align-items: center;
      gap: 5px;
      color: var(--light-text);
      font-size: 14px;
    }
    
    .detail-item i {
      color: #08314f;
    }
    
    .card-skills {
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
      margin: 15px 0;
    }
    
    .skill-tag {
      background-color: #f1f8fe;
      color: #08314f;
      padding: 4px 10px;
      border-radius: 20px;
      font-size: 12px;
      font-weight: 500;
    }
    
    .card-footer {
      padding: 15px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .stipend {
      color: #08314f;
    }
    
    .apply-btn {
      background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
      color: white;
      border: none;
      padding: 8px 20px;
      border-radius: 4px;
      cursor: pointer;
      font-weight: 500;
      transition: background-color 0.3s;
    }
    
    .apply-btn:hover {
      background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    }
    
    .pagination {
      display: flex;
      justify-content: center;
      margin-top: 40px;
      gap: 10px;
    }
    
    .page-btn {
      padding: 8px 15px;
      border: 1px solid #ddd;
      background-color: white;
      border-radius: 4px;
      cursor: pointer;
    }
    
    .page-btn.active {
      background-color: var(--primary-color);
      color: white;
      border-color: var(--primary-color);
    }
    
 /* Footer */
    footer {
      /*background: #1a3c32;*/
    color: white;
    padding-bottom: 15px;
    }
    
.logo_box {
    width: 100px;
    height: 100px;
    padding-top:25px;
    display: flex;
    margin: auto;
}

.logo_box img{
    width:100%;
    height:100%;
}

.contact_info_box{
    display:flex;
    justify-content:center;
}

.contact_info{
    text-align: center;
    position: relative;
    margin: 0;
    padding-top: 17px;
    padding-bottom: 11px;
}

.contact_info::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    height: 2px;
    background: #fff;
}
    
.footer-content {
    display: flex;
    justify-content: center;
    gap: 30px;
}

    .footer-column h3 {
      margin-bottom: 20px;
      font-size: 1.3rem;
      position: relative;
      padding-bottom: 10px;
    }

    .footer-column h3::after {
      content: '';
      position: absolute;
      left: 0;
      bottom: 0;
      width: 40px;
      height: 2px;
      background: #1a936f;
    }

    .footer-column p, .footer-column a {
      color: white;
      margin-bottom: 10px;
      display: block;
      text-decoration: none;
      transition: color 0.3s;
    }

    .footer-column a:hover {
      color: white;
    }

    .social-links {
      display: flex;
      gap: 15px;
      margin-top: 20px;
    }

    .social-links a {
      display: flex;
      align-items: center;
      justify-content: center;
      width: 40px;
      height: 40px;
      background: rgba(255,255,255,0.1);
      border-radius: 50%;
      transition: background 0.3s;
    }

    .social-links a:hover {
      background: #1a936f;
    }

    .copyright {
      text-align: center;
      border-top: 1px solid rgba(255,255,255,0.1);
      color: #aaa;
      font-size: 0.9rem;
    }    
    
    @media (max-width: 768px) {
      .header-content {
        flex-direction: column;
        gap: 15px;
      }
      
      .search-bar input{
        padding: 10px 15px !important;
      }
      
    .search-bar button {
        width: 40px;
        padding: 0 10px !important;
    }
      
      .internship-list {
        grid-template-columns: 1fr;
      }
      
      .search{
          display:none;
      }
      
header {
    padding: 23px 1% !important;
    gap: 20px !important;
    flex-flow: column !important; 
    }
    
    .footer-content {
        flex-flow: column;
        gap: 10px !important;
        padding-top: 20px;
        padding-bottom: 20px;
    }
    .footer-column p {
        margin: 0 !important;
        text-align: center;
    }
    
.hero h1 {
    font-size: 26px !important;
    
}    

.hero p {
    line-height: 23px;
    
}

.hero {
    padding: 15px 5% !important;
}
    }

.direct_top{
    position: fixed;
    bottom: 47px;
    right: 25px;
    background:  #db7a0b;
    width: 35px;
    color: white;
    height: 35px;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
    text-decoration: none;
    z-index: 100000;
}    
    
.toggle-btn{
    background: none;
    border: none;
    font-weight: bold;
    color: #0a7e6b;
    font-size: 12px;
}    

.description{
    overflow: auto;
    height: 185px;
}
    
  </style>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    
<a href="#top" class="direct_top scroll-top"><i class="fa-solid fa-arrow-up"></i></a>    
    
      <!-- Header Section -->
  <header>
    <!-- Left Side: Logo + NGO Name -->
    <div class="logo-area">
       <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
      <div>
          <h2><?php echo $dataweb['web_name']?></h2>
          <p style="margin:0; color:black;"><?php echo $dataweb['web_tag_line']?></p>
      </div>
    </div>

    <!-- Right Side: Navigation -->
    <nav>
        <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
            <i class="fa-solid fa-house-user"></i> Home
        </a>

<a href="tel:<?php echo $dataweb['site_mobile_1'] ?>" style="color: white;
    padding-left: 20px;
    text-decoration: none;">
    <i class="fa-solid fa-phone"></i> 
    <?php echo $dataweb['site_mobile_1'] ?>
</a>

    </nav>
  </header>
  
    <!-- Hero Section -->
  <section class="hero" id="top">
    <h1>Internship Opportunities</h1>
    <p>Join our mission to create positive change in communities worldwide. Gain valuable experience while making a difference.</p>
  </section>
  
  <div class="container">
    <div class="search-filter">
      <div class="search-bar">
        <input type="text" placeholder="Search internships by title, company or keyword">
        <button><i class="fas fa-search"></i> <span class="search">Search</span></button>
      </div>
      <div class="filters">
        <div class="filter-group">
    <select name="category">
      <option value="">All Categories</option>
      <?php foreach($intern as $data):?>
      <option value="<?= $data['category']?>"><?= $data['category']?></option>
      <?php endforeach;?>
    </select>
  </div>

  <div class="filter-group">
    <select name="type">
      <option value="">All Types</option>
      <?php foreach($intern as $data):?>
      <option value="<?= $data['type']?>"><?= $data['type']?></option>
      <?php endforeach;?>
    </select>
  </div>

      </div>
    </div>
    
    <div class="internship-list">
      <!-- Internship Card 1 -->
      <?php foreach($intern as $data):?>
      <div class="internship-card">
          <div style="background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);">
              <h3 class="card-title"><?= $data['title']?></h3>
              <div class="card-company"><?= $data['category']?></div>
          </div>
        <div class="card-header">
          
          <span class="card-type"><?= $data['type']?></span>
          
          <div style="display: flex; justify-content: space-between;">
              <p style="margin:0; font-size:13px;"><b>State:</b> <?= $data['state']?></p>
              <p style="margin:0; font-size:13px;"><b>City:</b> <?= $data['district']?></p>
          </div>
          <p style="margin: 0; font-size: 12px;"><b>Address:</b> <?= $data['address']?></p>
                    <div class="stipend"><?php if($data['stipend']=="Yes" ){ ?><b>Stipend:</b>  ₹ <?= $data['stipendAmount'] ?>
          
          <?php } else { ?>
          
          <?php } ?>
          </div>
        </div>
        <div class="card-body">
          <div class="card-details">
            <div class="detail-item">
              <i class="fas fa-briefcase"></i> <?= $data['duration']?>
            </div>
            <div class="detail-item">
              <i class="fas fa-clock"></i> <?= $data['timing']?>
            </div>
            <div class="detail-item">
              <i class="fas fa-map-marker-alt"></i> <?= $data['type']?>
            </div>
            <div class="detail-item">
              <i class="fas fa-graduation-cap"></i> <?= $data['qualification']?>
            </div>
          </div>
          
          <div style="display: flex; justify-content: space-between;">
              <p style="margin:0; font-size:12px;">Start Date: <?= date('d-m-y', strtotime( $data ['start']))?></p>
              <p style="margin:0; font-size:12px;">End Date: <?=date('d-m-y', strtotime( $data['end']))?></p>
          </div>
          
          <p><div class="description" id="desc<?= $data['id'] ?>">
    <?php 
        $text = strip_tags($data['description']); // remove HTML tags for safety
        $shortText = substr($text, 0, 250);
    ?>
    
    <span class="short-text"><?= $shortText ?><?= strlen($text) > 250 ? '......' : '' ?></span>
    
    <?php if(strlen($text) > 250): ?>
        <span class="full-text" style="display:none;"><?= $text ?></span>
        <button type="button" class="toggle-btn" onclick="toggleText(<?= $data['id'] ?>)">Show More</button>
    <?php endif; ?>
</div>

<script>
function toggleText(id) {
    const container = document.getElementById('desc' + id);
    const shortText = container.querySelector('.short-text');
    const fullText = container.querySelector('.full-text');
    const btn = container.querySelector('.toggle-btn');
    
    if (fullText.style.display === 'none') {
        fullText.style.display = 'inline';
        shortText.style.display = 'none';
        btn.textContent = 'Show Less';
    } else {
        fullText.style.display = 'none';
        shortText.style.display = 'inline';
        btn.textContent = 'Show More';
    }
}
</script>
</p>
         
       <div class="card-skills">
         Skills:  
  <?php 
  
  $skills = explode(',', $data['skills']);
 
  foreach ($skills as $skill) {
  
    $cleanSkill = htmlspecialchars(trim($skill));
   
    if (!empty($cleanSkill)) {
      echo '<span class="skill-tag">' . $cleanSkill . '</span>';
    }
  }
  ?>
</div>
        </div>
        <div class="card-footer">
            

          <a href="<?php echo base_url('Apply-Internship-Form/'.$data['id'])?>" style="width:100%;"><button class="apply-btn" style="width:100%;">Apply Now</button></a>
        </div>
      </div>
      <?php endforeach;?>
      
    
      
    </div>
    
    <div class="pagination">
      <button class="page-btn"><i class="fas fa-chevron-left"></i></button>
      <button class="page-btn active">1</button>
      <button class="page-btn">2</button>
      <button class="page-btn">3</button>
      <button class="page-btn"><i class="fas fa-chevron-right"></i></button>
    </div>
</div>   

 <!-- Benefits Section -->
  <section class="benefits">
    <h2 class="section-title" style="text-align:center; margin-top: 0;">Internship Benefits</h2>
    <div class="benefits-grid">
      <div class="benefit-item">
        <div class="benefit-icon">
          <i class="fas fa-handshake"></i>
        </div>
        <h3>Networking</h3>
        <p>Connect with professionals in the nonprofit sector and build valuable relationships.</p>
      </div>
      <div class="benefit-item">
        <div class="benefit-icon">
          <i class="fas fa-certificate"></i>
        </div>
        <h3>Certification</h3>
        <p>Receive a certificate of completion and recommendation letter for future opportunities.</p>
      </div>
      <div class="benefit-item">
        <div class="benefit-icon">
          <i class="fas fa-users"></i>
        </div>
        <h3>Mentorship</h3>
        <p>Work closely with experienced mentors who will guide your professional development.</p>
      </div>
      <div class="benefit-item">
        <div class="benefit-icon">
          <i class="fas fa-globe-americas"></i>
        </div>
        <h3>Global Impact</h3>
        <p>Contribute to meaningful projects that create positive change in communities worldwide.</p>
      </div>
    </div>
  </section>
 <!-- Footer -->
  <footer style="background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);">
      <div class="logo_box">
             <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
        </div>
        <div class="contact_info_box">
            <h3 class="contact_info">Contact Info</h3>
        </div>
        
    <div class="footer-content">
        
      <div class="footer-column">
        <p><i class="fas fa-phone"></i> <?php echo $dataweb['site_mobile_1']?></p>
      </div>
      <div class="footer-column">
        <p><i class="fas fa-envelope"></i>  <?php echo $dataweb['webemail_1']?></p>
       
      </div>
      <div class="footer-column">
        <p><i class="fas fa-map-marker-alt"></i> <?php echo $dataweb['website_address'] ?></p>
        
      </div>
    </div>
    <div class="copyright">
       <!-- footer --> 
            <?php require_once($_SERVER['DOCUMENT_ROOT'] . '/software/app/Views/footer.php'); ?>
        <!-- / footer -->
    </div>
  </footer>    

<script>
document.addEventListener("DOMContentLoaded", function () {
  const itemsPerPage = 6; 
  const internshipList = document.querySelector(".internship-list");
  const cards = internshipList.querySelectorAll(".internship-card");
  const pagination = document.querySelector(".pagination");

  let currentPage = 1;
  const totalPages = Math.ceil(cards.length / itemsPerPage);

  function showPage(page) {
    // Hide all cards
    cards.forEach((card, index) => {
      card.style.display = "none";
      // Show only cards of current page
      if (index >= (page - 1) * itemsPerPage && index < page * itemsPerPage) {
        card.style.display = "block";
      }
    });

    // Update pagination buttons
    renderPagination();
  }

  function renderPagination() {
    pagination.innerHTML = "";

    // Previous button
    const prevBtn = document.createElement("button");
    prevBtn.classList.add("page-btn");
    prevBtn.textContent = "Previous";
    prevBtn.disabled = currentPage === 1;
    prevBtn.addEventListener("click", () => {
      if (currentPage > 1) {
        currentPage--;
        showPage(currentPage);
      }
    });
    pagination.appendChild(prevBtn);

    // Numbered buttons
    for (let i = 1; i <= totalPages; i++) {
      const pageBtn = document.createElement("button");
      pageBtn.classList.add("page-btn");
      if (i === currentPage) pageBtn.classList.add("active");
      pageBtn.textContent = i;
      pageBtn.addEventListener("click", () => {
        currentPage = i;
        showPage(currentPage);
      });
      pagination.appendChild(pageBtn);
    }

    // Next button
    const nextBtn = document.createElement("button");
    nextBtn.classList.add("page-btn");
    nextBtn.textContent = "Next";
    nextBtn.disabled = currentPage === totalPages;
    nextBtn.addEventListener("click", () => {
      if (currentPage < totalPages) {
        currentPage++;
        showPage(currentPage);
      }
    });
    pagination.appendChild(nextBtn);
  }

  // Initialize
  showPage(currentPage);
});
</script>

<script>
// Arrow button click event
document.addEventListener("DOMContentLoaded", function () {
    const scrollBtn = document.querySelector(".fa-arrow-up, .scroll-top, .your-button-class"); // yaha apne arrow button ka class/id lagao

    if (scrollBtn) {
        scrollBtn.addEventListener("click", function (e) {
            e.preventDefault();
            window.scrollTo({
                top: 0,
                behavior: "smooth"
            });
        });
    }
});

</script>

  <script>
document.addEventListener("DOMContentLoaded", function () {
    const categorySelect = document.querySelector('select[name="category"]');
    const typeSelect = document.querySelector('select[name="type"]');
    const searchInput = document.querySelector('.search-bar input');
    const searchButton = document.querySelector('.search-bar button');
    const cards = document.querySelectorAll('.internship-card');
    const pagination = document.querySelector('.pagination');
    const itemsPerPage = 6;
    let currentPage = 1;

    function filterCards() {
        const categoryValue = categorySelect.value.toLowerCase().trim();
        const typeValue = typeSelect.value.toLowerCase().trim();
        const searchValue = searchInput.value.toLowerCase().trim();

        cards.forEach(card => {
            const cardCategory = card.querySelector('.card-company').textContent.toLowerCase().trim();
            const cardType = card.querySelector('.card-type').textContent.toLowerCase().trim();
            const cardTitle = card.querySelector('.card-title').textContent.toLowerCase().trim();
            const cardSkills = card.querySelector('.card-skills').textContent.toLowerCase().trim();
            const cardDescription = card.querySelector('.card-body p').textContent.toLowerCase().trim();

            const categoryMatch = categoryValue === '' || cardCategory === categoryValue;
            const typeMatch = typeValue === '' || cardType === typeValue;
            const searchMatch = searchValue === '' || 
                                cardTitle.includes(searchValue) || 
                                cardCategory.includes(searchValue) ||
                                cardSkills.includes(searchValue) ||
                                cardDescription.includes(searchValue);

            card.style.display = (categoryMatch && typeMatch && searchMatch) ? 'block' : 'none';
        });

        updatePagination();
    }

    function updatePagination() {
        const visibleCards = Array.from(cards).filter(card => card.style.display !== 'none');
        const totalPages = Math.ceil(visibleCards.length / itemsPerPage);

        visibleCards.forEach((card, index) => {
            const startIndex = (currentPage - 1) * itemsPerPage;
            const endIndex = startIndex + itemsPerPage;
            card.style.display = (index >= startIndex && index < endIndex) ? 'block' : 'none';
        });

        pagination.innerHTML = '';
        if (totalPages <= 1) return;

        const prevBtn = document.createElement('button');
        prevBtn.className = 'page-btn';
        prevBtn.innerHTML = '<i class="fas fa-chevron-left"></i>';
        prevBtn.disabled = currentPage === 1;
        prevBtn.addEventListener('click', () => { if (currentPage > 1) { currentPage--; filterCards(); } });
        pagination.appendChild(prevBtn);

        for (let i = 1; i <= totalPages; i++) {
            const pageBtn = document.createElement('button');
            pageBtn.className = 'page-btn';
            pageBtn.textContent = i;
            if (i === currentPage) pageBtn.classList.add('active');
            pageBtn.addEventListener('click', () => { currentPage = i; filterCards(); });
            pagination.appendChild(pageBtn);
        }

        const nextBtn = document.createElement('button');
        nextBtn.className = 'page-btn';
        nextBtn.innerHTML = '<i class="fas fa-chevron-right"></i>';
        nextBtn.disabled = currentPage === totalPages;
        nextBtn.addEventListener('click', () => { if (currentPage < totalPages) { currentPage++; filterCards(); } });
        pagination.appendChild(nextBtn);
    }

    categorySelect.addEventListener('change', () => { currentPage = 1; filterCards(); });
    typeSelect.addEventListener('change', () => { currentPage = 1; filterCards(); });
    searchInput.addEventListener('input', () => { currentPage = 1; filterCards(); });
    searchButton.addEventListener('click', () => { currentPage = 1; filterCards(); });

    filterCards(); // Initialize
});

</script>
</body>
</html>