<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';
mysqli_set_charset($connection, "utf8mb4");
$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

// Current date
$today = date('Y-m-d');

// Pagination setup
$perPage = 6; // items per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page > 1) ? ($page * $perPage) - $perPage : 0;

//  COUNT only Upcoming + Running events
$totalQuery = "
    SELECT COUNT(*) as total 
    FROM events 
    WHERE DATE(`date`) = '$today' OR DATE(`date`) > '$today'
";
$totalResult = mysqli_query($connection, $totalQuery);
$totalRow = mysqli_fetch_assoc($totalResult);
$total = $totalRow['total'];

// Calculate total pages
$pages = ceil($total / $perPage);

// Fetch Upcoming + Running events only
$query = "
    SELECT * FROM events 
    WHERE DATE(`date`) = '$today' OR DATE(`date`) > '$today' 
    ORDER BY DATE(`date`) ASC 
    LIMIT $start, $perPage
";
$event = mysqli_query($connection, $query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Active Event</title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>"/>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        :root {
            --primary-color: #0a7e6b;
            --hover-color: #c6c8cb;
            --secondary-color: #3f37c9;
            --accent-color: #4cc9f0;
            --light-bg: #f8f9fa;
            --dark-text: #212529;
        }
        
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--light-bg);
            color: var(--dark-text);
        }
        
    header {
      box-shadow: 0 2px 15px rgba(0,0,0,0.1);
      padding: 15px 20%;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 1000;
      background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    }

    header .logo-area {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    header .logo-area img {
      height: 50px;
      width: 50px;
      object-fit: contain;
    }

    header h2 {
      margin: 0;
      font-size: 22px;
      color: white;
      font-weight: 700;
    }

header nav a {
    margin-left:10px;
    text-decoration: none;
    color: black;
    font-weight: 500;
    transition: color 0.3s;
    position: relative;
    background: #f0f7f4;
    padding: 8px 20px;
    border-radius: 9px;
    text-decoration:none;
}

    header nav a:hover {
      color: black;
    }
        
        
        .hero-section {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 4rem 0;
            margin-bottom: 3rem;
            border-radius: 0 0 20px 20px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }
        
        .section-title {
            position: relative;
            display: inline-block;
            margin-bottom: 2rem;
            font-weight: 700;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 0;
            width: 50px;
            height: 4px;
            background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
            border-radius: 2px;
        }
        
        .event-card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.08);
            overflow: hidden;
            transition: all 0.3s ease;
            margin-bottom: 1.5rem;
            background: white;
        }
        
        .event-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 20px rgba(0,0,0,0.12);
        }
        
        .event-img {
            height: 100%;
            width: 100%;
        }
        
        .card-body {
            padding: 1.5rem;
        }
        
        .card-title {
            font-weight: 700;
            margin-bottom: 1rem;
            color: #08314f;
        }
        
        .card-text {
            color: #6c757d;
            margin-bottom: 1.5rem;
            text-align: justify;
        }
        
        .event-meta {
            display: flex;
            align-items: center;
            margin-bottom: 0.5rem;
        }
        
.event-meta i {
    width: 30px;
    height: 30px;
    color: #08314F;
    margin-right: 10px;
    background-color: rgba(67, 97, 238, 0.1);
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
}
        
        .price-tag {
            background-color:#08314F;
            color: white;
           padding: 0.5rem 1.5rem;
    border-radius: 8px;
            font-weight: 600;
            font-size: 0.9rem;
            display: inline-block;
        }
        
        .btn-primary {
            background-color: #08314F;
            border: none;
            padding: 0.5rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            margin-top: 1rem;
        }
        
        .btn:hover {
            background-color:#08314F !important;
            transition:0.4s;
            color: white;
        }
        
        
        
        .filter-container {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            margin-bottom: 2rem;
        }
        
        .category-tag {
            display: inline-block;
            background-color: #e9ecef;
            color: var(--dark-text);
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            margin-right: 0.5rem;
            margin-bottom: 0.5rem;
            transition: all 0.2s ease;
            cursor: pointer;
        }
        
        .category-tag:hover, .category-tag.active {
            background-color: var(--primary-color);
            color: white;
        }
        
        .event-date {
            position: absolute;
            top: 15px;
            left: 15px;
            background: rgba(255,255,255,0.9);
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 700;
            color: #08314f;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .category_box {
            position: absolute;
            top: 15px;
            right: 15px;
            background: rgba(255,255,255,0.9);
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 700;
            color: #08314f;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .img-container {
            position: relative;
            width: 100%;
            height: 220px;
        }
        
        .no-events {
            text-align: center;
            padding: 3rem;
            color: #6c757d;
            display: none;
        }
        
        .search-box {
            position: relative;
            margin-bottom: 1.5rem;
        }
        
        .search-box i {
            position: absolute;
            top: 12px;
            left: 15px;
            color: #6c757d;
        }
        
        .search-box input {
            padding-left: 40px;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }

        .cardshow {
            width: 100%; /* FIXED STRETCHER ISSUE */
            margin:0 !important;
        }
        
        
        
/* Footer */
    footer {
      /*background: #1a3c32;*/
    color: white;
    padding-bottom: 15px;
    }
    
.logo_box {
    width: 100px;
    height: 100px;
    display: flex;
    margin: auto;
}

.logo_box img{
    width:100%;
    height:100%;
}

.contact_info_box{
    display:flex;
    justify-content:center;
}

.contact_info{
    text-align: center;
    position: relative;
    margin: 0;
    padding-top: 17px;
    padding-bottom: 11px;
}

.contact_info::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    height: 2px;
    background: white;
}
    
.footer-content {
    display: flex;
    justify-content: center;
    gap: 30px;
    padding-top: 20px;
}

    .footer-column h3 {
      margin-bottom: 20px;
      font-size: 1.3rem;
      position: relative;
      padding-bottom: 10px;
    }

    .footer-column h3::after {
      content: '';
      position: absolute;
      left: 0;
      bottom: 0;
      width: 40px;
      height: 2px;
      background: #1a936f;
    }

    .footer-column p, .footer-column a {
      color: white;
      margin-bottom: 10px;
      display: block;
      text-decoration: none;
      transition: color 0.3s;
    }

    .footer-column a:hover {
      color: white;
    }

    .copyright {
      text-align: center;
      border-top: 1px solid rgba(255,255,255,0.1);
      color: #aaa;
      font-size: 0.9rem;
    }         
        
        
        @media(max-width:500px){
            .price-tag {
                font-size:10px !important;
            }
            
            .btn-primary{
                font-size:10px !important;
            }
            
            .event-date{
                font-size:10px !important;
            }
            
            .category_box {
                font-size:10px !important;
            }
            
            .card-body{
                padding:10px !important;
            }
            
            header {
    padding: 23px 1% !important;
    gap: 20px !important;
    flex-flow: column !important; 
    }
    
    .footer-content {
        flex-flow: column;
        gap: 10px !important;
        padding-top: 20px;
        padding-bottom: 20px;
    }
    .footer-column p {
        margin: 0 !important;
        text-align: center;
    }
        }
        
.description_box {
    height: 200px;
    overflow: auto;
    padding-right:10px;
    margin-bottom: 16px;
}

::-webkit-scrollbar {
  width: 4px;
  height:4px;
}

::-webkit-scrollbar-track {
  background: #f1f1f1;
}

::-webkit-scrollbar-thumb {
  background: #888;
  border-radius: 4px;
}

::-webkit-scrollbar-thumb:hover {
  background: #555;
}

  /* Filter box animation */
  .animated-slide-up {
    backdrop-filter: blur(10px);
    opacity:0;
    transform: translateY(40px);
    animation: slideUp 1.5s ease forwards;
    animation-delay: 0.6s;
  }
  @keyframes slideUp {
    to {opacity:1; transform: translateY(0);}
  }
  
.direct_top{
    position: fixed;
    bottom: 47px;
    right: 25px;
    background: #e57d07;
    width: 35px;
    color: white;
    height: 35px;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
    text-decoration: none;
    z-index: 100000;
}  
    </style>   
</head>
<body>
    
    
<a href="#" class="direct_top"><i class="fa-solid fa-arrow-up"></i></a>

<!-- Header Section -->
  <header>
    <!-- Left Side: Logo + NGO Name -->
    <div class="logo-area">
      <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
      <div>
          <h2><?php echo $dataweb['web_name']?></h2>
          <p style="margin:0; color:white;"><?php echo $dataweb['web_tag_line']?></p>
      </div>
    </div>

    <!-- Right Side: Navigation -->
    <nav>
      <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
            <i class="fa-solid fa-house-user"></i> Home
        </a>
        
      <a href="tel:<?php echo $dataweb['site_mobile_1'] ?>" style="color: black;
    padding-left: 20px;
    text-decoration: none;">
    <i class="fa-solid fa-phone"></i> 
    <?php echo $dataweb['site_mobile_1'] ?>
</a>
    </nav>
  </header>    
    
<div class="container py-5">
    <div class="filter-container animated-slide-up">
        <h3 class="mb-3">Filter Events</h3>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label">Search Events</label>
                <div class="search-box">
                    <i class="fas fa-search"></i>
                   <input type="text" id="searchInput" class="form-control" placeholder="Search by event name...">

                </div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label">Date Range</label>
                <input type="text" id="dateFilter" class="form-control" placeholder="Select dates">
            </div>
          
        </div>
    </div>

    <h2 class="section-title">Upcoming Events</h2>
    <div class="row" id="eventsContainer">
        <div class="no-events" id="noEvents">
            <i class="fas fa-calendar-times fa-3x mb-3"></i>
            <h4>No events found</h4>
            <p>There are currently no upcoming events</p>
        </div>

        <?php if(mysqli_num_rows($event) > 0): ?>
            <div class="row cardshow">
            <?php foreach($event as $data): ?>
            <div class="col-md-6 col-lg-4 event-item1" 
                 data-name="<?= strtolower($data['name']) ?>" 
                 data-category="<?= strtolower($data['category'] ?? 'general') ?>" 
                 data-date="<?= date('Y-m-d', strtotime($data['date'])) ?>">
                <div>
                    <div class="card event-card">
                    <div class="img-container">
                        <img src="<?php echo base_url('EventBanners/'.$data['banner'])?>" class="card-img-top event-img" alt="<?= $data['name'] ?>">
                        <div class="event-date">
                            <i class="fas fa-calendar-day me-1"></i> <?php echo date('d-M-y', strtotime($data['date']))?>
                        </div>
                        
                        <div class="category_box">
                            <i class="fa-solid fa-table"></i> <?= strtolower($data['event_type'] ) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <h5 class="card-title"><?= $data['name']?></h5>
                        
                        <div class="description_box">
    <p class="card-text">
        <?php 
            $desc = $data['description'];
            $short = mb_substr($desc, 0, 300, 'UTF-8'); 
            $long  = mb_substr($desc, 300, null, 'UTF-8');
        ?>

        <?= $short ?>

        <?php if (mb_strlen($desc, 'UTF-8') > 300): ?>
            <span class="dots">...</span>
            <span class="more-text" style="display:none;"><?= $long ?></span>
            <button type="button" class="btn btn-link p-0 show-more-btn" data-id="<?= $data['id'] ?>">
                Show More
            </button>
        <?php endif; ?>
    </p>
</div>

                        
                        <div class="event-meta">
                            <i class="fas fa-map-marker-alt"></i>
                            <span><b>Venue:</b> <?= $data['venue']?></span>
                        </div>
                        <div class="event-meta">
                            <i class="fas fa-clock"></i>
                            <span><b>Start Time:</b> <?= $data['stime']?>,  <b>End Time:</b> <?= $data['etime']?></span>
                        </div>
                        <div class="event-meta">
                            <i class="fas fa-users"></i>
                            <?php
                            $id = $data['id'];
                            require 'db_config.php';
                            $query = "SELECT * FROM `event_tickets` WHERE `event_id` = $id";
                            $query_num = mysqli_query($connection, $query);
                            $rowexp = mysqli_num_rows($query_num);
                            ?> 
                            <span><b>Current Registrations:</b> <?= $rowexp?> Registered</span>
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <span class="price-tag">Registration Fee ₹ <?= $data['fee']?></span>
                            <a href="<?php echo base_url('Registeration-Event/'.$data['id'])?>" class="btn btn-primary" style="margin:0;" target="_blank()">
                                <i class="fa-solid fa-address-card"></i>  Register
                            </a>
                        </div>
                    </div>
                </div>
                </div>
            </div>
            <?php endforeach; ?>
            </div>
        <?php else: ?>
            <script>document.getElementById('noEvents').style.display = 'block';</script>
        <?php endif; ?>
    </div>

    <?php if($pages > 1): ?>
    <nav aria-label="Event pagination" class="mt-5">
        <ul class="pagination justify-content-center">
            <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $page-1 ?>" tabindex="-1">Previous</a>
            </li>
            <?php for($i = 1; $i <= $pages; $i++): ?>
                <li class="page-item <?= ($page == $i) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
            <li class="page-item <?= ($page >= $pages) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $page+1 ?>">Next</a>
            </li>
        </ul>
    </nav>
    <?php endif; ?>
</div>

<!-- Footer -->
  <footer style="background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);">
      <div style="padding-top:25px;">
          <div class="logo_box">
             <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
        </div>
      </div>
        <div class="contact_info_box">
            <h3 class="contact_info">Contact Info</h3>
        </div>
        
    <div class="footer-content">
        
      <div class="footer-column">
        <p><i class="fas fa-phone"></i> <?php echo $dataweb['site_mobile_1']?></p>
      </div>
      <div class="footer-column">
        <p><i class="fas fa-envelope"></i>  <?php echo $dataweb['webemail_1']?></p>
       
      </div>
      <div class="footer-column">
        <p><i class="fas fa-map-marker-alt"></i> <?php echo $dataweb['website_address'] ?></p>
        
      </div>
    </div>
    <div class="copyright">
       <!-- footer --> 
            <?php require_once($_SERVER['DOCUMENT_ROOT'] . '/software/app/Views/footer.php'); ?>
        <!-- / footer -->
    </div>
  </footer>    

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>

document.addEventListener("click", function (e) {
    if (e.target.classList.contains("show-more-btn")) {
        let btn = e.target;
        let parent = btn.closest("p");
        let dots = parent.querySelector(".dots");
        let moreText = parent.querySelector(".more-text");

        if (moreText.style.display === "none") {
            moreText.style.display = "inline";
            dots.style.display = "none";
            btn.textContent = "Show Less";
        } else {
            moreText.style.display = "none";
            dots.style.display = "inline";
            btn.textContent = "Show More";
        }
    }
});

document.addEventListener('DOMContentLoaded', function() {
    const dateFilter = flatpickr("#dateFilter", {
        mode: "range",
        dateFormat: "Y-m-d",
        onChange: function() {
            filterEvents();
        }
    });

    const searchInput = document.getElementById('searchInput');
    const categoryTags = document.querySelectorAll('.category-tag');
    const eventItems = document.querySelectorAll('.event-item1');
    const noEventsMsg = document.getElementById('noEvents');
 const activeCategory = document.querySelector('.category-tag.active');
const selectedCategory = activeCategory ? activeCategory.dataset.category : 'all';

    searchInput.addEventListener('input', filterEvents);
    
    categoryTags.forEach(tag => {
        tag.addEventListener('click', function() {
            categoryTags.forEach(t => t.classList.remove('active'));
            this.classList.add('active');
            filterEvents();
        });
    });

   function filterEvents() {
    const searchTerm = searchInput.value.toLowerCase();
    const activeTag = document.querySelector('.category-tag.active');
    const selectedCategory = activeTag ? activeTag.dataset.category : 'all';
    const dateRange = dateFilter.input.value;
    let startDate, endDate;
    
    if (dateRange) {
        const dates = dateRange.split(' to ');
        startDate = dates[0];
        endDate = dates[1] || dates[0];
    }

    let visibleCount = 0;

    eventItems.forEach(item => {
        const eventName = item.dataset.name;
        const eventCategory = item.dataset.category;
        const eventDate = item.dataset.date;

        const nameMatch = eventName.includes(searchTerm);
        const categoryMatch = selectedCategory === 'all' || eventCategory === selectedCategory;
        let dateMatch = true;

        if (startDate && endDate) {
            dateMatch = eventDate >= startDate && eventDate <= endDate;
        }

        if (nameMatch && categoryMatch && dateMatch) {
            item.style.display = 'block';
            visibleCount++;
        } else {
            item.style.display = 'none';
        }
    });

    noEventsMsg.style.display = visibleCount === 0 ? 'block' : 'none';
}


    filterEvents();
});
</script>

<script>
// Fixed Image Upload Script
document.addEventListener('DOMContentLoaded', function() {
    // Simple file to data URL conversion without compression
    function readFileAsDataURL(file) {
        return new Promise((resolve, reject) => {
            const reader = new FileReader();
            reader.onload = (e) => resolve(e.target.result);
            reader.onerror = () => reject(new Error('Failed to read file'));
            reader.readAsDataURL(file);
        });
    }

    // Mukhiya Photo handling
    const mukhiyaPhotoInput = document.getElementById('MukhiyaPhoto');
    const mukhiyaSlot = document.querySelector('.mukhiya-photo-slot');
    const mukhiyaEmptySlot = mukhiyaSlot.querySelector('.empty-slot');
    const mukhiyaPreviewImg = mukhiyaSlot.querySelector('.preview-image');
    const mukhiyaRemoveBtn = mukhiyaSlot.querySelector('.remove-photo');

    mukhiyaEmptySlot.addEventListener('click', function() {
        mukhiyaPhotoInput.click();
    });

    mukhiyaPhotoInput.addEventListener('change', async function(e) {
        const file = e.target.files[0];
        if (!file) return;

        // Validate file type
        if (!file.type.startsWith('image/')) {
            alert('Please select a valid image file (JPEG, PNG, etc.)');
            return;
        }

        // Show loading state
        mukhiyaEmptySlot.innerHTML = '<i class="fas fa-spinner fa-spin fa-2x"></i><span>Processing...</span>';

        try {
            const imageData = await readFileAsDataURL(file);
            mukhiyaPreviewImg.src = imageData;
            mukhiyaPreviewImg.classList.remove('d-none');
            mukhiyaEmptySlot.classList.add('d-none');
            mukhiyaRemoveBtn.classList.remove('d-none');
            mukhiyaSlot.classList.add('has-image');
            
            // Restore original empty slot content
            mukhiyaEmptySlot.innerHTML = '<i class="fas fa-camera fa-2x"></i><span>Click to capture</span>';
        } catch (error) {
            console.error('Image processing failed:', error);
            mukhiyaEmptySlot.innerHTML = '<i class="fas fa-camera fa-2x"></i><span>Click to capture</span>';
            alert('Failed to process image. Please try with a different image file.');
        }
    });

    mukhiyaRemoveBtn.addEventListener('click', function(e) {
        e.stopPropagation();
        mukhiyaPhotoInput.value = '';
        mukhiyaPreviewImg.src = '';
        mukhiyaPreviewImg.classList.add('d-none');
        mukhiyaEmptySlot.classList.remove('d-none');
        mukhiyaRemoveBtn.classList.add('d-none');
        mukhiyaSlot.classList.remove('has-image');
    });

    // Mukhiya Docs Photo Upload Functionality
    const mukhiyaSlots = document.querySelectorAll('.mukhiya-docs-slot');
    const mukhiyaDataInput = document.getElementById('mukhiyaDocsData');
    const mukhiyaCameraInput = document.querySelector('.mukhiya-docs-camera-input');
    let mukhiyaPhotosData = JSON.parse(mukhiyaDataInput.value || '[]');
    
    // Initialize slots with existing data
    mukhiyaSlots.forEach((slot, index) => {
        const emptySlot = slot.querySelector('.empty-slot');
        const previewImg = slot.querySelector('.preview-image');
        const removeBtn = slot.querySelector('.remove-photo');
        
        if (mukhiyaPhotosData[index]) {
            previewImg.src = mukhiyaPhotosData[index];
            previewImg.classList.remove('d-none');
            emptySlot.classList.add('d-none');
            removeBtn.classList.remove('d-none');
            slot.classList.add('has-image');
        }
        
        emptySlot.addEventListener('click', () => {
            if (mukhiyaPhotosData[index]) return;
            mukhiyaCameraInput.value = '';
            mukhiyaCameraInput.setAttribute('data-slot-index', index);
            mukhiyaCameraInput.click();
        });
        
        removeBtn.addEventListener('click', (e) => {
            e.stopPropagation();
            const slotIndex = index;
            mukhiyaPhotosData[slotIndex] = null;
            mukhiyaDataInput.value = JSON.stringify(mukhiyaPhotosData);
            
            previewImg.src = '';
            previewImg.classList.add('d-none');
            emptySlot.classList.remove('d-none');
            removeBtn.classList.add('d-none');
            slot.classList.remove('has-image');
        });
    });
    
    mukhiyaCameraInput.addEventListener('change', async function() {
        const slotIndex = parseInt(this.dataset.slotIndex);
        const file = this.files[0];
        
        if (!file) return;

        if (!file.type.startsWith('image/')) {
            alert('Please select a valid image file (JPEG, PNG, etc.)');
            return;
        }

        const slot = mukhiyaSlots[slotIndex];
        const emptySlot = slot.querySelector('.empty-slot');
        const previewImg = slot.querySelector('.preview-image');
        const removeBtn = slot.querySelector('.remove-photo');

        emptySlot.innerHTML = '<i class="fas fa-spinner fa-spin fa-2x"></i><span>Processing...</span>';

        try {
            const imageData = await readFileAsDataURL(file);
            mukhiyaPhotosData[slotIndex] = imageData;
            mukhiyaDataInput.value = JSON.stringify(mukhiyaPhotosData);
            
            previewImg.src = imageData;
            previewImg.classList.remove('d-none');
            emptySlot.classList.add('d-none');
            removeBtn.classList.remove('d-none');
            slot.classList.add('has-image');
            
            emptySlot.innerHTML = '<i class="fas fa-camera fa-2x"></i><span>Click to capture</span>';
        } catch (error) {
            console.error('Image processing failed:', error);
            emptySlot.innerHTML = '<i class="fas fa-camera fa-2x"></i><span>Click to capture</span>';
            alert('Failed to process image. Please try with a different image file.');
        }
    });

    // Initialize all existing family members
    document.querySelectorAll('.family-member').forEach(member => {
        initMember(member);
    });
    
    // Add Family Member button
    let maxMembers = 6;
    document.getElementById('addFamilyMember').addEventListener('click', function() {
        const container = document.getElementById('familyMemberContainer');
        const original = container.querySelector('.family-member');
        const blocks = container.querySelectorAll('.family-member');

        if (blocks.length >= maxMembers) {
            this.style.display = 'none';
            return;
        }

        const clone = original.cloneNode(true);
        
        clone.querySelectorAll('input[type="text"], input[type="date"], input[type="email"]').forEach(input => {
            input.value = '';
        });
        
        clone.querySelectorAll('select').forEach(select => {
            select.selectedIndex = 0;
        });
        
        clone.querySelectorAll('.photo-slot').forEach(slot => {
            const img = slot.querySelector('.preview-image');
            const empty = slot.querySelector('.empty-slot');
            const removeBtn = slot.querySelector('.remove-photo');
            
            img.src = '';
            img.classList.add('d-none');
            empty.classList.remove('d-none');
            removeBtn.classList.add('d-none');
            slot.classList.remove('has-image');
        });
        
        clone.querySelector('#memberPhotosData').value = JSON.stringify(Array(4).fill(null));
        container.appendChild(clone);
        initMember(clone);
    });
    
    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-member')) {
            const members = document.querySelectorAll('.family-member');
            if (members.length > 1) {
                e.target.closest('.family-member').remove();
                if (members.length <= maxMembers) {
                    document.getElementById('addFamilyMember').style.display = 'block';
                }
            } else {
                alert("At least one family member is required.");
            }
        }

        if (e.target.classList.contains('remove-photo')) {
            e.preventDefault();
            e.stopPropagation();

            const photoSlot = e.target.closest('.photo-slot');
            const slotIndex = parseInt(photoSlot.dataset.index);
            const memberBlock = photoSlot.closest('.family-member');
            const photosDataInput = memberBlock.querySelector('#memberPhotosData');
            let photosData = JSON.parse(photosDataInput.value || '[]');

            photosData[slotIndex] = null;
            photosDataInput.value = JSON.stringify(photosData);

            const emptySlot = photoSlot.querySelector('.empty-slot');
            const previewImg = photoSlot.querySelector('.preview-image');
            const removeBtn = photoSlot.querySelector('.remove-photo');

            previewImg.src = '';
            previewImg.classList.add('d-none');
            emptySlot.classList.remove('d-none');
            removeBtn.classList.add('d-none');
            photoSlot.classList.remove('has-image');
        }
    });
});

// Initialize a family member block
function initMember(memberBlock) {
    const photoSlots = memberBlock.querySelectorAll('.photo-slot');
    const photosDataInput = memberBlock.querySelector('#memberPhotosData');
    let photosData = JSON.parse(photosDataInput.value || '[]');
    
    let cameraInput = memberBlock.querySelector('.member-camera-input');
    if (!cameraInput) {
        cameraInput = document.createElement('input');
        cameraInput.type = 'file';
        cameraInput.className = 'member-camera-input d-none';
        cameraInput.accept = 'image/*';
        cameraInput.capture = 'environment';
        memberBlock.appendChild(cameraInput);
    }
    
    photoSlots.forEach((slot, index) => {
        const emptySlot = slot.querySelector('.empty-slot');
        const previewImg = slot.querySelector('.preview-image');
        const removeBtn = slot.querySelector('.remove-photo');
        
        if (photosData[index]) {
            previewImg.src = photosData[index];
            previewImg.classList.remove('d-none');
            emptySlot.classList.add('d-none');
            removeBtn.classList.remove('d-none');
            slot.classList.add('has-image');
        } else {
            previewImg.classList.add('d-none');
            emptySlot.classList.remove('d-none');
            removeBtn.classList.add('d-none');
            slot.classList.remove('has-image');
        }
        
        emptySlot.addEventListener('click', () => {
            if (photosData[index]) return;
            cameraInput.value = '';
            cameraInput.setAttribute('data-slot-index', index);
            cameraInput.click();
        });
        
        removeBtn.addEventListener('click', () => {
            const slotIndex = index;
            photosData[slotIndex] = null;
            photosDataInput.value = JSON.stringify(photosData);
            
            previewImg.src = '';
            previewImg.classList.add('d-none');
            emptySlot.classList.remove('d-none');
            removeBtn.classList.add('d-none');
            slot.classList.remove('has-image');
        });
    });
    
    cameraInput.addEventListener('change', async function() {
        const slotIndex = parseInt(this.dataset.slotIndex);
        const file = this.files[0];
        
        if (!file) return;

        if (!file.type.startsWith('image/')) {
            alert('Please select a valid image file (JPEG, PNG, etc.)');
            return;
        }

        const slot = photoSlots[slotIndex];
        const emptySlot = slot.querySelector('.empty-slot');
        const previewImg = slot.querySelector('.preview-image');
        const removeBtn = slot.querySelector('.remove-photo');

        emptySlot.innerHTML = '<i class="fas fa-spinner fa-spin fa-2x"></i><span>Processing...</span>';

        try {
            // Use the simple file reader without compression
            const reader = new FileReader();
            reader.onload = function(e) {
                photosData[slotIndex] = e.target.result;
                photosDataInput.value = JSON.stringify(photosData);
                
                previewImg.src = e.target.result;
                previewImg.classList.remove('d-none');
                emptySlot.classList.add('d-none');
                removeBtn.classList.remove('d-none');
                slot.classList.add('has-image');
                
                emptySlot.innerHTML = '<i class="fas fa-camera fa-2x"></i><span>Click to capture</span>';
            };
            reader.onerror = function() {
                emptySlot.innerHTML = '<i class="fas fa-camera fa-2x"></i><span>Click to capture</span>';
                alert('Failed to process image. Please try with a different image file.');
            };
            reader.readAsDataURL(file);
        } catch (error) {
            console.error('Image processing failed:', error);
            emptySlot.innerHTML = '<i class="fas fa-camera fa-2x"></i><span>Click to capture</span>';
            alert('Failed to process image. Please try with a different image file.');
        }
    });
}
</script>
</body>
</html>