<?php
namespace App\Helpers;

use Config\Services;

if (!function_exists('encrypt_url')) {
    function encrypt_url(string $path): string
    {
        $encrypter = Services::encrypter();
        $encrypted = $encrypter->encrypt($path);
        return urlencode(base64_encode($encrypted));
    }
}

if (!function_exists('decrypt_url')) {
    function decrypt_url(string $encrypted): string
    {
        $encrypter = Services::encrypter();
        $decoded = base64_decode(urldecode($encrypted));
        return $encrypter->decrypt($decoded);
    }
}