<?php
 namespace App\Controllers;
use App\Models\UserModel;
use CodeIgniter\Controller;
use App\Models\CertificateModel;
use App\Models\CommonModel;
use App\Models\TransactionModel;
use App\Models\CampaignModel;
use App\Models\InternshipModel;
use App\Models\InternshipApplicationModel;
use App\Models\ApplyInternshipForm;
use App\Models\ProjectExpenseModel;
use App\Models\Payments_Mode_Models;
use App\Models\Payments_Payu_Mode_Model;
use App\Models\Payments_Razor_Mode_Model;
use App\Models\Donote_TransactionModel;
use App\Models\EnquiryModel;
use App\Models\DonateCampaignModel;
use App\Models\DonationProjectModel;
use CodeIgniter\I18n\Time;
use Razorpay\Api\Api;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
use App\Helpers\UrlEncryptHelper;
class Home extends BaseController
{
    public function __construct() 
    {
        helper('UrlEncryptHelper'); // Load the helper
    } 
    
    public function index()
    {
        $model=new UserModel();   
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }
        return view('index');
    }
    public function CampaignDonateForm($id){
      $CampModel = new CampaignModel();
     $data['campaign'] = $CampModel->where('id', $id)->first();  
      return view('Front/Campaign-Donate-Form',$data);
        
    }
    
    public function ApplyInternshipForm($id){
      $InternModel = new InternshipModel();
     $data['intern'] = $InternModel->where('id', $id)->first();  
      return view('Front/Apply-Internship-Form',$data);  
        
    }
    
  public function ApplyInternshipData()
{
    helper(['form']);
    $validation = \Config\Services::validation();

   
    $rules = [
        'full_name'     => 'required',
        'email'         => 'required|valid_email',
        'mobile_number' => 'required|numeric',
        'qualification' => 'required',
        'college_name'  => 'required',
        'state'         => 'required',
        'district'      => 'required',
        'address'       => 'required',
        'photo'         => 'uploaded[photo]|max_size[photo,5120]|is_image[photo]', 
        'resume'        => 'uploaded[resume]|max_size[resume,10240]|ext_in[resume,pdf,doc,docx]', 
    ];

    
    $errors = [
        'photo' => [
            'uploaded' => 'Please upload a profile photo',
            'max_size' => 'Profile photo must be less than 5MB',
            'is_image' => 'Profile photo must be a valid image file (JPG, PNG, etc.)'
        ],
        'resume' => [
            'uploaded' => 'Please upload your resume',
            'max_size' => 'Resume must be less than 10MB',
            'ext_in'   => 'Resume must be a PDF, DOC or DOCX file'
        ]
    ];

    if (!$this->validate($rules, $errors)) {
        return redirect()->back()
            ->withInput()
            ->with('errors', $validation->getErrors());
    }



$internship_id  = $this->request->getPost('id');
        $name      = $this->request->getPost('full_name');
        $email          = $this->request->getPost('email');
        $mobile_number  = $this->request->getPost('mobile_number');
         $phone  = $this->request->getPost('mobile_number');
        $qualification  = $this->request->getPost('qualification');
        $college_name   = $this->request->getPost('college_name');
        $state          = $this->request->getPost('state');
        $district       = $this->request->getPost('district');
        $address        = $this->request->getPost('address');
        
        $UserModel = new UserModel();
     $UsersData = $UserModel->where('user_type',"admin" )->first();  
        $adminEmail = $UsersData['email'];
        
        
$InternModel = new InternshipModel();
     $interData = $InternModel->where('id', $internship_id)->first();  

$internship_title=$interData['title'];
$cover_message= $interData['category'];
$created_at  = date('D-m-Y');
    $InternshipModel = new InternshipApplicationModel();
    
    $data = [
        'internship_id'  => $this->request->getPost('id'),
        'full_name'      => $this->request->getPost('full_name'),
        'email'          => $this->request->getPost('email'),
        'mobile_number'  => $this->request->getPost('mobile_number'),
        'qualification'  => $this->request->getPost('qualification'),
        'college_name'   => $this->request->getPost('college_name'),
        'state'          => $this->request->getPost('state'),
        'district'       => $this->request->getPost('district'),
        'address'        => $this->request->getPost('address'),
        'status'         => "pending",
    ];

    $photo = $this->request->getFile('photo');
    if ($photo && $photo->isValid() && !$photo->hasMoved()) {
        $newName = $photo->getRandomName();
        $photo->move('InternImage', $newName); 
        $data['photo'] = $newName;
    } else {
        return redirect()->back()
            ->withInput()
            ->with('error', 'Invalid profile photo upload');
    }

   
    $resume = $this->request->getFile('resume');
    if ($resume->isValid() && !$resume->hasMoved()) {
        $newNameresume = $resume->getRandomName();
        $resume->move('ResumeImage', $newNameresume);
        $data['resume'] = $newNameresume;
    } else {
        return redirect()->back()
            ->withInput()
            ->with('error', 'Invalid resume file upload');
    }

    
    try {
        $result = $InternshipModel->insert($data);
        $id = $InternshipModel->getInsertId();
        
        if ($result) {
          
          
          
        require 'vendor/autoload.php';
        require 'phpmailer/src/PHPMailer.php';
        require 'phpmailer/src/Exception.php';
        require 'phpmailer/src/SMTP.php';

        require 'db_config.php';

                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                            
                             $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                       $site_url=$dataweb['site_url'];
                        $certificate_provider_name= $dataweb['certificate_provider_name'];
                              $designation= $dataweb['designation'];
                              $datawebname= $dataweb['web_name'];
                              
             $weblogo = base_url('websiteLogoImages/'.$dataweb['web_logo']);
        // Fetch email config
        $email_data = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `email_credentials`"), MYSQLI_ASSOC);
        $dataweb = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `admin_website_update`"), MYSQLI_ASSOC);
        $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

        // ===================== SEND TO USER =====================
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = $email_data['host'];
            $mail->SMTPAuth = true;
            $mail->Username = $email_data['by_email'];
            $mail->Password = $email_data['by_password'];
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mail->addAddress($email, $name);
            $mail->isHTML(true);
            $mail->Subject = 'Internship Application Received at ' . $dataweb['web_name'];

$mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark container -->
  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <!-- Content box -->
    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
      </div>

      <!-- Message Body -->
      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear {$name},<br><br>

         Thank you for applying for the <strong>Internship Program</strong> at 
        <strong>{$dataweb['web_name']}</strong>.<br><br>

        We have successfully received your internship application. Our HR team will carefully review your profile 
        and get back to you within <strong>5–7 working days</strong>.<br><br>

        <strong>Here are the details you submitted:</strong><br><br>

        <table style='width: 100%; border-collapse: collapse;'>
          <tr><td style='padding: 6px 0;'><strong>Full Name:</strong></td><td>{$name}</td></tr>
          <tr><td style='padding: 6px 0;'><strong>Email:</strong></td><td>{$email}</td></tr>
          <tr><td style='padding: 6px 0;'><strong>Phone:</strong></td><td>{$phone}</td></tr>
          <tr><td style='padding: 6px 0;'><strong>Applied On:</strong></td><td>" . date('d M, Y') . "</td></tr>
          <tr><td style='padding: 6px 0;'><strong>Internship Position:</strong></td><td>{$internship_title}</td></tr>
        </table><br>

         If you need urgent assistance, feel free to reach out to us directly at 
        <a href='mailto:{$dataweb['webemail_1']}' style='color: #ff4b2b;'>{$dataweb['webemail_1']}</a><br><br>

        We truly appreciate your interest and look forward to working with you.<br><br>

        Best regards,<br>
        <strong>{$dataweb['certificate_provider_name']}</strong><br>
        {$dataweb['designation']}<br>
        <a href='https://www.{$dataweb['site_url']}' target='_blank' style='color: #ff416c;'>www.{$dataweb['site_url']}</a><br>
        <strong>{$dataweb['web_name']}</strong>
      </div>

    </div>
  </div>
</div>";

            $mail->send();
        } catch (Exception $e) {
             return redirect()->to('internship_success/'.$id)
                ->with('success', 'Application submitted successfully.');
        }

        // ===================== SEND TO ADMIN =====================
        $mailAdmin = new PHPMailer(true);
        try {
            $mailAdmin->isSMTP();
            $mailAdmin->Host = $email_data['host'];
            $mailAdmin->SMTPAuth = true;
            $mailAdmin->Username = $email_data['by_email'];
            $mailAdmin->Password = $email_data['by_password'];
            $mailAdmin->SMTPSecure = 'tls';
            $mailAdmin->Port = 587;

            $mailAdmin->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mailAdmin->addAddress($adminEmail, 'Enquiry from ' . $name);
            $mailAdmin->isHTML(true);
            $mailAdmin->Subject = 'New Internship Application from ' . $name;

$mailAdmin->Body = "
<div style='font-family: Arial, sans-serif; padding: 20px; background: #f9f9f9;'>
    <h2 style='color: #ff4b2b;'>New Internship Application Notification</h2>
    <p><strong>Applicant Name:</strong> {$name}</p>
    <p><strong>Email:</strong> {$email}</p>
    <p><strong>Phone:</strong> {$phone}</p>
    <p><strong>Internship Position:</strong> {$internship_title}</p>
    <p><strong>Cover Message:</strong> {$cover_message}</p>
    <p><strong>Submitted At:</strong> {$created_at}</p>
</div>";

            $mailAdmin->send();
               return redirect()->to('internship_success/'.$id)
                ->with('success', 'Application submitted successfully.');
        } catch (Exception $e) {
            return redirect()->to('internship_success/'.$id)
                ->with('success', 'Application submitted successfully.');
        }

       
        
       }

            
            
            
           
        } catch(Exception $e) {
            return redirect()->back()
                ->withInput()
                ->with('error', 'Failed to save application');
        }
    } 


public function internship_success($id){
     $AppInternshipModel = new InternshipApplicationModel();
     $data = $AppInternshipModel->where('id', $id)->first();
     $data['intern'] = $AppInternshipModel->where('id', $id)->first();
       $InternModel = new InternshipModel();
     $data['internship'] = $InternModel->where('id', $data['internship_id'])->first();  
      return view('Front/internship-success',$data); 
    
}

    public function MemberDataShow(){
        $model=new UserModel();    
        $data['member'] = $model->where('status', "active")->orderBy('id', 'DESC')->findAll();
         return view('Member-Data-Show',$data);
    }
    public function siteurl()
    {  
         require 'db_config.php';
                       
                        
                         $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         $url = $dataweb['site_url'];
                         
        return  parse_url[$url];
    } 
    
    
    public function EnquiryForm(){
        
        
         return view('Front/Enquiry-Form');
    }
    
    
     public function EnquiryFormData()
    {
         $session = session();

    // Get captcha value
    $userCaptcha = $this->request->getPost('captcha');
    $correctCaptcha = $session->get('captcha_sum');

    if ($userCaptcha != $correctCaptcha) {
        return redirect()->back()->withInput()->with('captcha_error', 'Incorrect answer. Please try again.');
    }
          $model=new UserModel(); 
          $adminData = $model->where('user_type', "admin")->first();
          $adminEmail = $adminData['email'];
         $name    = $this->request->getPost('name');
            $email   = $this->request->getPost('email');
            $phone   = $this->request->getPost('phone');
            $subject = $this->request->getPost('subject');
           $message = $this->request->getPost('message');
           $created_at = date('d-m-Y');
          helper(['form']);
        $validation = \Config\Services::validation();

        $rules = [
            'name'    => 'required',
            'email'   => 'required|valid_email',
            'phone'   => 'permit_empty|numeric|min_length[10]|max_length[10]',
            'subject' => 'required',
            'message' => 'required',
        ];
if (!$this->validate($rules)) {
    return redirect()->back()->withInput()->with('validation', $this->validator);
}

        $Enmodel = new EnquiryModel();

        $data = [
            'name'    => $this->request->getPost('name'),
            'email'   => $this->request->getPost('email'),
            'phone'   => $this->request->getPost('phone'),
            'subject' => $this->request->getPost('subject'),
            'message' => $this->request->getPost('message'),
            'status'=>"pending",
        ];

       $result =  $Enmodel->save($data);
       if($result){
          
            
       

        $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
       

        require 'vendor/autoload.php';
        require 'phpmailer/src/PHPMailer.php';
        require 'phpmailer/src/Exception.php';
        require 'phpmailer/src/SMTP.php';

        require 'db_config.php';

        // Fetch email config
        $email_data = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `email_credentials`"), MYSQLI_ASSOC);
        $dataweb = mysqli_fetch_array(mysqli_query($connection, "SELECT * FROM `admin_website_update`"), MYSQLI_ASSOC);
        $weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

        // ===================== SEND TO USER =====================
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = $email_data['host'];
            $mail->SMTPAuth = true;
            $mail->Username = $email_data['by_email'];
            $mail->Password = $email_data['by_password'];
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mail->addAddress($email, $name);
            $mail->isHTML(true);
            $mail->Subject = "Thank You for Contacting  {$dataweb['web_name']}! Your Inquiry Has Been Received";

            $mail->Body = "
            <div style=' margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background-color: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 80px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 24px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
      </div>

      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        Dear {$name},<br><br>

         Thank you for reaching out to us via the <strong>Enquiry Form</strong> on 
        <strong>{$dataweb['web_name']}</strong>.<br><br>

        We have received your enquiry and our team will get back to you as soon as possible.<br><br>

        <strong>Here are the details you submitted:</strong><br>
        <ul style='list-style: none; padding-left: 0;'>
          <li><strong>Full Name:</strong> {$name}</li>
          <li><strong>Email:</strong> {$email}</li>
          <li><strong>Phone:</strong> {$phone}</li>
          <li><strong>Subject:</strong> {$subject}</li>
          <li><strong>Message:</strong> {$message}</li>
        </ul><br>

    If you need urgent assistance, feel free to reach out to us directly at 
        <a href='mailto:{$dataweb['webemail_1']}' style='color: #ff4b2b;'>{$dataweb['webemail_1']}</a><br><br>

        We appreciate your interest and will be in touch soon.<br><br>

        Warm regards,<br>
        {$dataweb['certificate_provider_name']}<br>
        {$dataweb['designation']}<br>
        <a href='https://www.{$dataweb['site_url']}' target='_blank' style='color: #ff416c;'>www.{$dataweb['site_url']}</a><br>
        <strong>{$dataweb['web_name']}</strong>
      </div>

    </div>
  </div>
</div>";
            $mail->send();
        } catch (Exception $e) {
            return redirect()->back()->with('msg', 'Response saved, but user email failed to send.');
        }

        // ===================== SEND TO ADMIN =====================
        $mailAdmin = new PHPMailer(true);
        try {
            $mailAdmin->isSMTP();
            $mailAdmin->Host = $email_data['host'];
            $mailAdmin->SMTPAuth = true;
            $mailAdmin->Username = $email_data['by_email'];
            $mailAdmin->Password = $email_data['by_password'];
            $mailAdmin->SMTPSecure = 'tls';
            $mailAdmin->Port = 587;

            $mailAdmin->setFrom($email_data['by_email'], $dataweb['web_name']);
            $mailAdmin->addAddress($adminEmail, 'Enquiry from ' . $name);
            $mailAdmin->isHTML(true);
            $mailAdmin->Subject = 'New Enquiry Received from ' . $name;

            $mailAdmin->Body = "
            <div style='font-family: Arial, sans-serif; padding: 20px; background: #f9f9f9;'>
                <h2 style='color: #ff4b2b;'>New Enquiry Notification</h2>
                <p><strong>From:</strong> {$name}</p>
                <p><strong>Email:</strong> {$email}</p>
                <p><strong>Phone:</strong> {$phone}</p>
                <p><strong>Subject:</strong> {$subject}</p>
                <p><strong>Message:</strong> {$message}</p>
                <p><strong>Submitted At:</strong> {$created_at}</p>
            </div>";
            $mailAdmin->send();
              return redirect()->back()->with('success', 'Thank you for your enquiry! We will get back to you soon. Check Your Email Inox Or Spam Folder.');
        } catch (Exception $e) {
            return redirect()->back()->with('msg', 'Thank you for your enquiry! We will get back to you soon.Check Your Email Inox Or Spam Folder., But admin email failed to send.');
        }

       
      }else{
           
           
       }

      
    }
    
    public function MemberAreaData(){
        return view('Front/MemberAreaData');
    }
    
     public function mailSignup()
    {
        return view('user_dashboard/mailSignup');
    }
     public function contact()
    {
        return view('contact');
    }
    public function gallery()
    {
        return view('gallery');
    }
     public function pressrelease()
    {
        return view('pressrelease');
    }
     public function ourproject1()
    {
        return view('ourproject1');
    }
     public function ourproject2()
    {
        return view('ourproject2');
    }
     public function ourproject3()
    {
        return view('ourproject3');
    }
     public function bankinformation()
    {
        return view('bankinformation');
    }
    public function donate_view()
    {
        return view('user_dashboard/donate_view');
    }
     public function about()
    {
        return view('about');
    }
     public function error_page()
    {
        return view('error_page');
    }
    
     public function werewework()
    {
        return view('werewework');
    }
     public function ourmanegmentteam()
    {
        return view('ourmanegmentteam');
    }
     public function signin()
     
    {   
         $model=new UserModel();
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }
        
        
        $session=session(); 
       $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        
        if($data == !null){
        $session=session(); 
        if($data['user_type']=='user'){
            
           return redirect()->to('user_dashboard');
        }
         if($data['user_type']=='admin'){
            
           return redirect()->to('admin_dashboard');
        } 
        if($data['user_type']=='manager'){
            
           return redirect()->to('manager_dashboard');
        } 
        if($data['user_type']=='franchise'){
            
           return redirect()->to('franchise_dashboard');
        } 
        }
        else{
        
        return view('signin');
        }
    }
    
    public function referral_nodate_form($enCodeId){
        $id =  base64_decode($enCodeId);
 
          $userModel = new UserModel();
        $data = $userModel->where('id', $id)->first();
      
        if($data){
            
            $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $id)->first();
            
          return view('Front/referral_nodate_form',$data);   
            
        }else{
              
       return redirect()->to('signin')->with('msg', 'This Referral Code Not Valid!');
        }
        
    }
    
    
    public function signup()
    {
       
        $model=new UserModel();   
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }
          $session=session(); 
       $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        
        if($data == !null){
        $session=session(); 
        if($data['user_type']=='user'){
            
           return redirect()->to('user_dashboard');
        }
         if($data['user_type']=='admin'){
            
           return redirect()->to('admin_dashboard');
        } 
        if($data['user_type']=='manager'){
            
           return redirect()->to('manager_dashboard');
        } 
        if($data['user_type']=='franchise'){
            
           return redirect()->to('franchise_dashboard');
        } 
        }
        else{
        
        return view('signup');
        }
    }
      public function forgot_password_otp()
      {
            helper(['form', 'url']);   
              $email   = $this->request->getPost('email');
              $mobile   = $this->request->getPost('mobile');
              
             
     helper(['form']);
        $rules = [
          
            
            'email'           => 'required|min_length[4]|max_length[150]',
             'mobile'           => 'required',
            
        ];
  $session=session();
             $userModel = new UserModel();
       
        if($this->validate($rules))

        {
             $userModel = new UserModel();
$data = $userModel->where('email', $email)->where('mobile', $mobile)->first();


            
             if($data){
            $id=$data['id'];
            $name=$data['name'];
                  
                  
                $otp = rand(1111,9999);   
          
            $data = [

                 'otp'             => $otp,
                 
                
             ];
          
          
             $userModel = new UserModel();
            $userModel->update($id, $data);
          
             $userModel = new UserModel();
             $data = $userModel->where('email', $email)->first();
          
            $otp = $data['otp'];
            $email = $data['email'];
            
            
            //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
 
                         
    $dataurl = base_url();                     

try {
    
    //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                          $queryli = "SELECT * FROM `admin_website_update`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                       $site_url=$dataweb['site_url'];
                        $certificate_provider_name= $dataweb['certificate_provider_name'];
                              $designation= $dataweb['designation'];
                              
             $weblogo = base_url('websiteLogoImages/'.$dataweb['web_logo']);
    
  
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
   $mail->Subject = 'Your One-Time Password (OTP) for Password Reset';
$weblogo = base_url('websiteLogoImages/' . $dataweb['web_logo']);

$mail->Body = "
<div style='width: 100%; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background-color: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <div style=\"
    background-image: url('{$weblogo}');
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <div style='
      background-color: rgba(255, 255, 255, 0.90);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 80px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 24px; font-weight: bold; margin-top: 10px;'>{$dataweb['web_name']}</p>
      </div>

      <!-- OTP Message -->
      <div style='font-size: 16px; line-height: 1.6; color: #333;'>
        <p>Dear {$name},</p>

        <p>We received a request to reset your password for <strong>{$dataweb['web_name']}</strong>.</p>

        <p>Please use the following <strong style='color:#ff4b2b;'>One-Time Password (OTP)</strong>:</p>

       <div style='
  font-size: 14px; 
  font-weight: bold; 
  background: #ff416c; 
  color: #fff; 
  text-align: center; 
  padding: 5px; 
  border-radius: 10px; 
  letter-spacing: 3px;
  width: 100px;
  margin: 20px auto; /* centers horizontally */
'>
  {$otp}
</div>


        <p>Please enter this OTP on the password reset page within the next <strong>5 minutes</strong>.</p>

        <p>If you did not request a password reset, you can safely ignore this email.</p>

        <br>
        Thanks & Regards,<br>
        <a href='https://www.{$dataweb['site_url']}' target='_blank' style='color: #ff416c;'>www.{$dataweb['site_url']}</a><br>
        {$dataweb['certificate_provider_name']}, {$dataweb['designation']}<br>
        <strong>{$dataweb['web_name']}</strong>
      </div>

    </div>
  </div>
</div>
";

$mail->AltBody = "Hello {$name},\n\nYour OTP for password reset is: {$otp}\n\nThis OTP will expire in 5 minutes.\nIf you did not request this, please ignore.";


    $mail->send();
   $session=session();
            $data['validation'] = $this->validator;
            
             $userModel = new UserModel();
             $data['users'] = $userModel->where('email', $email)->first();
            $session->set("msgotp","OTP Sent To Your Register Email! Check inbox");
            $session->markAsFlashdata("msgotp");
            return view('otp_match_form',$data);
} 



catch (Exception $e) {
    $session=session();
            $data['validation'] = $this->validator;
            $session->set("msgemail","Email Id Not Registered Enter Valid Email ?");
            $session->markAsFlashdata("msgemail");
          return redirect()->back()->withInput();
}

 

             }

        else
        {
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("msgemail","Mobile Number Invalid! Try Again");
            $session->markAsFlashdata("msgemail");
            return redirect()->back()->withInput();
        }
          
        
}
$session=session(); 
       $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        
        if($data == !null){
        $session=session(); 
        if($data['user_type']=='user'){
            
           return redirect()->to('user_dashboard');
        }
         if($data['user_type']=='admin'){
            
           return redirect()->to('admin_dashboard');
        } 
        if($data['user_type']=='manager'){
            
           return redirect()->to('manager_dashboard');
        } 
        if($data['user_type']=='franchise'){
            
           return redirect()->to('franchise_dashboard');
        } 
        }
        else{
        
     return redirect()->to('signin');
        }
}
   
 public function match_otp_data(){
        
        helper(['form', 'url']);
              $id   = $this->request->getPost('id');
               $otp   = $this->request->getPost('otp');
                $email   = $this->request->getPost('email');
              
             
     helper(['form']);
       
  $session=session();
             $userModel = new UserModel();
       
        
             $userModel = new UserModel();
            $data = $userModel->where('email', $email)->where('id', $id)->first();
            
           
                  
                  
        if($data['otp']==$otp){
          
             $id=$data['id'];
          
             $userModel = new UserModel();
             $data['users'] = $userModel->where('id', $id)->first();
          
        
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("msgcng"," Enter New Password ?");
            $session->markAsFlashdata("msgcnf");
            return view('change_forgot_password_form',$data);
}
else
        {
           $session = session();
$session->setFlashdata("msgemail", "Incorrect OTP. Please enter a valid OTP!");


$userModel = new UserModel();
$data['users'] = $userModel->where('email', $email)->first();

return redirect()->back()->withInput();
        }  

        
    } 
    
    public function match_password_data(){
        
        helper(['form', 'url']);
              $id   = $this->request->getPost('id');
               $otp   = $this->request->getPost('otp');
                $email   = $this->request->getPost('email');
                 $password   = $this->request->getPost('password');
                  $upassword   = $this->request->getPost('uppassword');
             
            
            
     
       
  $session=session();
           $userModel = new UserModel();
           if($password==$upassword){
          
            
          $data = [
              
              
                'password' => password_hash($password, PASSWORD_DEFAULT)
            ];
           
             $userModel = new UserModel();
             
            $result =  $userModel->update($id, $data);
              
              $userModel = new UserModel();
             $data['users'] = $userModel->where('id', $id)->first();
          
        
           
           
            $data['users'] = $userModel->where('id', $session->id)->first();
            $data= $userModel->where('id', $session->id)->first();
             $data = $userModel->where('id', $id)->first();
            $sess_data = [ 
                  'admin_id'       => $data['admin_id'],
                     'id'       => $data['id'],
                     'name'     => $data['name'],
                     'mobile'     => $data['mobile'],
                     'city'     => $data['city'],
                      
                      'profile_update'     => $data['profile_update'],
                     'email'    => $data['email'],
                     'father_name'   => $data['father_name'],
                      'profile'   => $data['profile'],
                      'district' => $data['district'],
                      'nationality'=>$data['nationality'],
                      'status'=>$data['status'],
                      'payment_status'=>$data['payment_status'],
                     'user_type' => $data['user_type'],
                      'loginned' =>'loginned',
                 ];
               

                  $session=session();
                $session->set($sess_data);
                $userModel = new UserModel();
        $session = session();
            $userModel = new UserModel();
            $data['users'] = $userModel->where('id', $session->id)->first();
                 $data  = $userModel->where('id', $session->id)->first();
                 if($data['user_type']=='user'){
                     
                 $session=session();
                  $userModel = new UserModel();
            $data['users'] = $userModel->where('id', $session->id)->first();
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("success"," Password Change Successfully  ?");
            $session->markAsFlashdata("success");
        return redirect()->to('user_dashboard');

        }
        if($data['user_type']=='manager'){
                     
                 $session=session();
                  $userModel = new UserModel();
            $data['users'] = $userModel->where('id', $session->id)->first();
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("success"," Password Change Successfully  ?");
            $session->markAsFlashdata("success");
         return redirect()->to('manager_dashboard');

        }
        if($data['user_type']=='admin'){
                     
                 $session=session();
                  $userModel = new UserModel();
            $data['users'] = $userModel->where('id', $session->id)->first();
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("success"," Password Change Successfully  ?");
            $session->markAsFlashdata("success");
         return redirect()->to('admin_dashboard');

        }
        else{
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("msg","Password Does Not match ?");
            $session->markAsFlashdata("msg");
             $userModel = new UserModel();
             $data['users'] = $userModel->where('id', $id)->first();
            return view('forgot_password', $data);
        }
        
         
       //Import PHPMailer classes into the global namespace
//These must be at the top of your script, not inside a function



}
else
        {
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("msg","Password Does Not match ?");
            $session->markAsFlashdata("msg");
             $userModel = new UserModel();
             $data['users'] = $userModel->where('id', $id)->first();
           return redirect()->back()->withInput();
        }  

        
    } 
    
    
    
public function referralDonateData(){
        $paymentsModel=new Payments_Mode_Models();
          $dataphonepe=$paymentsModel->first(); 
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first();
        $referralId   = $this->request->getVar('referralId');   
      if(isset($referralId)){
          $id   = $this->request->getVar('referralId');
          $referralId   = $this->request->getVar('referralId');
                      $name    = $this->request->getVar('name');
                    $email    = $this->request->getVar('email');
                    $mobile    = $this->request->getVar('mobile');
                    $address    = $this->request->getVar('address');
                    $referance_id ="referral";
      }else{
           $id   = $this->request->getVar('id');
           $name    = $this->request->getVar('name');
                    $email    = $this->request->getVar('email');
                    $mobile    = $this->request->getVar('mobile');
                    $address    = $this->request->getVar('address');
                     $referance_id ="self";
      }
          
          
            $amount    = $this->request->getVar('amount');
             $bank_name    = $this->request->getVar('bank_name');
            $DonationPurpose    = $this->request->getPost('DonationPurpose');
              $branch_name    = $this->request->getVar('branch_name');
              $pan_no    = $this->request->getVar('pan_no');
            $order_id = substr(hash('sha256', mt_rand() . microtime()), 0, 20); 
             $txnid      =  $order_id;
        $session=session(); 
       $userModel = new UserModel();
        $data = $userModel->where('id', $id)->first();

        if($data == !null){
             if($data['user_type']=='user'){
        $session=session(); 
        
        
 require 'db_config.php';
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                       
      
if($datapayu['status']=="payu"){
   $key  = getenv('PAYU_KEY');
        $salt =getenv('PAYU_SALT');

        // Required fields (apni data source se lo)
        $txnid      =  $order_id;
        $amount = round($amount, 2); 
        $firstname  = $name ?? 'Buyer';
        $email      = $email ?? 'no@domain.com';
        $productinfo= $productinfo ?? 'Donation';
        $phone      = $mobile ?? '';

        // Build params
        $params = [
            'key'        => $key,
            'txnid'      => $txnid,
            'amount'     => $amount,
            'productinfo'=> $productinfo,
            'firstname'  => $firstname,
            'email'      => $email,
            'udf1' => '', 'udf2' => '', 'udf3' => '', 'udf4' => '', 'udf5' => '',
            
            'phone' => $phone,
            'Salt'=> $salt,
             'surl' => base_url().'payu/ReferralDonationresponse',
             'furl' => base_url().'payu/ReferralDonationresponse'
        ];

        // Generate correct hash
        $hash = $this->generatePayuRequestHash($params, $salt);

        // Prepare data for auto-post form
        $data = $params;
        $data['hash']   = $hash;
        $data['action'] = $this->payuUrl();
         
 $trans = [
     'user_name'=>$name,
     'mobile'=>$mobile,
     'email'=>$email,
     'address'=>$address,
     'transaction_id' => $txnid,
     'DonationPurpose'=>$DonationPurpose,
     'bank_name' => $bank_name,
     'branch_name' => $branch_name,
     'pan_no' => $pan_no,
     'amount'=>$amount,
     'payment_status'=>'fail',
     'referralId'=>$referralId,
     'user_id'=>$id,
     'referance_id'=>$referance_id,
     ];
     

   
$DonationModel = new Donote_TransactionModel();
$transid= $DonationModel->save($trans);
$donid = $DonationModel->getInsertID();
 if($transid){
        return view('payu_VisitorDonation_form', $data);
    }else{
        
        return redirect()->back()->with('msg', 'Server Not Response');
    }
          }  

         
          $paymentsModel=new Payments_Mode_Models();
          $dataPayment=$paymentsModel->first();
         if($dataphonepe['status']=="phonepe") {
             
             $trans = [
    'user_name'=>$name,
     'mobile'=>$mobile,
     'email'=>$email,
     'address'=>$address,
     'transaction_id' => $txnid,
     'DonationPurpose'=>$DonationPurpose,
     'bank_name' => $bank_name,
     'branch_name' => $branch_name,
     'pan_no' => $pan_no,
     'amount'=>$amount,
     'payment_status'=>'fail',
     'referralId'=>$referralId,
     'user_id'=>$id,
     'referance_id'=>$referance_id,
     ];
     
$finalAmount =$amount*100;
   
$DonationModel = new Donote_TransactionModel();
$transid= $DonationModel->save($trans);
$donid = $DonationModel->getInsertID();
             
             
        // phonepay
$wevname=$dataPayment['name']; 
$webemail=$dataPayment['email']; 
$client_id = $dataPayment['merchantId']; 
$client_secret = $dataPayment['apiKey']; 
$demo_link = $dataPayment['demo_link'];
$init_link = $dataPayment['init_link'];
//$mobile=9999999999;
// amount in INR
$description = $dataPayment['description']; 

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $demo_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 
  'client_id='.$client_id.'&client_version=1&client_secret='.$client_secret.'&grant_type=client_credentials',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$jsonResponse = curl_exec($curl);
$response = json_decode($jsonResponse, true);
$token = $response['access_token'];
 


$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $init_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "merchantOrderId": "'.$order_id.'",
    "amount": '.$finalAmount.',
    "expireAfter": 1200,
    "metaInfo": {
        "udf1": "'.$order_id.'",
        "udf2": "additional-information-2",
        "udf3": "additional-information-3",
        "udf4": "additional-information-4",
        "udf5": "additional-information-5"
    },
    "paymentFlow": {
        "type": "PG_CHECKOUT",
        "message": "Payment message used for collect requests",
        "merchantUrls": {
            "redirectUrl": "'.base_url('referrral_donote_success_payment').'"
        }
    } 
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$token,
  ),
));

$responseURL = curl_exec($curl);
// echo $responseURL;
// die;
curl_close($curl);
$response = json_decode($responseURL, true);
$tokenurl = $response['redirectUrl'];

// pay end
if($tokenurl){
 $session = session();
$sessdata =[
    'transactionId'=>$order_id,
'token_id'=>$token,
];
$session->set($sessdata);
return redirect()->to($tokenurl);

//end pay
}

else{
    
     $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction Data is Not Correct ");
                    $session->markAsFlashdata("msg");
                     return redirect()->to('admin_dashboard');
}
}
else{
     
  $trans = [
     'user_name'=>$name,
     'mobile'=>$mobile,
     'email'=>$email,
     'address'=>$address,
     'transaction_id' => $txnid,
     'DonationPurpose'=>$DonationPurpose,
     'bank_name' => $bank_name,
     'branch_name' => $branch_name,
     'pan_no' => $pan_no,
     'amount'=>$amount,
     'payment_status'=>'fail',
     'referralId'=>$referralId,
     'user_id'=>$id,
     'referance_id'=>$referance_id,
     ];
    

   
$DonationModel = new Donote_TransactionModel();
$transid= $DonationModel->save($trans);
$donid = $DonationModel->getInsertID();
             $session = session();
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

   $DonationModel = new Donote_TransactionModel();
    $user = $DonationModel->where('id', $donid)->first();
    
   

    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    // Create order
    $orderData = [
        'amount'          => $amount * 100,
        'currency'        => 'INR',
        'receipt'         => $order_id,
        'payment_capture' => 1
    ];

    try {
        $razorpayOrder = $api->order->create($orderData);
        $data = [
            'users'    => $user,
            'amount'   => $amount,
            'order_id' => $razorpayOrder->id,
            'dataweb'  => $dataweb,
            'receipt_id' =>$donid,
        ];
        
        $data['users'] = $DonationModel->where('id', $donid)->first();
          $data['amount']= $amount;
      
            return view('Front/referral-donate-payment-form',$data);
        
    } catch (Exception $e) {
        log_message('error', 'Razorpay Order Creation Error: '.$e->getMessage());
        session()->setFlashdata('error', 'Payment gateway error. Please try again.');
        return redirect()->back();
    }
       
} 
}
        else{
        
        return view('signin');
        
        }
            
        }
}

      
    public function ReferralDonationresponse(){
        
        $posted = $this->request->getPost();

        if (! isset($posted['status'], $posted['txnid'], $posted['hash'])) {
            return view('payment_error', ['msg' => 'Invalid response from PayU']);
        }

        // (Optional) verify response hash same way using reverse formula
        // TODO: implement reverse hash validation here

        if ($posted['status'] === 'success') {
              
$DonationModel = new Donote_TransactionModel();
$transid= $DonationModel->where('transaction_id', $posted['txnid'])->first(); 
$id = $transid['id'];
$transactionId = $posted['txnid'];

$data = [
    'merchantId'=>$posted['mihpayid'],
    'payment_status'=>$posted['status'],
    ];
  $DonationModel = new Donote_TransactionModel();
$result= $DonationModel->update($id, $data); 
if($result){
    
    return $this->ReferralDonationSendMail($transactionId);
    
}else{
   return view('payment_error', ['msg' => 'Invalid response from PayU']);  
}
        }
        
    }
    
    
    private function ReferralDonationSendMail($id){
        $userModel = new UserModel();
        $data = $userModel->where('user_type', "admin")->first();
        $adminEmail = $data['email'];
     $DonationModel = new Donote_TransactionModel();
$transid = $DonationModel->where('transaction_id', $id)->orWhere('id', $id)->first();

$id = $transid['id'];
$transactionId = $transid['transaction_id'];
$name = $transid['user_name'];
$email = $transid['email'];
$mobile = $transid['mobile'];
$payment_dateE = $transid['created_at'];
$payment_date = $transid['created_at'];
$amount_data = $transid['amount'];
$amount = $transid['amount'];

   //These must be at the top of your script, not inside a function
$dataurl= base_url();
$downloadurl = base_url('donate_receipt_download/'.$transactionId);
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                          $payment_dateE = date('d-m-Y h:i A', strtotime($payment_date)); // 04-09-2025 05:45 PM
   
 $weblogo = base_url('websiteLogoImages/'.$web_data['web_logo']);
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
     $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
  $mail->Subject = 'Donation Receipt for Your Generous Contribution';
  
   $mail->Body = "
<div style='width:100%; max-width:700px; margin:0 auto;
    border:5px solid transparent;
    border-image:linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice:1;
    background:#f9f9f9;
    border-radius:15px;
    overflow:hidden;
    font-family:Arial, sans-serif;
    color:#000;'>

     <div style='background-image: url({$weblogo}); 
        background-repeat: no-repeat; 
        background-position: center; 
        background-size: 280px 280px; 
        background-color: #ffffff; 
        padding: 40px; 
        font-family: Arial, sans-serif; 
        color: #000;'>

    <!-- Header -->
    <div style='text-align:center; margin-bottom:30px;'>
        <img src='{$weblogo}' style='width:100px; margin:0 auto;'>
        <p style='font-size:26px; font-weight:bold; margin-top:10px;'>{$web_data['web_name']}</p>
    </div>

    <!-- Main Content -->
    <div style='background-color:rgba(255,255,255,0.92);
        padding:30px; border-radius:10px;
        box-shadow:0 0 10px rgba(0,0,0,0.05);'>

      Dear {$name},<br><br>

      On behalf of <b>{$datawebname}</b>, we would like to express our heartfelt gratitude for your generous donation.  
      Your support enables us to continue our mission of <i>{$web_tag_line}</i>.<br><br>

      We are pleased to confirm that we have received your donation of  
      <span style='font-weight:600; color:#28a745;'>₹{$amount_data} on {$payment_dateE}</span>.  
      Your kindness and generosity will make a significant difference in the lives of those we serve.<br><br>

      As requested, we have attached your donation receipt to this email.  
      Please review the receipt for your records.<br><br>

      <span style='font-weight:600;'>Download Receipt Here:</span>  
      <a href='{$downloadurl}' target='_blank' style='color:#007BFF;'>Click Here to Download</a><br><br>

      If you have any questions or require further information, please do not hesitate to contact us at  
      <a href='mailto:{$webemail_1}'>{$webemail_1}</a> or call us at {$site_mobile_1}.<br><br>

      Once again, thank you for your generosity and compassion.  
      Your support is invaluable to us, and we are deeply grateful for your contribution.<br><br>

      Best regards,<br>
      <a href='https://www.{$web_data['site_url']}' target='_blank'>www.{$web_data['site_url']}</a><br>
      {$certificate_provider_name}<br>
      {$designation}<br>
      {$datawebname}
    </div>
  </div>
</div>
";

    
    
    $mail->AltBody = $email_data['message'];

    $mail->send();
   $session=session();
           
// ===================== SEND TO ADMIN =====================
$mailAdmin = new PHPMailer(true);
try {
    // SMTP Configuration
    $mailAdmin->isSMTP();
    $mailAdmin->Host = $email_data['host'];
    $mailAdmin->SMTPAuth = true;
    $mailAdmin->Username = $email_data['by_email'];
    $mailAdmin->Password = $email_data['by_password'];
    $mailAdmin->SMTPSecure = 'tls';
    $mailAdmin->Port = 587;

    // Email Content based on donation type
    $donationType = $this->request->getPost('donation_type') ?? 'General Donation';
    $amount = $this->request->getPost('amount') ?? 0;
    $frequency = $this->request->getPost('frequency') ?? 'One-time';
    $paymentMethod = $this->request->getPost('payment_method') ?? 'Online';
    
    // Customize subject based on donation
    $mailAdmin->setFrom($email_data['by_email'], $web_data['web_name']);
    $mailAdmin->addAddress($adminEmail, 'Admin');
    $mailAdmin->isHTML(true);
    $mailAdmin->Subject = "New  Donation Received - {$name}";

    // HTML Template with dynamic content
    $mailAdmin->Body = "
    <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #e0e0e0; border-radius: 8px;'>
        <div style='background: #ff4b2b; padding: 15px; text-align: center; border-radius: 8px 8px 0 0;'>
            <h2 style='color: white; margin: 0;'>New Donation Notification</h2>
        </div>
        
        <div style='padding: 20px; background: #f9f9f9; border-radius: 0 0 8px 8px;'>
            <h3 style='color: #333;'>Donation Details</h3>
            
            <table style='width: 100%; border-collapse: collapse; margin-bottom: 20px;'>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd; width: 30%;'><strong>Donor Name:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$name}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Email:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$email}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Phone:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$mobile}</td>
                </tr>
                
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Amount:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>" . number_format($amount, 2) . "</td>
                </tr>
               
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Payment Method:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>Online</td>
                </tr>
                <tr>
                    <td style='padding: 8px;'><strong>Transaction ID:</strong></td>
                    <td style='padding: 8px;'>{$transactionId}</td>
                </tr>
            </table>
            
            <div style='margin-top: 20px; padding: 15px; background: #e9f7ef; border-radius: 5px;'>
                <p style='margin: 0; color: #28a745;'>
                    <strong>Action Required:</strong> Please acknowledge this donation and send a thank you note to the donor.
                </p>
            </div>
            
            <p style='margin-top: 20px; text-align: center;'>
                <a href='{$downloadurl}' 
                   style='display: inline-block; padding: 10px 20px; background: #ff4b2b; color: white; text-decoration: none; border-radius: 5px;'>
                   View Donation Details
                </a>
            </p>
        </div>
        
        <div style='margin-top: 20px; text-align: center; font-size: 12px; color: #777;'>
            This email was automatically generated by {$web_data['web_name']} donation system.
        </div>
    </div>";

    $mailAdmin->send();
    return redirect()->to('donate_receipt_download/'.$transactionId);
} catch (Exception $e) {
      return redirect()->to('donate_receipt_download/'.$transactionId);
}
} catch (Exception $e) {
      return redirect()->to('donate_receipt_download/'.$transactionId);
}
    
        
    }
    
    public function nodate_now($id =null)
      { 
                 $referralId   = $this->request->getVar('referralId');   
      if(isset($referralId)){
          $id   = $this->request->getVar('referralId');
          $referralId   = $this->request->getVar('referralId');
                      $name    = $this->request->getVar('name');
                    $email    = $this->request->getVar('email');
                    $mobile    = $this->request->getVar('mobile');
                    $address    = $this->request->getVar('address');
      }else{
           $id   = $this->request->getVar('id');
           $name    = $this->request->getVar('name');
                    $email    = $this->request->getVar('email');
                    $mobile    = $this->request->getVar('mobile');
                    $address    = $this->request->getVar('address');
                    $referralId ="direct";
      }
           $amount    = $this->request->getVar('amount');
             $bank_name    = $this->request->getVar('bank_name');
            $DonationPurpose    = $this->request->getPost('DonationPurpose');
              $branch_name    = $this->request->getVar('branch_name');
              $pan_no    = $this->request->getVar('pan_no');
            $order_id ='ORD_'.time().'_'.$id; 
        $session=session(); 
       $userModel = new UserModel();
        $data = $userModel->where('id', $id)->first();

        if($data == !null){
        $session=session(); 
        if($data['user_type']=='user'){
            
            
              $paymentsModel=new Payments_Mode_Models();
          $dataphonepe=$paymentsModel->first(); 
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first();
          
          require 'db_config.php';
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                       
          
if($datapayu['status']=="payu"){
   $key  = getenv('PAYU_KEY');
        $salt =getenv('PAYU_SALT');

        // Required fields (apni data source se lo)
        $txnid      = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        $amount = round($amount, 2); 
        $firstname  = $name ?? 'Buyer';
        $email      = $email ?? 'no@domain.com';
        $productinfo= $productinfo ?? 'Donation';
        $phone      = $mobile ?? '';

        // Build params
        $params = [
            'key'        => $key,
            'txnid'      => $txnid,
            'amount'     => $amount,
            'productinfo'=> $productinfo,
            'firstname'  => $firstname,
            'email'      => $email,
            'udf1' => '', 'udf2' => '', 'udf3' => '', 'udf4' => '', 'udf5' => '',
            
            'phone' => $phone,
            'Salt'=> $salt,
             'surl' => base_url().'payu/Donationresponse',
             'furl' => base_url().'payu/Donationresponse'
        ];

        // Generate correct hash
        $hash = $this->generatePayuRequestHash($params, $salt);

        // Prepare data for auto-post form
        $data = $params;
        $data['hash']   = $hash;
        $data['action'] = $this->payuUrl();
         
 $trans = [
     'transaction_donoate_id' => $txnid,
     'bank_name' => $bank_name,
     'branch_name' => $branch_name,
     'pan_no' => $pan_no,
    
     'payment_status'=>'fail',
     ];
    
  $finalAmount = $amount*100; 
$userModel = new UserModel();
$transid= $userModel->update($id, $trans);
 if($transid){
        return view('user_dashboard/payu_Donation_form', $data);
    }else{
        
        return redirect()->back()->with('msg', 'Server Not Response');
    }
          }  
            
            
            
            
          $paymentsModel=new Payments_Mode_Models();
          $dataPayment=$paymentsModel->first();
         if($dataPayment['status']=="phonepe") {
        // phonepay
$wevname=$dataPayment['name']; 
$webemail=$dataPayment['email']; 
$client_id = $dataPayment['merchantId']; 
$client_secret = $dataPayment['apiKey']; 
$demo_link = $dataPayment['demo_link'];
$init_link = $dataPayment['init_link'];
//$mobile=9999999999;
// amount in INR
$description = $dataPayment['description']; 

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $demo_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 
  'client_id='.$client_id.'&client_version=1&client_secret='.$client_secret.'&grant_type=client_credentials',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$jsonResponse = curl_exec($curl);
$response = json_decode($jsonResponse, true);
$token = $response['access_token'];
 
 $trans = [
     'transaction_donoate_id' => $order_id,
     'bank_name' => $bank_name,
     'branch_name' => $branch_name,
     'pan_no' => $pan_no,
     'amount'=>$amount,
     'DonationPurpose'=>$DonationPurpose,
     'payment_status'=>'fail',
     ];
    
  $finalAmount = $amount*100; 
$userModel = new UserModel();
$transid= $userModel->update($id, $trans);

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $init_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "merchantOrderId": "'.$order_id.'",
    "amount": '.$finalAmount.',
    "expireAfter": 1200,
    "metaInfo": {
        "udf1": "'.$order_id.'",
        "udf2": "additional-information-2",
        "udf3": "additional-information-3",
        "udf4": "additional-information-4",
        "udf5": "additional-information-5"
    },
    "paymentFlow": {
        "type": "PG_CHECKOUT",
        "message": "Payment message used for collect requests",
        "merchantUrls": {
            "redirectUrl": "'.base_url('donote_success_payment').'"
        }
    } 
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$token,
  ),
));

$responseURL = curl_exec($curl);
// echo $responseURL;
// die;
curl_close($curl);
$response = json_decode($responseURL, true);
$tokenurl = $response['redirectUrl'];

// pay end
if($tokenurl){
 $session = session();
$sessdata =[
    'transactionId'=>$order_id,
'token_id'=>$token,
];
$session->set($sessdata);
return redirect()->to($tokenurl);
die;
//end pay
}

else{
    
     $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction Data is Not Correct ");
                    $session->markAsFlashdata("msg");
                     return redirect()->to('admin_dashboard');
}
}
else{
    
  $userModel = new UserModel();
        $data = $userModel->where('id', $id)->first();
       
$trans = [
     'transaction_donoate_id' => $order_id,
     
     ];
    
   
$userModel = new UserModel();
$transid= $userModel->update($id, $trans); 
        if($transid){
            
        $trans = [
     'user_name'=>$name,
     'mobile'=>$mobile,
     'email'=>$email,
     'address'=>$address,
     'transaction_id' => $order_id,
     'DonationPurpose'=>$DonationPurpose,
     'bank_name' => $bank_name,
     'branch_name' => $branch_name,
     'pan_no' => $pan_no,
     'amount'=>$amount,
     'payment_status'=>'fail',
     'referralId'=>$referralId,
     'user_id'=>$referralId,
     ];
     

   
$DonationModel = new Donote_TransactionModel();
$transid= $DonationModel->save($trans);
$donid = $DonationModel->getInsertID();
             $session = session();
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $userModel = new UserModel();
    $user = $userModel->where('id', $id)->first();
    
    if(!$user) {
        return redirect()->to('user_dashboard');
    }

    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    // Create order
    $orderData = [
        'amount'          => $amount * 100,
        'currency'        => 'INR',
        'receipt'         => $order_id,
        'payment_capture' => 1
    ];

    try {
        $razorpayOrder = $api->order->create($orderData);
        $data = [
            'users'    => $user,
            'amount'   => $amount,
            'order_id' => $razorpayOrder->id,
            'dataweb'  => $dataweb,
            'receipt_id' =>$donid,
        ];
        
        $data['users'] = $userModel->where('id', $id)->first();
          $data['amount']= $amount;
      
            return view('user_dashboard/donate-payment-form',$data);
        
    } catch (Exception $e) {
        log_message('error', 'Razorpay Order Creation Error: '.$e->getMessage());
        session()->setFlashdata('error', 'Payment gateway error. Please try again.');
        return redirect()->back();
    }
        }else{
          if($data['user_type']=='admin'){
            
           return redirect()->to('admin_dashboard');
        } 
        
        else{
        
        return view('signin');
        }
        }
            
        }
}

        }else{
           return redirect()->back();  
        }
         
    }
    
     private function generatePayuRequestHash($params, $salt)
{
    $key = $params['key'];
    $txnid = $params['txnid'];
    $amount = $params['amount'];
    $productinfo = $params['productinfo'];
    $firstname = $params['firstname'];
    $email = $params['email'];
    $udf1 = $params['udf1'] ?? '';
    $udf2 = $params['udf2'] ?? '';
    $udf3 = $params['udf3'] ?? '';
    $udf4 = $params['udf4'] ?? '';
    $udf5 = $params['udf5'] ?? '';

    // PayU sequence
    $hashString = $key . '|' . $txnid . '|' . $amount . '|' . $productinfo . '|' .
                  $firstname . '|' . $email . '|' . $udf1 . '|' . $udf2 . '|' .
                  $udf3 . '|' . $udf4 . '|' . $udf5 . '||||||' . $salt;

    // Generate hash (case should be exact)
    return hash('sha512', $hashString);
}



       private function payuUrl()
    {
        return (getenv('PAYU_ENV') === 'production')
            ? 'https://secure.payu.in/_payment'
            : 'https://test.payu.in/_payment';
    }

    public function Donationresponse()
    {
        $posted = $this->request->getPost();
   
        if (! isset($posted['status'], $posted['txnid'], $posted['hash'])) {
            return view('payment_error', ['msg' => 'Invalid response from PayU']);
        }
   
   $userModel = new UserModel();
        $data = $userModel->where('user_type', "admin")->first();
        
           $adminEmail = $data['email'];
            
            $userModel = new UserModel();
        $data = $userModel->where('transaction_donoate_id', $posted['txnid'])->first();
        
        $user_id = $data['id'];
         $id = $data['id'];
          $bank_name = $data['bank_name'];
           $branch_name = $data['branch_name'];
           $pan_no = $data['pan_no'];
            $address = $data['address'];
            $email = $data['email'];
             $mobile = $data['mobile'];
   $amount=$posted['amount'];
               $data=[
                   'user_id'=>$user_id,
                   'referance_id' =>$posted['mihpayid'],
                   'user_name'=>$data['name'],
                   'merchantId'=>$posted['key'],
                   'transaction_id'=> $posted['txnid'],
                   'payment_status'=>$posted['status'],
                   'amount'=>$posted['amount'],
                   'address'=> $address,
                   'pan_no' =>$pan_no,
                   'branch_name' =>$branch_name,
                   'bank_name' =>$bank_name,
                   'email'=>$email,
                   'mobile'=>$mobile,
                   'created_at' =>date('Y-m-d H:i:s'),
                   ];
              
       
                   $trans= new Donote_TransactionModel();
                   $success = $trans->save($data);
                   // sms start
                   if($success==TRUE) {
                       $transactionId = $posted['txnid'];
                                    return  $this->UserDonationSendMail($id);
       
                   }    
        else {
            return view('payment_failure', ['data' => $posted]);
        }
    

    }
    
    private function UserDonationSendMail(){
        
          $userModel = new UserModel();
        $data = $userModel->where('transaction_donoate_id', $posted['txnid'])->first();
        
           
            // end sms
        $trans= new Donote_TransactionModel();
         $data['payments'] = $trans->where('transaction_id', $transactionId)->first();
         
          $data = $trans->where('transaction_id', $transactionId)->first();
          $payementdate= $data['created_at'];
             $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $transactionId)->first();
          
               $session=session();
                    $session->set("msg",'<h1>'."Congratulations".'</h1>'." Payment successfully");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data = $userModel->where('id', $data['user_id'])->first();
             
                $email=$data['email'];
                $name=$data['name'];
                 
                $downloadurl=base_url('donate_receipt_download/'.$posted['txnid']);
              $transactionId=$posted['txnid'] ;
              $payment_date = date('Y-m-d H:i:s');
             //These must be at the top of your script, not inside a function
$dataurl= base_url();

//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                          $payment_dateE = date('d-m-Y h:i A', strtotime($payment_date)); // 04-09-2025 05:45 PM
                            $weblogo = base_url('websiteLogoImages/' . $web_data['web_logo']);
    $amount_data=$amount/100;
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
     $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
  $mail->Subject = 'Donation Receipt for Your Generous Contribution At '.$web_data['web_name'].'';
  
$mail->Body = "
<div style='width:100%; max-width:700px; margin:0 auto;
    border:5px solid transparent;
    border-image:linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice:1;
    background:#f9f9f9;
    border-radius:15px;
    overflow:hidden;
    font-family:Arial, sans-serif;
    color:#000;'>

  <div style=\"
    background-color:#fff;
    padding:40px;
    font-family:Arial, sans-serif;
    color:#000;
  \">

    <!-- Header -->
    <div style='text-align:center; margin-bottom:30px;'>
        <img src='{$weblogo}' style='width:100px; display:block; margin:0 auto;'>
        <p style='font-size:26px; font-weight:bold; margin-top:10px;'> {$datawebname}</p>
    </div>

    <!-- Main Content -->
    <div style='background-color:rgba(255,255,255,0.92);
        padding:30px; border-radius:10px;
        box-shadow:0 0 10px rgba(0,0,0,0.05);'>

      Dear {$name},<br><br>

      On behalf of <b>{$datawebname}</b>, we would like to express our  heartfelt gratitude for your generous donation.  
      Your support enables us to continue our mission of <i>{$web_tag_line}</i>.<br><br>

      We are pleased to confirm that we have received your donation of  
      <span style='font-weight:600; color:#28a745;'>₹{$amount_data} on {$payment_dateE}</span>.  
      Your kindness and generosity will make a significant difference in the lives of those we serve.<br><br>

       As requested, we have attached your donation receipt to this email.  
      Please review the receipt for your records.<br><br>

       <span style='font-weight:600;'>Download Receipt Here:</span>  
      <a href='{$downloadurl}' target='_blank' style='color:#007BFF;'> Click Here to Download</a><br><br>

       If you have any questions or require further information, please do not hesitate to contact us at  
      <a href='mailto:{$webemail_1}'>{$webemail_1}</a> or  {$site_mobile_1}.<br><br>

       Once again, thank you for your generosity and compassion.  
      Your support is invaluable to us, and we are deeply grateful for your contribution.<br><br>

      Best regards,<br>
      <a href='https://www.{$web_data['site_url']}' target='_blank'>www.{$web_data['site_url']}</a><br>
       {$certificate_provider_name}<br>
       {$designation}<br>
      {$datawebname}
    </div>
  </div>
</div>
";

    
    
    $mail->AltBody = $email_data['message'];

    $mail->send();
   $session=session();
           


 // ===================== SEND TO ADMIN =====================
$mailAdmin = new PHPMailer(true);
try {
    // SMTP Configuration
    $mailAdmin->isSMTP();
    $mailAdmin->Host = $email_data['host'];
    $mailAdmin->SMTPAuth = true;
    $mailAdmin->Username = $email_data['by_email'];
    $mailAdmin->Password = $email_data['by_password'];
    $mailAdmin->SMTPSecure = 'tls';
    $mailAdmin->Port = 587;

    // Email Content based on donation type
    $donationType = $this->request->getPost('donation_type') ?? 'General Donation';
    $amount = $this->request->getPost('amount') ?? 0;
    $frequency = $this->request->getPost('frequency') ?? 'One-time';
    $paymentMethod = $this->request->getPost('payment_method') ?? 'Online';
    
    // Customize subject based on donation
    $mailAdmin->setFrom($email_data['by_email'], $datawebname);
    $mailAdmin->addAddress($adminEmail, 'Admin');
    $mailAdmin->isHTML(true);
    $mailAdmin->Subject = "New  Donation Received - {$name}";

    // HTML Template with dynamic content
    $mailAdmin->Body = "
    <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #e0e0e0; border-radius: 8px;'>
        <div style='background: #ff4b2b; padding: 15px; text-align: center; border-radius: 8px 8px 0 0;'>
            <h2 style='color: white; margin: 0;'>New Donation Notification</h2>
        </div>
        
        <div style='padding: 20px; background: #f9f9f9; border-radius: 0 0 8px 8px;'>
            <h3 style='color: #333;'>Donation Details</h3>
            
            <table style='width: 100%; border-collapse: collapse; margin-bottom: 20px;'>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd; width: 30%;'><strong>Donor Name:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$name}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Email:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$email}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Phone:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$mobile}</td>
                </tr>
                
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Amount:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>" . number_format($amount, 2) . "</td>
                </tr>
               
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Payment Method:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>Online</td>
                </tr>
                <tr>
                    <td style='padding: 8px;'><strong>Transaction ID:</strong></td>
                    <td style='padding: 8px;'>{$transactionId}</td>
                </tr>
            </table>
            
            <div style='margin-top: 20px; padding: 15px; background: #e9f7ef; border-radius: 5px;'>
                <p style='margin: 0; color: #28a745;'>
                    <strong>Action Required:</strong> Please acknowledge this donation and send a thank you note to the donor.
                </p>
            </div>
            
            <p style='margin-top: 20px; text-align: center;'>
                <a href='{$web_data['site_url']}/donations/view/{$transactionId}' 
                   style='display: inline-block; padding: 10px 20px; background: #ff4b2b; color: white; text-decoration: none; border-radius: 5px;'>
                   View Donation Details
                </a>
            </p>
        </div>
        
        <div style='margin-top: 20px; text-align: center; font-size: 12px; color: #777;'>
            This email was automatically generated by {$web_data['web_name']} donation system.
        </div>
    </div>";

    $mailAdmin->send();
    return redirect()->to('donate_receipt_download/'.$transactionId);
} catch (Exception $e) {
      return redirect()->to('donate_receipt_download/'.$transactionId);
}          
           
}catch (Exception $e) {
      return redirect()->to('donate_receipt_download/'.$transactionId);
}    
        
    }
         
   public function campaigndonatepaymentProcess()
         {
            // Initialize session and get input
    $session = session();
    $input = $this->request->getPost();
  
     $id= $input['user_id'];
               $user_id= $input['user_id'];
    // Validate payment ID
    if (empty($input['razorpay_payment_id'])) {
        $session->setFlashdata('error', 'Payment ID missing');
        return redirect()->back();
    }

    // Load database configuration
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    // Initialize Razorpay API
    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    try {
        // Verify payment signature
        $attributes = [
            'razorpay_order_id' => $input['razorpay_order_id'],
            'razorpay_payment_id' => $input['razorpay_payment_id'],
            'razorpay_signature' => $input['razorpay_signature']
        ];
        $api->utility->verifyPaymentSignature($attributes);

        // Process payment
        $payment = $api->payment->fetch($input['razorpay_payment_id']);
        
        // Capture payment if authorized
        if ($payment->status == 'authorized') {
            $payment->capture(['amount' => $payment->amount]);
        }

        // Process successful payment
        if (in_array(strtolower($payment->status), ['captured', 'authorized'])) {
             $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
                
            
               $donatetrnx = new DonateCampaignModel();
        $data = $donatetrnx->where('id', $id)->first();
        
        
        
        
          $campaign_id =$data['campaign_id'];
          
          $campignname = new CampaignModel();
        $cmpdata = $campignname->where('id', $campaign_id)->first();
          
        $campignnm=$cmpdata['title'];
        $name =$data['name'];
         $email=$data['email'];
          $mobile=$data['mobile'];
          $address=$data['address'];
        $branch_name =$data['branch_name'];
         $branch_name =$data['branch_name'];
         $transactionId = $data['transaction_id'];
               $trnx = new DonateCampaignModel();
                $data =[
                     "amount" => $payment->amount/100,
                     "merchantId" => $payment->id,
                    "pay_at"=> date('Y-m-d H:i:s'),
                    "payment_status" =>$payment->status,
                 ];
                 
                 $donatetrnx = new DonateCampaignModel();
                  $trans_data = $donatetrnx->update($id,$data);
             
             
            $amount_data=$payment->amount/100;
            $payment_date = date('Y-m-d H:i:s');
            
           

     if($trans_data == TRUE){
  
              
return $this->CampaignDonationEmail($id);
    
     }
     else{
      
       
        $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Member Status Not Change ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->to('user_dashboard');
     }
    
                }else{
                    
                     $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Payment Faild ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->to('user_dashboard');
                }
                 
              

        }catch (Exception $e) {
            
     $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Payment Faild ! Try Again! ");
        $session->markAsFlashdata("msg");
 
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->back();
   
         }
         }
    
    
    
    
    private function CampaignDonationEmail($id){
         $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
        $donatetrnx = new DonateCampaignModel();
        $data = $donatetrnx->where('id', $id)->first();
        
        
        
        
          $campaign_id =$data['campaign_id'];
          
          $campignname = new CampaignModel();
        $cmpdata = $campignname->where('id', $campaign_id)->first();
          
        $campignnm=$cmpdata['title'];
        $name =$data['name'];
         $email=$data['email'];
          $mobile=$data['mobile'];
          $address=$data['address'];
        $branch_name =$data['branch_name'];
         $branch_name =$data['branch_name'];
         $transactionId = $data['transaction_id'];
         $amount_data =$data['amount'];
       $payment_date = date('D-m-Y'); 
        //These must be at the top of your script, not inside a function
$dataurl= base_url();
 $downloadurl=base_url('campaign_donate_receipt_download/'.$id);
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                          $weblogo = base_url('websiteLogoImages/'.$web_data['web_logo']);
                          $payment_dateE = date('d-m-Y h:i A', strtotime($payment_date)); // 04-09-2025 05:45 PM
    
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
    $mail->Host       = $email_data['host'];                       
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Donation Receipt for Your Generous Contribution';
    
$mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark container -->
  <div style=\"
    background-image: url({$weblogo});
    background-repeat: no-repeat;
    background-position: center 60%;
    background-size: 40%;
    background-color: #ffffff;
    border-radius: 15px;
    \">

    <!-- Content box -->
    <div style='
      background-color: rgba(255, 255, 255, 0.95);
      padding: 30px;
      border-radius: 10px;
      max-width: 650px;
      margin: 0 auto;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      '>

      <!-- Logo and Heading -->
      <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;' alt='Logo'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
      </div>

      <!-- Message Body -->
      <div style='font-size: 16px; line-height: 1.7; color: #333;'>
         Dear {$name},<br><br>

         On behalf of <b>{$datawebname}</b>, we sincerely thank you for your kind donation towards the campaign  
        <span style='color:#ff4b2b; font-weight:600;'>{$campignnm}</span>.<br><br>

         Your contribution strengthens our mission to serve communities with compassion, extend help to those in need, and create a lasting impact that transforms lives for a better tomorrow.<br><br>

         <strong>Donation Details:</strong><br>
         Amount Donated: <span style='font-weight:600;'>₹{$amount_data}</span><br>
        ️ Date: <span style='font-weight:600;'>{$payment_dateE}</span><br><br>

         As requested, we have attached your donation receipt to this email. Please keep it safe for your records.<br><br>

         <span style='font-weight:600;'>Download Your Receipt:</span>  
        <a href='{$downloadurl}' target='_blank' style='color:#007BFF; text-decoration:none;'> Click Here</a><br><br>

         If you have any questions or need more information, feel free to reach out to us at  
        <a href='mailto:{$webemail_1}' style='color:#ff4b2b;'> {$webemail_1}</a> or call us at {$site_mobile_1}.<br><br>

         Once again, thank you for your generosity and compassion.  
        Your contribution makes a real difference, and we are deeply grateful to have you with us on this journey.<br><br>

        Warm regards,<br>
        <a href='https://www.{$web_data['site_url']}' target='_blank' style='color:#ff416c;'>www.{$web_data['site_url']}</a><br>
        {$certificate_provider_name}<br>
        {$designation}<br>
        <strong>{$datawebname}</strong>
      </div>

    </div>
  </div>
</div>";

    
    
    $mail->AltBody = $email_data['message'];

    $mail->send();



 // ===================== SEND TO ADMIN =====================
$mailAdmin = new PHPMailer(true);
try {
    // SMTP Configuration
    $mailAdmin->isSMTP();
    $mailAdmin->Host = $email_data['host'];
    $mailAdmin->SMTPAuth = true;
    $mailAdmin->Username = $email_data['by_email'];
    $mailAdmin->Password = $email_data['by_password'];
    $mailAdmin->SMTPSecure = 'tls';
    $mailAdmin->Port = 587;

    // Email Content based on donation type
    $donationType = $this->request->getPost('donation_type') ?? 'General Donation';
    $amount = $this->request->getPost('amount') ?? 0;
    $frequency = $this->request->getPost('frequency') ?? 'One-time';
    $paymentMethod = $this->request->getPost('payment_method') ?? 'Online';
    
    // Customize subject based on donation
    $mailAdmin->setFrom($email_data['by_email'], $web_data['web_name']);
    $mailAdmin->addAddress($adminEmail, 'Admin');
    $mailAdmin->isHTML(true);
    $mailAdmin->Subject = "New  Donation Received - {$name}";

    // HTML Template with dynamic content
    $mailAdmin->Body = "
    <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #e0e0e0; border-radius: 8px;'>
        <div style='background: #ff4b2b; padding: 15px; text-align: center; border-radius: 8px 8px 0 0;'>
            <h2 style='color: white; margin: 0;'>New Donation Notification</h2>
        </div>
        
        <div style='padding: 20px; background: #f9f9f9; border-radius: 0 0 8px 8px;'>
            <h3 style='color: #333;'>Donation Details</h3>
            
            <table style='width: 100%; border-collapse: collapse; margin-bottom: 20px;'>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd; width: 30%;'><strong>Donor Name:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$name}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Email:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$email}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Phone:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$mobile}</td>
                </tr>
                
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Amount:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>" . number_format($amount, 2) . "</td>
                </tr>
               
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Payment Method:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>Online</td>
                </tr>
                <tr>
                    <td style='padding: 8px;'><strong>Transaction ID:</strong></td>
                    <td style='padding: 8px;'>{$transactionId}</td>
                </tr>
            </table>
            
            <div style='margin-top: 20px; padding: 15px; background: #e9f7ef; border-radius: 5px;'>
                <p style='margin: 0; color: #28a745;'>
                    <strong>Action Required:</strong> Please acknowledge this donation and send a thank you note to the donor.
                </p>
            </div>
            
            <p style='margin-top: 20px; text-align: center;'>
                <a href='$downloadurl' 
                   style='display: inline-block; padding: 10px 20px; background: #ff4b2b; color: white; text-decoration: none; border-radius: 5px;'>
                   View Donation Details
                </a>
            </p>
        </div>
        
        <div style='margin-top: 20px; text-align: center; font-size: 12px; color: #777;'>
            This email was automatically generated by {$web_data['web_name']} donation system.
        </div>
    </div>";

    $mailAdmin->send();
   return redirect()->to('campaign_donate_receipt_download/'.$id);
} catch (Exception $e) {
    
      return redirect()->to('campaign_donate_receipt_download/'.$id);
}
   
  
     }
     catch (Exception $e) {
       
          return redirect()->to('campaign_donate_receipt_download/'.$id);
    }
    
        
        
        
    }
    
    
    
    
      
   public function vistordonatepaymentprocess()
         {
             
            // Initialize session and get input
    $session = session();
    $input = $this->request->getPost();
   
     $id= $input['user_id'];
               $user_id= $input['user_id'];
    // Validate payment ID
    if (empty($input['razorpay_payment_id'])) {
        $session->setFlashdata('error', 'Payment ID missing');
        return redirect()->back();
    }

    // Load database configuration
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    // Initialize Razorpay API
    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    try {
        // Verify payment signature
        $attributes = [
            'razorpay_order_id' => $input['razorpay_order_id'],
            'razorpay_payment_id' => $input['razorpay_payment_id'],
            'razorpay_signature' => $input['razorpay_signature']
        ];
        $api->utility->verifyPaymentSignature($attributes);

        // Process payment
        $payment = $api->payment->fetch($input['razorpay_payment_id']);
        
        // Capture payment if authorized
        if ($payment->status == 'authorized') {
            $payment->capture(['amount' => $payment->amount]);
        }

        // Process successful payment
        if (in_array(strtolower($payment->status), ['captured', 'authorized'])) {
             $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
                
            
               $donatetrnx = new Donote_TransactionModel();
        $data = $donatetrnx->where('id', $id)->first();
         $id =$data['id'];
        $name =$data['user_name'];
         $email=$data['email'];
          $mobile=$data['mobile'];
          $address=$data['address'];
        $branch_name =$data['branch_name'];
         $branch_name =$data['branch_name'];
         $transactionId = $data['transaction_id'];
               $trnx = new Donote_TransactionModel();
                $data =[
                     "amount" => $payment->amount/100,
                     "currency" => $payment->currency,
                     "merchantId" => $payment->id,
                    "transaction_id"=>$payment->id,
                    
                    "created_at"=> date('Y-m-d H:i:s'),
                    "payment_status" =>$payment->status,
                 ];
                 
                 $donatetrnx = new Donote_TransactionModel();
                  $trans_data = $donatetrnx->update($id,$data);
             
             
            $amount_data=$payment->amount/100;
            $payment_date = date('Y-m-d H:i:s');
           

     if($trans_data == TRUE){
  return $this->VisitorDonationSendMail($id);     
    
     }
     else{
      
       
        $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Member Status Not Change ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->to('user_dashboard');
     }
    
                }else{
                    
                     $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Payment Faild ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->to('user_dashboard');
                }
                 
              

        }catch (Exception $e) {
     $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Payment Faild ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->back();
   
         }
         }
    
    public function Referraluserdonatepaymentprocess(){
      
        $session  = session();
             //Input items of form
              $input = $this->request->getVar();
            
           $id = $input['user_id'];
            $user_id = $input['user_id'];   
            	 if (empty($input['razorpay_payment_id'])) {
        $session->setFlashdata('error', 'Payment ID missing');
        return redirect()->back();
    }
             $session = session();
         require 'db_config.php';
                        $queryli = "SELECT * FROM `website_razor_transaction`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                //get API Configuration
             $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);
             //Fetch payment information by razorpay_payment_id
            
      

        // Process payment
        $payment = $api->payment->fetch($input['razorpay_payment_id']);
        
      /*  // Capture payment if authorized
        if ($payment->status == 'authorized') {
            $payment->capture(['amount' => $payment->amount]);
        }
      */

        // Process successful payment
        if (in_array(strtolower($payment->status), ['captured', 'authorized'])) {
    
                 // save transaction details
                
                 $trnx = new Donote_TransactionModel();
              
                if($payment->status =="PAYMENT_SUCCESS" or $payment->status =="captured"){
           
                $trnx = new Donote_TransactionModel();
        $data = $trnx->where('id', $id)->first();
        $name =$data['user_name'];
         $email=$data['email'];
          $mobile=$data['mobile'];
          $address=$data['address'];
        $branch_name =$data['branch_name'];
         $branch_name =$data['branch_name'];
          $transactionId =$data['transaction_id'];
         
               
               
                $trans_data= [
                     "amount" => $payment->amount/100,
                     "currency" => $payment->currency,
                     "merchantId" => $payment->id,
                    "payment_status" =>$payment->status,
                 ];
                $result =  $trnx->update($id, $trans_data);
              
             $amount = $payment->amount/100;
             $dataid = $id;
            $amount_data=$payment->amount/100;
            $payment_date = date('Y-m-d H:i:s');
       $payment_dateE = date('d-m-Y h:i A', strtotime($payment_date)); 

 $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
     if($result){
  
   return $this->ReferralDonationSendMail($transactionId);
 
     }
     else{
      
       
        $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Member Status Not Change ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->to('user_dashboard');
     }
    
                }else{
                    $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Payment Faild ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->to('user_dashboard'); 
                }
                 
             }
       
        
        
    }
    
    
    
    public function referral_donate_receipt_download($trans_id){
      
        $trans= new Donote_TransactionModel();
         $data = $trans->where('id', $trans_id)->first();
        
        if($data) {
            
        $trans= new Donote_TransactionModel();
         $data = $trans->where('id', $trans_id)->first();
         
        
            
              $word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['created_at'];
$id = $data['user_id'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ]; 
          $userModel = new UserModel();
      
      
         $trans= new Donote_TransactionModel();
         $data['payments'] = $trans->where('id', $trans_id)->first();
         
          return view('visitor_payment_donote_receipt',$data);   
        
        
    }
    }
   public function userdonatepaymentprocess()
         {
             $session  = session();
             //Input items of form
              $input = $this->request->getVar();
             
           $id = $input['user_id'];
            $user_id = $input['user_id'];   
            	 if (empty($input['razorpay_payment_id'])) {
        $session->setFlashdata('error', 'Payment ID missing');
        return redirect()->back();
    }
             $session = session();
         require 'db_config.php';
                        $queryli = "SELECT * FROM `website_razor_transaction`";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                //get API Configuration
             $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);
             //Fetch payment information by razorpay_payment_id
            
      

        // Process payment
        $payment = $api->payment->fetch($input['razorpay_payment_id']);
        
      /*  // Capture payment if authorized
        if ($payment->status == 'authorized') {
            $payment->capture(['amount' => $payment->amount]);
        }
      */

        // Process successful payment
        if (in_array(strtolower($payment->status), ['captured', 'authorized'])) {
    
                 // save transaction details
                
                 $trnx = new Donote_TransactionModel();
              
                if($payment->status =="PAYMENT_SUCCESS" or $payment->status =="captured"){
            
              $userModel = new UserModel();
        $data = $userModel->where('id', $id)->first();
        $name =$data['name'];
         $email=$data['email'];
          $mobile=$data['mobile'];
          $address=$data['address'];
        $branch_name =$data['branch_name'];
         $branch_name =$data['branch_name'];
          $transactionId =$data['transaction_donoate_id'];
         
               $trnx = new Donote_TransactionModel();
                $Dodata = $trnx->where('transaction_id', $transactionId)->first();
               $amount = $payment->amount/100;
                $trans_data= [
                     "amount" => $payment->amount/100,
                     "currency" => $payment->currency,
                     "merchantId" => $payment->id,
                    "transaction_id"=>$payment->id,
                     "status" => $payment->status,
                     "user_name" => $name,
                     "address" =>$address,
                    
                   
                    
                    "payment_status" =>$payment->status,
                 ];
                $result =  $trnx->update($id, $trans_data);
              
             
             
            $amount_data=$payment->amount/100;
            $payment_date = date('Y-m-d H:i:s');
            
 $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();

        $adminEmail = $adminData['email'];
     if($result== TRUE){
  
              
//These must be at the top of your script, not inside a function
$dataurl= base_url();
 $downloadurl=base_url('donate_receipt_download/'.$input['razorpay_payment_id']);
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                           $site_url= $web_data['site_url'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                          $payment_dateE = date('d-m-Y h:i A', strtotime($payment_date)); 
            $weblogo = base_url('websiteLogoImages/' . $web_data['web_logo']);
    
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
      $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Donation Receipt for Your Generous Contribution';
    
    $mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto;
    border: 5px solid transparent;
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b);
    border-image-slice: 1;
    background: #f9f9f9;
    border-radius: 15px;
    overflow: hidden;
    font-family: Arial, sans-serif;
    color: #000;'>

  <!-- Background watermark -->
  <div style=\"
    background-image: url({$weblogo});
    background-repeat: no-repeat;
    background-position: center;
    background-size: 280px 280px;
    background-color: #ffffff;
    padding: 40px;
    font-family: Arial, sans-serif;
    color: #000;
  \">

    <!-- Logo and Title -->
    <div style='text-align: center; margin-bottom: 30px;'>
        <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
        <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
    </div>

    <!-- Main Content Block -->
    <div style='
      background-color: rgba(255,255,255,0.92);
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    '>

      Dear {$name},<br><br>

      On behalf of <b>{$datawebname}</b>, we would like to express our heartfelt gratitude for your generous donation.  
      Your support enables us to continue our mission of <i>{$web_tag_line}</i>.<br><br>

      We are pleased to confirm that we have received your donation of  
      <span style='font-weight:600;'>₹{$amount_data} on {$payment_dateE}</span>.  
      Your kindness and generosity will make a significant difference in the lives of those we serve.<br><br>

      As requested, we have attached your donation receipt to this email.  
      Please review the receipt for your records.<br><br>

      <span style='font-weight:600;'>Download Receipt Here:</span>  
      <a href='{$downloadurl}' target='_blank' style='color:#007BFF;'>Click Here to Download</a><br><br>

      If you have any questions or require further information, please do not hesitate to contact us at  
      <a href='mailto:{$webemail_1}'>{$webemail_1}</a> or call us at {$site_mobile_1}.<br><br>

      Once again, thank you for your generosity and compassion.  
      Your support is invaluable to us, and we are deeply grateful for your contribution.<br><br>

      Best regards,<br>
      <a href='https://www.{$web_data['site_url']}' target='_blank'>www.{$web_data['site_url']}</a><br>
      {$certificate_provider_name}<br>
      {$designation}<br>
      {$datawebname}
    </div>
  </div>
</div>
";

    
    
    $mail->AltBody = $email_data['message'];

    $mail->send();

// ===================== SEND TO ADMIN =====================
$mailAdmin = new PHPMailer(true);
try {
    // SMTP Configuration
    $mailAdmin->isSMTP();
    $mailAdmin->Host = $email_data['host'];
    $mailAdmin->SMTPAuth = true;
    $mailAdmin->Username = $email_data['by_email'];
    $mailAdmin->Password = $email_data['by_password'];
    $mailAdmin->SMTPSecure = 'tls';
    $mailAdmin->Port = 587;

    // Email Content based on donation type
    $donationType = $this->request->getPost('donation_type') ?? 'General Donation';
   
    $frequency = $this->request->getPost('frequency') ?? 'One-time';
    $paymentMethod = $this->request->getPost('payment_method') ?? 'Online';
    
    // Customize subject based on donation
    $mailAdmin->setFrom($email_data['by_email'], $web_data['web_name']);
    $mailAdmin->addAddress($adminEmail, 'Admin');
    $mailAdmin->isHTML(true);
    $mailAdmin->Subject = "New {$donationType} Donation Received - {$name}";

    // HTML Template with dynamic content
    $mailAdmin->Body = "
    <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #e0e0e0; border-radius: 8px;'>
        <div style='background: #ff4b2b; padding: 15px; text-align: center; border-radius: 8px 8px 0 0;'>
            <h2 style='color: white; margin: 0;'>New Donation Notification</h2>
        </div>
        
        <div style='padding: 20px; background: #f9f9f9; border-radius: 0 0 8px 8px;'>
            <h3 style='color: #333;'>Donation Details</h3>
            
            <table style='width: 100%; border-collapse: collapse; margin-bottom: 20px;'>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd; width: 30%;'><strong>Donor Name:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$name}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Email:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$email}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Phone:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$mobile}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Donation Type:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>Online</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Amount:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>" . number_format($amount, 2) . " </td>
                </tr>
               
               
            </table>
            
            <div style='margin-top: 20px; padding: 15px; background: #e9f7ef; border-radius: 5px;'>
                <p style='margin: 0; color: #28a745;'>
                    <strong>Action Required:</strong> Please acknowledge this donation and send a thank you note to the donor.
                </p>
            </div>
            
            <p style='margin-top: 20px; text-align: center;'>
                <a href='$downloadurl' 
                   style='display: inline-block; padding: 10px 20px; background: #ff4b2b; color: white; text-decoration: none; border-radius: 5px;'>
                   View Donation Details
                </a>
            </p>
        </div>
        
        <div style='margin-top: 20px; text-align: center; font-size: 12px; color: #777;'>
            This email was automatically generated by {$web_data['web_name']} donation system.
        </div>
    </div>";

    $mailAdmin->send();
    return redirect()->to('donate_receipt_download/'.$input['razorpay_payment_id']);
} catch (Exception $e) {
    return redirect()->to('donate_receipt_download/'.$input['razorpay_payment_id']);
}
 
     }
     catch (Exception $e) {
           
        $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Member Email  Not Send ! ");
        $session->markAsFlashdata("msg");
  
  return redirect()->to('donate_receipt_download/'.$input['razorpay_payment_id']);
    }
     }
     else{
      
       
        $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Member Status Not Change ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->to('user_dashboard');
     }
    
                }else{
                    $session=session();
        $session->set("msg",'<h1>'."OPPs".'</h1>'."Payment Faild ! Try Again! ");
        $session->markAsFlashdata("msg");
  
// return view('user_dashboard/membership_payment_receipt',$data);]
return redirect()->to('user_dashboard'); 
                }
                 
             }

        }
    
    public function referrral_donote_success_payment(){
      
      
      $response=  $this->request->getPost();
           $response=  $this->request->getVar();
        $session = session();
$transactionId = $session->get('transactionId');
$tokenId = $session->get('token_id');
 $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();
$curl = curl_init();
 $paymentsModel=new Payments_Mode_Models();
          $dataPayment=$paymentsModel->first();           
   $paymentMode = $dataPayment['payment_mode'];
if($paymentMode=="test"){
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
// CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
}
else{
    
    curl_setopt_array($curl, array(
//   CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
 CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
    
}

$response = curl_exec($curl);

curl_close($curl);
$responseUrl = json_decode($response, true);
      
                   
             $trans_id = $transactionId;
              $amount = $responseUrl['amount'];
              
               $trans_status = $responseUrl['state'];
                if($trans_status =="COMPLETED" or $trans_status =="captured"){
               $staff_id = $transactionId;
               $cust_id = $this->request->getPost('cust_id');
               $providerReferenceId = $this->request->getPost('providerReferenceId');
               $merchantId = $this->request->getPost('merchantId');
               $cust_mobile = $this->request->getPost('cust_mobile');
                $userModel = new UserModel();
                
                 $userModel = new Donote_TransactionModel();
        $data = $userModel->where('transaction_id', $transactionId)->first();
        
        $id = $data['id'];
          $bank_name = $data['bank_name'];
           $branch_name = $data['branch_name'];
           $pan_no = $data['pan_no'];
            $address = $data['address'];
            $email = $data['email'];
             $mobile = $data['mobile'];
  
               $data=[
                  
                   'referance_id' =>$providerReferenceId,
               
                   'merchantId'=>$merchantId,
                  
                   'payment_status'=>$trans_status,
                   'amount'=>$amount/100,
                   
                   ];
              
       
                   $trans= new Donote_TransactionModel();
                   $success = $trans->update($id, $data);
                   // sms start
                   if($success==TRUE) {
            
   
             //These must be at the top of your script, not inside a function
 return $this->ReferralDonationSendMail($transactionId);       
                   
                              
    } 
   
         
         
         else {
             
             $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data['users'] = $userModel->where('id', $data['id'])->first();
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
             ];
              
                  $session=session();
                $session->set($sess_data);
                 
         return redirect()->to('user_dashboard');
             
         }
            
                }else{
                    $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data['users'] = $userModel->where('id', $data['id'])->first();
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
             ];
              
                  $session=session();
                $session->set($sess_data);
                 
         return redirect()->to('user_dashboard');
                }
      
        
        
    }
     public function donote_success_payment(){
        
       $response=  $this->request->getPost();
           $response=  $this->request->getVar();
        $session = session();
$transactionId = $session->get('transactionId');
$tokenId = $session->get('token_id');
 $adminModel = new UserModel();
        $adminData = $adminModel->where('user_type', "admin")->first();
$curl = curl_init();
 $paymentsModel=new Payments_Mode_Models();
          $dataPayment=$paymentsModel->first();           
   $paymentMode = $dataPayment['payment_mode'];
if($paymentMode=="test"){
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
// CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
}
else{
    
    curl_setopt_array($curl, array(
//   CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
 CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
    
}

$response = curl_exec($curl);

curl_close($curl);
$responseUrl = json_decode($response, true);
      
                   
             $trans_id = $transactionId;
              $amount = $responseUrl['amount'];
              
               $trans_status = $responseUrl['state'];
                if($trans_status =="COMPLETED" or $trans_status =="captured"){
               $staff_id = $transactionId;
               $cust_id = $this->request->getPost('cust_id');
               $providerReferenceId = $this->request->getPost('providerReferenceId');
               $merchantId = $this->request->getPost('merchantId');
               $cust_mobile = $this->request->getPost('cust_mobile');
                $userModel = new UserModel();
                
                 $userModel = new UserModel();
        $data = $userModel->where('transaction_donoate_id', $transactionId)->first();
        
        $user_id = $data['id'];
          $bank_name = $data['bank_name'];
           $branch_name = $data['branch_name'];
           $pan_no = $data['pan_no'];
            $address = $data['address'];
            $email = $data['email'];
             $mobile = $data['mobile'];
  
               $data=[
                   'user_id'=>$user_id,
                   'referance_id' =>$providerReferenceId,
                   'user_name'=>$data['name'],
                   'merchantId'=>$merchantId,
                   'transaction_id'=> $transactionId,
                   'payment_status'=>$trans_status,
                   'amount'=>$amount/100,
                   'address'=> $address,
                   'pan_no' =>$pan_no,
                   'branch_name' =>$branch_name,
                   'bank_name' =>$bank_name,
                   'email'=>$email,
                   'mobile'=>$mobile,
                   'created_at' =>date('Y-m-d H:i:s'),
                   ];
              
       
                   $trans= new Donote_TransactionModel();
                   $success = $trans->save($data);
                   // sms start
                   if($success==TRUE) {
            
            $userModel = new UserModel();
        $data = $userModel->where('transaction_donoate_id', $transactionId)->first();
        
           
            // end sms
        $trans= new Donote_TransactionModel();
         $data['payments'] = $trans->where('transaction_id', $transactionId)->first();
         
          $data = $trans->where('transaction_id', $transactionId)->first();
          $payementdate= $data['created_at'];
             $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $data['user_id'])->first();
          
               $session=session();
                    $session->set("msg",'<h1>'."Congratulations".'</h1>'." Payment successfully");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data = $userModel->where('id', $data['user_id'])->first();
             
                $email=$data['email'];
                $name=$data['name'];
                 
                $downloadurl=base_url('donate_receipt_download/'.$transactionId);
              
             //These must be at the top of your script, not inside a function
 return $this->ReferralDonationSendMail($transactionId);       
                   
                              
    } 
   
         
         
         else {
             
             $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data['users'] = $userModel->where('id', $data['id'])->first();
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
             ];
              
                  $session=session();
                $session->set($sess_data);
                 
         return redirect()->to('user_dashboard');
             
         }
                }
        
    }
     public function numberToWord($num = '')
	{
		$num    = (string) ((int) $num);

		if ((int) ($num) && ctype_digit($num)) {
			$words  = array();

			$num    = str_replace(array(',', ' '), '', trim($num));

			$list1  = array(
				'', 'one', 'two', 'three', 'four', 'five', 'six', 'seven',
				'eight', 'nine', 'ten', 'eleven', 'twelve', 'thirteen', 'fourteen',
				'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
			);

			$list2  = array(
				'', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty',
				'seventy', 'eighty', 'ninety', 'hundred'
			);

			$list3  = array(
				'', 'thousand', 'million', 'billion', 'trillion',
				'quadrillion', 'quintillion', 'sextillion', 'septillion',
				'octillion', 'nonillion', 'decillion', 'undecillion',
				'duodecillion', 'tredecillion', 'quattuordecillion',
				'quindecillion', 'sexdecillion', 'septendecillion',
				'octodecillion', 'novemdecillion', 'vigintillion'
			);

			$num_length = strlen($num);
			$levels = (int) (($num_length + 2) / 3);
			$max_length = $levels * 3;
			$num    = substr('00' . $num, -$max_length);
			$num_levels = str_split($num, 3);

			foreach ($num_levels as $num_part) {
				$levels--;
				$hundreds   = (int) ($num_part / 100);
				$hundreds   = ($hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ($hundreds == 1 ? '' : 's') . ' ' : '');
				$tens       = (int) ($num_part % 100);
				$singles    = '';

				if ($tens < 20) {
					$tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
				} else {
					$tens = (int) ($tens / 10);
					$tens = ' ' . $list2[$tens] . ' ';
					$singles = (int) ($num_part % 10);
					$singles = ' ' . $list1[$singles] . ' ';
				}
				$words[] = $hundreds . $tens . $singles . (($levels && (int) ($num_part)) ? ' ' . $list3[$levels] . ' ' : '');
			}
			$commas = count($words);
			if ($commas > 1) {
				$commas = $commas - 1;
			}

			$words  = implode(', ', $words);

			$words  = trim(str_replace(' ,', ',', ucwords($words)), ', ');
			if ($commas) {
				$words  = str_replace(',', ' and', $words);
			}

			return $words;
		} else if (!((int) $num)) {
			return 'Zero';
		}
		return '';
	}
    
    public function campaign_donate_receipt_download($trans_id){
        $session = session();
        $trans= new DonateCampaignModel();
       $data = $trans->where('transaction_id', $trans_id)
              ->orWhere('id', $trans_id)
              ->first();

        
        if($data) {
            
        $trans= new DonateCampaignModel();
         $data =  $trans->where('transaction_id', $trans_id)
              ->orWhere('id', $trans_id)
              ->first();
         
        
            
              $word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['created_at'];
$id = $data['campaign_id'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ]; 
          $userModel = new DonationProjectModel();
      
             $data['users'] = $userModel->where('id', $id)->first();
               $trans= new DonateCampaignModel();
      $CampModel = new CampaignModel();
     $data['campaign'] = $CampModel->where('id', $id)->first();
         $trans= new DonateCampaignModel();
         $data['payments'] =  $trans->where('transaction_id', $trans_id)
              ->orWhere('id', $trans_id)
              ->first();
       
          return view('Front/campaign_donate_receipt_download',$data);   
        
    }else{
        
        return redirect()->back();
        
    }
    }
    
    
    public function donate_receipt_download($trans_id){
      
        $trans= new Donote_TransactionModel();
         $data = $trans->where('transaction_id', $trans_id)->first();
        
        if($data) {
            
        $trans= new Donote_TransactionModel();
         $data = $trans->where('transaction_id', $trans_id)->first();
         
        
            
              $word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['created_at'];
$id = $data['user_id'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ]; 
          $userModel = new UserModel();
      
             $data['users'] = $userModel->where('id', $id)->first();
               $trans= new TransactionModel();
      
         $trans= new Donote_TransactionModel();
         $data['payments'] = $trans->where('transaction_id', $trans_id)->first();
         
          return view('visitor_payment_donote_receipt',$data);
         } 
         else{
            
             $trans= new TransactionModel();
         $data = $trans->where('trans_id', $trans_id)->first();
         
         if($data['trans_id'] !=NULL)
         {
         $id=$data['user_id'];
          // Load the custom helper
       $word = $this->numberToWord( $data['amount']);
		
                // Assuming you have a date string
$dateString = $data['created_at'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datarecipt']=['formattedDate'=>$formattedDate,
                                  'formatteword'=>$word
                                ];  
             $userModel = new UserModel();
      
             $data['users'] = $userModel->where('id', $id)->first();
               $trans= new TransactionModel();
         $data['payments'] = $trans->where('user_id', $id)->first();
           
          return view('user_dashboard/user_payment_donote_receipt',$data); 
             
         }
        
         
        
        else{
            
             $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Not Donation Any One ");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data['users'] = $userModel->where('id', $session->id)->first();
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
             ];
              
                  $session=session();
                $session->set($sess_data);
                 
         return redirect()->to('user_dashboard');
        }
         }
        
    }
    public function donation_visitor_form(){
        
      return view('donation_visitor_form');   
        
    }
   public function app_download(){
    $this->response->setHeader('Access-Control-Allow-Origin', '*');
    
    return view('App/app_download');   
}
   public function donoate_visitor(){
        
    $data=    $this->request->getPost();
     
       
        $name= $this->request->getVar('name');
         $email= $this->request->getVar('email');
        $mobile= $this->request->getVar('mobile');
        $amount=$this->request->getVar('amount');
         $address=$this->request->getVar('address');
        $DonationPurpose=$this->request->getPost('DonationPurpose');
          $bank_name=$this->request->getPost('bank_name');
         $branch_name=$this->request->getPost('branch_name');
          $pan_no =$this->request->getPost('pan_no');
        
        
        
          require 'db_config.php';
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                
            
            $paymentsModel=new Payments_Mode_Models();
          $dataphonepe=$paymentsModel->first(); 
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first();
          
          require 'db_config.php';
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                       
          
if($datapayu['status']=="payu"){
   $key  = getenv('PAYU_KEY');
        $salt =getenv('PAYU_SALT');

        // Required fields (apni data source se lo)
        $txnid      = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        $amountq = round($amount, 2); 
        $firstname  = $name ?? 'Buyer';
        $email      = $email ?? 'no@domain.com';
        $productinfo= $productinfo ?? 'Visitor Donation';
        $phone      = $mobile ?? '1234567890';

        // Build params
        $params = [
            'key'        => $key,
            'txnid'      => $txnid,
            'amount'     => $amountq,
            'productinfo'=> $productinfo,
            'firstname'  => $firstname,
            'email'      => $email,
            'udf1' => '', 'udf2' => '', 'udf3' => '', 'udf4' => '', 'udf5' => '',
            
            'phone' => $phone,
            'Salt'=> $salt,
            'surl'=> base_url('payu/VisitorDonationResponse'),
             'furl'=> base_url('payu/VisitorDonationResponse'),
        ];

        // Generate correct hash
        $hash = $this->generatePayuRequestHash($params, $salt);

        // Prepare data for auto-post form
        $data = $params;
        $data['hash']   = $hash;
        $data['action'] = $this->payuUrl();
         
 $datap = [
     'user_name'=>$name,
     'mobile'=>$mobile,
     'email'=>$email,
     'DonationPurpose'=>$DonationPurpose,
     'address'=>$address,
     'transaction_id'=>$txnid,
     'bank_name' =>$bank_name,
     'branch_name'=>$branch_name,
     'pan_no'=>$pan_no,
     ];
 

   
$trans= new Donote_TransactionModel();
                  $success = $trans->save($datap);
 if($success){
        return view('payu_VisitorDonation_form', $data);
    }else{
        
        return redirect()->back()->with('msg', 'Server Not Response');
    }
          }  
        
        
        
        
        
          $paymentsModel=new Payments_Mode_Models();
          $dataPayment = $paymentsModel->first();
          if($dataPayment['status']=="phonepe") {
      
         
$webname=$dataPayment['name']; 
$webemail=$dataPayment['email']; 
$client_id = $dataPayment['merchantId']; 
$client_secret = $dataPayment['apiKey']; 
$demo_link = $dataPayment['demo_link'];
$init_link = $dataPayment['init_link'];
//$mobile=9999999999;
// amount in INR
$description = $dataPayment['description']; 

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $demo_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 
  'client_id='.$client_id.'&client_version=1&client_secret='.$client_secret.'&grant_type=client_credentials',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$jsonResponse = curl_exec($curl);
$response = json_decode($jsonResponse, true);

$token = $response['access_token'];

$order_id = uniqid();
 
 $data = [
      'user_name'=>$name,
     'mobile'=>$mobile,
     'email'=>$email,
     'amount'=>$amount,
     'address'=>$address,
     'transaction_id'=>$order_id,
     'DonationPurpose'=>$DonationPurpose,
     'bank_name' =>$bank_name,
     'branch_name'=>$branch_name,
     'pan_no'=>$pan_no,
     'user_id'=>"visitor",
     ];
 
 $finalAmount = $amount*100;
   
$trans= new Donote_TransactionModel();
                  $success = $trans->save($data);
if($success==TRUE){
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $init_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "merchantOrderId": "'.$order_id.'",
    "amount": '.$finalAmount.',
    "expireAfter": 1200,
    "metaInfo": {
        "udf1": "additional-information-1",
        "udf2": "additional-information-2",
        "udf3": "additional-information-3",
        "udf4": "additional-information-4",
        "udf5": "additional-information-5"
    },
    "paymentFlow": {
        "type": "PG_CHECKOUT",
        "message": "Payment message used for collect requests",
        "merchantUrls": {
            "redirectUrl": "'.base_url('visitor_donote_success_payment').'"
        }
    } 
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$token,
  ),
));

$responseURL = curl_exec($curl);

curl_close($curl);
$response = json_decode($responseURL, true);

$tokenurl = $response['redirectUrl'];
$session = session();
$sessdata =[
    'transactionId'=>$order_id,
'token_id'=>$token,
];
$session->set($sessdata);
return redirect()->to($tokenurl);
die;

//end pay
 }else{
     return redirect()->to(preveous_url());
 }
          }
 else{
  $order_id = 'ORD_'.time().'_'.'d';
 $data = [
      'user_name'=>$name,
     'mobile'=>$mobile,
     'email'=>$email,
     'amount'=>$amount,
     'address'=>$address,
     'transaction_id'=>$order_id,
     'DonationPurpose'=>$DonationPurpose,
     'bank_name' =>$bank_name,
     'branch_name'=>$branch_name,
     'pan_no'=>$pan_no,
     'user_id'=>"visitor",
     ];
     
 
   
$trans= new Donote_TransactionModel();
$success = $trans->save($data);
        if($success == TRUE){
            
            
            
            $session = session();
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

     $trans= new Donote_TransactionModel();
            $donar=$trans->where('transaction_id',$order_id)->first();
    
    if(!$donar) {
        return redirect()->to('user_dashboard');
    }

    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    // Create order
    $orderData = [
        'amount'          => $amount * 100,
        'currency'        => 'INR',
        'receipt'         => $order_id,
        'payment_capture' => 1
    ];

    try {
        $razorpayOrder = $api->order->create($orderData);
        $data = [
            'users'    => $donar,
            'amount'   => $amount,
            'order_id' => $razorpayOrder->id,
            'dataweb'  => $dataweb
        ];
        
       $trans= new Donote_TransactionModel();
            $data['users']=$trans->where('transaction_id',$order_id)->first();
            
            
            
            
            return view('visitor-payment-form',$data);
        
    } catch (Exception $e) {
        log_message('error', ' Order Creation Error: '.$e->getMessage());
        session()->setFlashdata('error', 'Payment gateway error. Please try again.');
        return redirect()->back();
    }
        }
 }
        
    }
    
    
      public function VisitorDonationResponse(){
        
        
        $posted = $this->request->getPost();
  
        if (! isset($posted['status'], $posted['txnid'], $posted['hash'])) {
            return view('payment_error', ['msg' => 'Invalid response from PayU']);
        }
        
         $trans= new Donote_TransactionModel();
                $transdata = $trans->where('transaction_id',$posted['txnid'])->first();
                $amount =$posted['amount'];
                
              $transactionId =$posted['txnid'];
                $id=$transdata['id'];
                $email=$transdata['email'];
                 $name=$transdata['user_name'];
                $mobile=$transdata['mobile'];
                $payementdate= $transdata['created_at'];
                  $transaction_id= $transdata['transaction_id'];  
               $data =[
                   'user_id'=> "visitor",
                   'referance_id' =>$posted['mihpayid'],
                   
                   'merchantId'=>$posted['key'],
                    
                   'payment_statusd'=>$posted['status'],
                   'amount'=>$posted['amount'],
                   'created_at' =>date('Y-m-d H:i:s'),
                   ];
                 
       
                   $donateModel = new Donote_TransactionModel();
                   $success = $donateModel->update($id, $data);
                   // sms start
                   if($success==TRUE) {
           
            
  return $this->VisitorDonationSendMail($id);       
        
        
    }else{
       return view('payment_error', ['msg' => 'Invalid response from PayU']);  
    }
    }
    
    
    
   private function VisitorDonationSendMail($id){
        $UserModel= new UserModel();
                $admindata = $UserModel->first();
        $adminEmail = $admindata['email'];
            $trans= new Donote_TransactionModel();
                $transdata = $trans->where('transaction_id',$id)->Orwhere('id', $id)->first();
                $amount =$transdata['amount'];
                
              $transactionId =$transdata['transaction_id'];
                $id=$transdata['id'];
                $email=$transdata['email'];
                 $name=$transdata['user_name'];
                $mobile=$transdata['mobile'];
                $payementdate= $transdata['created_at'];
                  $transaction_id= $transdata['transaction_id'];        
         $payment_date =  date('Y-m-d H:i:s');  
        $dataurl= base_url();
$amount_data=$amount;
 $downloadurl=base_url('donate_receipt_download/'.$transactionId);
 
//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);

try {
    
        //Load Composer's autoloader

$mail = new PHPMailer(true);
 require 'db_config.php';
                         $queryli = "SELECT * FROM `email_credentials`";
                         $result = mysqli_query($connection, $queryli);
                         $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                         $datawebname= $web_data['web_name'];
                          $webemail_1= $web_data['webemail_1'];
                           $site_mobile_1= $web_data['site_mobile_1'];
                             $certificate_provider_name= $web_data['certificate_provider_name'];
                              $designation= $web_data['designation'];
                          $web_tag_line= $web_data['web_tag_line'];
                          $payment_dateE = date('d-m-Y h:i A', strtotime($payment_date)); // 04-09-2025 05:45 PM
     $weblogo = base_url('websiteLogoImages/'.$web_data['web_logo']);
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                          
    
     $mail->Host       = $email_data['host'];                     
    
    $mail->SMTPAuth   = true;                                  
   
    $mail->Username   = $email_data['by_email'];                     
     
    $mail->Password   = $email_data['by_password'];                               //SMTP password
    
    $mail->SMTPSecure = 'tls';
    //Enable implicit TLS encryption
    $mail->Port       = 587;    
    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

    //Recipients
    $mail->setFrom($email_data['by_email'], $email_data['subject']);
    $mail->addAddress($email, $email_data['subject']);     //Add a recipient
    // $mail->addAddress('ellen@example.com');               //Name is optional
    // $mail->addReplyTo('info@example.com', 'Information');
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');

    //Attachments
    // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
    // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

    //Content
    $mail->isHTML(true);                                  
     
    $mail->Subject = 'Donation Receipt for Your Generous Contribution';
    
    $mail->Body = "
<div style='width: 100%; max-width: 700px; margin: 0 auto; 
    border: 5px solid transparent; 
    border-image: linear-gradient(135deg, #ff416c, #ff4b2b); 
    border-image-slice: 1; 
    background: #f9f9f9; 
    border-radius: 15px; 
    overflow: hidden; 
    font-family: Arial, sans-serif; 
    color: #000;'>

    <div style='background-image: url({$weblogo}); 
        background-repeat: no-repeat; 
        background-position: center; 
        background-size: 280px 280px; 
        background-color: #ffffff; 
        padding: 40px; 
        font-family: Arial, sans-serif; 
        color: #000;'>

        <!-- Logo and site name -->
        <div style='text-align: center; margin-bottom: 30px;'>
            <img src='{$weblogo}' style='width: 100px; display: block; margin: 0 auto;'>
            <p style='font-size: 26px; font-weight: bold; margin-top: 10px;'>{$web_data['web_name']}</p>
        </div>

        <!-- Main content block -->
        <div style='background-color: rgba(255,255,255,0.9); 
            padding: 30px; 
            border-radius: 10px; 
            box-shadow: 0 0 10px rgba(0,0,0,0.05);'>

            Dear {$name},<br><br>

             On behalf of <b>{$datawebname}</b>, we sincerely thank you for your generous donation. <br>
            Your contribution strengthens our mission to serve communities, bring hope to those in need, 
            and create a meaningful impact that will inspire positive change for years to come.<br><br>

            We are pleased to confirm that we have received your donation of 
            <span style='font-weight:600;'>₹{$amount_data} on {$payment_dateE}</span>.<br><br>

             <span style='font-weight:600;'>Download Receipt:</span> 
            <a href='{$downloadurl}' target='_blank' style='color:#007BFF;'>Click Here</a><br><br>

             If you have any questions or require further assistance, 
            feel free to contact us at 
            <a href='mailto:{$webemail_1}'>{$webemail_1}</a> or  {$site_mobile_1}.<br><br>

            Once again, thank you for your generosity and compassion. <br><br>

            Your support is invaluable to us, and we are truly grateful for your contribution.<br><br>

            Best regards,<br>
            <a href='https://www.{$web_data['site_url']}' target='_blank'> www.{$web_data['site_url']}</a><br>
            {$certificate_provider_name}<br>
            {$designation}<br>
            {$datawebname}
        </div>
    </div>
</div>";
 $mail->AltBody = $email_data['message'];

    $mail->send();
   $session=session();
  $mailAdmin = new PHPMailer(true);
try {
    // SMTP Configuration
    $mailAdmin->isSMTP();
    $mailAdmin->Host = $email_data['host'];
    $mailAdmin->SMTPAuth = true;
    $mailAdmin->Username = $email_data['by_email'];
    $mailAdmin->Password = $email_data['by_password'];
    $mailAdmin->SMTPSecure = 'tls';
    $mailAdmin->Port = 587;

    // Email Content based on donation type
    $donationType = $this->request->getPost('donation_type') ?? 'General Donation';
    $amount = $this->request->getPost('amount') ?? 0;
    $frequency = $this->request->getPost('frequency') ?? 'One-time';
    $paymentMethod = $this->request->getPost('payment_method') ?? 'Online';
    
    // Customize subject based on donation
    $mailAdmin->setFrom($email_data['by_email'], $web_data['web_name']);
    $mailAdmin->addAddress($adminEmail, 'Admin');
    $mailAdmin->isHTML(true);
    $mailAdmin->Subject = "New  Donation Received - {$name}";

    // HTML Template with dynamic content
    $mailAdmin->Body = "
    <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #e0e0e0; border-radius: 8px;'>
        <div style='background: #ff4b2b; padding: 15px; text-align: center; border-radius: 8px 8px 0 0;'>
            <h2 style='color: white; margin: 0;'>New Donation Notification</h2>
        </div>
        
        <div style='padding: 20px; background: #f9f9f9; border-radius: 0 0 8px 8px;'>
            <h3 style='color: #333;'>Donation Details</h3>
            
            <table style='width: 100%; border-collapse: collapse; margin-bottom: 20px;'>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd; width: 30%;'><strong>Donor Name:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$name}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Email:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$email}</td>
                </tr>
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Phone:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>{$mobile}</td>
                </tr>
                
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Amount:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>
        ₹" . number_format($amount_data) . " on " . $payment_dateE . "
      </td>
                </tr>
               
                <tr>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'><strong>Payment Method:</strong></td>
                    <td style='padding: 8px; border-bottom: 1px solid #ddd;'>Online</td>
                </tr>
                <tr>
                    <td style='padding: 8px;'><strong>Transaction ID:</strong></td>
                    <td style='padding: 8px;'>{$transactionId}</td>
                </tr>
            </table>
            
            <div style='margin-top: 20px; padding: 15px; background: #e9f7ef; border-radius: 5px;'>
                <p style='margin: 0; color: #28a745;'>
                    <strong>Action Required:</strong> Please acknowledge this donation and send a thank you note to the donor.
                </p>
            </div>
            
            <p style='margin-top: 20px; text-align: center;'>
                <a href='{$downloadurl}' 
                   style='display: inline-block; padding: 10px 20px; background: #ff4b2b; color: white; text-decoration: none; border-radius: 5px;'>
                   View Donation Details
                </a>
            </p>
        </div>
        
        <div style='margin-top: 20px; text-align: center; font-size: 12px; color: #777;'>
            This email was automatically generated by {$web_data['web_name']} donation system.
        </div>
    </div>";

    $mailAdmin->send();
    return redirect()->to('donate_receipt_download/'.$transactionId);
} catch (Exception $e) {
      return redirect()->to('donate_receipt_download/'.$transactionId);
}  
    
   
            
            
          
                
         
           return redirect()->to('donate_receipt_download/'.$transactionId);
                   
                    
         }
                    
catch (Exception $e) {
   
   
         
           return redirect()->to('donate_receipt_download/'.$transactionId);
}
 
        
        
        
    }
    
    
    public function report_expense_Download($id){
        
     $Dmodel = new DonationProjectModel();
    $ExpenseModel = new ProjectExpenseModel();
    
    $data = $Dmodel->where('id', $id)->first();
     $data['project'] = $Dmodel->where('id', $id)->first();
     $Dmodel = new DonationProjectModel();
      $data['expenses'] = $ExpenseModel->where('project_id', $data['id'])->findAll();
   
    

//   $dompdf = new \Dompdf\Dompdf();
//   $dompdf->set('isRemoteEnabled', true);
//     $html = view('Front/report_expense_Download', $data);

//     $dompdf->loadHtml($html);
//     $dompdf->setPaper('A4', 'portrait');
//     $dompdf->render();
//     $dompdf->stream("expense_report_{$data['id']}.pdf", ["Attachment" => true]);
   
   
     return view('Front/report_expense_Download', $data);   
        
    }
    
    public function PublicReportProject() {
    $data['heading'] = "Active-Donation-Project";
    $Dmodel = new DonationProjectModel();
    $ExpenseModel = new ProjectExpenseModel();   
    
  
    $perPage = 6;  

   
    $data['project'] = $Dmodel->orderBy('id', 'DESC')->paginate($perPage);

    $data['pager'] = $Dmodel->pager;

    return view('Front/Public-Report-Project', $data);
}

    
      public function donoate_campaign_data(){
        
    $data=    $this->request->getPost();
     
       
        $name= $this->request->getVar('name');
         $email= $this->request->getVar('email');
        $mobile= $this->request->getVar('mobile');
        $amount=$this->request->getVar('amount');
         $address=$this->request->getVar('address');
        $DonationPurpose=$this->request->getPost('DonationPurpose');
          $bank_name=$this->request->getVar('bank_name');
         $branch_name=$this->request->getVar('branch_name');
          $pan_no =$this->request->getVar('pan_no');
        $campaign_id      = $this->request->getPost('campaignId');
        
        
        $paymentsModel=new Payments_Mode_Models();
          $dataphonepe=$paymentsModel->first(); 
           $payuModel=new Payments_Payu_Mode_Model();
          $datapayu=$payuModel->first(); 
           $razorModel=new Payments_Razor_Mode_Model();
          $datarazor=$razorModel->first();
          
          require 'db_config.php';
                         
                         $queryliweb = "SELECT * FROM `admin_website_update`";
                         $resultweb = mysqli_query($connection, $queryliweb);
                         $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
                       
          
if($datapayu['status']=="payu"){
   $key  = getenv('PAYU_KEY');
        $salt =getenv('PAYU_SALT');

        // Required fields (apni data source se lo)
        $txnid      = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        $amount = round($amount, 2); 
        $firstname  = $name ?? 'Buyer';
        $email      = $email ?? 'no@domain.com';
        $productinfo= $productinfo ?? 'Donation';
        $phone      = $mobile ?? '';

        // Build params
        $params = [
            'key'        => $key,
            'txnid'      => $txnid,
            'amount'     => $amount,
            'productinfo'=> $productinfo,
            'firstname'  => $name,
            'email'      => $email,
            'udf1' => '', 'udf2' => '', 'udf3' => '', 'udf4' => '', 'udf5' => '',
            
            'phone' => $phone,
            'Salt'=> $salt,
             'surl' => base_url().'payu/payuCamp_success_payment',
             'furl' => base_url().'payu/payuCamp_success_payment'
        ];

        // Generate correct hash
        $hash = $this->generatePayuRequestHash($params, $salt);

        // Prepare data for auto-post form
        $data = $params;
        $data['hash']   = $hash;
        $data['action'] = $this->payuUrl();
         
$Dmodel = new DonateCampaignModel();

        $datacmp = [
            'campaign_id'      => $this->request->getPost('campaignId'),
            'name'             => $this->request->getPost('name'),
            'email'            => $this->request->getPost('email'),
            'mobile'           => $this->request->getPost('mobile'),
            'amount'           => $this->request->getPost('amount'),
            'donation_purpose' => $this->request->getPost('DonationPurpose'),
            'bank_name'=>$this->request->getVar('bank_name'),
         'branch_name'=>$this->request->getVar('branch_name'),
          'pan_no' =>$this->request->getVar('pan_no'),
            'address'          => $this->request->getPost('address'),
            'created_at'       => date('Y-m-d H:i:s'),
            'transaction_id'=>$txnid,
        ];

       $success = $Dmodel->insert($datacmp);
 if($success){
     
        return view('Front/payu_CampDonation_form', $data);
    }else{
        
        return redirect()->back()->with('msg', 'Server Not Response');
    }
          }  
            
        
        
        
        
        
        
        
        
          $paymentsModel=new Payments_Mode_Models();
          $dataPayment = $paymentsModel->first();
          if($dataPayment['status']=="phonepe") {
      
         
$webname=$dataPayment['name']; 
$webemail=$dataPayment['email']; 
$client_id = $dataPayment['merchantId']; 
$client_secret = $dataPayment['apiKey']; 
$demo_link = $dataPayment['demo_link'];
$init_link = $dataPayment['init_link'];
//$mobile=9999999999;
// amount in INR
$description = $dataPayment['description']; 

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $demo_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 
  'client_id='.$client_id.'&client_version=1&client_secret='.$client_secret.'&grant_type=client_credentials',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$jsonResponse = curl_exec($curl);
$response = json_decode($jsonResponse, true);

$token = $response['access_token'];

$order_id = uniqid();
 
  $Dmodel = new DonateCampaignModel();

        $data = [
            'campaign_id'      => $this->request->getPost('campaignId'),
            'name'             => $this->request->getPost('name'),
            'email'            => $this->request->getPost('email'),
            'mobile'           => $this->request->getPost('mobile'),
            'amount'           => $this->request->getPost('amount'),
            'donation_purpose' => $this->request->getPost('DonationPurpose'),
            'bank_name'=>$this->request->getVar('bank_name'),
         'branch_name'=>$this->request->getVar('branch_name'),
          'pan_no' =>$this->request->getVar('pan_no'),
            'address'          => $this->request->getPost('address'),
            'created_at'       => date('Y-m-d H:i:s'),
            'transaction_id'=>$order_id,
        ];

       $success = $Dmodel->insert($data);
 
 $finalAmount = $amount*100;
   

                 
if($success==TRUE){
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $init_link,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "merchantOrderId": "'.$order_id.'",
    "amount": '.$finalAmount.',
    "expireAfter": 1200,
    "metaInfo": {
        "udf1": "additional-information-1",
        "udf2": "additional-information-2",
        "udf3": "additional-information-3",
        "udf4": "additional-information-4",
        "udf5": "additional-information-5"
    },
    "paymentFlow": {
        "type": "PG_CHECKOUT",
        "message": "Payment message used for collect requests",
        "merchantUrls": {
            "redirectUrl": "'.base_url('camp_donote_success_payment').'"
        }
    } 
}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$token,
  ),
));

$responseURL = curl_exec($curl);

curl_close($curl);
$response = json_decode($responseURL, true);

$tokenurl = $response['redirectUrl'];
$session = session();
$sessdata =[
    'transactionId'=>$order_id,
'token_id'=>$token,
];
$session->set($sessdata);
return redirect()->to($tokenurl);
die;

//end pay
 }else{
     return redirect()->to(preveous_url());
 }
          }
 else{
  $order_id = 'ORD_'.time().'_'.'d';
 $data = [
      'name'=>$name,
     'mobile'=>$mobile,
     'email'=>$email,
     'amount'=>$amount,
     'address'=>$address,
     'transaction_id'=>$order_id,
     'DonationPurpose'=>$DonationPurpose,
     'bank_name' =>$bank_name,
     'branch_name'=>$branch_name,
     'pan_no'=>$pan_no,
     'campaign_id'=>$this->request->getPost('campaignId'),
     ];

   $Dmodel = new DonateCampaignModel();
  $success = $Dmodel->insert($data);

        if($success == TRUE){
            
            
            
            $session = session();
    require 'db_config.php';
    
    // Get Razorpay credentials
    $query = "SELECT * FROM `website_razor_transaction` LIMIT 1";
    $result = mysqli_query($connection, $query);
    $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

     $trans= new DonateCampaignModel();
            $donar=$trans->where('transaction_id',$order_id)->first();
    
    if(!$donar) {
        return redirect()->to('user_dashboard');
    }

    $api = new Api($dataweb['merchantId'], $dataweb['apiKey']);

    // Create order
    $orderData = [
        'amount'          => $amount * 100,
        'currency'        => 'INR',
        'receipt'         => $order_id,
        'payment_capture' => 1
    ];

    try {
        $razorpayOrder = $api->order->create($orderData);
        $data = [
            'users'    => $donar,
            'amount'   => $amount,
            'order_id' => $razorpayOrder->id,
            'dataweb'  => $dataweb
        ];
        
       $trans= new DonateCampaignModel();
            $data['users']=$trans->where('transaction_id',$order_id)->first();
            
             return view('Front/campaign-payment-form',$data);
        
    } catch (Exception $e) {
        log_message('error', ' Order Creation Error: '.$e->getMessage());
        session()->setFlashdata('error', 'Payment gateway error. Please try again.');
        return redirect()->back();
    }
        }
 }
        
    }
    
    public function payuCamp_success_payment(){
        
        
       
        $posted = $this->request->getPost();
   
        if (! isset($posted['status'], $posted['txnid'], $posted['hash'])) {
            return view('payment_error', ['msg' => 'Invalid response from PayU']);
        }
   
   $userModel = new UserModel();
        $data = $userModel->where('user_type', "admin")->first();
        
           $adminEmail = $data['email'];
        
 $trans= new DonateCampaignModel();
                $transdata = $trans->where('transaction_id',$posted['txnid'])->first();
              
                $id=$transdata['id'];
                $email=$transdata['email'];
                 $name=$transdata['name'];
                $mobile=$transdata['mobile'];
                $payementdate= $transdata['created_at'];
                  $transactionId= $transdata['transaction_id'];  
               $data =[
                 
                   
                   'merchantId'=>$posted['mihpayid'],
                   
                   'payment_status'=>$posted['status'],
                   'amount'=>$posted['amount'],
                   'created_at' =>date('Y-m-d H:i:s'),
                   ];
                 
       $payment_date=date('Y-m-d H:i:s');
                   $donateModel = new DonateCampaignModel();
                   $success = $donateModel->update($id, $data);
                   // sms start
                   if($success==TRUE) {
           
return $this->CampaignDonationEmail($id);
                       
                   }
         
         
         else {
             
             $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data['users'] = $userModel->where('id', $data['id'])->first();
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
             ];
              
                  $session=session();
                $session->set($sess_data);
                 
         return redirect()->to('user_dashboard');
             
         }
 }
 
 public function camp_donote_success_payment(){
     
     $response=  $this->request->getVar();
        $session = session();
$transactionId = $session->get('transactionId');
$tokenId = $session->get('token_id');

// echo "Transaction ID: " . $transactionId . "<br>";
// echo "Token ID: " . $tokenId;
//             echo "<pre>";
//             print_r($response);
            
            


$curl = curl_init();
 $paymentsModel=new Payments_Mode_Models();
          $dataPayment=$paymentsModel->first();           
   $paymentMode = $dataPayment['payment_mode'];
if($paymentMode=="test"){
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
// CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
}
else{
    
    curl_setopt_array($curl, array(
//   CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
 CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
    
}
$response = curl_exec($curl);

curl_close($curl);
$responseUrl = json_decode($response, true);

             $trans_id = $transactionId;
              $amount = $responseUrl['amount'];
              
               $trans_status = $responseUrl['state'];
               if($trans_status=="COMPLETED"){
               $staff_id = $transactionId;
               $cust_id = $this->request->getPost('cust_id');
               $providerReferenceId = $this->request->getPost('providerReferenceId');
               $merchantId = $this->request->getPost('merchantId');
               $cust_mobile = $this->request->getPost('cust_mobile');
               
                $donateModel = new DonateCampaignModel();
                $transdata = $donateModel->where('transaction_id',$transactionId)->first();
              
                $id=$transdata['id'];
                $email=$transdata['email'];
                 $name=$transdata['name'];
                $mobile=$transdata['mobile'];
                $payementdate= $transdata['created_at'];
                  $transaction_id= $transdata['transaction_id'];  
                $data =[
                 
                   
                   'merchantId'=>$merchantId,
                   'payment_status'=>$trans_status,
                   'amount'=>$amount/100,
                   'created_at' =>date('Y-m-d H:i:s'),
                   ];
                 
       $payment_date=date('Y-m-d H:i:s');
                   $donateModel = new DonateCampaignModel();
                   $success = $donateModel->update($id, $data);
                   // sms start
                   if($success==TRUE) {
                       
                       
                   return $this->CampaignDonationEmail($id);
           
            
     }
         
         
         else {
             
             $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data['users'] = $userModel->where('id', $data['id'])->first();
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
             ];
              
                  $session=session();
                $session->set($sess_data);
                 
         return redirect()->to('user_dashboard');
             
         }
               }else{
                  $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg"); 
                    return redirect()->to('donation_visitor_form');
               }
       
        
     
 }
 
 public function payudonate_receipt_download($id){
     
      $DonateCampaignModel= new DonateCampaignModel();
                $transdata = $DonateCampaignModel->where('transaction_id',$id)->first();
              
     echo "<pre>";
     print_r($transdata);
     die;
     
     
     
 }
    
   public function visitor_donote_success_payment(){
        
        $response=  $this->request->getVar();
        $session = session();
$transactionId = $session->get('transactionId');
$tokenId = $session->get('token_id');

// echo "Transaction ID: " . $transactionId . "<br>";
// echo "Token ID: " . $tokenId;
//             echo "<pre>";
//             print_r($response);
            
            


$curl = curl_init();
 $paymentsModel=new Payments_Mode_Models();
          $dataPayment=$paymentsModel->first();           
   $paymentMode = $dataPayment['payment_mode'];
if($paymentMode=="test"){
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
// CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
}
else{
    
    curl_setopt_array($curl, array(
//   CURLOPT_URL => 'https://api-preprod.phonepe.com/apis/pg-sandbox/checkout/v2/order/'.$transactionId.'/status?details=false',
 CURLOPT_URL => 'https://api.phonepe.com/apis/pg/checkout/v2/order/'.$transactionId.'/status?details=false',

  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Authorization: O-Bearer '.$tokenId.''
  ),
));
    
}
$response = curl_exec($curl);

curl_close($curl);
$responseUrl = json_decode($response, true);

             $trans_id = $transactionId;
              $amount = $responseUrl['amount'];
              
               $trans_status = $responseUrl['state'];
               if($trans_status=="COMPLETED"){
               $staff_id = $transactionId;
               $cust_id = $this->request->getPost('cust_id');
               $providerReferenceId = $this->request->getPost('providerReferenceId');
               $merchantId = $this->request->getPost('merchantId');
               $cust_mobile = $this->request->getPost('cust_mobile');
               
                $trans= new Donote_TransactionModel();
                $transdata = $trans->where('transaction_id',$transactionId)->first();
              
                $id=$transdata['id'];
                $email=$transdata['email'];
                 $name=$transdata['user_name'];
                $mobile=$transdata['mobile'];
                $payementdate= $transdata['created_at'];
                  $transaction_id= $transdata['transaction_id'];  
               $data =[
                  
                   'merchantId'=>$merchantId,
                   
                   'payment_status'=>$trans_status,
                   'amount'=>$amount/100,
                   'created_at' =>date('Y-m-d H:i:s'),
                   ];
                 
       $payment_date=date('Y-m-d H:i:s');
                  $trans= new Donote_TransactionModel();
                   $success = $trans->update($id, $data);
                   // sms start
                   if($success==TRUE) {
                       
                       
                     return $this->VisitorDonationSendMail($id);     
           
            
     }
         
         
         else {
             
             $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg");
                   
                    $userModel = new UserModel();
        $session = session();
             $data['users'] = $userModel->where('id', $data['id'])->first();
                 $sess_data = [
                     'id'       => $data['id'],
                   
                     
                      'loginned' =>'loginned',
             ];
              
                  $session=session();
                $session->set($sess_data);
                 
         return redirect()->to('user_dashboard');
             
         }
               }else{
                  $session=session();
                    $session->set("msg",'<h1>'."OOPs".'</h1>'." Your Transaction has been Failed ");
                    $session->markAsFlashdata("msg"); 
                    return redirect()->to('donation_visitor_form');
               }
       
       
    }
    
    public function receipt_download($id=null){
         $trans= new Donote_TransactionModel();
    $data['payments'] = $trans->where('transaction_id', $id)->first();
                
                
         
          return view('visitor_payment_donote_receipt',$data);
        
        
    }
    
    
public function nodate_form($userid)
{
    $session = session();

    if ($userid != $session->id) {
        $id = base64_decode($userid); 
    } else {
        $id = $session->id; 
    }

    if (isset($_GET['referralId']) && !empty($_GET['referralId'])) {
        $referralId = base64_decode($_GET['referralId']); 
    } else {
        $referralId = "direct"; 
    }

    $model = new UserModel();
    $users = $model->where('id', $id)->first();

    if ($users && $users['profile'] !== null) {
        if ($users['status'] !== 'block' && $users['status'] === 'active') {
            $data['referralId'] = $referralId; 
            $data['users'] = $users; 
;
            return view('user_dashboard/donate_form', $data);
        }
    }

    
    return redirect()->to('user_dashboard');
}

public function ApplyBeneficiaryform(){
    
 $data['heading']="Beneficiary Apply Form";
        return view('beneficiary/create-update',$data); 
    
}

    
}
