<?php

namespace App\Controllers;

use CodeIgniter\Controller;

class EncryptedRouter extends Controller
{
    public function route($encryptedPath)
    {
        try {
            $decrypted = decrypt_url($encryptedPath);
            
            // Handle GET/POST requests
            $method = $this->request->getMethod();
            $router = service('router');
            
            // Parse the decrypted path
            return $router->handle($decrypted);
            
        } catch (\Exception $e) {
            return $this->response->setStatusCode(404)->setBody('Invalid URL');
        }
    }
}