<?php

namespace App\Controllers;

class EncodedController extends BaseController
{
    public function handle($encoded)
    {
        $decoded = base64_decode($encoded);

        if (!$decoded) {
            return 'Invalid or missing encoded URL.';
        }

        // Decode query string to array
        parse_str($decoded, $params);

        $controller = $params['c'] ?? 'Home';
        $method     = $params['m'] ?? 'index';

        unset($params['c'], $params['m']);

        $controllerClass = 'App\Controllers\\' . ucfirst($controller);

        if (!class_exists($controllerClass)) {
            return 'Controller not found: ' . $controller;
        }

        $instance = new $controllerClass();

        if (!method_exists($instance, $method)) {
            return 'Method not found: ' . $method;
        }

        // Merge GET + POST parameters
        $finalParams = array_merge($params, $this->request->getPost());

        return call_user_func_array([$instance, $method], $finalParams);
    }
}
